/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.pcf;

import com.ibm.mq.MQException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.event.PCFQuery;

public class PCFResponseAnalyser {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/pcf/PCFResponseAnalyser.java";
    public static final int NO_ERROR_PARAMETER = -1;
    private int reasonCode = 0;
    private int completionCode = 0;
    private int errorParameter = -1;
    private String objectName = "";

    public PCFResponseAnalyser(Trace t, MQException mqe) {
        PCFException pcfe = null;
        boolean commandFailed = false;
        if (Trace.isTracing) {
            PCFQuery.traceMQException((Trace)t, (MQException)mqe);
        }
        if (mqe instanceof PCFException) {
            pcfe = (PCFException)((Object)mqe);
        } else if (mqe.exceptionSource instanceof PCFException) {
            pcfe = (PCFException)((Object)mqe.exceptionSource);
        }
        if (pcfe != null) {
            if (pcfe.exceptionSource instanceof PCFMessage[]) {
                PCFMessage[] msgs = (PCFMessage[])pcfe.exceptionSource;
                int i = 0;
                while (i < msgs.length) {
                    try {
                        this.errorParameter = msgs[i].getIntParameterValue(1012);
                    }
                    catch (PCFException pCFException) {}
                    try {
                        this.objectName = msgs[i].getStringParameterValue(3046);
                    }
                    catch (PCFException pCFException) {}
                    if (msgs[i].getReason() == 3008) {
                        commandFailed = true;
                    } else if (msgs[i].getReason() != this.reasonCode && msgs[i].getReason() != 0) {
                        this.reasonCode = msgs[i].getReason();
                        this.completionCode = msgs[i].getCompCode();
                    }
                    ++i;
                }
                if (commandFailed && this.reasonCode == 0) {
                    this.reasonCode = 3008;
                }
            }
        } else {
            this.reasonCode = mqe.reasonCode;
            this.completionCode = mqe.completionCode;
        }
    }

    public int getReasonCode() {
        return this.reasonCode;
    }

    public int getCompletionCode() {
        return this.completionCode;
    }

    public int getErrorParameter() {
        return this.errorParameter;
    }

    public String getObjectName() {
        return this.objectName;
    }
}

