/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.passwords;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.passwords.internal.event.IPwStoreListener;
import com.ibm.mq.explorer.passwords.internal.event.PwStoreEvent;
import com.ibm.mq.explorer.passwords.internal.store.IPwCredentials;
import com.ibm.mq.explorer.passwords.internal.store.PwDefaultStore;
import java.util.Vector;

public class DmPasswordStoreManager
implements IPwStoreListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/passwords/DmPasswordStoreManager.java";
    private static final String PASSWORD_STORE_MGR_ID = "com.ibm.mq.explorer.core";
    private static PwDefaultStore passwordStore = null;
    private static DmPasswordStoreManager storeManager = null;

    private DmPasswordStoreManager(Trace t) {
        PwDefaultStore.addListener((Trace)t, (IPwStoreListener)this);
    }

    public IPwCredentials getCredentials(Trace t, String ownerId, String objectId, String resourceId) {
        IPwCredentials credentials = null;
        credentials = passwordStore.getCredentials(t, ownerId, objectId, resourceId);
        return credentials;
    }

    public Vector<IPwCredentials> getAllCredentials(Trace t, String ownerId) {
        Vector allCredentials = null;
        allCredentials = passwordStore.getAllCredentials(t);
        return allCredentials;
    }

    public Vector<IPwCredentials> getAllCredentials(Trace t) {
        Vector allCredentials = null;
        allCredentials = passwordStore.getAllCredentials(t);
        return allCredentials;
    }

    public int saveCredentials(Trace t, IPwCredentials c) {
        int rc = 0;
        if (passwordStore != null && passwordStore.isOpen(t)) {
            rc = passwordStore.saveCredentials(t, c);
        }
        return rc;
    }

    public void close(Trace t) {
        PwDefaultStore.removeListener((Trace)t, (IPwStoreListener)this);
        passwordStore = null;
        storeManager = null;
    }

    public static DmPasswordStoreManager getStoreManager(Trace t) {
        if (storeManager == null) {
            storeManager = new DmPasswordStoreManager(t);
        }
        return storeManager;
    }

    public static boolean isStoreOpen(Trace t) {
        if (storeManager != null) {
            if (passwordStore != null) {
                return passwordStore.isOpen(t);
            }
            return false;
        }
        return false;
    }

    public static boolean isSavingPasswordsPreference(Trace t) {
        return PwDefaultStore.isSavingPasswordsPreference();
    }

    public void pwStoreClosed(PwStoreEvent event) {
    }

    public void pwStoreOpen(PwStoreEvent event) {
        Trace t = Trace.getInstance();
        passwordStore = PwDefaultStore.getDefaultStore((Trace)t);
    }

    public String getListenerId() {
        return PASSWORD_STORE_MGR_ID;
    }
}

