/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.parser;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.parser.Attribute;
import com.ibm.mq.explorer.core.internal.parser.FfstChecker;
import com.ibm.mq.explorer.core.internal.parser.IConverter;
import com.ibm.mq.explorer.core.internal.parser.ParseUtils;
import com.ibm.mq.explorer.core.internal.parser.PlatformChecker;
import java.util.ArrayList;
import java.util.HashMap;
import org.osgi.framework.Bundle;

public class XmlObject
implements IConverter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/parser/XmlObject.java";
    private String objectName = null;
    private String platformApplicability = null;
    private String cmdLvlApplicability = null;
    private ArrayList<Attribute> attributeList = null;
    private HashMap<String, Class<?>> constantsMap = null;
    private HashMap<Class<?>, Object> classCache = null;
    private Bundle bundle = null;
    private static final boolean DEFAULT_READWRITE = true;
    private boolean readWrite = true;

    public XmlObject(Trace t, String name, Bundle bund) {
        this.objectName = name;
        this.attributeList = new ArrayList();
        this.classCache = new HashMap();
        this.bundle = bund;
    }

    public void setPlatform(Trace t, String value) {
        this.platformApplicability = value;
    }

    public void setCmdLvl(Trace t, String value) {
        this.cmdLvlApplicability = value;
    }

    public boolean isValid(Trace t, int commandLvl, int platform) {
        boolean valid = false;
        if (PlatformChecker.validPlatform(t, platform, this.platformApplicability) && PlatformChecker.validCommandLvl(t, commandLvl, this.cmdLvlApplicability)) {
            valid = true;
        }
        return valid;
    }

    public void addAttribute(Trace t, Attribute attribute) {
        this.attributeList.add(attribute);
    }

    public void addToConstants(Trace t, String key, String value) {
        if (this.constantsMap == null) {
            this.constantsMap = new HashMap();
        }
        try {
            if (this.bundle != null) {
                this.constantsMap.put(key, this.bundle.loadClass(value));
            } else {
                this.constantsMap.put(key, Class.forName(value));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (FfstChecker.isFfsting) {
                t.FFST(65, "XmlObject.addToConstants", 10, 50052, 0, 0, String.valueOf(value) + " is not a valid class as defined in the constants in object " + this.objectName, null, null);
            }
            System.err.println("Error: " + value + " is not a valid class as defined in the constants in object " + this.objectName);
        }
    }

    @Override
    public HashMap<String, Class<?>> getConstantsMapping(Trace t) {
        return this.constantsMap;
    }

    public ArrayList<Attribute> getAttributes(Trace t) {
        return this.attributeList;
    }

    @Override
    public String getObjectName(Trace t) {
        return this.objectName;
    }

    @Override
    public HashMap<Class<?>, Object> getClassCache(Trace t) {
        return this.classCache;
    }

    public XmlObject getOwningObject(Trace t) {
        return this;
    }

    public void setReadWrite(Trace t, boolean value) {
        this.readWrite = value;
    }

    public void setReadWrite(Trace t, String value) {
        this.readWrite = ParseUtils.getDefault(t).getBooleanValue(t, value, this);
    }

    public boolean isReadWrite(Trace t) {
        return this.readWrite;
    }
}

