/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.parser;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.parser.Attribute;
import java.util.ArrayList;
import java.util.HashMap;

public class Where {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/parser/Where.java";
    private HashMap<String, String> entries = null;
    private Attribute parent = null;
    private String[] mandatory = new String[]{"id", "op", "wherevalue", "wheretype"};
    private boolean mandatoryValues = false;
    private boolean checked = false;

    public Where(Trace t, Attribute parent) {
        this.parent = parent;
        this.entries = new HashMap();
    }

    public void addEntry(Trace t, String key, String value) {
        this.entries.put(key, value);
    }

    public String getEntry(Trace t, String key) {
        return this.entries.get(key);
    }

    public String getId(Trace t) {
        if (!this.checked) {
            this.validateWhereClause(t);
        }
        String id = this.parent.checkHashMap(t, "id", this.entries, this.mandatoryValues);
        return id;
    }

    public String getOp(Trace t) {
        if (!this.checked) {
            this.validateWhereClause(t);
        }
        String op = this.parent.checkHashMap(t, "op", this.entries, this.mandatoryValues);
        return op;
    }

    public String getVal(Trace t) {
        if (!this.checked) {
            this.validateWhereClause(t);
        }
        String val = this.parent.checkHashMap(t, "wherevalue", this.entries, this.mandatoryValues);
        return val;
    }

    public String getType(Trace t) {
        if (!this.checked) {
            this.validateWhereClause(t);
        }
        String type = this.parent.checkHashMap(t, "wheretype", this.entries, this.mandatoryValues);
        return type;
    }

    public void validateWhereClause(Trace t) {
        ArrayList<String> missing = new ArrayList<String>();
        int i = 0;
        while (i < this.mandatory.length) {
            if (this.entries.containsKey(this.mandatory[i]) && this.entries.get(this.mandatory[i]) == null) {
                missing.add(this.mandatory[i]);
            }
            ++i;
        }
        if (missing.size() < this.mandatory.length) {
            this.mandatoryValues = true;
        }
        this.checked = true;
    }
}

