/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.parser;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.UpdateGroup;
import com.ibm.mq.explorer.core.internal.parser.FfstChecker;
import com.ibm.mq.explorer.core.internal.parser.IConverter;
import com.ibm.mq.explorer.core.internal.parser.ParseUtils;
import java.net.URL;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class UpdateGroupList
extends DefaultHandler
implements IConverter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/parser/UpdateGroupList.java";
    private static HashMap<String, UpdateGroup> updateGroups = null;
    private static boolean parsed = false;
    private static final String ELEMENT_CONSTANT = "constant";
    private static String objectName = null;
    private HashMap<String, Class<?>> constantsMap = null;
    private HashMap<Class<?>, Object> classCache = new HashMap();
    private Bundle bundle = null;

    public UpdateGroupList(Trace t, Bundle bund, String name) {
        this.bundle = bund;
        this.init(t, name);
    }

    private void init(Trace t, String name) {
        parsed = true;
        objectName = name;
        URL url = null;
        String fullFilename = null;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        fullFilename = "xml/" + name + ".xml";
        url = this.bundle.getEntry(fullFilename);
        try {
            SAXParser saxParser = factory.newSAXParser();
            if (url != null) {
                saxParser.parse(url.toString(), (DefaultHandler)this);
            } else if (FfstChecker.isFfsting) {
                t.FFST(65, "UpdateGroupList.init", 0, 50048, 0, 0, "An error occured whilst parsing xml file - could not get url from bundle", fullFilename, null);
            } else {
                System.err.println("Error: An error occured whilst parsing xml file " + fullFilename + " - could not get url from bundle");
            }
        }
        catch (Throwable ex) {
            t.FFST(65, "UpdateGroupList.init", 0, 50048, 0, 0, "An error occured whilst parsing xml file", objectName, ex.toString());
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Trace t = Trace.getInstance();
        if (qName.equals("updategroup")) {
            if (updateGroups == null) {
                updateGroups = new HashMap();
            }
            String key = "";
            int value = -1;
            int i = 0;
            while (i < attributes.getLength()) {
                String aName = attributes.getLocalName(i);
                if ("".equals(aName)) {
                    aName = attributes.getQName(i);
                }
                String aValue = attributes.getValue(i);
                if (aName.equals("name")) {
                    key = aValue;
                } else if (aName.equals("primary")) {
                    value = ParseUtils.getDefault(t).getIntValue(t, aValue, this);
                }
                ++i;
            }
            if (key != "") {
                updateGroups.put(key, new UpdateGroup(t, key, value));
            }
        } else if (qName.equals(ELEMENT_CONSTANT)) {
            if (this.constantsMap == null) {
                this.constantsMap = new HashMap();
            }
            int i = 0;
            while (i < attributes.getLength()) {
                String aName = attributes.getLocalName(i);
                if ("".equals(aName)) {
                    aName = attributes.getQName(i);
                }
                String aValue = attributes.getValue(i);
                try {
                    this.constantsMap.put(aName, Class.forName(aValue));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    t.FFST(65, "UpdateGroupList.startElement", 10, 50018, 0, 0, String.valueOf(aValue) + " is not a valid class as defined in the constants in updategroups", null, null);
                }
                ++i;
            }
        }
    }

    public static HashMap<String, UpdateGroup> getUpdateGroups(Trace t) {
        if (parsed) {
            if (updateGroups == null) {
                t.FFST(65, "UpdateGroupList.getUpdateGroups", 0, 50050, 0, 0, "No update group information found. There were no <updategroup> tags in the xml file parsed", objectName, null);
            }
        } else {
            t.FFST(65, "UpdateGroupList.getUpdateGroups", 1, 50048, 0, 0, "Incorrect usage - XML data has not yet been parsed. Need to call init beforehand.", objectName, null);
        }
        return updateGroups;
    }

    @Override
    public HashMap<String, Class<?>> getConstantsMapping(Trace t) {
        return this.constantsMap;
    }

    @Override
    public HashMap<Class<?>, Object> getClassCache(Trace t) {
        return this.classCache;
    }

    @Override
    public String getObjectName(Trace t) {
        return objectName;
    }
}

