/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.parser;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.parser.FfstChecker;
import java.util.HashMap;

public class PlatformChecker {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/parser/PlatformChecker.java";
    public static final int ALL = -1;
    private static final String GREATER_EQUAL = "ge";
    private static final String LESS_THAN = "lt";
    private static final String EQUALS = "eq";
    private static final String NOT_EQUALS = "ne";
    private static final String PLATFORM_ZOS = "ZOS";
    private static final String PLATFORM_OS2 = "OS2";
    private static final String PLATFORM_UNIX = "UNIX";
    private static final String PLATFORM_OS400 = "OS400";
    private static final String PLATFORM_WIN32 = "WIN32";
    private static final String PLATFORM_VMS = "VMS";
    private static final String PLATFORM_NSK = "NSK";
    private static final String PLATFORM_VSE = "VSE";
    private static final String PLATFORM_APPLIANCE = "APPL";
    private static int[] platformKeys = new int[]{1, 2, 3, 4, 11, 12, 13, 27, 28};
    private static String[] platformValues = new String[]{"ZOS", "OS2", "UNIX", "OS400", "WIN32", "VMS", "NSK", "VSE", "APPL"};
    private static HashMap<Integer, String> platforms = new HashMap();

    static {
        int i = 0;
        while (i < platformKeys.length) {
            platforms.put(platformKeys[i], platformValues[i]);
            ++i;
        }
    }

    private PlatformChecker() {
    }

    public static boolean validPlatform(Trace t, int platformToCheck, String platformValidity) {
        boolean valid = false;
        if (platformValidity == null || platformToCheck == -1) {
            valid = true;
        } else {
            String actualPlatform = platforms.get(platformToCheck);
            if (actualPlatform == null) {
                actualPlatform = PLATFORM_UNIX;
                if (FfstChecker.isFfsting) {
                    t.FFST(65, "PlatformChecker.validPlatform", 0, 50049, 0, 0, String.valueOf(platformToCheck) + " is not a valid value - Unknown platform, Will default to UNIX", null, null);
                } else {
                    System.err.println("Error: " + platformToCheck + " is not a valid value - Unknown platform, Will default to UNIX");
                }
            }
            if (platformValidity.startsWith(NOT_EQUALS)) {
                if (platformValidity.indexOf(actualPlatform) == -1) {
                    valid = true;
                }
            } else if (platformValidity.indexOf(actualPlatform) != -1) {
                valid = true;
            }
        }
        return valid;
    }

    public static boolean validCommandLvl(Trace t, int cmdLvlToCheck, String cmdLvlValidity) {
        boolean valid = false;
        if (cmdLvlValidity == null || cmdLvlToCheck == -1) {
            valid = true;
        } else if (cmdLvlValidity.startsWith(GREATER_EQUAL)) {
            int cmdLvl = Integer.valueOf(cmdLvlValidity.substring(2));
            if (cmdLvlToCheck >= cmdLvl) {
                valid = true;
            }
        } else if (cmdLvlValidity.startsWith(LESS_THAN)) {
            int cmdLvl = Integer.valueOf(cmdLvlValidity.substring(2));
            if (cmdLvlToCheck < cmdLvl) {
                valid = true;
            }
        } else if (cmdLvlValidity.startsWith(EQUALS)) {
            if (cmdLvlValidity.indexOf(Integer.toString(cmdLvlToCheck)) != -1) {
                valid = true;
            }
        } else if (FfstChecker.isFfsting) {
            t.FFST(65, "PlatformChecker.validCommandLvl", 0, 50049, 0, 0, String.valueOf(cmdLvlValidity) + " is not a valid value for command level information in the xml", null, null);
        } else {
            System.err.println("Error: " + cmdLvlValidity + " is not a valid value for command level information in the xml");
        }
        return valid;
    }
}

