/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.parser;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.objects.DisplayGroup;
import com.ibm.mq.explorer.core.internal.parser.FfstChecker;
import com.ibm.mq.explorer.core.internal.parser.IConverter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;

public class ParseUtils {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/parser/ParseUtils.java";
    public static final String EMPTY_STRING = "";
    public static final String FILE_EXTENSION = ".xml";
    public static final String ROOT_DIR = "xml";
    public static final String SEPARATOR = System.getProperty("file.separator");
    public static final char BUNDLE_SEPARATOR = '/';
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String YES = "Y";
    private static final String NO = "N";
    private static final String CLASS_SEPARATOR = ".";
    private static ParseUtils utils = null;
    public static final int UNKNOWN_VALUE = -999999;

    private ParseUtils() {
    }

    public static ParseUtils getDefault(Trace t) {
        if (utils == null) {
            utils = new ParseUtils();
        }
        return utils;
    }

    public int getIntValue(Trace t, String convert, IConverter converter) {
        int value;
        block9: {
            value = -999999;
            if (convert.indexOf(46) != -1) {
                try {
                    Object constant = this.getConstantByReflection(t, convert, converter);
                    if (constant != null) {
                        value = (Integer)constant;
                    }
                }
                catch (ClassCastException e) {
                    if (FfstChecker.isFfsting) {
                        t.FFST(65, "ParseUtils.getIntValue", 0, 50049, 0, 0, String.valueOf(convert) + " is not a valid int value", converter.getObjectName(t), e.toString());
                        break block9;
                    }
                    System.err.println("Error: " + convert + " is not a valid int value in " + converter.getObjectName(t) + ": " + e.toString());
                }
            } else {
                try {
                    value = Integer.parseInt(convert);
                }
                catch (NumberFormatException e) {
                    if (FfstChecker.isFfsting) {
                        t.FFST(65, "ParseUtils.getIntValue", 1, 50049, 0, 0, String.valueOf(convert) + " is not a valid number value", converter.getObjectName(t), e.toString());
                    }
                    System.err.println("Error: " + convert + " is not a valid number value in " + converter.getObjectName(t) + ": " + e.toString());
                }
            }
        }
        return value;
    }

    public long getLongValue(Trace t, String convert, IConverter converter) {
        long value;
        block9: {
            value = -999999L;
            if (convert.indexOf(CLASS_SEPARATOR) != -1) {
                try {
                    Object constant = this.getConstantByReflection(t, convert, converter);
                    if (constant != null) {
                        value = (Long)constant;
                    }
                }
                catch (ClassCastException e) {
                    if (FfstChecker.isFfsting) {
                        t.FFST(65, "ParseUtils.getLongValue", 0, 50049, 0, 0, String.valueOf(convert) + " is not a valid long value", converter.getObjectName(t), e.toString());
                        break block9;
                    }
                    System.err.println("Error: " + convert + " is not a valid long value in " + converter.getObjectName(t) + ": " + e.toString());
                }
            } else {
                try {
                    value = Long.parseLong(convert);
                }
                catch (NumberFormatException e) {
                    if (FfstChecker.isFfsting) {
                        t.FFST(65, "ParseUtils.getLongValue", 1, 50049, 0, 0, String.valueOf(convert) + " is not a valid number value", converter.getObjectName(t), e.toString());
                    }
                    System.err.println("Error: " + convert + " is not a valid number value in " + converter.getObjectName(t) + ": " + e.toString());
                }
            }
        }
        return value;
    }

    public boolean getBooleanValue(Trace t, String convert, IConverter converter) {
        boolean value = false;
        if (convert.equalsIgnoreCase(TRUE) || convert.equalsIgnoreCase(YES)) {
            value = true;
        } else if (!convert.equalsIgnoreCase(FALSE) && !convert.equalsIgnoreCase(NO)) {
            if (FfstChecker.isFfsting) {
                t.FFST(65, "ParseUtils.getBooleanValue", 0, 50049, 0, 0, String.valueOf(convert) + " is not a valid boolean value", converter.getObjectName(t), null);
            } else {
                System.err.println("Error: " + convert + " is not a valid boolean value in " + converter.getObjectName(t));
            }
        }
        return value;
    }

    private Object getConstantByReflection(Trace t, String convert, IConverter converter) {
        Object value;
        block19: {
            value = null;
            HashMap<String, Class<?>> constantsMapping = converter.getConstantsMapping(t);
            if (constantsMapping == null) {
                if (FfstChecker.isFfsting) {
                    t.FFST(65, "ParseUtils.getConstantByReflection", 0, 50050, 0, 0, "No constant definitions found in xml file", converter.getObjectName(t), null);
                } else {
                    System.err.println("Error: No constant definitions found in xml file for " + converter.getObjectName(t));
                }
                return value;
            }
            int split = convert.indexOf(CLASS_SEPARATOR);
            if (split != -1) {
                String classToCheck = convert.substring(0, split);
                String valueToCheck = convert.substring(split + 1);
                try {
                    Class<?> interestedClass = null;
                    HashMap<Class<?>, Object> classCache = converter.getClassCache(t);
                    if (constantsMapping.containsKey(classToCheck)) {
                        interestedClass = constantsMapping.get(classToCheck);
                        HashMap fieldMapping = new HashMap();
                        classCache.put(interestedClass, fieldMapping);
                    } else if (FfstChecker.isFfsting) {
                        t.FFST(65, "ParseUtils.getConstantByReflection", 1, 50050, 0, 0, "constant definition " + classToCheck + " not found in xml file", converter.getObjectName(t), null);
                    } else {
                        System.err.println("Error: constant definition " + classToCheck + " not found in xml file for " + converter.getObjectName(t));
                    }
                    if (interestedClass == null || !classCache.containsKey(interestedClass)) break block19;
                    if (((HashMap)classCache.get(interestedClass)).containsKey(valueToCheck)) {
                        value = ((HashMap)classCache.get(interestedClass)).get(valueToCheck);
                        break block19;
                    }
                    HashMap fields = (HashMap)classCache.get(interestedClass);
                    value = interestedClass.getField(valueToCheck).get(null);
                    fields.put(valueToCheck, value);
                }
                catch (NoSuchFieldException e) {
                    if (FfstChecker.isFfsting) {
                        t.FFST(65, "ParseUtils.getConstantByReflection", 2, 50049, 0, 0, String.valueOf(convert) + " field not found in xml file", converter.getObjectName(t), e.toString());
                        break block19;
                    }
                    System.err.println("Error: " + convert + " field not found in xml file for " + converter.getObjectName(t) + ": " + e.toString());
                }
                catch (NullPointerException e) {
                    if (FfstChecker.isFfsting) {
                        t.FFST(65, "ParseUtils.getConstantByReflection", 3, 50049, 0, 0, String.valueOf(classToCheck) + " not a valid class to check", converter.getObjectName(t), e.toString());
                        break block19;
                    }
                    System.err.println("Error: " + classToCheck + " not a valid class to check for " + converter.getObjectName(t) + ": " + e.toString());
                }
                catch (Exception e) {
                    if (FfstChecker.isFfsting) {
                        t.FFST(65, "ParseUtils.getConstantByReflection", 4, 50049, 0, 0, "Error retrieving value for " + convert, converter.getObjectName(t), e.toString());
                        break block19;
                    }
                    System.err.println("Error: Error retrieving value for " + convert + " for " + converter.getObjectName(t) + ": " + e.toString());
                }
            } else if (FfstChecker.isFfsting) {
                t.FFST(65, "ParseUtils.getConstantByReflection", 5, 50049, 0, 0, String.valueOf(convert) + " is not a valid static constant", converter.getObjectName(t), null);
            } else {
                System.err.println("Error: " + convert + " is not a valid static constant for object " + converter.getObjectName(t));
            }
        }
        return value;
    }

    public DisplayGroup getDisplayGroupByReflection(Trace t, String convert, IConverter converter) {
        DisplayGroup value;
        block9: {
            value = null;
            int split = convert.indexOf(CLASS_SEPARATOR);
            if (split != -1) {
                try {
                    Field field = DisplayGroup.class.getField(convert.substring(split + 1));
                    value = (DisplayGroup)field.get(null);
                }
                catch (NoSuchFieldException e) {
                    if (FfstChecker.isFfsting) {
                        t.FFST(65, "ParseUtils.getDisplayGroupByReflection", 0, 50049, 0, 0, String.valueOf(convert) + " field not found in xml file", converter.getObjectName(t), e.toString());
                        break block9;
                    }
                    System.err.println("Error: " + convert + " field not found in xml file for " + converter.getObjectName(t) + ": " + e.toString());
                }
                catch (Exception e) {
                    if (FfstChecker.isFfsting) {
                        t.FFST(65, "ParseUtils.getDisplayGroupByReflection", 1, 50049, 0, 0, "Error retrieving value for " + convert, converter.getObjectName(t), e.toString());
                        break block9;
                    }
                    System.err.println("Error: Error retrieving value for " + convert + " for " + converter.getObjectName(t) + ": " + e.toString());
                }
            } else if (FfstChecker.isFfsting) {
                t.FFST(65, "ParseUtils.getDisplayGroupByReflection", 2, 50049, 0, 0, String.valueOf(convert) + " is not a valid static constant", converter.getObjectName(t), null);
            } else {
                System.err.println("Error: " + convert + " is not a valid static constant for object " + converter.getObjectName(t));
            }
        }
        return value;
    }

    public int[] getIntArray(Trace t, ArrayList list, IConverter converter) {
        int[] result = new int[list.size()];
        int i = 0;
        while (i < list.size()) {
            try {
                if (list.get(i) instanceof Integer) {
                    result[i] = (Integer)list.get(i);
                } else if (list.get(i) instanceof String) {
                    result[i] = this.getIntValue(t, (String)list.get(i), converter);
                }
            }
            catch (ClassCastException e) {
                if (FfstChecker.isFfsting) {
                    t.FFST(65, "ParseUtils.getIntArray", 0, 50049, 0, 0, "Non integer value found in " + list + ". " + list.get(i).toString() + " is not a valid value", converter.getObjectName(t), e.toString());
                }
                System.err.println("Error: Non integer value found in " + list + ". " + list.get(i).toString() + " is not a valid value in " + converter.getObjectName(t) + ": " + e.toString());
            }
            ++i;
        }
        return result;
    }
}

