/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.parser;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.parser.Attribute;
import com.ibm.mq.explorer.core.internal.parser.FfstChecker;
import com.ibm.mq.explorer.core.internal.parser.PlatformChecker;
import java.util.ArrayList;
import java.util.HashMap;

public class Info {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/parser/Info.java";
    public static final String PROP_DEFAULT = "DEFAULT";
    public static final String PROP_TRIM = "TRIM";
    public static final String PROP_MAXLEN = "MAXLEN";
    public static final String PROP_MINLEN = "MINLEN";
    public static final String PROP_PASSWORD = "PASSWORD";
    public static final String PROP_TOTLEN = "TOTLEN";
    public static final String PROP_MIN = "MIN";
    public static final String PROP_MAX = "MAX";
    public static final String PROP_UNIQUE = "UNIQUE";
    public static final String PROP_ITEMCOUNT = "ITEM_COUNT";
    public static final String PROP_REGEXP = "REGEXP";
    public static final String PROP_DATETIMETYPE = "DATETIMETYPE";
    public static final String PROP_SELECTONLY = "SELECTONLY";
    public static final String PROP_INFOPOP_ID = "INFOPOP_ID";
    private HashMap<String, String> entries = null;
    private Attribute parent = null;
    private static String[] xmlValuesAllowed = new String[]{"DEFAULT", "TRIM", "MAXLEN", "TOTLEN", "MAX", "MIN", "UNIQUE", "PASSWORD", "ITEM_COUNT", "REGEXP", "DATETIMETYPE", "SELECTONLY", "INFOPOP_ID", "MINLEN"};
    private static ArrayList<String> xmlValues = new ArrayList();

    static {
        int i = 0;
        while (i < xmlValuesAllowed.length) {
            xmlValues.add(xmlValuesAllowed[i]);
            ++i;
        }
    }

    public Info(Trace t, Attribute parent) {
        this.parent = parent;
        this.entries = new HashMap();
    }

    public void addEntry(Trace t, String key, String value) {
        if (key.equals("name")) {
            this.validateEntry(t, value);
        }
        this.entries.put(key, value);
    }

    public void validateEntry(Trace t, String key) {
        if (!xmlValues.contains(key)) {
            if (FfstChecker.isFfsting) {
                t.data(65, "Info.validateEntry", 300, "optional key (" + key + ") not found in info section for object " + this.parent.getObjectName(t));
            } else {
                System.err.println("Warning: Unknown value in info tags " + key + " in attribute " + this.parent.getAttributeName(t) + " in " + this.parent.getObjectName(t));
            }
        }
    }

    public String getName(Trace t) {
        return this.parent.checkHashMap(t, "name", this.entries, true);
    }

    public String getValue(Trace t) {
        return this.parent.checkHashMap(t, "value", this.entries, true);
    }

    public String getPlatform(Trace t) {
        return this.parent.checkHashMap(t, "platform", this.entries, false);
    }

    public String getCommandLevel(Trace t) {
        return this.parent.checkHashMap(t, "cmdlvl", this.entries, false);
    }

    public boolean isValid(Trace t, int commandLvl, int platform) {
        boolean valid = false;
        if (PlatformChecker.validPlatform(t, platform, this.getPlatform(t)) && PlatformChecker.validCommandLvl(t, commandLvl, this.getCommandLevel(t))) {
            valid = true;
        }
        if (Trace.isTracing) {
            t.data(65, "Info.isValid", 300, "Info for parent " + this.parent.getAttributeName(t) + ", commandlevel " + commandLvl + ", platform " + platform + ", valid=" + valid);
        }
        return valid;
    }
}

