/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.parser;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.parser.Attribute;
import com.ibm.mq.explorer.core.internal.parser.PlatformChecker;
import java.util.HashMap;

public class Enum {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/parser/Enum.java";
    private HashMap<String, String> entries = null;
    private Attribute parent = null;

    public Enum(Trace t, Attribute parent) {
        this.parent = parent;
        this.entries = new HashMap();
    }

    public void addEntry(Trace t, String key, String value) {
        this.entries.put(key, value);
    }

    public String getName(Trace t) {
        return this.parent.checkHashMap(t, "name", this.entries, true);
    }

    public String getValue(Trace t) {
        return this.parent.checkHashMap(t, "value", this.entries, true);
    }

    public String getPlatform(Trace t) {
        return this.parent.checkHashMap(t, "platform", this.entries, false);
    }

    public String getCommandLevel(Trace t) {
        return this.parent.checkHashMap(t, "cmdlvl", this.entries, false);
    }

    public boolean hasBeenSuperseded(Trace t, int commandLvl, int platform) {
        String val = this.parent.checkHashMap(t, "supercededcmdlvl", this.entries, false);
        if (val == null || "".equals(val)) {
            return false;
        }
        if (!PlatformChecker.validPlatform(t, platform, this.getPlatform(t))) {
            return false;
        }
        return !PlatformChecker.validCommandLvl(t, commandLvl, val);
    }

    public boolean isValid(Trace t, int commandLvl, int platform) {
        boolean valid = false;
        if (PlatformChecker.validPlatform(t, platform, this.getPlatform(t)) && PlatformChecker.validCommandLvl(t, commandLvl, this.getCommandLevel(t))) {
            valid = true;
        }
        if (Trace.isTracing) {
            t.data(65, "Enum.isValid", 300, "Enum for parent " + this.parent.getAttributeName(t) + ", commandlevel " + commandLvl + ", platform " + platform + ", valid=" + valid);
        }
        return valid;
    }
}

