/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.parser;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFactory;
import com.ibm.mq.explorer.core.internal.attrs.UpdateGroup;
import com.ibm.mq.explorer.core.internal.parser.Attribute;
import com.ibm.mq.explorer.core.internal.parser.Enum;
import com.ibm.mq.explorer.core.internal.parser.FfstChecker;
import com.ibm.mq.explorer.core.internal.parser.Info;
import com.ibm.mq.explorer.core.internal.parser.UpdateGroupList;
import com.ibm.mq.explorer.core.internal.parser.Where;
import com.ibm.mq.explorer.core.internal.parser.XmlObject;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DmXmlParser
extends DefaultHandler {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/parser/DmXmlParser.java";
    private static final String ELEMENT_OBJECT = "object";
    private static final String ELEMENT_ATTRIBUTE = "attribute";
    private static final String ELEMENT_CONSTANTS = "constants";
    private static final String ELEMENT_CONSTANT = "constant";
    private static final String ELEMENT_ENUM = "enum";
    private static final String ELEMENT_INFO = "info";
    private static final String ELEMENT_WHERE = "where";
    private static final String ELEMENT_PCFFILTER = "pcffilter";
    private static final int DEFAULT_PRIMARY_ATTRIBUTE = -1;
    private boolean foundObject = false;
    private boolean alreadyParsed = false;
    private String objectName = "";
    private XmlObject object = null;
    private Attribute currentAttribute;
    private Bundle bundle = null;
    private String root = null;
    String fullFilename = null;

    public DmXmlParser(Trace t, Bundle bund) {
        this.bundle = bund;
    }

    public DmXmlParser(Trace t, String root) {
        this.root = root;
    }

    public void init(Trace t, String name) {
        this.objectName = name;
        URL url = null;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        if (this.bundle != null) {
            this.fullFilename = "xml/" + name + ".xml";
            url = this.bundle.getEntry(this.fullFilename);
        } else {
            this.fullFilename = String.valueOf(this.root) + name + ".xml";
        }
        if (Trace.isTracing) {
            t.data(65, "DmXmlParser.init", 300, "Filename of XML file for object " + name + " is " + this.fullFilename);
        }
        try {
            SAXParser saxParser = factory.newSAXParser();
            if (this.bundle != null) {
                if (url != null) {
                    saxParser.parse(url.toString(), (DefaultHandler)this);
                } else if (FfstChecker.isFfsting) {
                    t.FFST(65, "DmXmlParser.init", 0, 50048, 0, 0, "An error occured whilst parsing xml file - could not get url from bundle", this.fullFilename, null);
                } else {
                    System.err.println("Error: An error occured whilst parsing xml file " + this.fullFilename + " - could not get url from bundle");
                }
            } else {
                saxParser.parse(new File(this.fullFilename), (DefaultHandler)this);
            }
        }
        catch (Throwable ex) {
            if (FfstChecker.isFfsting) {
                t.FFST(65, "DmXmlParser.init", 0, 50048, 0, 0, "An error occured whilst parsing xml file", this.fullFilename, ex.toString());
            }
            System.err.println("Error: An error occured whilst parsing xml file " + this.fullFilename + ": " + ex.toString());
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Trace t = Trace.getInstance();
        String aName = null;
        String aValue = null;
        if (this.alreadyParsed) {
            return;
        }
        if (this.foundObject) {
            int i;
            if (qName.equals(ELEMENT_OBJECT)) {
                this.foundObject = false;
                this.alreadyParsed = true;
                return;
            }
            if (qName.equals(ELEMENT_CONSTANT)) {
                int i2 = 0;
                while (i2 < attributes.getLength()) {
                    aName = attributes.getLocalName(i2);
                    if ("".equals(aName)) {
                        aName = attributes.getQName(i2);
                    }
                    aValue = attributes.getValue(i2);
                    this.object.addToConstants(t, aName, aValue);
                    ++i2;
                }
            } else if (qName.equals(ELEMENT_ATTRIBUTE)) {
                this.currentAttribute = new Attribute(t, this.object);
                int i3 = 0;
                while (i3 < attributes.getLength()) {
                    aName = attributes.getLocalName(i3);
                    if ("".equals(aName)) {
                        aName = attributes.getQName(i3);
                    }
                    aValue = attributes.getValue(i3);
                    this.currentAttribute.addAttribute(t, aName, aValue);
                    ++i3;
                }
            } else if (qName.equals(ELEMENT_ENUM)) {
                Enum currentEnum = new Enum(t, this.currentAttribute);
                i = 0;
                while (i < attributes.getLength()) {
                    aName = attributes.getLocalName(i);
                    if ("".equals(aName)) {
                        aName = attributes.getQName(i);
                    }
                    aValue = attributes.getValue(i);
                    currentEnum.addEntry(t, aName, aValue);
                    ++i;
                }
                this.currentAttribute.addEnum(t, currentEnum);
            } else if (qName.equals(ELEMENT_INFO)) {
                Info currentInfo = new Info(t, this.currentAttribute);
                i = 0;
                while (i < attributes.getLength()) {
                    aName = attributes.getLocalName(i);
                    if ("".equals(aName)) {
                        aName = attributes.getQName(i);
                    }
                    aValue = attributes.getValue(i);
                    currentInfo.addEntry(t, aName, aValue);
                    ++i;
                }
                this.currentAttribute.addInfo(t, currentInfo);
            } else if (qName.equals(ELEMENT_WHERE)) {
                Where currentWhere = new Where(t, this.currentAttribute);
                i = 0;
                while (i < attributes.getLength()) {
                    aName = attributes.getLocalName(i);
                    if ("".equals(aName)) {
                        aName = attributes.getQName(i);
                    }
                    aValue = attributes.getValue(i);
                    currentWhere.addEntry(t, aName, aValue);
                    ++i;
                }
                this.currentAttribute.addWhere(t, currentWhere);
            } else if (qName.equals(ELEMENT_PCFFILTER)) {
                int i4 = 0;
                while (i4 < attributes.getLength()) {
                    aName = attributes.getLocalName(i4);
                    if ("".equals(aName)) {
                        aName = attributes.getQName(i4);
                    }
                    aValue = attributes.getValue(i4);
                    this.currentAttribute.addAttribute(t, aName, aValue);
                    ++i4;
                }
            } else if (!qName.equals(ELEMENT_CONSTANTS)) {
                int i5 = 0;
                while (i5 < attributes.getLength()) {
                    aName = attributes.getLocalName(i5);
                    if ("".equals(aName)) {
                        aName = attributes.getQName(i5);
                    }
                    aValue = attributes.getValue(i5);
                    if (!this.currentAttribute.containsAttribute(t, aName)) {
                        this.currentAttribute.addAttribute(t, aName, aValue);
                    }
                    ++i5;
                }
                if (FfstChecker.isFfsting) {
                    t.data(65, "DmXmlParser.startElement", 300, "unknown tag " + qName + " found in XML file " + this.fullFilename);
                } else {
                    System.err.println("Warning: unknown tag " + qName + " found in XML file " + this.fullFilename);
                }
            }
        }
        if (qName.equals(ELEMENT_OBJECT)) {
            String platformApplicability = null;
            String cmdLvlApplicability = null;
            String readWrite = null;
            int i = 0;
            while (i < attributes.getLength()) {
                aName = attributes.getLocalName(i);
                if ("".equals(aName)) {
                    aName = attributes.getQName(i);
                }
                aValue = attributes.getValue(i);
                if (aName.equals("platform")) {
                    platformApplicability = aValue;
                } else if (aName.equals("cmdlvl")) {
                    cmdLvlApplicability = aValue;
                } else if (aName.equals("readwrite")) {
                    readWrite = aValue;
                } else if (aName.equals("value")) {
                    if (aValue.equalsIgnoreCase(this.objectName)) {
                        this.foundObject = true;
                        this.object = new XmlObject(t, this.objectName, this.bundle);
                    } else if (FfstChecker.isFfsting) {
                        t.data(65, "DmXmlParser.startElement", 300, "incorrect object " + aValue + " found in XML file " + this.fullFilename);
                    } else {
                        System.err.println("Error: incorrect object " + aValue + " found in XML file " + this.fullFilename);
                    }
                }
                ++i;
            }
            if (this.object != null) {
                if (platformApplicability != null) {
                    this.object.setPlatform(t, platformApplicability);
                }
                if (cmdLvlApplicability != null) {
                    this.object.setCmdLvl(t, cmdLvlApplicability);
                }
                if (readWrite != null) {
                    this.object.setReadWrite(t, readWrite);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        Trace t = Trace.getInstance();
        if (this.foundObject && qName.equals(ELEMENT_ATTRIBUTE)) {
            this.object.addAttribute(t, this.currentAttribute);
        }
    }

    public XmlObject getXmlObject(Trace t) {
        return this.object;
    }

    public HashMap<Integer, AttrType> generateAttributeHashMap(Trace t, int commandLvl, int platform) {
        HashMap<Integer, AttrType> generatedTable = null;
        if (this.object != null) {
            if (this.object.isValid(t, commandLvl, platform)) {
                AttrTypeFactory factory = new AttrTypeFactory(t, commandLvl, platform);
                ArrayList<Attribute> attributeList = this.object.getAttributes(t);
                generatedTable = new HashMap<Integer, AttrType>(attributeList.size());
                int i = 0;
                while (i < attributeList.size()) {
                    Attribute current = attributeList.get(i);
                    AttrType newAttr = null;
                    newAttr = factory.create(t, current);
                    if (newAttr != null) {
                        int key = current.getName(t);
                        generatedTable.put(key, newAttr);
                    }
                    ++i;
                }
            } else if (Trace.isTracing) {
                t.data(65, "DmXmlParser.generateAttributeHashMap", 300, String.valueOf(this.object.getObjectName(t)) + " not applicable to command level " + commandLvl + " and platform " + platform);
            }
        }
        return generatedTable;
    }

    public void validateAttributeHashMap(Trace t, int commandLvl, int platform) {
        if (this.object != null) {
            if (this.object.isValid(t, commandLvl, platform)) {
                AttrTypeFactory factory = new AttrTypeFactory(t, commandLvl, platform);
                ArrayList<Attribute> attributeList = this.object.getAttributes(t);
                int i = 0;
                while (i < attributeList.size()) {
                    Attribute current = attributeList.get(i);
                    factory.validate(t, current);
                    ++i;
                }
            } else if (Trace.isTracing) {
                t.data(65, "DmXmlParser.validateAttributeHashMap", 300, String.valueOf(this.object.getObjectName(t)) + " not applicable to command level " + commandLvl + " and platform " + platform);
            }
        }
    }

    public HashMap<String, UpdateGroup> generateUpdateGroupHashMap(Trace t) {
        HashMap<String, UpdateGroup> updateGroup = null;
        ArrayList<Attribute> attributeList = this.object.getAttributes(t);
        int i = 0;
        while (i < attributeList.size()) {
            Attribute current = attributeList.get(i);
            String updateGroupName = current.getUpdateGroup(t);
            if (updateGroupName != null) {
                if (updateGroup == null) {
                    updateGroup = new HashMap<String, UpdateGroup>();
                }
                if (updateGroup.containsKey(updateGroupName)) {
                    ((UpdateGroup)updateGroup.get(updateGroupName)).addAttribute(t, current.getPPCFValue(t), current.getName(t));
                } else {
                    UpdateGroup currentEntry;
                    if (UpdateGroupList.getUpdateGroups(t).containsKey(updateGroupName)) {
                        currentEntry = UpdateGroupList.getUpdateGroups(t).get(updateGroupName);
                    } else {
                        currentEntry = new UpdateGroup(t, updateGroupName, -1);
                        if (Trace.isTracing) {
                            t.data(65, "DmXmlParser.generateUpdateGroupHashMap", 900, "WARNING: " + updateGroupName + " is not a valid update group and has not been defined in the UpdateGroup.xml file");
                        }
                    }
                    currentEntry.addAttribute(t, current.getPPCFValue(t), current.getName(t));
                    updateGroup.put(updateGroupName, currentEntry);
                }
            }
            ++i;
        }
        return updateGroup;
    }
}

