/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.parser;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.objects.DisplayGroup;
import com.ibm.mq.explorer.core.internal.parser.Enum;
import com.ibm.mq.explorer.core.internal.parser.FfstChecker;
import com.ibm.mq.explorer.core.internal.parser.Info;
import com.ibm.mq.explorer.core.internal.parser.ParseUtils;
import com.ibm.mq.explorer.core.internal.parser.PlatformChecker;
import com.ibm.mq.explorer.core.internal.parser.UpdateGroupList;
import com.ibm.mq.explorer.core.internal.parser.Where;
import com.ibm.mq.explorer.core.internal.parser.XmlObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class Attribute {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/parser/Attribute.java";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_CMDLVL = "cmdlvl";
    public static final String ATTR_SUPERCEDEDCMDLVL = "supercededcmdlvl";
    public static final String ATTR_PLATFORM = "platform";
    public static final String ATTR_MQSCNAME = "mqscname";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_READWRITE = "readwrite";
    public static final String ATTR_READWRITEONCREATE = "readwriteoncreate";
    public static final String ATTR_RWTYPE = "rwtype";
    public static final String ATTR_RWIFEQ = "rwifeq";
    public static final String ATTR_RWIFNE = "rwifne";
    public static final String ATTR_DISPLAYGROUP = "displaygroup";
    public static final String ATTR_UPDATEGROUP = "updategroup";
    public static final String ATTR_DISTCOLSEQ = "distcolseq";
    public static final String ATTR_ZOSCOLSEQ = "zoscolseq";
    public static final String ATTR_GRPSEQ = "grpseq";
    public static final String ATTR_PCFTYPE = "pcftype";
    public static final String ATTR_REPEATING = "repeating";
    public static final String ATTR_PPCFVALUE = "ppcfvalue";
    public static final String ATTR_SEQUENCE = "sequence";
    public static final String ATTR_UGTYPE = "ugtype";
    public static final String ATTR_PRIMARY = "primary";
    public static final String ATTR_PLATFORMID = "platformid";
    public static final String ATTR_NEEDS_PCF = "needsPCF";
    public static final String ATTR_NEEDS_JMS = "needsJMS";
    public static final String ATTR_ID = "id";
    public static final String ATTR_OP = "op";
    public static final String ATTR_WHEREVAL = "wherevalue";
    public static final String ATTR_WHERETYPE = "wheretype";
    public static final String ATTR_FILTERNAME = "objectname";
    public static final String ATTR_FILTERTYPE = "objecttype";
    public static final String ATTR_SUBTYPE = "objectsubtype";
    private static final String PCF = "PCF";
    private static final String CFG = "CFG";
    private static final String QMH = "QMH";
    private static final String SUB = "SUB";
    private static final String DEFAULT_DISPLAYGROUP = "DisplayGroup.GENERAL";
    private static final boolean DEFAULT_READWRITEONCREATE = true;
    private static final boolean DEFAULT_REPEATING = false;
    private static final int DEFAULT_PCFTYPE = 0;
    private static final int DEFAULT_COLUMNSEQUENCE = 1;
    private static final int DEFAULT_GROUPSEQUENCE = 1;
    private static final int DEFAULT_MIN = 0;
    private static final int DEFAULT_ITEM_COUNT = -1;
    private static final String DEFAULT_REG_EXP = "";
    private static final boolean DEFAULT_PASSWORD = false;
    private static final boolean DEFAULT_TRIM = true;
    private static final boolean DEFAULT_UNIQUE = false;
    private static final boolean DEFAULT_SELECTONLY = false;
    private static final String DEFAULT_INFOPOP_ID = "";
    private HashMap<String, String> attributes = null;
    private ArrayList<Enum> enums = null;
    private ArrayList<Info> infos = null;
    private Where where = null;
    private XmlObject parent = null;
    private String attributeName = null;
    private static String[] xmlValuesAllowed = new String[]{"name", "value", "cmdlvl", "platform", "mqscname", "type", "readwrite", "displaygroup", "updategroup", "distcolseq", "zoscolseq", "grpseq", "pcftype", "ppcfvalue", "objectname", "objecttype", "objectsubtype", "supercededcmdlvl"};
    private static ArrayList<String> xmlValues = new ArrayList();

    static {
        int i = 0;
        while (i < xmlValuesAllowed.length) {
            xmlValues.add(xmlValuesAllowed[i]);
            ++i;
        }
    }

    public Attribute(Trace t, XmlObject object) {
        this.parent = object;
        this.attributes = new HashMap();
    }

    public HashMap<String, String> getAttributes(Trace t) {
        return this.attributes;
    }

    public ArrayList<Enum> getEnums(Trace t) {
        return this.enums;
    }

    public ArrayList<Info> getInfos(Trace t) {
        return this.infos;
    }

    public String getObjectName(Trace t) {
        return this.parent.getObjectName(t);
    }

    public String getAttributeName(Trace t) {
        return this.attributeName;
    }

    public void addAttribute(Trace t, String key, String value) {
        this.validateEntry(t, key);
        if (key.equals(ATTR_NAME)) {
            this.attributeName = value;
        }
        this.attributes.put(key, value);
    }

    public void validateEntry(Trace t, String key) {
        if (!xmlValues.contains(key)) {
            if (FfstChecker.isFfsting) {
                if (Trace.isTracing) {
                    t.data(65, "Attribute.validateEntry", 300, "optional key (" + key + ") not found in info section for object " + this.parent.getObjectName(t));
                }
            } else {
                System.err.println("Warning: Unknown value in info tags " + key + " in attribute " + this.getAttributeName(t) + " in " + this.parent.getObjectName(t));
            }
        }
    }

    public boolean containsAttribute(Trace t, String key) {
        return this.attributes.containsKey(key);
    }

    public String getAttribute(Trace t, String key) {
        return this.attributes.get(key);
    }

    public void addEnum(Trace t, Enum en) {
        if (this.enums == null) {
            this.enums = new ArrayList();
        }
        this.enums.add(en);
    }

    public void addInfo(Trace t, Info info) {
        if (this.infos == null) {
            this.infos = new ArrayList();
        }
        this.infos.add(info);
    }

    public void addWhere(Trace t, Where wh) {
        this.where = wh;
    }

    public boolean isValid(Trace t, int commandLvl, int platform) {
        boolean valid = false;
        if (PlatformChecker.validPlatform(t, platform, this.getPlatform(t)) && PlatformChecker.validCommandLvl(t, commandLvl, this.getCommandLevel(t))) {
            valid = true;
        }
        if (Trace.isTracing) {
            t.data(65, "Attribute.isValid", 300, "Attribute " + this.attributeName + ", commandlevel " + commandLvl + ", platform " + platform + ", valid=" + valid);
        }
        return valid;
    }

    public int getName(Trace t) {
        String value = this.checkHashMap(t, ATTR_NAME, this.attributes, true);
        int name = 0;
        if (value != null) {
            name = ParseUtils.getDefault(t).getIntValue(t, value, this.getOwningObject(t));
        }
        return name;
    }

    public void setName(Trace t, String value) {
        this.attributes.put(ATTR_NAME, value);
    }

    public String getValue(Trace t) {
        String value = this.checkHashMap(t, ATTR_VALUE, this.attributes, true);
        return value;
    }

    public void setValue(Trace t, String value) {
        this.attributes.put(ATTR_VALUE, value);
    }

    public String getType(Trace t) {
        return this.checkHashMap(t, ATTR_TYPE, this.attributes, true);
    }

    public void setType(Trace t, String value) {
        this.attributes.put(ATTR_TYPE, value);
    }

    public String getPlatform(Trace t) {
        String platform = this.checkHashMap(t, ATTR_PLATFORM, this.attributes, false);
        return platform;
    }

    public void setPlatform(Trace t, String value) {
        this.attributes.put(ATTR_PLATFORM, value);
    }

    public String getCommandLevel(Trace t) {
        return this.checkHashMap(t, ATTR_CMDLVL, this.attributes, false);
    }

    public void setCommandLevel(Trace t, String value) {
        this.attributes.put(ATTR_CMDLVL, value);
    }

    public String getSuperseded(Trace t) {
        return this.checkHashMap(t, ATTR_SUPERCEDEDCMDLVL, this.attributes, false);
    }

    public void setSuperseded(Trace t, String value) {
        this.attributes.put(ATTR_SUPERCEDEDCMDLVL, value);
    }

    public DisplayGroup getDisplayGroup(Trace t) {
        String displayGroup = DEFAULT_DISPLAYGROUP;
        String value = this.checkHashMap(t, ATTR_DISPLAYGROUP, this.attributes, false);
        if (value != null) {
            displayGroup = "DisplayGroup." + value;
        }
        return ParseUtils.getDefault(t).getDisplayGroupByReflection(t, displayGroup, this.getOwningObject(t));
    }

    public void setDisplayGroup(Trace t, String value) {
        this.attributes.put(ATTR_DISPLAYGROUP, value);
    }

    public int getSequence(Trace t) {
        int grpSequence = 1;
        String value = this.checkHashMap(t, ATTR_GRPSEQ, this.attributes, false);
        if (value != null) {
            grpSequence = ParseUtils.getDefault(t).getIntValue(t, value, this.getOwningObject(t));
        }
        return grpSequence;
    }

    public void setSequence(Trace t, String value) {
        this.attributes.put(ATTR_GRPSEQ, value);
    }

    public int getDistributedSequence(Trace t) {
        int distributedSequence = 1;
        String value = this.checkHashMap(t, ATTR_DISTCOLSEQ, this.attributes, false);
        if (value != null) {
            distributedSequence = ParseUtils.getDefault(t).getIntValue(t, value, this.getOwningObject(t));
        }
        return distributedSequence;
    }

    public void setDistributedSequence(Trace t, String value) {
        this.attributes.put(ATTR_DISTCOLSEQ, value);
    }

    public int getZosSequence(Trace t) {
        int zosSequence = 1;
        String value = this.checkHashMap(t, ATTR_ZOSCOLSEQ, this.attributes, false);
        if (value != null) {
            zosSequence = ParseUtils.getDefault(t).getIntValue(t, value, this.getOwningObject(t));
        }
        return zosSequence;
    }

    public void setZosSequence(Trace t, String value) {
        this.attributes.put(ATTR_ZOSCOLSEQ, value);
    }

    public boolean getRepeatingValue(Trace t) {
        boolean repeating = false;
        String value = this.checkHashMap(t, ATTR_REPEATING, this.attributes, false);
        if (value != null) {
            repeating = ParseUtils.getDefault(t).getBooleanValue(t, value, this.getOwningObject(t));
        } else {
            String updateGroup = this.getUpdateGroup(t);
            if (updateGroup != null && UpdateGroupList.getUpdateGroups(t) != null && UpdateGroupList.getUpdateGroups(t).containsKey(updateGroup) && UpdateGroupList.getUpdateGroups(t).get(updateGroup).getPrimaryAttribute() != -1) {
                repeating = true;
            }
        }
        return repeating;
    }

    public void setRepeating(Trace t, String value) {
        this.attributes.put(ATTR_REPEATING, value);
    }

    public boolean getReadWrite(Trace t) {
        boolean readWrite = this.getOwningObject(t).isReadWrite(t);
        String value = this.checkHashMap(t, ATTR_READWRITE, this.attributes, false);
        if (value != null) {
            readWrite = ParseUtils.getDefault(t).getBooleanValue(t, value, this.getOwningObject(t));
        }
        return readWrite;
    }

    public boolean getReadWriteOnCreate(Trace t) {
        boolean readWriteOnCreate = true;
        String value = this.checkHashMap(t, ATTR_READWRITEONCREATE, this.attributes, false);
        readWriteOnCreate = value != null ? ParseUtils.getDefault(t).getBooleanValue(t, value, this.getOwningObject(t)) : this.getReadWrite(t);
        return readWriteOnCreate;
    }

    public void setReadWrite(Trace t, String value) {
        this.attributes.put(ATTR_READWRITE, value);
    }

    public String getPPCFValue(Trace t) {
        return this.checkHashMap(t, ATTR_PPCFVALUE, this.attributes, false);
    }

    public void setPPCFValue(Trace t, String value) {
        this.attributes.put(ATTR_PPCFVALUE, value);
    }

    public String getUpdateGroup(Trace t) {
        return this.checkHashMap(t, ATTR_UPDATEGROUP, this.attributes, false);
    }

    public void setUpdateGroup(Trace t, String value) {
        this.attributes.put(ATTR_UPDATEGROUP, value);
    }

    public int getPCFType(Trace t) {
        int pcfType = 0;
        String value = this.checkHashMap(t, ATTR_PCFTYPE, this.attributes, false);
        if (value != null) {
            if (value.equals(PCF)) {
                pcfType = 0;
            } else if (value.equals(CFG)) {
                pcfType = 1;
            } else if (value.equals(QMH)) {
                pcfType = 2;
            } else if (value.equals(SUB)) {
                pcfType = 3;
            } else if (FfstChecker.isFfsting) {
                t.FFST(65, "Attribute.getPCFType", 0, 50051, 0, 0, "Unknown pcfType " + value, this.getObjectName(t), null);
            } else {
                System.err.println("Error: Unknown pcfType " + value + " in attribute " + this.attributeName + " in " + this.getObjectName(t));
            }
        }
        return pcfType;
    }

    public void setPCFType(Trace t, String value) {
        this.attributes.put(ATTR_PCFTYPE, value);
    }

    public String getFilterName(Trace t) {
        return this.checkHashMap(t, ATTR_FILTERNAME, this.attributes, true);
    }

    public Integer getFilterType(Trace t) {
        Integer filterType = -1;
        String value = this.checkHashMap(t, ATTR_FILTERTYPE, this.attributes, true);
        if (value != null) {
            filterType = ParseUtils.getDefault(t).getIntValue(t, value, this.getOwningObject(t));
        }
        return filterType;
    }

    public Integer getFilterSubType(Trace t) {
        Integer filterSubType = null;
        String value = this.checkHashMap(t, ATTR_SUBTYPE, this.attributes, false);
        if (value != null) {
            filterSubType = ParseUtils.getDefault(t).getIntValue(t, value, this.getOwningObject(t));
        }
        return filterSubType;
    }

    public String getDefaultValue(Trace t, int commandLvl, int platform) {
        return this.getInfoValue(t, "DEFAULT", commandLvl, platform, false);
    }

    public boolean getTrimmed(Trace t, int commandLvl, int platform) {
        boolean trimmed = true;
        String value = this.getInfoValue(t, "TRIM", commandLvl, platform, false);
        if (value != null) {
            trimmed = ParseUtils.getDefault(t).getBooleanValue(t, value, this.getOwningObject(t));
        }
        return trimmed;
    }

    public int getMaxLen(Trace t, int commandLvl, int platform) {
        int maxLen = -1;
        String value = this.getInfoValue(t, "MAXLEN", commandLvl, platform, true);
        if (value != null) {
            maxLen = ParseUtils.getDefault(t).getIntValue(t, value, this.getOwningObject(t));
        }
        return maxLen;
    }

    public int getMinLen(Trace t, int commandLvl, int platform) {
        int minLen = -1;
        String value = this.getInfoValue(t, "MINLEN", commandLvl, platform, true);
        if (value != null) {
            minLen = ParseUtils.getDefault(t).getIntValue(t, value, this.getOwningObject(t));
        }
        return minLen;
    }

    public int getTotLen(Trace t, int commandLvl, int platform) {
        int totLen = -1;
        String value = this.getInfoValue(t, "TOTLEN", commandLvl, platform, true);
        if (value != null) {
            totLen = ParseUtils.getDefault(t).getIntValue(t, value, this.getOwningObject(t));
        }
        return totLen;
    }

    public int getMin(Trace t, int commandLvl, int platform) {
        int min = 0;
        String value = this.getInfoValue(t, "MIN", commandLvl, platform, false);
        if (value != null) {
            min = ParseUtils.getDefault(t).getIntValue(t, value, this.getOwningObject(t));
        }
        return min;
    }

    public int getMax(Trace t, int commandLvl, int platform) {
        int max = -1;
        String value = this.getInfoValue(t, "MAX", commandLvl, platform, true);
        if (value != null) {
            max = ParseUtils.getDefault(t).getIntValue(t, value, this.getOwningObject(t));
        }
        return max;
    }

    public long getLongMin(Trace t, int commandLvl, int platform) {
        long min = 0L;
        String value = this.getInfoValue(t, "MIN", commandLvl, platform, false);
        if (value != null) {
            min = ParseUtils.getDefault(t).getLongValue(t, value, this.getOwningObject(t));
        }
        return min;
    }

    public long getLongMax(Trace t, int commandLvl, int platform) {
        long max = -1L;
        String value = this.getInfoValue(t, "MAX", commandLvl, platform, true);
        if (value != null) {
            max = ParseUtils.getDefault(t).getLongValue(t, value, this.getOwningObject(t));
        }
        return max;
    }

    public int getDateTimeType(Trace t, int commandLvl, int platform) {
        int dateTime = -1;
        String value = this.getInfoValue(t, "DATETIMETYPE", commandLvl, platform, true);
        if (value != null) {
            dateTime = ParseUtils.getDefault(t).getIntValue(t, value, this.getOwningObject(t));
        }
        return dateTime;
    }

    public int getItemCount(Trace t, int commandLvl, int platform) {
        int itemCount = -1;
        String value = this.getInfoValue(t, "ITEM_COUNT", commandLvl, platform, false);
        if (value != null) {
            itemCount = ParseUtils.getDefault(t).getIntValue(t, value, this.getOwningObject(t));
        }
        return itemCount;
    }

    public boolean getPassword(Trace t, int commandLvl, int platform) {
        boolean password = false;
        String value = this.getInfoValue(t, "PASSWORD", commandLvl, platform, false);
        if (value != null) {
            password = ParseUtils.getDefault(t).getBooleanValue(t, value, this.getOwningObject(t));
        }
        return password;
    }

    public boolean getUnique(Trace t, int commandLvl, int platform) {
        boolean unique = false;
        String value = this.getInfoValue(t, "UNIQUE", commandLvl, platform, false);
        if (value != null) {
            unique = ParseUtils.getDefault(t).getBooleanValue(t, value, this.getOwningObject(t));
        }
        return unique;
    }

    public String getRegExp(Trace t, int commandLvl, int platform) {
        String regExp = "";
        String value = this.getInfoValue(t, "REGEXP", commandLvl, platform, false);
        if (value != null) {
            regExp = value;
        }
        return regExp;
    }

    public Info getInfo(Trace t, String key, int commandLvl, int platform) {
        Info value = null;
        if (this.infos != null) {
            int i = 0;
            while (i < this.infos.size()) {
                Info current = this.infos.get(i);
                if (current.getName(t).equals(key) && current.isValid(t, commandLvl, platform)) {
                    value = current;
                }
                ++i;
            }
        }
        return value;
    }

    public String getInfoValue(Trace t, String key, int commandLvl, int platform, boolean mandatory) {
        String returnVal = null;
        Info value = null;
        if (this.infos != null) {
            int i = 0;
            while (i < this.infos.size()) {
                Info current = this.infos.get(i);
                if (current.getName(t).equals(key) && current.isValid(t, commandLvl, platform)) {
                    value = current;
                }
                ++i;
            }
        }
        if (value != null) {
            returnVal = value.getValue(t);
        } else if (mandatory) {
            if (FfstChecker.isFfsting) {
                t.FFST(65, "Attribute.getInfoValue", 0, 50050, 0, 0, "mandatory key (" + key + ") not found in attribute " + this.attributeName, this.getObjectName(t), null);
            } else {
                System.err.println("Error: mandatory key (" + key + ") not found in attribute " + this.attributeName + " in " + this.getObjectName(t));
            }
        } else if (Trace.isTracing) {
            t.data(65, "Attribute.getInfoValue", 300, "optional key (" + key + ") not found in info section for object " + this.getObjectName(t));
        }
        return returnVal;
    }

    public int[] getEnumNames(Trace t) {
        return this.getEnumNames(t, -1, -1);
    }

    public String[] getEnumStringNames(Trace t) {
        return this.getEnumStringNames(t, -1, -1);
    }

    public String[] getEnumValues(Trace t) {
        return this.getEnumValues(t, -1, -1);
    }

    public int[] getEnumNames(Trace t, int commandLvl, int platform) {
        ArrayList<Integer> names = new ArrayList<Integer>();
        if (this.enums != null) {
            int i = 0;
            while (i < this.enums.size()) {
                Enum current = this.enums.get(i);
                if (current.isValid(t, commandLvl, platform)) {
                    names.add(ParseUtils.getDefault(t).getIntValue(t, current.getName(t), this.getOwningObject(t)));
                }
                ++i;
            }
        }
        return ParseUtils.getDefault(t).getIntArray(t, names, this.getOwningObject(t));
    }

    public String[] getEnumStringNames(Trace t, int commandLvl, int platform) {
        ArrayList<String> names = new ArrayList<String>();
        if (this.enums != null) {
            int i = 0;
            while (i < this.enums.size()) {
                Enum current = this.enums.get(i);
                if (current.isValid(t, commandLvl, platform)) {
                    names.add(current.getName(t));
                }
                ++i;
            }
        }
        return names.toArray(new String[names.size()]);
    }

    public String[] getEnumValues(Trace t, int commandLvl, int platform) {
        ArrayList<String> names = new ArrayList<String>();
        if (this.enums != null) {
            int i = 0;
            while (i < this.enums.size()) {
                Enum current = this.enums.get(i);
                if (current.isValid(t, commandLvl, platform)) {
                    names.add(current.getValue(t));
                }
                ++i;
            }
        }
        return names.toArray(new String[names.size()]);
    }

    public Set<String> getEnumSupersededValues(Trace t, int commandLvl, int platform) {
        HashSet<String> supersededValues = new HashSet<String>();
        if (this.enums != null) {
            for (Enum current : this.enums) {
                if (!current.hasBeenSuperseded(t, commandLvl, platform)) continue;
                supersededValues.add(current.getName(t));
            }
        }
        return supersededValues;
    }

    public Integer getWhereId(Trace t) {
        String value;
        Integer whereId = null;
        if (this.where != null && (value = this.where.getId(t)) != null) {
            whereId = ParseUtils.getDefault(t).getIntValue(t, value, this.getOwningObject(t));
        }
        return whereId;
    }

    public Integer getWhereOp(Trace t) {
        String value;
        Integer whereOp = null;
        if (this.where != null && (value = this.where.getOp(t)) != null) {
            whereOp = ParseUtils.getDefault(t).getIntValue(t, value, this.getOwningObject(t));
        }
        return whereOp;
    }

    public Object getWhereVal(Trace t) {
        String value;
        Object whereVal = null;
        if (this.where != null && (value = this.where.getVal(t)) != null) {
            whereVal = this.getWhereType(t).equals("INT") ? Integer.valueOf(ParseUtils.getDefault(t).getIntValue(t, value, this.getOwningObject(t))) : value;
        }
        return whereVal;
    }

    public String getWhereType(Trace t) {
        String value;
        String whereType = null;
        if (this.where != null && (value = this.where.getType(t)) != null) {
            whereType = value;
        }
        return whereType;
    }

    public boolean getSelectOnly(Trace t, int commandLvl, int platform) {
        boolean selectOnly = false;
        String value = this.getInfoValue(t, "SELECTONLY", commandLvl, platform, false);
        if (value != null) {
            selectOnly = ParseUtils.getDefault(t).getBooleanValue(t, value, this.getOwningObject(t));
        }
        return selectOnly;
    }

    public String getInfoPopId(Trace t, int commandLvl, int platform) {
        String infoPopId = "";
        String value = this.getInfoValue(t, "INFOPOP_ID", commandLvl, platform, false);
        if (value != null) {
            infoPopId = value;
        }
        return infoPopId;
    }

    public String checkHashMap(Trace t, String element, HashMap<String, String> check, boolean mandatory) {
        String value = null;
        if (check.containsKey(element)) {
            value = check.get(element);
        } else if (mandatory) {
            if (FfstChecker.isFfsting) {
                t.FFST(65, "Attribute.checkHashMap", 0, 50050, 0, 0, "mandatory key (" + element + ") not found in attribute " + this.attributeName, this.getObjectName(t), check.toString());
            } else {
                System.err.println("Error: mandatory key (" + element + ") not found in attribute " + this.attributeName + " in " + this.getObjectName(t));
            }
        } else if (Trace.isTracing) {
            t.data(65, "Attribute.checkHashMap", 300, "optional key (" + element + ") not found in " + check + " for attribute " + this.attributeName + " in object " + this.getObjectName(t));
        }
        return value;
    }

    public XmlObject getOwningObject(Trace t) {
        return this.parent.getOwningObject(t);
    }
}

