/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.UpdateGroup;
import com.ibm.mq.explorer.core.internal.parser.DmXmlParser;
import java.util.HashMap;
import java.util.Hashtable;
import org.osgi.framework.Bundle;

public class TableFactory {
    public static final String COPYRIGHT = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/objects/TableFactory.java";
    private static Hashtable tables = new Hashtable(9);
    private static final String ZERO_PADDING = "000";
    private static final String CONFIG = "Config";
    private static HashMap<String, DmXmlParser> parsingMap = new HashMap();

    private TableFactory() {
    }

    private static String generateKey(Trace t, String name, int cmdlvl, int platform) {
        String commandLevel = Integer.toString(cmdlvl);
        String platformID = Integer.toString(platform);
        if (platformID.length() < ZERO_PADDING.length()) {
            platformID = String.valueOf(ZERO_PADDING.substring(platformID.length())) + platformID;
        }
        if (commandLevel.length() < ZERO_PADDING.length()) {
            commandLevel = String.valueOf(ZERO_PADDING.substring(commandLevel.length())) + commandLevel;
        }
        String key = String.valueOf(name) + commandLevel + platformID;
        if (Trace.isTracing) {
            t.data(65, "TableFactory.generateKey", 300, "Class key name is " + key);
        }
        return key;
    }

    public static HashMap getHashMap(Trace t, String name, Bundle bund) {
        HashMap<Integer, AttrType> table = (HashMap<Integer, AttrType>)tables.get(name);
        if (table == null) {
            DmXmlParser xmlParser = new DmXmlParser(t, bund);
            xmlParser.init(t, name);
            table = xmlParser.generateAttributeHashMap(t, -1, -1);
            parsingMap.put(name, xmlParser);
            if (table != null) {
                tables.put(name, table);
                if (Trace.isTracing) {
                    t.data(65, "TableFactory.getHashMap", 300, "Loaded table " + name);
                }
            } else if (Trace.isTracing) {
                t.data(65, "TableFactory.getHashMap", 900, "Unable to find table " + name);
            }
        } else if (Trace.isTracing) {
            t.data(65, "TableFactory.getHashMap", 300, "Reusing table " + name);
        }
        return table;
    }

    public static HashMap getHashMap(Trace t, String name, int commandLevel, int platform) {
        String key = TableFactory.generateKey(t, name, commandLevel, platform);
        HashMap<Integer, AttrType> table = (HashMap<Integer, AttrType>)tables.get(key);
        if (table == null && (table = parsingMap.get(name).generateAttributeHashMap(t, commandLevel, platform)) != null) {
            tables.put(key, table);
        }
        return table;
    }

    public static HashMap getConfigHashMap(Trace t, String name) {
        String key = String.valueOf(name) + CONFIG;
        HashMap<String, UpdateGroup> table = (HashMap<String, UpdateGroup>)tables.get(key);
        if (table == null && (table = parsingMap.get(name).generateUpdateGroupHashMap(t)) != null) {
            tables.put(key, table);
        }
        return table;
    }
}

