/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.objects;

import com.ibm.mq.MQException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.pcf.PCFCommands;
import com.ibm.mq.explorer.core.internal.report.ReportManager;
import com.ibm.mq.explorer.core.internal.utils.ConvertReasonCode;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFParameter;
import com.ibm.mq.pcf.event.PCFQuery;
import java.util.HashSet;
import java.util.Set;

public class PCFAction
extends Thread {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/objects/PCFAction.java";
    public static Set<Integer> DEBUG;
    private DmObject dmObject = null;
    private PCFMessage request = null;
    private int command = 0;
    private int action = 0;
    private DmActionListener listener = null;
    private int reasonCode = 0;
    private int completionCode = 0;
    private DmCoreException dmCoreException = null;
    public static final String SEPARATOR = "@";

    static {
        String value = System.getProperty("com.ibm.mq.explorer.core.internal.objects.PCFAction.DEBUG");
        if (value != null) {
            String[] words;
            DEBUG = new HashSet<Integer>();
            String[] stringArray = words = value.split(",");
            int n = words.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                Integer cmd = Integer.parseInt(word);
                DEBUG.add(cmd);
                ++n2;
            }
        }
    }

    public PCFAction(Trace t, int cmd, DmObject dmo) {
        this.dmObject = dmo;
        this.command = cmd;
        this.request = new PCFMessage(cmd);
        if (Trace.isTracing) {
            t.data(65, "PCFAction.PCFAction", 300, "Creating PCFAction " + this.command + " for " + this.dmObject.getTitle());
        }
    }

    @Override
    public void run() {
        Trace t = Trace.getInstance();
        if (Trace.isTracing) {
            t.data(65, "PCFAction.run", 300, "Running asynchronous PCFAction " + this.command + " for " + this.dmObject.getTitle());
        }
        this.reasonCode = this.execute(t);
        if (Trace.isTracing) {
            t.data(65, "PCFAction.run", 300, "Notifying listener, rc=" + this.reasonCode);
        }
        if (this.reasonCode == 0) {
            this.listener.dmActionDone(new DmActionEvent(this.dmObject, this.command, this.reasonCode));
        } else {
            String msg = ConvertReasonCode.getSystemMessage(t, this.dmObject, this.command, this.reasonCode, this.completionCode);
            String msgId = CommonServices.getSystemMessageId((Trace)t, (int)this.reasonCode);
            int severity = CommonServices.getSystemMessageSeverity((Trace)t, (String)msgId);
            this.dmCoreException = new DmCoreException(t, msg, msgId, this.reasonCode, this.completionCode, severity);
            this.listener.dmActionDone(new DmActionEvent(this.dmObject, this.command, this.reasonCode, this.dmCoreException));
        }
    }

    protected void addParameter(Trace t, PCFParameter parameter) {
        if (Trace.isTracing) {
            t.data(65, "PCFAction.addParameter", 300, "Adding PCF id " + parameter.getParameter() + ", value = " + parameter.getStringValue());
        }
        this.request.addParameter(parameter);
    }

    protected int execute(Trace t, DmActionListener aListener) {
        return this.execute(t, aListener, 4);
    }

    protected int execute(Trace t, DmActionListener _Listener, int _action) {
        int rc = 0;
        this.action = _action;
        if (_Listener == null) {
            if (Trace.isTracing) {
                t.data(65, "PCFAction.execute", 300, String.valueOf(this.action) + " command will be run synchronously");
            }
            rc = this.execute(t);
        } else {
            if (Trace.isTracing) {
                t.data(65, "PCFAction.execute", 300, String.valueOf(this.action) + " command will be run asynchronously");
            }
            this.listener = _Listener;
            this.start();
        }
        return rc;
    }

    protected int execute(Trace t) {
        int rc = 2149;
        ReportManager.getDefault().add(t, this.dmObject.getQueueManager().getTitle(), this.request);
        if (Trace.isTracing) {
            t.data(65, "PCFAction.execute", 300, "Sending PCF command " + this.command + " for " + this.dmObject.getTitle() + " to " + this.dmObject.getQueueManager().getTitle() + "\n" + this.request.toString());
        }
        try {
            PCFMessage[] responses;
            if (DEBUG != null) {
                this.debug("PCFAction.execute", this.request);
            }
            if ((responses = this.dmObject.getQueueManager().sendCommand(t, this.request)) != null) {
                PCFMessage message = responses[0];
                rc = message.getReason();
            }
        }
        catch (MQException mqe) {
            rc = mqe.reasonCode;
            PCFQuery.traceMQRequest((Trace)t, (PCFMessage)this.request);
            PCFQuery.traceMQException((Trace)t, (MQException)mqe);
        }
        return rc;
    }

    private void debug(String text, PCFMessage msg) {
        int cmd = msg.getCommand();
        if (DEBUG.contains(cmd)) {
            this.log(text, msg);
        }
    }

    private void log(String text, PCFMessage msg) {
        int cmd = msg.getCommand();
        StringBuffer sb = new StringBuffer();
        sb.append(text);
        sb.append(": ");
        sb.append(MQConstants.lookup((int)cmd, (String)"MQCMD_.*"));
        System.out.println(sb.toString());
    }

    public PCFMessage getRequest(Trace t) {
        return this.request;
    }

    public static int getPCFNameId(Trace t, int objectType) {
        switch (objectType) {
            case 114: {
                return 2015;
            }
            case 1013: {
                return 2015;
            }
            case 83: {
                return 2045;
            }
            case 87: {
                return 2015;
            }
            case 25: {
                return 3501;
            }
            case 1009: {
                return 3501;
            }
            case 1010: {
                return 3501;
            }
            case 204: {
                return 3501;
            }
            case 70: {
                return 3501;
            }
            case 1005: {
                return 3501;
            }
            case 1004: {
                return 2016;
            }
            case 191: {
                return 2110;
            }
            case 85: {
                return 7006;
            }
            case 1006: {
                return 7006;
            }
            case 115: {
                return 2039;
            }
            case 186: {
                return 3183;
            }
            case 199: {
                return 3186;
            }
            case 1019: {
                return 2039;
            }
            case 1020: {
                return 2039;
            }
            case 1021: {
                return 2039;
            }
            case 1028: {
                return 2039;
            }
            case 1000: {
                return 2015;
            }
            case 1015: {
                return 2015;
            }
            case 88: {
                return 2015;
            }
            case 97: {
                return 3554;
            }
            case 98: {
                return 3554;
            }
            case 120: {
                return 2015;
            }
            case 1011: {
                return 2015;
            }
            case 1012: {
                return 2015;
            }
            case 36: {
                return 2010;
            }
            case 7: {
                return 2012;
            }
            case 185: {
                return 2015;
            }
            case 1031: {
                return 3211;
            }
            case 1032: {
                return 3228;
            }
            case 2: {
                return 2015;
            }
            case 161: {
                return 2015;
            }
            case 13: {
                return 2016;
            }
            case 119: {
                return 2015;
            }
            case 1007: {
                return 2016;
            }
            case 1008: {
                return 2016;
            }
            case 1030: {
                return 2017;
            }
            case 121: {
                return 2015;
            }
            case 1014: {
                return 2015;
            }
            case 153: {
                return 2077;
            }
            case 154: {
                return 2077;
            }
            case 122: {
                return 2022;
            }
            case 176: {
                return 3152;
            }
            case 182: {
                return 3152;
            }
            case 123: {
                return 2015;
            }
            case 174: {
                return 2092;
            }
            case 183: {
                return 2092;
            }
            case 1022: {
                return 2092;
            }
            case 1023: {
                return 2092;
            }
            case 126: {
                return 2015;
            }
            case 1016: {
                return 2015;
            }
            case 1017: {
                return 2015;
            }
            case 1018: {
                return 2015;
            }
            case 1029: {
                return 2015;
            }
            case 1024: {
                return 2092;
            }
            case 1026: {
                return 3501;
            }
            case 1027: {
                return 3501;
            }
        }
        if (Trace.isTracing) {
            t.data(65, "PCFAction.getPCFNameId", 900, "Unknown object type : " + objectType);
        }
        return -1;
    }

    public static int getPCFTypeId(Trace t, int objectType) {
        switch (objectType) {
            case 114: {
                return 1175;
            }
            case 1013: {
                return 1175;
            }
            case 25: {
                return 1511;
            }
            case 1009: {
                return 1523;
            }
            case 1010: {
                return 1523;
            }
            case 204: {
                return 1352;
            }
            case 1005: {
                return 1511;
            }
            case 1004: {
                return 20;
            }
            case 1024: {
                return 208;
            }
            case 85: {
                return 1110;
            }
            case 1006: {
                return 1110;
            }
            case 1019: {
                return 1135;
            }
            case 1020: {
                return 1135;
            }
            case 1021: {
                return 1135;
            }
            case 1028: {
                return 1135;
            }
            case 1015: {
                return 1501;
            }
            case 97: {
                return 1501;
            }
            case 120: {
                return 1175;
            }
            case 1011: {
                return 1175;
            }
            case 1012: {
                return 1175;
            }
            case 185: {
                return 1314;
            }
            case 1031: {
                return 1460;
            }
            case 1032: {
                return 1474;
            }
            case 13: {
                return 20;
            }
            case 119: {
                return 2015;
            }
            case 1007: {
                return 1103;
            }
            case 1008: {
                return 1103;
            }
            case 121: {
                return 1152;
            }
            case 1014: {
                return 1154;
            }
            case 153: {
                return 121;
            }
            case 123: {
                return 1175;
            }
            case 183: {
                return 1302;
            }
            case 1022: {
                return 1302;
            }
            case 1023: {
                return 1302;
            }
            case 126: {
                return 1175;
            }
            case 1016: {
                return 1157;
            }
            case 1017: {
                return 1157;
            }
            case 1018: {
                return 1157;
            }
            case 1029: {
                return 1157;
            }
            case 1026: {
                return 1511;
            }
        }
        if (Trace.isTracing) {
            t.data(65, "PCFAction.getPCFTypeId", 900, "Unknown object type : " + objectType);
        }
        return -1;
    }

    public static PCFQuery getStatusQuery(Trace t, String uuid, int objectType, String name) {
        PCFQuery query = null;
        switch (objectType) {
            case 25: {
                query = new PCFQuery(PCFCommands.createTemplate(t, uuid, 7), name);
                break;
            }
            case 115: {
                query = new PCFQuery(PCFCommands.createTemplate(t, uuid, 16), name);
                break;
            }
            case 97: {
                query = new PCFQuery(PCFCommands.createTemplate(t, uuid, 22), name);
                break;
            }
            case 13: {
                query = new PCFQuery(PCFCommands.createTemplate(t, uuid, 32), name);
                break;
            }
            case 2: {
                query = new PCFQuery(PCFCommands.createTemplate(t, uuid, 30));
                break;
            }
            case 153: {
                query = new PCFQuery(PCFCommands.createTemplate(t, uuid, 37), name);
                break;
            }
            case 176: {
                query = new PCFQuery(PCFCommands.createTemplate(t, uuid, 48), name);
                break;
            }
            case 174: {
                query = new PCFQuery(PCFCommands.createTemplate(t, uuid, 49), name);
            }
        }
        if (query != null) {
            t.data(65, "PCFAction.getStatusQuery", 300, "PCF status query : " + query.getTemplate().toString());
        } else {
            t.data(65, "PCFAction.getStatusQuery", 900, "Unknown object type : " + objectType);
        }
        return query;
    }

    public static int getStatusQueryObjectType(Trace t, int objectType) {
        int retValue = -1;
        switch (objectType) {
            case 25: {
                retValue = 1009;
                break;
            }
            case 115: {
                retValue = 1020;
                break;
            }
            case 97: {
                retValue = 98;
                break;
            }
            case 13: {
                retValue = 1008;
                break;
            }
            case 2: {
                retValue = 161;
                break;
            }
            case 153: {
                retValue = 154;
            }
        }
        if (Trace.isTracing) {
            t.data(65, "PCFAction.getStatusQueryObjectType", 900, "Status object type " + retValue + " associated with " + objectType);
        }
        return retValue;
    }

    public static boolean isStatusQuery(Trace t, int command) {
        boolean retValue = false;
        switch (command) {
            case 98: 
            case 154: 
            case 161: 
            case 182: 
            case 183: 
            case 1007: 
            case 1008: 
            case 1009: 
            case 1010: 
            case 1019: 
            case 1020: 
            case 1021: 
            case 1022: 
            case 1023: 
            case 1028: 
            case 1031: 
            case 1032: {
                retValue = true;
            }
        }
        if (Trace.isTracing) {
            if (retValue) {
                t.data(65, "PCFAction.isStatusQuery", 300, "Dm object type " + command + " is for a status object");
            } else {
                t.data(65, "PCFAction.isStatusQuery", 300, "Dm object type " + command + " is not for a status object");
            }
        }
        return retValue;
    }
}

