/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrKey;
import com.ibm.mq.explorer.core.internal.attrs.AttrString;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.core.internal.objects.PCFAction;
import com.ibm.mq.pcf.PCFMessage;
import java.util.HashMap;
import java.util.Hashtable;
import org.osgi.framework.Bundle;

public class DmTopic
extends DmObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/objects/DmTopic.java";
    protected static final String DEFAULT = "SYSTEM.DEFAULT.TOPIC";
    protected static final String BASE = "SYSTEM.BASE.TOPIC";
    private static HashMap<Integer, AttrType> allAttributesByType = null;

    protected DmTopic(Trace t, String nn) {
        super(nn, 174);
    }

    public static boolean staticInit(Trace t, Bundle bund) {
        allAttributesByType = DmTopic.initAllAttrTypeTable(t, DmTopic.getClassName(DmTopic.class.getName()), allAttributesByType, bund);
        if (allAttributesByType == null) {
            if (Trace.isTracing) {
                t.data(65, "DmTopic.staticInit", 900, "Error loading allAttributesByType table");
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean init(Trace t) {
        this.addAttr(t, this.attributesByType, 2092, 0, this.getTitle());
        return true;
    }

    public static String getAttributeTitle(Trace t, int id) {
        return DmTopic.getAttributeTitle(t, allAttributesByType, id);
    }

    public static AttrType getAttributeType(Trace t, int id) {
        return DmTopic.getAttributeType(t, allAttributesByType, id);
    }

    public static String getAttributeDefaultValue(Trace t, int id) {
        return DmTopic.getAttributeDefaultValue(t, allAttributesByType, id);
    }

    public static int[] getDisplayColumnSequence(Trace t, int[] ids, boolean zOS) {
        return DmTopic.getDisplayColumnSequence(t, allAttributesByType, ids, zOS);
    }

    public static boolean isAttributeRepeating(Trace t, int id) {
        return DmTopic.isAttributeRepeating(t, allAttributesByType, id);
    }

    public static int[] getAllAttributesByType(Trace t) {
        return DmTopic.getAllAttributesByType(t, allAttributesByType);
    }

    @Override
    public String toString(Trace t) {
        return this.getTitle();
    }

    @Override
    public void close(Trace t) {
    }

    public int actionDelete(Trace t, DmActionListener listener) {
        return this.actionDelete(t, listener, null);
    }

    @Override
    public int actionDelete(Trace t, DmActionListener listener, Object parms) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmTopic.actionDelete", 300, "Deleting topic " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 173, this);
        cmd.getRequest(t).addParameter(2092, this.getTitle());
        this.addQSGDispToRequest(t, cmd);
        if (parms != null && this.getQueueManager().getCommandLevel() >= 710 && this.getQueueManager().getPlatform() != 1) {
            cmd.getRequest(t).addParameter(1398, ((int[])parms)[0]);
        }
        rc = cmd.execute(t, listener, 2);
        return rc;
    }

    @Override
    public int actionCreate(Trace t, DmActionListener listener, Object job) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmTopic.actionCreate", 300, "Creating topic " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 171, this);
        cmd.getRequest(t).addParameter(3150, this.getClonedFrom());
        cmd.getRequest(t).addParameter(3149, this.getTitle());
        this.mergeNewWithChangesToPCFRequest(t, job, cmd.getRequest(t));
        this.addTopicStringToRequest(t, cmd.getRequest(t), job);
        this.endUpdate(t, job);
        rc = cmd.execute(t, listener);
        return rc;
    }

    @Override
    public int actionChange(Trace t, DmActionListener listener, Object job, boolean force) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmTopic.actionChange", 300, "Changing topic " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 170, this);
        cmd.getRequest(t).addParameter(2092, this.getTitle());
        this.addQSGDispToRequest(t, cmd);
        this.appendToPCFRequest(t, job, cmd.getRequest(t));
        this.endUpdate(t, job);
        rc = cmd.execute(t, listener);
        return rc;
    }

    public int actionClearTopicString(Trace t, DmActionListener listener, int scope) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmTopic.actionClearTopicString", 300, "Clear retained message from " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 184, this);
        cmd.getRequest(t).addParameter(2094, this.getAttributeValue(t, 2094, 0));
        cmd.getRequest(t).addParameter(1305, 1);
        cmd.getRequest(t).addParameter(1306, scope);
        rc = cmd.execute(t, listener);
        return rc;
    }

    @Override
    public boolean isSystemDefault(Trace t) {
        boolean retValue = false;
        if (this.getTitle().equals(DEFAULT)) {
            retValue = true;
        }
        return retValue;
    }

    public static String getDefaultName(Trace t) {
        return DEFAULT;
    }

    public static String getBaseName(Trace t) {
        return BASE;
    }

    @Override
    public int[] getMandatoryIds(Trace t) {
        return DmTopic.getMandatoryIds();
    }

    public static int[] getMandatoryIds() {
        return new int[]{2092, 2094};
    }

    @Override
    public void initialize(Trace t) {
        this.setName(t, 2092);
        Attr attr = this.getAttribute(t, 63, 0);
        if (attr != null) {
            attr.setReadWrite(t, false);
        }
    }

    public static int[] getValidAuthorities(Trace t) {
        return DmTopic.getValidAuthorities(t, allAttributesByType);
    }

    private void addTopicStringToRequest(Trace t, PCFMessage req, Object job) {
        int attrId = 2094;
        if (req.getParameter(attrId) == null) {
            Hashtable<AttrKey, Attr> table = this.getUpdateTable(t, job);
            AttrKey ak = new AttrKey(attrId, 0);
            AttrString attr = (AttrString)table.remove(ak);
            Object value = null;
            if (attr != null) {
                value = attr.getNewValue(t);
            } else {
                attr = (AttrString)this.getAttribute(t, attrId, 0);
                if (attr != null) {
                    value = attr.getValue(t);
                } else {
                    IDmObject original = this.getClonedFromObject();
                    if (original != null && (attr = (AttrString)original.getAttribute(t, attrId, 0)) != null) {
                        value = attr.getValue(t);
                    }
                }
            }
            if (value != null) {
                String topicString = value.toString();
                req.addParameter(attrId, topicString);
            } else if (Trace.isTracing) {
                t.data(65, "DmTopic.addTopicStringToRequest", 900, "CMQC.MQCA_TOPIC_STRING not found to set for the CMQCFC.MQCMD_COPY_TOPIC command");
            }
        } else if (Trace.isTracing) {
            t.data(65, "DmTopic.addTopicStringToRequest", 300, "CMQC.MQCA_TOPIC_STRING already set for the CMQCFC.MQCMD_COPY_TOPIC command");
        }
    }

    @Override
    public int getStatusType(Trace t) {
        return this.getQueueManager().getStatusType(t, 174, this.getObjectSubType(t));
    }

    @Override
    public int getNameAttributeId() {
        return 2092;
    }
}

