/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthStringEnum;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmObjectFactory;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.PCFAction;
import com.ibm.mq.pcf.PCFMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.osgi.framework.Bundle;

public class DmTelemetryChannel
extends DmObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/objects/DmTelemetryChannel.java";
    public static final String DEFAULT_TELEMETRY_CHANNEL = "SYSTEM.DEF.MQTT";
    private static HashMap<Integer, AttrType> allAttributesByType = null;

    protected DmTelemetryChannel(Trace t, String cn) {
        super(cn, 1026);
    }

    public static boolean staticInit(Trace t, Bundle bund) {
        allAttributesByType = DmTelemetryChannel.initAllAttrTypeTable(t, DmTelemetryChannel.getClassName(DmTelemetryChannel.class.getName()), allAttributesByType, bund);
        if (allAttributesByType == null) {
            if (Trace.isTracing) {
                t.data(65, "DmTelemetryChannel.staticInit", 900, "Error loading allAttributesByType table");
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean init(Trace t) {
        this.addAttr(t, this.attributesByType, 3501, 0, this.getTitle());
        this.addAttr(t, this.attributesByType, 1527, 0, 0);
        return true;
    }

    public static String getAttributeTitle(Trace t, int id) {
        return DmTelemetryChannel.getAttributeTitle(t, allAttributesByType, id);
    }

    public static AttrType getAttributeType(Trace t, int id) {
        return DmTelemetryChannel.getAttributeType(t, allAttributesByType, id);
    }

    public static String getAttributeDefaultValue(Trace t, int id) {
        return DmTelemetryChannel.getAttributeDefaultValue(t, allAttributesByType, id);
    }

    public static int[] getDisplayColumnSequence(Trace t, int[] ids, boolean zOS) {
        return DmTelemetryChannel.getDisplayColumnSequence(t, allAttributesByType, ids, zOS);
    }

    public static boolean isAttributeRepeating(Trace t, int id) {
        return DmTelemetryChannel.isAttributeRepeating(t, allAttributesByType, id);
    }

    public static int[] getAllAttributesByType(Trace t) {
        return DmTelemetryChannel.getAllAttributesByType(t, allAttributesByType);
    }

    @Override
    public String toString(Trace t) {
        return this.getTitle();
    }

    @Override
    public void close(Trace t) {
    }

    @Override
    public int actionDelete(Trace t, DmActionListener listener, Object parms) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmTelemetryChannel.actionDelete", 300, "Deleting TelemetryChannel " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 24, this);
        PCFMessage pcfMessage = cmd.getRequest(t);
        pcfMessage.addParameter(3501, this.getTitle());
        pcfMessage.addParameter(1511, 10);
        rc = cmd.execute(t, listener, 2);
        return rc;
    }

    @Override
    public int actionCreate(Trace t, DmActionListener listener, Object job) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmTelemetryChannel.actionCreate", 300, "Creating TelemetryChannel " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 22, this);
        PCFMessage pcfMessage = cmd.getRequest(t);
        pcfMessage.addParameter(3007, this.getClonedFrom());
        pcfMessage.addParameter(3008, this.getTitle());
        pcfMessage.addParameter(1511, this.getObjectSubType(t));
        this.mergeNewWithChangesToPCFRequest(t, job, cmd.getRequest(t));
        this.endUpdate(t, job);
        rc = cmd.execute(t, listener);
        return rc;
    }

    @Override
    public int actionChange(Trace t, DmActionListener listener, Object job, boolean force) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmTelemetryChannel.actionChange", 300, "Changing TelemetryChannel " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 21, this);
        PCFMessage pcfMessage = cmd.getRequest(t);
        pcfMessage.addParameter(3501, this.getTitle());
        pcfMessage.addParameter(1511, this.getObjectSubType(t));
        this.addQSGDispToRequest(t, cmd);
        this.appendToPCFRequest(t, job, cmd.getRequest(t));
        this.endUpdate(t, job);
        rc = cmd.execute(t, listener);
        return rc;
    }

    public int actionStart(Trace t, DmActionListener listener) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmTelemetryChannel.actionStart", 300, "Starting channel " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 28, this);
        PCFMessage pcfMessage = cmd.getRequest(t);
        pcfMessage.addParameter(3501, this.getTitle());
        pcfMessage.addParameter(1511, 10);
        rc = cmd.execute(t, listener);
        return rc;
    }

    public int actionStop(Trace t, DmActionListener listener) {
        return this.actionStop(t, listener, 1, 6, null, null);
    }

    public int actionStop(Trace t, DmActionListener listener, int mode, int state, String connName, String qmName) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmTelemetryChannel.actionStop", 300, "Stopping channel " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 29, this);
        PCFMessage pcfMessage = cmd.getRequest(t);
        pcfMessage.addParameter(3501, this.getTitle());
        pcfMessage.addParameter(1511, 10);
        if (Trace.isTracing) {
            t.data(65, "DmTelemetryChannel.actionStop", 300, "Stopping mode = " + mode);
        }
        if (connName != null) {
            cmd.getRequest(t).addParameter(3506, connName);
        }
        if (qmName != null) {
            cmd.getRequest(t).addParameter(2015, qmName);
        }
        rc = cmd.execute(t, listener);
        return rc;
    }

    public int actionPurge(Trace t, DmActionListener listener) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmTelemetryChannel.actionPurge", 300, "Purging channel " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 195, this);
        PCFMessage pcfMessage = cmd.getRequest(t);
        pcfMessage.addParameter(3501, this.getTitle());
        pcfMessage.addParameter(1511, 10);
        pcfMessage.addParameter(1501, 2);
        rc = cmd.execute(t, listener);
        return rc;
    }

    @Override
    public boolean isSystemDefault(Trace t) {
        boolean retValue = false;
        if (this.getTitle().equals(DEFAULT_TELEMETRY_CHANNEL)) {
            retValue = true;
        }
        return retValue;
    }

    @Override
    public boolean isEnumerationIdValid(Trace t, int attrId, int enumId) {
        boolean retValue = false;
        retValue = true;
        if (Trace.isTracing) {
            if (retValue) {
                t.data(65, "DmTelemetryChannel.isEnumerationIdValid", 300, "Valid enumeration type : " + enumId + " for " + this.getTitle());
            } else {
                t.data(65, "DmTelemetryChannel.isEnumerationIdValid", 900, "Invalid enumeration type : " + enumId + " for " + this.getTitle());
            }
        }
        return retValue;
    }

    public static String getDefaultName(Trace t, int subType) {
        return DEFAULT_TELEMETRY_CHANNEL;
    }

    public static String getDefaultName(Trace t, int type, int subType) {
        return DEFAULT_TELEMETRY_CHANNEL;
    }

    @Override
    public int[] getMandatoryIds(Trace t) {
        int subType = this.getObjectSubType(t);
        ArrayList<Integer> list = DmTelemetryChannel.getListOfMandatoryIds(subType);
        switch (subType) {
            case 10: {
                int trType = this.getTransportType(t);
                if (trType != 2) break;
                list.add(1522);
            }
        }
        int[] array = new int[list.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = list.get(i);
            ++i;
        }
        return array;
    }

    public static int[] getMandatoryIds(int subType) {
        ArrayList<Integer> list = DmTelemetryChannel.getListOfMandatoryIds(subType);
        int[] array = new int[list.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = list.get(i);
            ++i;
        }
        return array;
    }

    private static ArrayList<Integer> getListOfMandatoryIds(int subType) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        switch (subType) {
            case 10: {
                list.add(3501);
                list.add(1511);
                list.add(3506);
                list.add(1501);
                list.add(3505);
            }
        }
        return list;
    }

    @Override
    public int getStatusType(Trace t) {
        int retValue = 0;
        Attr a = this.getAttribute(t, 1527, 0);
        if (a != null) {
            int i = (Integer)a.getValue(t);
            switch (i) {
                case 3: {
                    retValue = 2;
                    break;
                }
                case 6: {
                    retValue = 0;
                }
            }
        }
        return retValue;
    }

    public boolean isRunning(Trace t) {
        boolean running;
        block4: {
            running = false;
            Attr a = this.getAttribute(t, 1527, 0);
            if (a != null) {
                try {
                    int i = (Integer)a.getValue(t);
                    if (i == 3) {
                        running = true;
                    }
                }
                catch (Exception e) {
                    if (!Trace.isTracing) break block4;
                    t.data(65, "DmTelemetryChannel.isRunning", 900, "Error getting CMQCFC.MQIACH_CHANNEL_STATUS : " + e.toString());
                }
            }
        }
        return running;
    }

    private int getTransportType(Trace t) {
        int type = -3;
        AttrInt attr = (AttrInt)this.getAttribute(t, 1501, 0);
        if (attr != null) {
            type = (Integer)attr.getValue(t);
        }
        if (Trace.isTracing) {
            t.data(65, "DmTelemetryChannel.getTransportType", 300, "Transport-type for " + this.getTitle() + " is " + type);
        }
        return type;
    }

    @Override
    public int getObjectSubType(Trace t) {
        return 10;
    }

    @Override
    public void initialize(Trace t) {
        this.setName(t, 3501);
    }

    public static int[] getValidAuthorities(Trace t) {
        return DmTelemetryChannel.getValidAuthorities(t, allAttributesByType);
    }

    public static HashMap<Integer, AttrType> getAllAttributesByTypeTable() {
        return allAttributesByType;
    }

    @Override
    protected boolean initAttrTypeTable(Trace t, int commandLevel, int platform) {
        boolean result = super.initAttrTypeTable(t, commandLevel, platform);
        DmTelemetryChannel.updateSslCipherSuite(t, this.queueManager, allAttributesByType);
        DmTelemetryChannel.updateSslCipherSuite(t, this.queueManager, this.attributesByType);
        return result;
    }

    private static void updateSslCipherSuite(Trace t, DmQueueManager dmQueueManager, HashMap<Integer, AttrType> hashtable) {
        int id = 3569;
        AttrType at = hashtable.get(id);
        AttrTypeFixedLengthStringEnum attrType = (AttrTypeFixedLengthStringEnum)at;
        attrType.clearEnumerations(t);
        String blank = "";
        attrType.addEnumeration(t, blank, blank);
        Set<String> sslCipherSuites = dmQueueManager.getSslCipherSuites();
        for (String suite : sslCipherSuites) {
            attrType.addEnumeration(t, suite, suite);
        }
    }

    public static DmObject clone(Trace t, DmQueueManager qMgr, String name, int type, int subType) {
        DmObject object = null;
        DmObject defaultObject = null;
        String defaultName = DmTelemetryChannel.getDefaultName(t, type, subType);
        if (!defaultName.equals("[not_found]")) {
            DmObjectFilter query = new DmObjectFilter(t, defaultName, type, subType);
            ArrayList list = new ArrayList(0);
            try {
                list = qMgr.getObjects(t, query, false);
                if (list.size() == 1) {
                    defaultObject = (DmObject)list.get(0);
                    object = DmObjectFactory.create(t, defaultObject, name);
                    object.setClonedFrom(defaultObject);
                }
            }
            catch (DmCoreException dmCoreException) {}
        }
        if (Trace.isTracing) {
            if (object == null) {
                t.data(67, "DmTelemetryChannel.clone", 900, "Error creating new object called " + name);
            } else {
                t.data(67, "DmTelemetryChannel.clone", 300, "Created new object called " + name);
            }
        }
        return object;
    }
}

