/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrKey;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.filter.DmSubscriptionResponse;
import com.ibm.mq.explorer.core.internal.filter.IDmObjectResponse;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.PCFAction;
import java.util.HashMap;
import java.util.Hashtable;
import org.osgi.framework.Bundle;

public class DmSubscription
extends DmObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/objects/DmSubscription.java";
    protected static final String DEFAULT = "SYSTEM.DEFAULT.SUB";
    protected static final String DEFAULT_BROKER_DESTINATION = "SYSTEM.BROKER.INTER.BROKER.COMMUNICATIONS";
    private static HashMap<Integer, AttrType> allAttributesByType = null;

    public DmSubscription(Trace t, String pn) {
        super(pn, 176);
    }

    public static boolean staticInit(Trace t, Bundle bund) {
        int rc = 0;
        allAttributesByType = DmSubscription.initAllAttrTypeTable(t, DmSubscription.getClassName(DmSubscription.class.getName()), allAttributesByType, bund);
        if (allAttributesByType == null) {
            if (Trace.isTracing) {
                t.data(65, "DmSubscription.staticInit", 900, "Error loading allAttributesByType table");
            }
            rc = 50011;
        }
        return rc == 0;
    }

    @Override
    public boolean init(Trace t) {
        this.addAttr(t, this.attributesByType, 3152, 0, this.getTitle());
        return true;
    }

    public static String getAttributeTitle(Trace t, int id) {
        return DmSubscription.getAttributeTitle(t, allAttributesByType, id);
    }

    public static AttrType getAttributeType(Trace t, int id) {
        return DmSubscription.getAttributeType(t, allAttributesByType, id);
    }

    public static String getAttributeDefaultValue(Trace t, int id) {
        return DmSubscription.getAttributeDefaultValue(t, allAttributesByType, id);
    }

    public static int[] getDisplayColumnSequence(Trace t, int[] ids, boolean zOS) {
        return DmSubscription.getDisplayColumnSequence(t, allAttributesByType, ids, zOS);
    }

    public static boolean isAttributeRepeating(Trace t, int id) {
        return DmSubscription.isAttributeRepeating(t, allAttributesByType, id);
    }

    public static int[] getAllAttributesByType(Trace t) {
        return DmSubscription.getAllAttributesByType(t, allAttributesByType);
    }

    @Override
    public String toString(Trace t) {
        return this.getTitle();
    }

    @Override
    public void close(Trace t) {
    }

    public int actionDelete(Trace t, DmActionListener listener) {
        return this.actionDelete(t, listener, null);
    }

    @Override
    public int actionDelete(Trace t, DmActionListener listener, Object parms) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmSubscription.actionDelete", 300, "Deleting subscription " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 179, this);
        cmd.getRequest(t).addParameter(3152, this.getTitle());
        rc = cmd.execute(t, listener, 2);
        return rc;
    }

    @Override
    public int actionCreate(Trace t, DmActionListener listener, Object job) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmSubscription.actionCreate", 300, "Creating subscription " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 181, this);
        cmd.getRequest(t).addParameter(3163, this.getClonedFrom());
        cmd.getRequest(t).addParameter(3164, this.getTitle());
        Hashtable table = (Hashtable)this.updateTables.get(job);
        AttrKey destinationClassKey = new AttrKey(1273, 0);
        Attr attr = (Attr)table.get(destinationClassKey);
        if (attr != null && (Integer)attr.getNewValue(t) == 1) {
            AttrKey key = new AttrKey(3153, 0);
            table.remove(key);
            key = new AttrKey(3154, 0);
            table.remove(key);
            key = new AttrKey(7015, 0);
            table.remove(key);
        }
        this.mergeNewWithChangesToPCFRequest(t, job, cmd.getRequest(t));
        rc = cmd.execute(t, listener);
        return rc;
    }

    @Override
    public int actionChange(Trace t, DmActionListener listener, Object job, boolean force) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmSubscription.actionChange", 300, "Changing subscription " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 178, this);
        cmd.getRequest(t).addParameter(3152, this.getTitle());
        this.addQSGDispToRequest(t, cmd);
        this.appendToPCFRequest(t, job, cmd.getRequest(t));
        this.endUpdate(t, job);
        rc = cmd.execute(t, listener);
        return rc;
    }

    @Override
    public boolean isSystemDefault(Trace t) {
        boolean retValue = false;
        if (this.getTitle().equals(DEFAULT)) {
            retValue = true;
        }
        return retValue;
    }

    public static String getDefaultName(Trace t) {
        return DEFAULT;
    }

    @Override
    public int[] getMandatoryIds(Trace t) {
        return DmSubscription.getMandatoryIds();
    }

    public static int[] getMandatoryIds() {
        return new int[]{3152, 11502, 11501};
    }

    @Override
    public void initialize(Trace t) {
        this.setName(t, 3152);
        this.addCombinedTopicName(t);
        this.addCombinedDestName(t);
    }

    public static int[] getValidAuthorities(Trace t) {
        return DmSubscription.getValidAuthorities(t, allAttributesByType);
    }

    private void addCombinedTopicName(Trace t) {
        String objectName = this.getAttributeValue(t, 2092, 0);
        String stringName = this.getAttributeValue(t, 2094, 0);
        String combinedTopicName = String.valueOf(objectName) + stringName;
        this.addAttr(t, this.attributesByType, 11502, 0, combinedTopicName);
        if (Trace.isTracing) {
            t.data(65, "DmSubscription.addCombinedTopicName", 300, "Added PARAM_COMBINED_TOPIC_NAME attribute for " + this.getTitle());
        }
    }

    private void addCombinedDestName(Trace t) {
        String combinedDestName = null;
        Attr attr = this.getAttribute(t, 1273, 0);
        Integer value = (Integer)attr.getValue(t);
        boolean isProvided = value == 2;
        combinedDestName = isProvided ? this.getAttributeValue(t, 3154, 0) : "";
        this.addAttr(t, this.attributesByType, 11501, 0, combinedDestName);
        if (Trace.isTracing) {
            t.data(65, "DmSubscription.addCombinedDestName", 300, "Added PARAM_COMBINED_DEST_NAME attribute for " + this.getTitle());
        }
    }

    @Override
    public IDmObjectResponse getObjectResponse(Trace t) {
        if (this.objectResponse == null) {
            this.objectResponse = new DmSubscriptionResponse(t);
        }
        return this.objectResponse;
    }

    @Override
    public boolean isSystemObject(Trace t) {
        boolean retValue = super.isSystemObject(t);
        if (!retValue) {
            String dest = this.getAttributeValue(t, 3154, 0);
            if (DEFAULT_BROKER_DESTINATION.equalsIgnoreCase(dest)) {
                retValue = true;
            } else {
                Integer subType;
                Attr a = this.getAttribute(t, 1289, 0);
                if (a != null && (subType = (Integer)a.getValue(t)) == 3) {
                    retValue = true;
                }
            }
        }
        if (Trace.isTracing) {
            t.data(65, "DmSubscription.isSystemObject", 300, "System object " + this.name + " " + retValue);
        }
        return retValue;
    }

    @Override
    public int getNameAttributeId() {
        return 3152;
    }
}

