/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.PCFAction;
import java.util.ArrayList;
import java.util.HashMap;
import org.osgi.framework.Bundle;

public class DmService
extends DmObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/objects/DmService.java";
    protected static final String DEFAULT = "SYSTEM.DEFAULT.SERVICE";
    private static HashMap<Integer, AttrType> allAttributesByType = null;

    public DmService(Trace t, String nn) {
        super(nn, 153);
    }

    public static boolean staticInit(Trace t, Bundle bund) {
        allAttributesByType = DmService.initAllAttrTypeTable(t, DmService.getClassName(DmService.class.getName()), allAttributesByType, bund);
        if (allAttributesByType == null) {
            if (Trace.isTracing) {
                t.data(65, "DmService.staticInit", 900, "Error loading allAttributesByType table");
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean init(Trace t) {
        this.addAttr(t, this.attributesByType, 2077, 0, this.getTitle());
        return true;
    }

    public static String getAttributeTitle(Trace t, int id) {
        return DmService.getAttributeTitle(t, allAttributesByType, id);
    }

    public static AttrType getAttributeType(Trace t, int id) {
        return DmService.getAttributeType(t, allAttributesByType, id);
    }

    public static String getAttributeDefaultValue(Trace t, int id) {
        return DmService.getAttributeDefaultValue(t, allAttributesByType, id);
    }

    public static int[] getDisplayColumnSequence(Trace t, int[] ids, boolean zOS) {
        return DmService.getDisplayColumnSequence(t, allAttributesByType, ids, zOS);
    }

    public static boolean isAttributeRepeating(Trace t, int id) {
        return DmService.isAttributeRepeating(t, allAttributesByType, id);
    }

    public static int[] getAllAttributesByType(Trace t) {
        return DmService.getAllAttributesByType(t, allAttributesByType);
    }

    @Override
    public String toString(Trace t) {
        return this.getTitle();
    }

    @Override
    public void close(Trace t) {
    }

    public int actionDelete(Trace t, DmActionListener listener) {
        return this.actionDelete(t, listener, null);
    }

    @Override
    public int actionDelete(Trace t, DmActionListener listener, Object parms) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmService.actionDelete", 300, "Deleting service " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 152, this);
        cmd.getRequest(t).addParameter(2077, this.getTitle());
        rc = cmd.execute(t, listener);
        return rc;
    }

    public int actionStart(Trace t, DmActionListener listener) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmService.actionStart", 300, "Starting service " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 155, this);
        cmd.getRequest(t).addParameter(2077, this.getTitle());
        rc = cmd.execute(t, listener);
        return rc;
    }

    public int actionStop(Trace t, DmActionListener listener) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmService.actionStop", 300, "Stopping service " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 156, this);
        cmd.getRequest(t).addParameter(2077, this.getTitle());
        rc = cmd.execute(t, listener);
        return rc;
    }

    @Override
    public int actionCreate(Trace t, DmActionListener listener, Object job) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmService.actionCreate", 300, "Creating service " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 150, this);
        cmd.getRequest(t).addParameter(3126, this.getClonedFrom());
        cmd.getRequest(t).addParameter(3127, this.getTitle());
        this.mergeNewWithChangesToPCFRequest(t, job, cmd.getRequest(t));
        rc = cmd.execute(t, listener);
        return rc;
    }

    @Override
    public int actionChange(Trace t, DmActionListener listener, Object job, boolean force) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmService.actionChange", 300, "Changing service " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 149, this);
        cmd.getRequest(t).addParameter(2077, this.getTitle());
        this.appendToPCFRequest(t, job, cmd.getRequest(t));
        this.endUpdate(t, job);
        rc = cmd.execute(t, listener);
        return rc;
    }

    @Override
    public boolean isSystemDefault(Trace t) {
        boolean retValue = false;
        if (this.getTitle().equals(DEFAULT)) {
            retValue = true;
        }
        return retValue;
    }

    public static String getDefaultName(Trace t) {
        return DEFAULT;
    }

    @Override
    public int[] getMandatoryIds(Trace t) {
        return DmService.getMandatoryIds();
    }

    public static int[] getMandatoryIds() {
        return new int[]{2077};
    }

    @Override
    public int getStatusType(Trace t) {
        if (this.getObjectSubType(t) == 0) {
            return 0;
        }
        return this.getQueueManager().getStatusType(t, 153, this.getObjectSubType(t));
    }

    public DmObject updateStatus(Trace t, ArrayList list, int action) {
        int i = 0;
        while (i < list.size()) {
            DmObject object = (DmObject)list.get(i);
            Attr attr1 = object.getAttribute(t, 2077, 0);
            if (attr1 != null) {
                Attr attr2;
                String value = (String)attr1.getValue(t);
                if (this.getTitle().equals(value) && (attr2 = object.getAttribute(t, 1260, 0)) != null) {
                    Integer status = (Integer)attr2.getValue(t);
                    this.addAttr(t, this.attributesByType, 1260, 0, status);
                }
            }
            ++i;
        }
        return this;
    }

    public boolean isRunning(Trace t) {
        boolean running;
        block4: {
            running = false;
            Attr a = this.getAttribute(t, 1260, 0);
            if (a != null) {
                try {
                    int i = (Integer)a.getValue(t);
                    if (i == 2) {
                        running = true;
                    }
                }
                catch (Exception e) {
                    if (!Trace.isTracing) break block4;
                    t.data(65, "DmService.isRunning", 900, "Error getting CMQCFC.MQIACF_SERVICE_STATUS : " + e.toString());
                }
            }
        }
        return running;
    }

    @Override
    public void initialize(Trace t) {
        this.setName(t, 2077);
        if (this.getObjectSubType(t) == 1) {
            this.addAttr(t, this.attributesByType, 1260, 0, 0);
        }
    }

    @Override
    public int getObjectSubType(Trace t) {
        int subType = -2;
        AttrInt attr = (AttrInt)this.getAttribute(t, 121, 0);
        if (attr != null) {
            subType = (Integer)attr.getValue(t);
        }
        if (Trace.isTracing) {
            t.data(65, "DmService.getObjectSubType", 300, "Service subtype of " + this.getTitle() + " is " + subType);
        }
        return subType;
    }

    public static int[] getValidAuthorities(Trace t) {
        return DmService.getValidAuthorities(t, allAttributesByType);
    }

    @Override
    public int getNameAttributeId() {
        return 2077;
    }
}

