/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrKey;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmMachine;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import org.osgi.framework.Bundle;

public class DmQueueManagerHandleInstance
extends DmObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/objects/DmQueueManagerHandleInstance.java";
    public static final int STATUS_NOT_CONNECTED = 0;
    public static final int STATUS_CONNECTED = 1;
    public static final int STATUS_STANDBY = 2;
    public static final int STATUS_ERROR = 3;
    public static final int STATUS_ERROR_NAME = 4;
    public static final int STATUS_ERROR_UUID = 5;
    private static HashMap<Integer, AttrType> allAttributesByType = null;
    private DmQueueManagerHandle queueManagerHandle = null;
    private String connName = null;
    private DmActionListener listener = null;

    public DmQueueManagerHandleInstance(Trace t, DmQueueManagerHandle qmh, String s) {
        super(String.valueOf(qmh.getQueueManager().getTitle()) + "|" + s, 1025);
        this.queueManagerHandle = qmh;
        this.queueManager = qmh.getQueueManager();
        this.connName = s;
        this.initAttrTypeTable(t, DmMachine.getCommandLevel(t), DmMachine.getPlatform(t));
        this.init(t);
    }

    public static boolean staticInit(Trace t, Bundle bund) {
        allAttributesByType = DmQueueManagerHandleInstance.initAllAttrTypeTable(t, DmQueueManagerHandleInstance.getClassName(DmQueueManagerHandleInstance.class.getName()), allAttributesByType, bund);
        if (allAttributesByType == null) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManagerHandleInstance.staticInit", 900, "Error loading allAttributesByType table");
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean init(Trace t) {
        this.addAttr(t, allAttributesByType, 11031, 0, 0);
        this.refreshAttributes(t);
        return true;
    }

    public static String getAttributeTitle(Trace t, int id) {
        return DmQueueManagerHandleInstance.getAttributeTitle(t, allAttributesByType, id);
    }

    public static AttrType getAttributeType(Trace t, int id) {
        return DmQueueManagerHandleInstance.getAttributeType(t, allAttributesByType, id);
    }

    public static String getAttributeDefaultValue(Trace t, int id) {
        return DmQueueManagerHandleInstance.getAttributeDefaultValue(t, allAttributesByType, id);
    }

    public static int[] getDisplayColumnSequence(Trace t, int[] ids, boolean zOS) {
        return DmQueueManagerHandleInstance.getDisplayColumnSequence(t, allAttributesByType, ids, zOS);
    }

    public static boolean isAttributeRepeating(Trace t, int id) {
        return DmQueueManagerHandleInstance.isAttributeRepeating(t, allAttributesByType, id);
    }

    public static int[] getAllAttributesByType(Trace t) {
        return DmQueueManagerHandleInstance.getAllAttributesByType(t, allAttributesByType);
    }

    public boolean refreshAttributes(Trace t) {
        this.addAttr(t, allAttributesByType, 11002, 0, this.connName);
        this.addAttr(t, allAttributesByType, 11003, 0, this.queueManagerHandle.getAttributeValue(t, 11003, 0));
        if (this.isActiveInstance(t)) {
            this.addAttr(t, allAttributesByType, 11030, 0, 1);
        } else {
            this.addAttr(t, allAttributesByType, 11030, 0, 0);
        }
        return true;
    }

    @Override
    public String toString(Trace t) {
        return this.getTitle();
    }

    @Override
    public void close(Trace t) {
    }

    public DmQueueManagerHandle getQueueManagerHandle(Trace t) {
        return this.queueManagerHandle;
    }

    @Override
    public int actionChange(Trace t, DmActionListener _listener, Object _job, boolean _force) {
        int rc = 0;
        this.listener = _listener;
        Hashtable<AttrKey, Attr> table = this.getUpdateTable(t, _job);
        if (table.size() == 0) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManagerHandleInstance.actionChange", 900, "No attributes to update");
            }
            return rc;
        }
        Set<AttrKey> k = table.keySet();
        for (AttrKey ak : k) {
            Attr a = table.get(ak);
            int id = ak.getAttributeID();
            AttrType at = a.getAttrType();
            if (at.getPCFType() != 2) {
                if (!Trace.isTracing) continue;
                t.data(65, "DmQueueManagerHandleInstance.actionChange", 900, "Attribute " + id + "." + ak.getRepeatingIndex() + " is not pseudo - update ignored");
                continue;
            }
            switch (id) {
                case 11030: {
                    int v = (Integer)((AttrInt)this.getAttribute(t, table, id, 0)).getNewValue(t);
                    this.replaceAttributeValue(t, 11030, 0, v, false);
                    break;
                }
                case 11031: {
                    int v = (Integer)((AttrInt)this.getAttribute(t, table, id, 0)).getNewValue(t);
                    this.replaceAttributeValue(t, 11031, 0, v, false);
                    break;
                }
                default: {
                    if (Trace.isTracing) {
                        t.data(65, "DmQueueManagerHandleInstance.actionChange", 900, "DmQueueManagerHandleInstance unknown attribute id " + id);
                    }
                    return 50010;
                }
            }
        }
        this.endUpdate(t, _job);
        this.notifyChange(t);
        return rc;
    }

    private void notifyChange(Trace t) {
        if (this.listener != null) {
            this.listener.dmActionDone(new DmActionEvent(this.queueManager, 1, 0));
        }
    }

    public boolean isActiveInstance(Trace t) {
        boolean active = false;
        String s = this.queueManagerHandle.getQueueManagerHandle(t).getConnectionName();
        if (s != null && s.equals(this.connName) && this.queueManager.isConnected()) {
            active = true;
        }
        return active;
    }

    @Override
    public boolean equals(Object obj) {
        boolean retValue = false;
        Trace t = Trace.getInstance();
        if (obj == this) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManagerHandleInstance.equals", 300, "Comparing the same object");
            }
            return true;
        }
        if (!(obj instanceof DmQueueManagerHandleInstance)) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManagerHandleInstance.equals", 900, "Not comparing same object types");
            }
            return false;
        }
        retValue = this.queueManagerHandle.equals(((DmQueueManagerHandleInstance)obj).getQueueManagerHandle(t));
        return retValue;
    }
}

