/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrKey;
import com.ibm.mq.explorer.core.internal.attrs.AttrString;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.event.DmMonitor;
import com.ibm.mq.explorer.core.internal.objects.DmMachine;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.utils.PersistQueueManagerHandles;
import com.ibm.mq.explorer.core.internal.utils.QueueManagerHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Level;
import org.osgi.framework.Bundle;

public class DmQueueManagerHandle
extends DmObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/objects/DmQueueManagerHandle.java";
    private static HashMap<Integer, AttrType> allAttributesByType = null;
    private QueueManagerHandle queueManagerHandle = null;
    private boolean userDisconnect = false;
    private boolean connectNow = false;
    private DmActionListener listener = null;

    public DmQueueManagerHandle(Trace t, QueueManagerHandle qmh) {
        super(qmh.getQueueManagerName(), 1002);
        this.queueManagerHandle = qmh;
        this.initAttrTypeTable(t, DmMachine.getCommandLevel(t), DmMachine.getPlatform(t));
        this.init(t);
    }

    public static boolean staticInit(Trace t, Bundle bund) {
        allAttributesByType = DmQueueManagerHandle.initAllAttrTypeTable(t, DmQueueManagerHandle.getClassName(DmQueueManagerHandle.class.getName()), allAttributesByType, bund);
        if (allAttributesByType == null) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManagerHandle.staticInit", 900, "Error loading allAttributesByType table");
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean init(Trace t) {
        this.refreshAttributes(t);
        return true;
    }

    public static String getAttributeTitle(Trace t, int id) {
        return DmQueueManagerHandle.getAttributeTitle(t, allAttributesByType, id);
    }

    public static AttrType getAttributeType(Trace t, int id) {
        return DmQueueManagerHandle.getAttributeType(t, allAttributesByType, id);
    }

    public static String getAttributeDefaultValue(Trace t, int id) {
        return DmQueueManagerHandle.getAttributeDefaultValue(t, allAttributesByType, id);
    }

    public static int[] getDisplayColumnSequence(Trace t, int[] ids, boolean zOS) {
        return DmQueueManagerHandle.getDisplayColumnSequence(t, allAttributesByType, ids, zOS);
    }

    public static boolean isAttributeRepeating(Trace t, int id) {
        return DmQueueManagerHandle.isAttributeRepeating(t, allAttributesByType, id);
    }

    public static int[] getAllAttributesByType(Trace t) {
        return DmQueueManagerHandle.getAllAttributesByType(t, allAttributesByType);
    }

    public boolean refreshAttributes(Trace t) {
        this.addAttr(t, allAttributesByType, 11001, 0, this.queueManagerHandle.getTreeName(t));
        if (QueueManagerHandle.addAttribute(t, this.queueManagerHandle, 11002)) {
            this.addAttr(t, allAttributesByType, 11002, 0, this.queueManagerHandle.getConnectionName());
        }
        if (QueueManagerHandle.addAttribute(t, this.queueManagerHandle, 11029)) {
            this.addAttr(t, allAttributesByType, 11029, 0, this.queueManagerHandle.getConnectionNames());
        }
        if (QueueManagerHandle.addAttribute(t, this.queueManagerHandle, 11003)) {
            this.addAttr(t, allAttributesByType, 11003, 0, this.queueManagerHandle.getChannel());
        }
        this.addAttr(t, allAttributesByType, 11011, 0, this.queueManagerHandle.getRefreshInterval());
        this.addAttr(t, allAttributesByType, 11014, 0, this.queueManagerHandle.getWaitInterval());
        this.addAttr(t, allAttributesByType, 11015, 0, this.queueManagerHandle.getExpiryInterval());
        this.addAttr(t, allAttributesByType, 11012, 0, this.queueManagerHandle.getAutoReconnect());
        this.addAttr(t, allAttributesByType, 11032, 0, this.queueManagerHandle.getUserIdState());
        this.addAttr(t, allAttributesByType, 11008, 0, this.queueManagerHandle.getConnectionType());
        this.addAttr(t, allAttributesByType, 11005, 0, this.queueManagerHandle.getVisible());
        if (QueueManagerHandle.addAttribute(t, this.queueManagerHandle, 11010)) {
            if (this.queueManagerHandle.getChannelDefTable() == null) {
                this.addAttr(t, allAttributesByType, 11010, 0, "");
            } else {
                this.addAttr(t, allAttributesByType, 11010, 0, this.queueManagerHandle.getChannelDefTable().toString());
            }
        }
        if (QueueManagerHandle.addAttribute(t, this.queueManagerHandle, 11016)) {
            this.addAttr(t, allAttributesByType, 11016, 0, this.queueManagerHandle.getSecurityExitName());
        }
        if (QueueManagerHandle.addAttribute(t, this.queueManagerHandle, 11017)) {
            this.addAttr(t, allAttributesByType, 11017, 0, this.queueManagerHandle.getSecurityExitData());
        }
        if (QueueManagerHandle.addAttribute(t, this.queueManagerHandle, 11024)) {
            this.addAttr(t, allAttributesByType, 11024, 0, this.queueManagerHandle.getSecurityExitLocation());
        }
        if (QueueManagerHandle.addAttribute(t, this.queueManagerHandle, 11033)) {
            this.addAttr(t, allAttributesByType, 11033, 0, this.queueManagerHandle.getCompatMode());
        }
        if (QueueManagerHandle.addAttribute(t, this.queueManagerHandle, 11034)) {
            this.addAttr(t, allAttributesByType, 11034, 0, this.queueManagerHandle.getPasswordMode());
        }
        if (QueueManagerHandle.addAttribute(t, this.queueManagerHandle, 11018)) {
            this.addAttr(t, allAttributesByType, 11018, 0, this.queueManagerHandle.getUserid());
        }
        if (QueueManagerHandle.addAttribute(t, this.queueManagerHandle, 11019)) {
            this.addAttr(t, allAttributesByType, 11019, 0, this.queueManagerHandle.getPassword());
        }
        if (QueueManagerHandle.addAttribute(t, this.queueManagerHandle, 11020)) {
            this.addAttr(t, allAttributesByType, 11020, 0, this.queueManagerHandle.getSSLCipherSuite());
        }
        if (QueueManagerHandle.addAttribute(t, this.queueManagerHandle, 11021)) {
            this.addAttr(t, allAttributesByType, 11021, 0, this.queueManagerHandle.getSSLFIPSRequired());
        }
        if (QueueManagerHandle.addAttribute(t, this.queueManagerHandle, 11023)) {
            this.addAttr(t, allAttributesByType, 11023, 0, this.queueManagerHandle.getSSLPeerName());
        }
        if (QueueManagerHandle.addAttribute(t, this.queueManagerHandle, 11022)) {
            this.addAttr(t, allAttributesByType, 11022, 0, this.queueManagerHandle.getSSLResetCount());
        }
        if (QueueManagerHandle.addAttribute(t, this.queueManagerHandle, 11025)) {
            this.addAttr(t, allAttributesByType, 11025, 0, this.queueManagerHandle.getSSLPersonalStore());
        }
        if (QueueManagerHandle.addAttribute(t, this.queueManagerHandle, 11026)) {
            this.addAttr(t, allAttributesByType, 11026, 0, this.queueManagerHandle.getSSLPersonalStorePassword());
        }
        if (QueueManagerHandle.addAttribute(t, this.queueManagerHandle, 11027)) {
            this.addAttr(t, allAttributesByType, 11027, 0, this.queueManagerHandle.getSSLTrustedStore());
        }
        if (QueueManagerHandle.addAttribute(t, this.queueManagerHandle, 11028)) {
            this.addAttr(t, allAttributesByType, 11028, 0, this.queueManagerHandle.getSSLTrustedStorePassword());
        }
        if (this.getQueueManager() != null) {
            if (this.getQueueManager().isLocal()) {
                this.addAttr(t, allAttributesByType, 11009, 0, 0);
            } else {
                this.addAttr(t, allAttributesByType, 11009, 0, 1);
            }
        }
        return true;
    }

    @Override
    public String toString(Trace t) {
        return this.getTitle();
    }

    @Override
    public void close(Trace t) {
    }

    public boolean isVisible(Trace t) {
        return this.queueManagerHandle.getVisible() != 0;
    }

    public boolean isAutoReconnect(Trace t) {
        return this.queueManagerHandle.getAutoReconnect() != 0;
    }

    public boolean isClient(Trace t) {
        return this.queueManagerHandle.getConnectionType() == 2 || this.queueManagerHandle.getConnectionType() == 5 || this.queueManagerHandle.getConnectionType() == 4 || this.queueManagerHandle.getConnectionType() == 3;
    }

    public void setUserDisconnect(Trace t, boolean b) {
        this.userDisconnect = b;
    }

    public void setConnectNow(Trace t, boolean b) {
        this.connectNow = b;
    }

    public QueueManagerHandle getQueueManagerHandle(Trace t) {
        return this.queueManagerHandle;
    }

    public boolean isUserDisconnect(Trace t) {
        return this.userDisconnect;
    }

    public boolean isConnectNow(Trace t) {
        return this.connectNow;
    }

    @Override
    public int actionChange(Trace t, DmActionListener _listener, Object _job, boolean _force) {
        int rc = 0;
        this.listener = _listener;
        Hashtable<AttrKey, Attr> table = this.getUpdateTable(t, _job);
        if (table.size() == 0) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManagerHandle.actionChange", 900, "No attributes to update");
            }
            return rc;
        }
        Set<AttrKey> k = table.keySet();
        for (AttrKey ak : k) {
            Attr a = table.get(ak);
            int id = ak.getAttributeID();
            AttrType at = a.getAttrType();
            if (at.getPCFType() != 2) {
                if (!Trace.isTracing) continue;
                t.data(65, "DmQueueManagerHandle.actionChange", 900, "Attribute " + id + "." + ak.getRepeatingIndex() + " is not pseudo - update ignored");
                continue;
            }
            switch (id) {
                case 11012: {
                    int v = (Integer)((AttrInt)this.getAttribute(t, table, id, 0)).getNewValue(t);
                    this.getQueueManagerHandle(t).setAutoConnect(t, v);
                    break;
                }
                case 11032: {
                    int v = (Integer)((AttrInt)this.getAttribute(t, table, id, 0)).getNewValue(t);
                    this.getQueueManagerHandle(t).setUserIdState(t, v);
                    break;
                }
                case 11033: {
                    int v = (Integer)((AttrInt)this.getAttribute(t, table, id, 0)).getNewValue(t);
                    this.getQueueManagerHandle(t).setCompatMode(v);
                    break;
                }
                case 11034: {
                    int v = (Integer)((AttrInt)this.getAttribute(t, table, id, 0)).getNewValue(t);
                    this.getQueueManagerHandle(t).setPasswordMode(v);
                    break;
                }
                case 11011: {
                    int v = (Integer)((AttrInt)this.getAttribute(t, table, id, 0)).getNewValue(t);
                    this.getQueueManagerHandle(t).setRefreshInterval(t, v);
                    this.getQueueManager().setRefreshInterval(t, v);
                    break;
                }
                case 11005: {
                    int v = (Integer)((AttrInt)this.getAttribute(t, table, id, 0)).getNewValue(t);
                    this.getQueueManagerHandle(t).setVisible(t, v);
                    this.notifyVisibility(t, v);
                    break;
                }
                case 11015: {
                    int v = (Integer)((AttrInt)this.getAttribute(t, table, id, 0)).getNewValue(t);
                    this.getQueueManagerHandle(t).setExpiryInterval(t, v);
                    this.getQueueManager().setExpiryInterval(t, v);
                    break;
                }
                case 11014: {
                    int v = (Integer)((AttrInt)this.getAttribute(t, table, id, 0)).getNewValue(t);
                    this.getQueueManagerHandle(t).setWaitInterval(t, v);
                    this.getQueueManager().setWaitInterval(t, v);
                    break;
                }
                case 11016: {
                    String s = (String)((AttrString)this.getAttribute(t, table, id, 0)).getNewValue(t);
                    if (s == null) {
                        s = (String)((AttrString)this.getAttribute(t, table, id, 0)).getValue(t);
                    }
                    this.getQueueManagerHandle(t).setSecurityExitName(s);
                    break;
                }
                case 11024: {
                    String s = (String)((AttrString)this.getAttribute(t, table, id, 0)).getNewValue(t);
                    if (s == null) {
                        s = (String)((AttrString)this.getAttribute(t, table, id, 0)).getValue(t);
                    }
                    this.getQueueManagerHandle(t).setSecurityExitLocation(s);
                    break;
                }
                case 11017: {
                    String s = (String)((AttrString)this.getAttribute(t, table, id, 0)).getNewValue(t);
                    if (s == null) {
                        s = (String)((AttrString)this.getAttribute(t, table, id, 0)).getValue(t);
                    }
                    this.getQueueManagerHandle(t).setSecurityExitData(s);
                    break;
                }
                case 11018: {
                    String s = (String)((AttrString)this.getAttribute(t, table, id, 0)).getNewValue(t);
                    this.getQueueManagerHandle(t).setUserid(s);
                    break;
                }
                case 11019: {
                    String s = (String)((AttrString)this.getAttribute(t, table, id, 0)).getNewValue(t);
                    this.getQueueManagerHandle(t).setPassword(s);
                    break;
                }
                case 11020: {
                    String s = (String)((AttrString)this.getAttribute(t, table, id, 0)).getNewValue(t);
                    this.getQueueManagerHandle(t).setSSLCipherSuite(s);
                    break;
                }
                case 11023: {
                    String s = (String)((AttrString)this.getAttribute(t, table, id, 0)).getNewValue(t);
                    this.getQueueManagerHandle(t).setSSLPeerName(s);
                    break;
                }
                case 11021: {
                    int v = (Integer)((AttrInt)this.getAttribute(t, table, id, 0)).getNewValue(t);
                    this.getQueueManagerHandle(t).setSSLFIPSRequired(v);
                    break;
                }
                case 11022: {
                    int v = (Integer)((AttrInt)this.getAttribute(t, table, id, 0)).getNewValue(t);
                    this.getQueueManagerHandle(t).setSSLResetCount(v);
                    break;
                }
                case 11025: {
                    String s = (String)((AttrString)this.getAttribute(t, table, id, 0)).getNewValue(t);
                    this.getQueueManagerHandle(t).setSSLPersonalStore(s);
                    break;
                }
                case 11026: {
                    String s = (String)((AttrString)this.getAttribute(t, table, id, 0)).getNewValue(t);
                    this.getQueueManagerHandle(t).setSSLPersonalStorePassword(s);
                    break;
                }
                case 11027: {
                    String s = (String)((AttrString)this.getAttribute(t, table, id, 0)).getNewValue(t);
                    this.getQueueManagerHandle(t).setSSLTrustedStore(s);
                    break;
                }
                case 11028: {
                    String s = (String)((AttrString)this.getAttribute(t, table, id, 0)).getNewValue(t);
                    this.getQueueManagerHandle(t).setSSLTrustedStorePassword(s);
                    break;
                }
                case 11029: {
                    ArrayList ss = (ArrayList)this.getAttribute(t, table, id, 0).getNewValue(t);
                    if (ss == null) {
                        ss = (ArrayList)this.getAttribute(t, table, id, 0).getValue(t);
                    }
                    this.getQueueManagerHandle(t).setConnectionNames(t, ss);
                    this.getQueueManagerHandle(t).resetConnectionTypeMi();
                    break;
                }
                default: {
                    if (Trace.isTracing) {
                        t.data(65, "DmQueueManagerHandle.actionChange", 900, "DmQueueManagerHandle unknown attribute id " + id);
                    }
                    return 50010;
                }
            }
        }
        PersistQueueManagerHandles.add(t, this);
        this.endUpdate(t, _job);
        this.refreshAttributes(t);
        this.notifyChange(t);
        return rc;
    }

    private void notifyVisibility(Trace t, int v) {
        if (v == 0) {
            this.queueManager.notifyListeners(t, 101, null, "ALL");
        } else {
            this.queueManager.notifyListeners(t, 100, null, "ALL");
        }
    }

    private void notifyChange(Trace t) {
        if (this.listener != null) {
            this.listener.dmActionDone(new DmActionEvent(this.queueManager, 1, 0));
        }
        DmMonitor.notifyAllQueueManagerListeners(t, this.queueManager, 4, null, true);
    }

    @Override
    public boolean equals(Object obj) {
        boolean retValue = false;
        if (obj == this) {
            if (Trace.isTracing) {
                Trace.data((Level)Level.FINEST, (String)"DmQueueManagerHandle", (String)"equals", (String)"Comparing the same object");
            }
            return true;
        }
        if (!(obj instanceof DmQueueManagerHandle)) {
            if (Trace.isTracing) {
                Trace.data((Level)Level.WARNING, (String)"DmQueueManagerHandle", (String)"equals", (String)"Not comparing same object types");
            }
            return false;
        }
        retValue = this.queueManagerHandle.equals(((DmQueueManagerHandle)obj).getQueueManagerHandle(Trace.getInstance()));
        return retValue;
    }

    public boolean isConnectionTypeServer(Trace t) {
        return this.queueManagerHandle.getConnectionType() == 1;
    }

    public boolean isConnectionTypeClient(Trace t) {
        return this.queueManagerHandle.getConnectionType() == 2;
    }

    public boolean isConnectionTypeMultiInstance(Trace t) {
        return this.queueManagerHandle.getConnectionType() == 5;
    }

    public boolean isConnectionTypeChanDefTable(Trace t) {
        return this.queueManagerHandle.getConnectionType() == 4;
    }

    public boolean isConnectionTypeVia(Trace t) {
        return this.queueManagerHandle.getConnectionType() == 3;
    }

    public void resetQueueManagerName(Trace t, String qmName) {
        if (Trace.isTracing) {
            t.data(65, "DmQueueManagerHandle.resetQueueManagerName", 300, "New queue manager name : " + qmName);
        }
        this.addAttr(t, this.attributesByType, 11001, 0, qmName);
        this.setName(t, 11001);
    }

    public boolean isPromptPassword() {
        boolean promptForPasssword = false;
        if (this.queueManagerHandle.getUserIdState() == 1 && this.queueManagerHandle.getPasswordMode() == 1) {
            promptForPasssword = true;
        }
        return promptForPasssword;
    }

    public void deletePassword() {
        Trace t = Trace.getInstance();
        this.queueManagerHandle.setPassword(null);
        AttrKey attrKey = new AttrKey(11019, 0);
        this.getAttributesTable(t).remove(attrKey);
    }
}

