/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.objects;

import com.ibm.mq.MQException;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.NativeCalls;
import com.ibm.mq.explorer.core.internal.Common;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrKey;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnum;
import com.ibm.mq.explorer.core.internal.base.CorePlugin;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.base.IDmObservable;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.event.DmMonitor;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectListView;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectSummaryEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectView;
import com.ibm.mq.explorer.core.internal.objects.AsyncConnectionToQueueManager;
import com.ibm.mq.explorer.core.internal.objects.AsyncDisconnectionFromQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmAuthinfo;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmClientChannel;
import com.ibm.mq.explorer.core.internal.objects.DmCommInfo;
import com.ibm.mq.explorer.core.internal.objects.DmListener;
import com.ibm.mq.explorer.core.internal.objects.DmMQQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmNamelist;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmObjectWithConfig;
import com.ibm.mq.explorer.core.internal.objects.DmProcess;
import com.ibm.mq.explorer.core.internal.objects.DmQueue;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.objects.DmRemoteQueueManagerName;
import com.ibm.mq.explorer.core.internal.objects.DmService;
import com.ibm.mq.explorer.core.internal.objects.DmTopic;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.core.internal.objects.PCFAction;
import com.ibm.mq.explorer.core.internal.objects.TableFactory;
import com.ibm.mq.explorer.core.internal.pcf.PCFResponseAnalyser;
import com.ibm.mq.explorer.core.internal.trace.GenerateFFST;
import com.ibm.mq.explorer.core.internal.utils.ConvertReasonCode;
import com.ibm.mq.explorer.core.internal.utils.CoreServices;
import com.ibm.mq.explorer.core.internal.utils.PersistQueueManagerHandles;
import com.ibm.mq.explorer.core.internal.utils.QueueManagerHandle;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.event.ErrorListener;
import com.ibm.mq.pcf.event.PCFMonitorAgent;
import com.ibm.mq.pcf.event.PCFQuery;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.osgi.framework.Bundle;

public class DmQueueManager
extends DmObjectWithConfig
implements ErrorListener,
DmObjectListener,
PCFMonitorAgent.RefreshListener,
IDmObservable {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/objects/DmQueueManager.java";
    public static int MQQMSTA_STOPPED = -1;
    public static int MQQMSTA_STANDBY = 4;
    public static int MQQMSTA_ELSEWHERE = 5;
    private static HashMap<Integer, AttrType> allAttributesByType = null;
    private static HashMap updateGroupsByName = null;
    private static final String EXPLORER_REPLY_MODEL_QUEUE = "SYSTEM.MQEXPLORER.REPLY.MODEL";
    private static final String EXPLORER_REPLY_QUEUE_PREFIX = "AMQ.MQEXPLORER.";
    protected PCFMonitorAgent pcfMonitorAgent = null;
    private int refreshInterval = 15;
    private int expiryInterval = 30;
    private int waitInterval = 30;
    private boolean connected = false;
    private boolean oldConnectionStatus = false;
    private int platform = 0;
    private int commandLevel = 0;
    private String uuid = "[not_found]";
    private DmQueueManagerHandle dmConnectionHandle = null;
    private QueueManagerHandle connectionHandle = null;
    private String notifyID = null;
    private boolean save = false;
    private MQQueueManager mqQueueManager = null;
    private boolean closed = false;
    private DmCoreException exception = null;
    private boolean connecting = false;
    private boolean disconnecting = false;
    private boolean connectNow = true;
    private Hashtable oldConfigAttributes = new Hashtable();
    private AsyncConnectionToQueueManager connectionThread = null;
    private AsyncDisconnectionFromQueueManager disconnectionThread = null;
    private DmQueueManager viaQueueManager = null;
    private Object lockConnection = new Object();
    private Object lockDisconnection = new Object();
    private Object lockLookup = new Object();
    private String treeName = null;
    private boolean oamUseridsSupported = false;
    private int oamInterfaceVersion = 0;
    private String[] oamListOfServices = null;
    private HashMap<String, DmObjectView> currentListeners = new HashMap();
    private HashMap<String, DmObjectListView> currentListListeners = new HashMap();
    private Object hashLock = new Object();
    private boolean standby = false;
    private boolean standbyPermitted = false;
    private int runningStatus = 10;
    private boolean ignoreConnectionCheck = false;
    private boolean connectionError = false;
    private Set<String> sslCipherSuites;
    private Object updateSslCipherSuitesLock = new Object();
    private boolean sslCipherSuitesReady;
    private Object inquireSslCipherSuitesLock = new Object();

    public DmQueueManager(Trace t, DmQueueManagerHandle dmqmh, String id) {
        super(dmqmh.getQueueManagerHandle(t).getQueueManagerName(), 2);
        this.notifyID = id;
        this.queueManager = this;
        this.parent = this.queueManager;
        this.dmConnectionHandle = dmqmh;
        dmqmh.setQueueManager(t, this);
        this.dmConnectionHandle.refreshAttributes(t);
        this.connectionHandle = this.dmConnectionHandle.getQueueManagerHandle(t);
        this.connectNow = this.dmConnectionHandle.isConnectNow(t);
        if (this.notifyID.startsWith("ALL")) {
            this.save = true;
        }
        if (CoreServices.handleAlreadyExists(t, this.dmConnectionHandle)) {
            this.exception = new DmCoreException(t, CommonServices.getSystemMessage((Trace)t, (String)CommonServices.getSystemMessageId((Trace)t, (int)10042), (String)this.getTreeName(t)), CommonServices.getSystemMessageId((Trace)t, (int)10042), 10042, 0, 20);
            return;
        }
        this.refreshInterval = this.connectionHandle.getRefreshInterval();
        this.expiryInterval = this.connectionHandle.getExpiryInterval();
        this.waitInterval = this.connectionHandle.getWaitInterval();
        this.addAttr(t, allAttributesByType, 2015, 0, this.getTitle());
        this.addAttr(t, allAttributesByType, 10154, 0, this.getTreeName(t));
        if (this.isLocal(t)) {
            this.commandLevel = this.getMachineCommandLevel(t);
            this.platform = this.getMachinePlatform(t);
            this.setCommandLevelAndPlatformAttrs(t);
            this.initAttrTypeTable(t, this.commandLevel, this.platform);
            this.refreshConfigAttributes(t);
        } else {
            this.getCommandLevelAndPlatform(t);
        }
    }

    @Override
    protected boolean init(Trace t) throws DmCoreException {
        this.exception = null;
        this.dmConnectionHandle.refreshAttributes(t);
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.init", 300, "autoReconnect = " + this.dmConnectionHandle.isAutoReconnect(t) + ", userDisconnect = " + this.dmConnectionHandle.isUserDisconnect(t) + ", connectNow = " + this.connectNow);
        }
        if (this.isLocal(t) && NativeCalls.isStandbyQueueManager((Trace)t, (String)this.dmTitle)) {
            this.setStandbyStatus(t, true);
            this.exception = this.createException(t, 0, 2543, 2);
            throw this.exception;
        }
        if (this.isLocal(t) && !this.isCommandServerRunning(t)) {
            this.exception = this.createException(t, 0, 2322, 2);
            throw this.exception;
        }
        if (!this.connectNow && !this.attemptAutoReconnect(t)) {
            this.exception = this.createException(t, 0, 50045, 2);
            throw this.exception;
        }
        this.connectToQueueManager(t);
        try {
            this.initAttrTypeTable(t, this.getPcfMonitorAgent(t).getCommandLevel(), this.getPcfMonitorAgent(t).getPlatform());
            int ccsid = CorePlugin.getCCSID();
            this.getPcfMonitorAgent(t).setCharacterSet(ccsid);
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.init", 300, "Using CCSID " + ccsid);
            }
            this.oldConnectionStatus = this.mqQueueManager.isConnected();
            this.getQueueManagerSnapshot(t);
        }
        catch (DmCoreException dmce) {
            this.getCommandLevelAndPlatform(t);
            this.disconnect(t, false, false, 50013);
            throw dmce;
        }
        this.getPcfMonitorAgent(t).setSendSummaryEvents(true);
        this.getPcfMonitorAgent(t).start(t, "PCFMonitorAgent for " + this.getTreeName(t));
        this.setRefreshInterval(t, this.refreshInterval);
        this.setExpiryInterval(t, this.expiryInterval);
        this.setWaitInterval(t, this.waitInterval);
        this.getPcfMonitorAgent(t).addErrorListener(t, (ErrorListener)this);
        this.getPcfMonitorAgent(t).setRefreshListener(t, (PCFMonitorAgent.RefreshListener)this);
        this.connectionHandle.setCommandLevel(this.getCommandLevel());
        this.connectionHandle.setPlatform(this.getPlatform());
        this.connectionHandle.setUuid(this.getUUID());
        this.addObserver(t, this, new DmObjectFilter(t, 2));
        this.refresh(t, true);
        if (this.save) {
            PersistQueueManagerHandles.add(t, this.dmConnectionHandle);
        }
        this.dmConnectionHandle.refreshAttributes(t);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void connectToQueueManager(Trace t) throws DmCoreException {
        this.standby = false;
        try {
            switch (this.connectionHandle.getConnectionType()) {
                case 2: {
                    this.connectUsingClient(t);
                    break;
                }
                case 5: {
                    try {
                        this.connectionHandle.setFirstConnName(t);
                        this.connectUsingClient(t);
                        this.treeName = null;
                        this.getTreeName(t);
                        break;
                    }
                    catch (DmCoreException e) {
                        tryAnother = this.connectionHandle.interateConnName(t);
                        if (tryAnother) ** GOTO lbl30
                        throw e;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            this.connectUsingClient(t);
                            this.treeName = null;
                            this.getTreeName(t);
                            tryAnother = false;
                            continue;
                        }
                        catch (DmCoreException v0) {
                            tryAnother = this.connectionHandle.interateConnName(t);
                            if (tryAnother) continue;
                            throw e;
                        }
lbl30:
                        // 3 sources

                        ** while (tryAnother)
                    }
lbl31:
                    // 1 sources

                    break;
                }
                case 1: {
                    this.connectUsingBind(t);
                    break;
                }
                case 3: {
                    this.connectUsingVia(t);
                    break;
                }
                case 4: {
                    this.connectUsingChanDefTable(t);
                    break;
                }
                default: {
                    if (Trace.isTracing) {
                        t.data(65, "DmQueueManager.connectToQueueManager", 900, "Invalid QueueManagerHandle type : " + this.connectionHandle.getConnectionType() + " for " + this.connectionHandle.getQueueManagerName());
                    }
                    return;
                }
            }
        }
        catch (DmCoreException dmce) {
            this.checkReasonCodeForStandby(t, dmce.getReasonCode());
            this.disconnect(t, false, false, dmce.getReasonCode());
            throw dmce;
        }
    }

    private void connectUsingBind(Trace t) throws DmCoreException {
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.connectUsingBind", 300, "Server connection to " + this.connectionHandle.getQueueManagerName());
        }
        if (NativeCalls.isStandbyQueueManager((Trace)t, (String)this.dmTitle)) {
            this.standby = true;
            this.exception = this.createException(t, 0, 2543, 2);
            throw this.exception;
        }
        if (!CommonServices.isMqjbnd()) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.connectUsingBind", 900, "Load library not available");
            }
            throw this.createException(t, 0, 50047, 2);
        }
        try {
            int connectOptions = CorePlugin.getMQConnectOptions();
            int ccsid = CorePlugin.getCCSID();
            Hashtable<String, Object> parms = this.connectionHandle.getUserIdOptions(t);
            parms.put("connectOptions", connectOptions);
            parms.put("CCSID", ccsid);
            parms.put("APPNAME", Common.CLIENT_CONNECTION_APPNAME);
            this.mqQueueManager = new MQQueueManager(this.connectionHandle.getQueueManagerName(), parms);
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.connectUsingBind", 300, "Created new MQQueueManager object");
            }
            this.pcfMonitorAgent = new PCFMonitorAgent(t);
            this.getPcfMonitorAgent(t).setCharacterSet(ccsid);
            this.setModelAndReplyQueueNames(t);
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.connectUsingBind", 300, "Set CCSID and model and reply queue names");
            }
            this.getPcfMonitorAgent(t).connect(this.mqQueueManager);
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.connectUsingBind", 300, "Connected to PCFMonitorAgent");
            }
        }
        catch (MQException mqe) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.connectUsingBind", 900, "Error binding to " + this.connectionHandle.getQueueManagerName());
                t.data(65, "DmQueueManager.connectUsingBind", 900, mqe.getMessage());
            }
            if (this.save) {
                PersistQueueManagerHandles.add(t, this.dmConnectionHandle);
            }
            DmCoreException e = null;
            if (mqe.reasonCode == 2035 && mqe.exceptionSource != null && mqe.exceptionSource instanceof MQQueue) {
                try {
                    String queueName = ((MQQueue)mqe.exceptionSource).getName().trim();
                    String message = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4401", (String)queueName);
                    e = new DmCoreException(t, message, "AMQ4401", mqe.reasonCode, mqe.completionCode, 10);
                }
                catch (MQException mqe2) {
                    if (Trace.isTracing) {
                        t.data(65, "DmQueueManager.connectUsingBind", 900, "Error getting MQException.exceptionSource name");
                        t.data(65, "DmQueueManager.connectUsingBind", 900, mqe2.getMessage());
                    }
                    e = null;
                }
            }
            if (e == null) {
                e = this.createException(t, 0, mqe.reasonCode, mqe.completionCode);
            }
            throw e;
        }
        catch (DmCoreException dmce) {
            throw dmce;
        }
    }

    private void connectUsingClient(Trace t) throws DmCoreException {
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.connectUsingClient", 300, "Client connection to " + this.connectionHandle.getQueueManagerName() + " at" + this.connectionHandle.getHostName(t) + "(" + this.connectionHandle.getPortAddress(t) + ") using " + this.connectionHandle.getChannel());
        }
        try {
            Hashtable<String, Object> parms = this.connectionHandle.getSecurityOptions(t);
            parms.put("hostname", this.connectionHandle.getHostName(t));
            parms.put("port", this.connectionHandle.getPortAddress(t));
            parms.put("channel", this.connectionHandle.getChannel());
            parms.put("transport", "MQSeries Client");
            parms.put("APPNAME", Common.CLIENT_CONNECTION_APPNAME);
            int ccsid = CorePlugin.getCCSID();
            parms.put("CCSID", ccsid);
            if (!parms.containsKey("userID")) {
                String userID = System.getProperty("user.name", "");
                parms.put("userID", userID);
            }
            this.mqQueueManager = new MQQueueManager(this.connectionHandle.getQueueManagerName(), parms);
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.connectUsingClient", 300, "Created new MQQueueManager object");
            }
            this.pcfMonitorAgent = new PCFMonitorAgent(t);
            this.setModelAndReplyQueueNames(t);
            this.getPcfMonitorAgent(t).setCharacterSet(ccsid);
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.connectUsingClient", 300, "Set CCSID and model and reply queue names");
            }
            this.getPcfMonitorAgent(t).connect(this.mqQueueManager);
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.connectUsingClient", 300, "Connected to PCFMonitorAgent");
            }
            this.standby = false;
            if (this.name.startsWith("*")) {
                this.resetQueueManagerName(t);
            }
        }
        catch (DmCoreException dmce) {
            throw dmce;
        }
        catch (SecurityException e) {
            String messageId = "AMQ4129";
            String message = CommonServices.getSystemMessage((Trace)t, (String)messageId);
            DmCoreException ex = new DmCoreException(t, message, e, messageId, 50013, 2, 0);
            throw ex;
        }
        catch (MQException mqe) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.connectUsingClient", 900, "Error starting client connection to " + this.connectionHandle.getHostName(t) + "(" + this.connectionHandle.getPortAddress(t) + ") using " + this.connectionHandle.getChannel());
                t.data(65, "DmQueueManager.connectUsingClient", 900, mqe.toString());
            }
            if (this.save) {
                PersistQueueManagerHandles.add(t, this.dmConnectionHandle);
            }
            throw this.createException(t, 0, mqe.reasonCode, mqe.completionCode);
        }
        catch (Exception e) {
            String messageId = "AMQ4059";
            String message = CommonServices.getSystemMessage((Trace)t, (String)messageId, (String)String.valueOf(2059));
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.connectUsingClient", 900, "Exception starting client connection to " + this.connectionHandle.getHostName(t) + "(" + this.connectionHandle.getPortAddress(t) + ") using " + this.connectionHandle.getChannel());
                t.data(65, "DmQueueManager.connectUsingClient", 900, "Exception = " + e.toString());
            }
            DmCoreException ex = new DmCoreException(t, message, e, messageId, 50013, 2, 0);
            throw ex;
        }
    }

    private void connectUsingVia(Trace t) throws DmCoreException {
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.connectUsingVia", 300, "Connection to " + this.getTitle() + " via " + this.connectionHandle.getQueueManagerName());
        }
        try {
            DmQueueManager dmqm = CoreServices.getMatchingQueueManager(t, this.connectionHandle.getViaUUID(), false);
            try {
                if (dmqm == null) {
                    Thread.sleep(10000L);
                    dmqm = CoreServices.getMatchingQueueManager(t, this.connectionHandle.getViaUUID(), false);
                }
            }
            catch (InterruptedException interruptedException) {}
            DmMQQueueManager newConnection = dmqm.getNewConnection(t);
            this.mqQueueManager = newConnection.createConnection(t);
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.connectUsingVia", 300, "Created new DmMQQueueManager object");
            }
            this.pcfMonitorAgent = new PCFMonitorAgent(t);
            this.setModelAndReplyQueueNames(t);
            this.pcfMonitorAgent.setCharacterSet(CorePlugin.getCCSID());
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.connectUsingVia", 300, "Set CCSID and model and reply queue names");
            }
            this.getPcfMonitorAgent(t).connect(this.mqQueueManager, this.connectionHandle.getCommandQueueName(), this.getTitle());
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.connectUsingVia", 300, "Connected to PCFMonitorAgent");
            }
            this.viaQueueManager = dmqm;
        }
        catch (MQException mqe) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.connectUsingVia", 900, "Error starting connection to " + this.getTitle() + " via " + this.connectionHandle.getViaUUID());
                t.data(65, "DmQueueManager.connectUsingVia", 900, mqe.getMessage());
            }
            throw this.createException(t, 0, mqe.reasonCode, mqe.completionCode);
        }
        catch (NullPointerException nullPointerException) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.connectUsingVia", 900, "Error starting connection to " + this.getTitle() + " via " + this.connectionHandle.getViaUUID());
            }
            throw new DmCoreException(t, CommonServices.getSystemMessage((Trace)t, (String)"AMQ4630", (String)this.getTitle()), "AMQ4630", 50013, 0, 20);
        }
        catch (DmCoreException dmce) {
            throw dmce;
        }
    }

    private void connectUsingChanDefTable(Trace t) throws DmCoreException {
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.connectUsingChanDefTable", 300, "Connection to " + this.getTitle() + " using " + this.connectionHandle.getChannelDefTable());
        }
        try {
            Hashtable<String, Object> parms = this.connectionHandle.getSecurityOptions(t);
            parms.put("CCSID", CorePlugin.getCCSID());
            String userID = System.getProperty("user.name", "");
            parms.put("userID", userID);
            URL chanDefTable = new URL(this.connectionHandle.getChannelDefTable());
            this.mqQueueManager = new MQQueueManager(this.connectionHandle.getQueueManagerName(), parms, chanDefTable);
            this.pcfMonitorAgent = new PCFMonitorAgent(t);
            this.getPcfMonitorAgent(t).setCharacterSet(CorePlugin.getCCSID());
            this.setModelAndReplyQueueNames(t);
            this.getPcfMonitorAgent(t).connect(this.mqQueueManager);
            if (this.name.startsWith("*")) {
                this.resetQueueManagerName(t);
            }
        }
        catch (MQException mqe) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.connectUsingChanDefTable", 900, "Error starting connection to " + this.getTitle() + " using " + this.connectionHandle.getChannelDefTable());
                t.data(65, "DmQueueManager.connectUsingChanDefTable", 900, mqe.getMessage());
            }
            throw this.createException(t, 0, mqe.reasonCode, mqe.completionCode);
        }
        catch (NullPointerException npe) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.connectUsingChanDefTable", 900, "Error starting connection to " + this.getTitle() + " using " + this.connectionHandle.getChannelDefTable());
                t.data(65, "DmQueueManager.connectUsingChanDefTable", 900, npe.getMessage());
            }
            if (this.save) {
                PersistQueueManagerHandles.add(t, this.dmConnectionHandle);
            }
            throw this.createException(t, 0, 2087, 2);
        }
        catch (MalformedURLException me) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.connectUsingChanDefTable", 900, "Error creating URL to " + this.getTitle() + " using " + this.connectionHandle.getChannelDefTable());
                t.data(65, "DmQueueManager.connectUsingChanDefTable", 900, me.getMessage());
            }
            if (this.save) {
                PersistQueueManagerHandles.add(t, this.dmConnectionHandle);
            }
            throw this.createException(t, 0, 2087, 2);
        }
        catch (DmCoreException dmce) {
            throw dmce;
        }
    }

    private void setModelAndReplyQueueNames(Trace t) throws DmCoreException {
        block8: {
            this.pcfMonitorAgent.setReplyQueuePrefix(EXPLORER_REPLY_QUEUE_PREFIX);
            try {
                this.getPcfMonitorAgent(t).setModelQueueName(EXPLORER_REPLY_MODEL_QUEUE);
                MQQueue queue = this.mqQueueManager.accessQueue(EXPLORER_REPLY_MODEL_QUEUE, 32, "", "AMQ.MQEXPLORER.*", "mqm");
                queue.setCloseOptions(2);
                queue.close();
            }
            catch (MQException e) {
                if (Trace.isTracing) {
                    t.data(65, "DmQueueManager.setModelAndReplyQueueNames", 900, "SYSTEM.MQEXPLORER.REPLY.MODEL not found");
                }
                DmCoreException dmce = null;
                String message = null;
                switch (e.reasonCode) {
                    case 2085: {
                        message = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4400", (String)EXPLORER_REPLY_MODEL_QUEUE);
                        dmce = new DmCoreException(t, message, "AMQ4400", e.reasonCode, e.completionCode, 10);
                        break;
                    }
                    case 2035: {
                        message = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4401", (String)EXPLORER_REPLY_MODEL_QUEUE);
                        dmce = new DmCoreException(t, message, "AMQ4401", e.reasonCode, e.completionCode, 10);
                        break;
                    }
                    default: {
                        String value = String.valueOf(e.reasonCode);
                        message = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4402", (String[])new String[]{EXPLORER_REPLY_MODEL_QUEUE, value});
                        dmce = new DmCoreException(t, message, "AMQ4402", e.reasonCode, e.completionCode, 10);
                    }
                }
                throw dmce;
            }
            catch (DmCoreException dmCoreException) {
                if (!Trace.isTracing) break block8;
                t.data(65, "DmQueueManager.setModelAndReplyQueueNames", 900, "PCFMonitorAgent not found");
            }
        }
    }

    public static boolean staticInit(Trace t, Bundle bund) {
        allAttributesByType = DmQueueManager.initAllAttrTypeTable(t, DmQueueManager.getClassName(DmQueueManager.class.getName()), allAttributesByType, bund);
        if (allAttributesByType == null) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.staticInit", 900, "Error loading allAttributesByType table");
            }
            return false;
        }
        updateGroupsByName = DmQueueManager.initConfigTable(t, DmQueueManager.getClassName(DmQueueManager.class.getName()), updateGroupsByName);
        if (updateGroupsByName == null) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.staticInit", 900, "Error loading updateGroupsByName table");
            }
            return false;
        }
        return true;
    }

    public static String getAttributeTitle(Trace t, int id) {
        return DmQueueManager.getAttributeTitle(t, allAttributesByType, id);
    }

    public static AttrType getAttributeType(Trace t, int id) {
        return DmQueueManager.getAttributeType(t, allAttributesByType, id);
    }

    public static String getAttributeDefaultValue(Trace t, int id) {
        return DmQueueManager.getAttributeDefaultValue(t, allAttributesByType, id);
    }

    public static int[] getDisplayColumnSequence(Trace t, int[] ids, boolean zOS) {
        return DmQueueManager.getDisplayColumnSequence(t, allAttributesByType, ids, zOS);
    }

    public static boolean isAttributeRepeating(Trace t, int id) {
        return DmQueueManager.isAttributeRepeating(t, allAttributesByType, id);
    }

    @Override
    public int getStatusType(Trace t) {
        return this.getStatusType(t, 2, 0);
    }

    @Override
    public String toString(Trace t) {
        return this.getTitle();
    }

    public String getTreeName(Trace t) {
        if (this.treeName != null) {
            return this.treeName;
        }
        this.treeName = this.getTitle();
        if (this.connectionHandle != null) {
            switch (this.connectionHandle.getConnectionType()) {
                case 2: 
                case 5: {
                    this.treeName = CoreServices.message.getMessage(t, "TREENAME_ON.title", this.getTitle(), "'" + this.connectionHandle.getConnectionName() + "'");
                    if (!CoreServices.sameTreeNameExists(t, this)) break;
                    this.treeName = CoreServices.message.getMessage(t, "TREENAME_USING.title", this.treeName, "'" + this.connectionHandle.getChannel() + "'");
                    break;
                }
                case 4: {
                    this.treeName = CoreServices.message.getMessage(t, "TREENAME_USING.title", this.getTitle(), "'" + this.connectionHandle.getChannelDefTable() + "'");
                    break;
                }
                case 3: {
                    this.treeName = CoreServices.message.getMessage(t, "TREENAME_VIA.title", this.getTitle(), "'" + this.connectionHandle.getViaQueueManagerName() + "'");
                }
            }
        }
        return this.treeName;
    }

    private boolean getCommandLevelAndPlatform(Trace t) {
        Attr aPlatform;
        Attr aCommandLevel = this.getAttribute(t, 31, 0);
        if (aCommandLevel != null) {
            this.setCommandLevel((Integer)aCommandLevel.getValue(t));
        }
        if ((aPlatform = this.getAttribute(t, 32, 0)) != null) {
            this.setPlatform((Integer)aPlatform.getValue(t));
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.getCommandLevelAndPlatform", 300, "Platform = " + this.getPlatform() + ", command level = " + this.getCommandLevel());
            }
            return true;
        }
        if (this.pcfMonitorAgent != null && this.pcfMonitorAgent.getPlatform() > 0) {
            this.setPlatform(this.pcfMonitorAgent.getPlatform());
            this.setCommandLevel(this.pcfMonitorAgent.getCommandLevel());
            this.setCommandLevelAndPlatformAttrs(t);
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.getCommandLevelAndPlatform", 300, "PCFMonitor platform = " + this.getPlatform() + ", command level = " + this.getCommandLevel());
            }
            return true;
        }
        if (this.connectionHandle.getCommandLevel() > 0) {
            this.setPlatform(this.connectionHandle.getPlatform());
            this.setCommandLevel(this.connectionHandle.getCommandLevel());
            this.setCommandLevelAndPlatformAttrs(t);
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.getCommandLevelAndPlatform", 300, "Previously saved platform = " + this.getPlatform() + ", command level = " + this.getCommandLevel());
            }
            return true;
        }
        return true;
    }

    private boolean getQueueManagerSnapshot(Trace t) throws DmCoreException {
        PCFMessage[] pcfResponses;
        block12: {
            PCFMessage pcfRequest = new PCFMessage(2);
            pcfRequest.addParameter(1001, 1009);
            if (this.pcfMonitorAgent == null) {
                return false;
            }
            pcfResponses = this.pcfMonitorAgent.snapshot(t, new PCFQuery(PCFQuery.INQUIRE_Q_MGR), true);
            if (pcfResponses != null) break block12;
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.getQueueManagerSnapshot", 900, "Error retrieving queue manager snapshot");
            }
            return false;
        }
        try {
            this.addAttrFromPCFResponse(t, pcfResponses[0]);
            String s = this.getAttributeValue(t, 2032, 0);
            if (s.equals("[not_found]") && Trace.isTracing) {
                t.data(65, "DmQueueManager.getQueueManagerSnapshot", 900, "UUID not found for " + this.getTitle());
            }
            this.setUUID(t, s);
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.getQueueManagerSnapshot", 300, "UUID = " + this.getUUID());
            }
            this.checkCommandLevel(t);
            this.ignoreConnectionCheck = false;
            this.getCommandLevelAndPlatform(t);
            if (!this.isZos() && this.commandLevel >= 600) {
                this.getOamInformation(t);
            }
        }
        catch (DmCoreException e) {
            throw e;
        }
        catch (PCFException pcfe) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.getQueueManagerSnapshot", 900, "Error retrieving UUID");
            }
            this.exception = this.createException(t, 0, pcfe.reasonCode, pcfe.completionCode);
            throw this.exception;
        }
        catch (MQException mqe) {
            this.exception = this.createException(t, 0, mqe.reasonCode, mqe.completionCode);
            throw this.exception;
        }
        catch (IOException iOException) {
            this.exception = this.createException(t, 2, 50012, 2);
            throw this.exception;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refreshConfigAttributes(Trace t) {
        boolean retValue = false;
        boolean tablesEqual = false;
        if (this.isLocal(t) && !this.closed && NativeCalls.isUserAuthorized((Trace)t)) {
            Hashtable hashtable = this.attributes;
            synchronized (hashtable) {
                this.removeConfigAttributes(t);
                retValue = this.getStanzaAttrs(t, this.attributesByType, this.toString(t), updateGroupsByName);
                if (retValue) {
                    this.loadDefaultAttributeValues(t, updateGroupsByName);
                    if (Trace.isTracing) {
                        t.data(65, "DmQueueManager.refreshConfigAttributes", 300, "Config attributes refreshed for " + this.getTitle());
                    }
                    Hashtable currentConfigAttributes = this.getConfigAttributes(t);
                    tablesEqual = this.compareTables(t, currentConfigAttributes, this.oldConfigAttributes);
                    this.oldConfigAttributes.clear();
                    this.oldConfigAttributes = (Hashtable)currentConfigAttributes.clone();
                    if (!tablesEqual && this.connected) {
                        this.notifyListeners(t, 4, null, "ALL");
                    } else if (Trace.isTracing) {
                        t.data(65, "DmQueueManager.refreshConfigAttributes", 300, "No config attribute changes for " + this.getTitle());
                    }
                    this.addMachineAttributes(t, this.dmTitle);
                } else if (Trace.isTracing) {
                    t.data(65, "DmQueueManager.refreshConfigAttributes", 900, "Error refreshing config attributes for " + this.getTitle());
                }
            }
        } else if (Trace.isTracing) {
            t.data(65, "DmQueueManager.refreshConfigAttributes", 300, "Config refresh ignored - " + this.getTitle() + " is closed, not a local queue manager or user is not authorized");
        }
        return retValue;
    }

    public HashMap<String, DmObjectListView> getListOfObjectListViews(Trace t) {
        return this.currentListListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getObjects(Trace t, DmObjectListListener listener, DmObjectFilter filter) {
        DmObjectListView objectView = null;
        boolean added = false;
        DmObjectListView addedView = null;
        String uniqueName = Trace.NO_LISTENER_INFO;
        Object object = this.hashLock;
        synchronized (object) {
            objectView = new DmObjectListView(t, this, listener, filter);
            uniqueName = this.getUniqueObjectName(listener);
            addedView = this.currentListListeners.put(uniqueName, objectView);
        }
        if (addedView == null) {
            added = true;
            Thread thread = new Thread(objectView);
            thread.setName("WMQ - get list of object types " + filter.getType());
            thread.start();
            if (Trace.isTracing) {
                String filterString = filter.toString(t);
                t.data(65, "DmQueueManager.getObjects", 300, String.valueOf(this.getTreeName(t)) + " adding getObjects listener for " + uniqueName + ", add status = true" + "\nfilter = " + filterString);
            }
        } else if (Trace.isTracing) {
            t.data(65, "DmQueueManager.getObjects", 900, String.valueOf(this.getTreeName(t)) + " getObjects listener already in list for " + uniqueName);
        }
        return added;
    }

    public ArrayList getObjects(Trace t, DmObjectFilter filter) throws DmCoreException {
        return this.getObjects(t, filter, true);
    }

    public ArrayList getObjects(Trace t, DmObjectFilter filter, boolean addStatus) throws DmCoreException {
        DmObjectListView objectView = null;
        ArrayList<IDmObject> list = null;
        objectView = new DmObjectListView(t, this, null, filter);
        list = objectView.getList(t, addStatus);
        return list;
    }

    public boolean isLocal() {
        return !this.dmConnectionHandle.isClient(Trace.getInstance());
    }

    public boolean isLocal(Trace t) {
        return !this.dmConnectionHandle.isClient(t);
    }

    public PCFMonitorAgent getPcfMonitorAgent(Trace t) throws DmCoreException {
        if (this.pcfMonitorAgent == null) {
            throw this.createException(t, 0, 50015, 2);
        }
        return this.pcfMonitorAgent;
    }

    public PCFMessage[] sendCommand(Trace t, PCFMessage request) throws MQException {
        PCFMessage[] pcfResponses = null;
        if (this.pcfMonitorAgent == null) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.sendCommand", 900, "PCFMonitor agent not created");
            }
            return null;
        }
        try {
            pcfResponses = this.pcfMonitorAgent.update(t, request);
        }
        catch (PCFException pcfe) {
            PCFQuery.traceMQRequest((Trace)t, (PCFMessage)request);
            PCFResponseAnalyser err = new PCFResponseAnalyser(t, (MQException)((Object)pcfe));
            int pcfCompCode = err.getCompletionCode();
            int pcfReasonCode = err.getReasonCode();
            if (request.getCommand() == 203 && pcfe.getReason() == 3081) {
                switch (request.getIntParameterValue(1086)) {
                    case 6: 
                    case 7: 
                    case 8: {
                        pcfCompCode = 2;
                        pcfReasonCode = 2035;
                        break;
                    }
                }
            }
            MQException mqe = new MQException(pcfCompCode, pcfReasonCode, (Object)pcfe);
            this.onError(mqe);
            throw mqe;
        }
        catch (MQException mqe) {
            PCFQuery.traceMQRequest((Trace)t, (PCFMessage)request);
            PCFQuery.traceMQException((Trace)t, (MQException)mqe);
            this.onError(mqe);
            throw mqe;
        }
        catch (IOException ioe) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.sendCommand", 900, ioe.toString());
            }
            return null;
        }
        return pcfResponses;
    }

    public void connectAsynchronously(Trace t) {
        String key = "ALL";
        this.connectAsynchronously(t, (Object)key);
    }

    public void connectAsynchronously(Trace t, Object key) {
        this.connectNow = true;
        this.dmConnectionHandle.setUserDisconnect(t, false);
        this.connectAsynchronously(t, (String)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectAsynchronously(Trace t, String key) {
        Object object = this.lockConnection;
        synchronized (object) {
            if (this.connecting) {
                if (Trace.isTracing) {
                    t.data(65, "DmQueueManager.connectAsynchronously", 300, "Connect request to " + this.getTreeName(t) + " ignored - already trying to connect");
                }
                return;
            }
            this.connecting = true;
        }
        if (this.disconnecting && Trace.isTracing) {
            t.data(65, "DmQueueManager.connectAsynchronously", 900, "Connect while disconnecting to " + this.getTreeName(t));
        }
        if (this.pcfMonitorAgent == null) {
            this.connectionError = false;
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.connectAsynchronously", 300, "Trying to re-initialize " + this.getTreeName(t));
            }
            this.notifyListeners(t, 106, null, key);
            this.connectionThread = new AsyncConnectionToQueueManager(t, this, key);
        } else {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.connectAsynchronously", 300, "Connect request to " + this.getTreeName(t) + " ignored - PCFMonitorAgent already defined");
            }
            this.connecting = false;
        }
    }

    public boolean connectSynchronously(Trace t) {
        this.connectNow = true;
        this.dmConnectionHandle.setUserDisconnect(t, false);
        boolean retValue = this.connectSynchronously(t, "ALL");
        return retValue;
    }

    protected boolean connectSynchronously(Trace t, String key) {
        if (this.disconnecting && Trace.isTracing) {
            t.data(65, "DmQueueManager.connectSynchronously", 900, "Connect while disconnecting to " + this.getTreeName(t));
        }
        if (this.pcfMonitorAgent == null) {
            this.connectionError = false;
            if (!this.connecting) {
                this.connecting = true;
                if (Trace.isTracing) {
                    t.data(65, "DmQueueManager.connectSynchronously", 300, "Initialising connection to " + this.getTreeName(t));
                }
                this.notifyListeners(t, 106, null, key);
                try {
                    this.init(t);
                    this.connectNow = false;
                    this.connected = this.mqQueueManager.isConnected();
                    if (Trace.isTracing) {
                        t.data(65, "DmQueueManager.connectSynchronously", 300, "Connection status to " + this.getTreeName(t) + " is " + this.connected);
                    }
                    this.notifyListeners(t, 103, null, key);
                    this.connecting = false;
                }
                catch (DmCoreException dmce) {
                    if (Trace.isTracing) {
                        t.data(65, "DmQueueManager.connectSynchronously", 300, "Connection to " + this.getTreeName(t) + " failed");
                    }
                    this.connecting = false;
                    this.connected = false;
                    this.connectNow = false;
                    this.exception = dmce;
                    if (dmce.getReasonCode() != 50045) {
                        this.notifyListeners(t, 102, dmce, key);
                    }
                    return false;
                }
            } else if (Trace.isTracing) {
                t.data(65, "DmQueueManager.connectSynchronously", 300, "Connect request ignored - already trying to connect");
            }
        } else if (Trace.isTracing) {
            t.data(65, "DmQueueManager.connectSynchronously", 300, "PCFMonitorAgent not defined to " + this.getTreeName(t));
        }
        return this.connected;
    }

    public void disconnect(Trace t) {
        this.disconnect(t, true, true, 2009);
        this.dmConnectionHandle.setUserDisconnect(t, true);
        if (this.dmConnectionHandle.isPromptPassword()) {
            this.dmConnectionHandle.deletePassword();
        }
    }

    public void disconnectAsync(Trace t, int rc) {
        this.disconnectionThread = new AsyncDisconnectionFromQueueManager(t, this, rc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(Trace t, boolean notifyDisconnect, boolean notifyRefresh, int rc) {
        block26: {
            Object object = this.lockDisconnection;
            synchronized (object) {
                if (this.disconnecting) {
                    if (Trace.isTracing) {
                        t.data(65, "DmQueueManager.disconnect", 300, "Disconnect ignored for " + this.getTreeName(t) + ", already disconnecting");
                    }
                    return;
                }
                this.disconnecting = true;
            }
            if (this.connecting && Trace.isTracing) {
                t.data(65, "DmQueueManager.disconnect", 300, "Disconnect while connecting to " + this.getTreeName(t));
            }
            DmCoreException ex = this.createException(t, 0, rc, 2);
            if (notifyRefresh) {
                this.notifyAllViews(t, this, 0, true, ex);
            }
            if (notifyDisconnect) {
                this.notifyListeners(t, 102, ex, "ALL");
            }
            this.deleteAllObservers(t);
            this.deleteObserver(t, this);
            this.resetLocalAttributes(t);
            try {
                block27: {
                    if (this.pcfMonitorAgent != null) {
                        block25: {
                            if (Trace.isTracing) {
                                t.data(65, "DmQueueManager.disconnect", 300, String.valueOf(this.getTreeName(t)) + " removing error listener");
                            }
                            this.pcfMonitorAgent.removeErrorListener(t, (ErrorListener)this);
                            if (Trace.isTracing) {
                                t.data(65, "DmQueueManager.disconnect", 300, String.valueOf(this.getTreeName(t)) + " stopping monitor thread");
                            }
                            this.pcfMonitorAgent.stop(t);
                            if (Trace.isTracing) {
                                t.data(65, "DmQueueManager.disconnect", 300, String.valueOf(this.getTreeName(t)) + " disconnecting PCFMonitorAgent");
                            }
                            try {
                                this.pcfMonitorAgent.disconnect(t);
                            }
                            catch (MQException e) {
                                if (Trace.isTracing) {
                                    t.data(65, "DmQueueManager.disconnect", 900, "Error stopping PCFMonitorAgent to " + this.getTreeName(t) + " : " + e.toString());
                                }
                            }
                            catch (NullPointerException npe) {
                                if (!Trace.isTracing) break block25;
                                t.data(65, "DmQueueManager.disconnect", 900, "Error stopping PCFMonitorAgent to " + this.getTreeName(t) + " : " + npe.toString());
                            }
                        }
                        this.pcfMonitorAgent = null;
                        if (Trace.isTracing) {
                            t.data(65, "DmQueueManager.disconnect", 300, "PCFMonitorAgent to " + this.getTreeName(t) + " disconnected and terminated");
                        }
                    } else if (Trace.isTracing) {
                        t.data(65, "DmQueueManager.disconnect", 900, "PCFMonitorAgent not initialized for " + this.getTreeName(t));
                    }
                    if (this.mqQueueManager == null) break block26;
                    if (Trace.isTracing) {
                        t.data(65, "DmQueueManager.disconnect", 300, "Disconnecting MQQueueManager to " + this.getTreeName(t));
                    }
                    try {
                        this.mqQueueManager.disconnect();
                    }
                    catch (Exception e) {
                        if (!Trace.isTracing) break block27;
                        t.data(65, "DmQueueManager.disconnect", 900, "Error stopping MQQueueManager to " + this.getTreeName(t) + " : " + e.getMessage());
                    }
                }
                this.mqQueueManager = null;
            }
            finally {
                this.connected = false;
                this.disconnecting = false;
                this.connectionError = true;
            }
        }
    }

    private void resetLocalAttributes(Trace t) {
        this.attributes.clear();
        if (this.attributesByType == null) {
            this.addAttr(t, allAttributesByType, 2015, 0, this.getTitle());
            this.addAttr(t, allAttributesByType, 10154, 0, this.getTreeName(t));
        } else {
            this.addAttr(t, this.attributesByType, 2015, 0, this.getTitle());
            this.setCommandLevelAndPlatformAttrs(t);
            this.addAttr(t, this.attributesByType, 10154, 0, this.getTreeName(t));
            this.refreshConfigAttributes(t);
        }
        this.isRunning();
    }

    protected void setRefreshInterval(Trace t, int ri) {
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.setRefreshInterval", 300, "New refresh interval is " + ri + " secs");
        }
        if (this.pcfMonitorAgent != null) {
            if (ri < 1) {
                if (Trace.isTracing) {
                    t.data(65, "DmQueueManager.setRefreshInterval", 300, "Stopping PCFMonitorAgent refresh");
                }
                this.pcfMonitorAgent.stop(t);
            } else {
                if (Trace.isTracing) {
                    t.data(65, "DmQueueManager.setRefreshInterval", 300, "PCFMonitorAgent refresh interval reset to " + ri + " secs");
                }
                this.pcfMonitorAgent.setPollInterval(t, ri);
                if (!this.pcfMonitorAgent.isRunning(t)) {
                    if (Trace.isTracing) {
                        t.data(65, "DmQueueManager.setRefreshInterval", 300, "Restarting PCFMonitorAgent refresh");
                    }
                    this.pcfMonitorAgent.start(t, "PCFMonitorAgent for " + this.getTreeName(t));
                }
            }
        } else if (Trace.isTracing) {
            t.data(65, "DmQueueManager.setRefreshInterval", 300, "Set new refresh interval request ignored - PCFMonitorAgent not created");
        }
        this.refreshInterval = ri;
    }

    protected void setExpiryInterval(Trace t, int interval) {
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.setExpiryInterval", 300, "New expiry interval is " + interval + " secs");
        }
        if (this.pcfMonitorAgent != null) {
            this.pcfMonitorAgent.setWaitInterval(this.pcfMonitorAgent.getWaitInterval(), interval);
        }
    }

    protected void setWaitInterval(Trace t, int interval) {
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.setWaitInterval", 300, "New wait interval is " + interval + " secs");
        }
        if (this.pcfMonitorAgent != null) {
            this.pcfMonitorAgent.setWaitInterval(interval, this.pcfMonitorAgent.getExpiry());
        }
    }

    public int getRefreshInterval(Trace t) {
        return this.refreshInterval;
    }

    public void setUserDisconnect(Trace t, boolean b) {
        this.dmConnectionHandle.setUserDisconnect(t, b);
    }

    public boolean isConnected() {
        return this.connected && !this.disconnecting;
    }

    public boolean isRunning() {
        boolean running;
        block8: {
            Trace t = Trace.getInstance();
            running = false;
            if (this.isLocal(t)) {
                Attr a = this.getAttribute(t, 1149, 0);
                if (a != null) {
                    try {
                        int i = (Integer)a.getValue(t);
                        if (i == 2) {
                            running = true;
                        }
                        break block8;
                    }
                    catch (Exception e) {
                        if (Trace.isTracing) {
                            t.data(65, "DmQueueManager.isRunning", 900, "Error getting queue manager status attribute 1149\n" + e.toString());
                        }
                        break block8;
                    }
                }
                if (Trace.isTracing) {
                    t.data(65, "DmQueueManager.isRunning", 900, "Queue manager status attribute 1149 not found");
                }
                this.setRunningStatus(t, NativeCalls.getQueueManagerStatus((Trace)t, (String)this.getTitle()));
            } else {
                running = this.connected;
            }
        }
        return running;
    }

    public void setRunningStatus(Trace t, int i) {
        this.runningStatus = i;
        if (this.isLocal(t)) {
            int pcfValue = 0;
            this.standby = false;
            switch (i) {
                case 6: {
                    pcfValue = 3;
                    break;
                }
                case 0: {
                    pcfValue = 2;
                    break;
                }
                case 14: {
                    pcfValue = MQQMSTA_ELSEWHERE;
                    break;
                }
                case 13: {
                    pcfValue = MQQMSTA_STANDBY;
                    this.standby = true;
                    break;
                }
                default: {
                    pcfValue = MQQMSTA_STOPPED;
                    this.standbyPermitted = false;
                }
            }
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.setRunningStatus", 300, "Setting queue manager running status attribute to " + pcfValue + "(from " + i + ")");
            }
            this.addAttr(t, allAttributesByType, 1149, 0, pcfValue);
        } else if (Trace.isTracing) {
            t.data(65, "DmQueueManager.setRunningStatus", 300, "Request ignored - not a local queue manager");
        }
    }

    public boolean isZos() {
        return this.platform == 1;
    }

    public boolean isUnix() {
        switch (this.platform) {
            case 3: 
            case 4: 
            case 12: 
            case 13: 
            case 28: {
                return true;
            }
        }
        return false;
    }

    public boolean isClient(Trace t) {
        return this.dmConnectionHandle.isClient(t);
    }

    public int getPlatform() {
        return this.platform;
    }

    public int getCommandLevel() {
        return this.commandLevel;
    }

    public String getUUID() {
        if (this.uuid == null) {
            return "[not set]";
        }
        return this.uuid;
    }

    public DmQueueManagerHandle getConnectionHandle() {
        return this.dmConnectionHandle;
    }

    private void setPlatform(int i) {
        this.platform = i;
    }

    private void setCommandLevel(int i) {
        this.commandLevel = i;
    }

    private void setUUID(Trace t, String newUUID) throws DmCoreException {
        String oldUUID = this.connectionHandle.getUuid();
        if (!(this.isLocal(t) || "[not_defined]".equals(oldUUID) || "".equals(oldUUID) || this.ignoreConnectionCheck || newUUID.equals(oldUUID))) {
            String messageId = "AMQ4615";
            String message = CommonServices.getSystemMessage((Trace)t, (String)messageId, (String)this.name);
            DmCoreException ex = new DmCoreException(t, message, messageId, 2546, 2, 10);
            throw ex;
        }
        this.uuid = newUUID;
    }

    public void setOldConnectionStatus(boolean b) {
        this.oldConnectionStatus = b;
    }

    public boolean getOldConnectionStatus() {
        return this.oldConnectionStatus;
    }

    public static int[] getAllAttributesByType(Trace t) {
        return DmQueueManager.getAllAttributesByType(t, allAttributesByType);
    }

    @Override
    public void close(Trace t) {
        block13: {
            block12: {
                this.closed = true;
                try {
                    if (this.pcfMonitorAgent != null) {
                        if (Trace.isTracing) {
                            t.data(65, "DmQueueManager.close", 900, "Stopping PCFMonitorAgent to " + this.getTreeName(t));
                        }
                        this.deleteAllObservers(t);
                        this.deleteObserver(t, this);
                        this.pcfMonitorAgent.removeErrorListener(t, (ErrorListener)this);
                        this.pcfMonitorAgent.stop(t);
                        if (this.connected || this.connecting) {
                            this.pcfMonitorAgent.disconnect();
                        }
                        if (Trace.isTracing) {
                            t.data(65, "DmQueueManager.close", 900, "PCFMonitorAgent disconnected from " + this.getTreeName(t));
                        }
                    }
                }
                catch (MQException e) {
                    if (!Trace.isTracing) break block12;
                    t.data(65, "DmQueueManager.close", 900, "Disconnect error to " + this.getTreeName(t) + " : " + e.getMessage());
                }
            }
            try {
                if (this.mqQueueManager != null) {
                    if (Trace.isTracing) {
                        t.data(65, "DmQueueManager.close", 900, "Disconnecting MQQueueManager to " + this.getTreeName(t));
                    }
                    this.mqQueueManager.disconnect();
                } else if (Trace.isTracing) {
                    t.data(65, "DmQueueManager.close", 900, "MQQueueManager not defined to " + this.getTreeName(t));
                }
            }
            catch (MQException e) {
                if (!Trace.isTracing) break block13;
                t.data(65, "DmQueueManager.close", 900, "Disconnect error to " + this.getTreeName(t) + " : " + e.getMessage());
            }
        }
        this.viaQueueManager = null;
        DmMonitor.notifyAllQueueManagerListeners(t, this, 2, null);
    }

    public boolean isVisible(Trace t) {
        return this.dmConnectionHandle.isVisible(t);
    }

    public String getNotifyID(Trace t) {
        return this.notifyID;
    }

    public void onError(MQException mqe) {
        Trace t = Trace.getInstance();
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.onError", 900, "MQException for " + this.getTreeName(t) + ", reason code = " + mqe.reasonCode + ", comp code = " + mqe.completionCode + ", message = " + mqe.getMessage());
        }
        if (!GenerateFFST.ignoreFFST(t, mqe.reasonCode)) {
            t.FFST(65, "DmQueueManager.onError", 0, mqe.reasonCode, mqe.getMessage());
        }
        if (this.checkForDisconnection(t, mqe.reasonCode) && this.dmConnectionHandle.isConnectionTypeMultiInstance(t)) {
            this.connectAsynchronously(t);
        }
    }

    public boolean checkForDisconnection(Trace t, int rc) {
        boolean disconnect = false;
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.checkForDisconnection", 300, "Checking reason code " + rc + " for " + this.getTreeName(t));
        }
        switch (rc) {
            case 2009: 
            case 2017: 
            case 2018: 
            case 2019: 
            case 2051: 
            case 2059: 
            case 2161: 
            case 2162: 
            case 2202: 
            case 2203: 
            case 2223: 
            case 2322: 
            case 2538: 
            case 2543: 
            case 6124: {
                disconnect = true;
                this.disconnect(t, true, true, rc);
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(65, "DmQueueManager.checkForDisconnection", 900, "Error " + rc + " for " + this.getTreeName(t) + " ignored");
            }
        }
        return disconnect;
    }

    public DmMQQueueManager getNewConnection(Trace t) {
        DmMQQueueManager mqqm = null;
        int connectionType = this.connectionHandle.getConnectionType();
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.getNewConnection", 300, "Connection type is " + connectionType + " for " + this.getTreeName(t));
        }
        switch (connectionType) {
            case 2: 
            case 5: {
                mqqm = new DmMQQueueManager(t, this.getTitle(), this.connectionHandle.getHostName(t), this.connectionHandle.getPortAddress(t), this.connectionHandle.getChannel());
                mqqm.setConnHandle(this.connectionHandle);
                break;
            }
            case 1: {
                mqqm = new DmMQQueueManager(t, this.getTitle());
                mqqm.setConnHandle(this.connectionHandle);
                break;
            }
            case 4: {
                mqqm = new DmMQQueueManager(t, this.getTitle(), this.connectionHandle.getChannelDefTable());
                mqqm.setConnHandle(this.connectionHandle);
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(65, "DmQueueManager.getNewConnection", 900, "Unknown connection type : " + connectionType);
            }
        }
        return mqqm;
    }

    public void refresh(Trace t) {
        if (this.isVisible(t)) {
            this.refresh(t, false);
            DmMonitor.checkStatusOfQueueManager(t, this);
        }
    }

    private void refresh(Trace t, boolean sync) {
        if (this.isConnected()) {
            this.refreshObservable(t, this);
        }
        this.refreshConfigAttributes(t);
        this.dmConnectionHandle.refreshAttributes(t);
    }

    private boolean refresh(Trace t, Object v) {
        DmObjectView view = null;
        try {
            view = (DmObjectView)v;
        }
        catch (ClassCastException classCastException) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.refresh", 900, "View not DmObjectView object");
            }
            return false;
        }
        view.refresh(t, false);
        return true;
    }

    public int actionPing(Trace t, DmActionListener listener) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.actionPing", 300, "Pinging queue manager " + this.getTreeName(t));
        }
        PCFAction cmd = new PCFAction(t, 40, this);
        rc = cmd.execute(t, listener);
        return rc;
    }

    public int actionRefreshCluster(Trace t, DmActionListener listener, String clusterName) {
        return this.actionRefreshCluster(t, listener, clusterName, 0);
    }

    public int actionRefreshCluster(Trace t, DmActionListener listener, String clusterName, int refresh) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.actionRefreshCluster", 300, "Cluster refresh for queue manager " + this.getTreeName(t));
        }
        PCFAction cmd = new PCFAction(t, 73, this);
        cmd.getRequest(t).addParameter(2029, clusterName);
        if (this.commandLevel > 510) {
            cmd.getRequest(t).addParameter(1095, refresh);
        }
        rc = cmd.execute(t, listener);
        return rc;
    }

    public int actionRefreshSecurity(Trace t, DmActionListener listener, int secType) {
        int rc = 0;
        rc = secType == 3 ? this.actionRefreshSecurity(t, listener, secType, 0) : this.actionRefreshSecurity(t, listener, secType, -1);
        return rc;
    }

    public int actionRefreshSecurity(Trace t, DmActionListener listener, int secType, int secItem) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.actionRefreshSecurity", 300, "Refresh security for queue manager " + this.getTreeName(t));
        }
        PCFAction cmd = new PCFAction(t, 78, this);
        if (this.commandLevel >= 600) {
            cmd.getRequest(t).addParameter(1106, secType);
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.actionRefreshSecurity", 300, "Security type " + secType);
            }
            if (secItem != -1) {
                cmd.getRequest(t).addParameter(1129, secItem);
                if (Trace.isTracing) {
                    t.data(65, "DmQueueManager.actionRefreshSecurity", 300, "Security item " + secItem);
                }
            }
        }
        rc = cmd.execute(t, listener);
        return rc;
    }

    public int actionResetCluster(Trace t, DmActionListener listener, String clusterName, String id, String qmName) {
        return this.actionResetCluster(t, listener, clusterName, id, qmName, 1, 0);
    }

    public int actionResetCluster(Trace t, DmActionListener listener, String clusterName, String id, String qmName, int action, int removeQueues) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.actionResetCluster", 300, "Cluster reset for queue manager " + this.getTreeName(t));
        }
        PCFAction cmd = new PCFAction(t, 74, this);
        rc = cmd.execute(t, listener);
        return rc;
    }

    public int actionResumeCluster(Trace t, DmActionListener listener, String clusterName, String clusterNameList) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.actionResumeCluster", 300, "Cluster resume for queue manager " + this.getTreeName(t));
        }
        PCFAction cmd = new PCFAction(t, 71, this);
        if (clusterName != null) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.actionResumeCluster", 300, "Cluster name : " + clusterName);
            }
            cmd.getRequest(t).addParameter(2029, clusterName);
        }
        if (clusterNameList != null) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.actionResumeCluster", 300, "Cluster namelist : " + clusterNameList);
            }
            cmd.getRequest(t).addParameter(2030, clusterNameList);
        }
        rc = cmd.execute(t, listener);
        return rc;
    }

    public int actionSuspendCluster(Trace t, DmActionListener listener, String clusterName, String clusterNameList) {
        return this.actionSuspendCluster(t, listener, clusterName, clusterNameList, 1);
    }

    public int actionSuspendCluster(Trace t, DmActionListener listener, String clusterName, String clusterNameList, int mode) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.actionSuspendCluster", 300, "Cluster suspend for queue manager : " + this.getTreeName(t));
        }
        PCFAction cmd = new PCFAction(t, 72, this);
        if (clusterName != null) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.actionSuspendCluster", 300, "Cluster name : " + clusterName);
            }
            cmd.getRequest(t).addParameter(2029, clusterName);
        }
        if (clusterNameList != null) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.actionSuspendCluster", 300, "Cluster namelist : " + clusterNameList);
            }
            cmd.getRequest(t).addParameter(2030, clusterNameList);
        }
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.actionSuspendCluster", 300, "Option : " + mode);
        }
        cmd.getRequest(t).addParameter(1008, mode);
        rc = cmd.execute(t, listener);
        return rc;
    }

    public int actionReset(Trace t, DmActionListener listener) {
        return this.actionReset(t, listener, 2);
    }

    public int actionReset(Trace t, DmActionListener listener, int action) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.actionReset", 300, "Resetting queue manager " + this.getTreeName(t));
        }
        PCFAction cmd = new PCFAction(t, 92, this);
        rc = cmd.execute(t, listener);
        return rc;
    }

    @Override
    public int actionChange(Trace t, DmActionListener listener, Object job, boolean force) {
        int configRc = 0;
        int qmRc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.actionChange", 300, "Changing queue manager " + this.getTreeName(t));
        }
        if ((configRc = this.processConfigAttributes(t, job, updateGroupsByName)) != 0) {
            this.endUpdate(t, job);
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.actionChange", 300, "Error processing config attributes " + configRc);
            }
            if (listener != null) {
                DmCoreException ex = DmCoreException.create(t, this, 1, configRc, 2);
                listener.dmActionDone(new DmActionEvent(this, configRc, 2, ex));
                configRc = 0;
            }
            return configRc;
        }
        this.refreshConfigAttributes(t);
        PCFAction cmd = new PCFAction(t, 1, this);
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.actionChange", 300, "Force option : " + force);
        }
        if (force) {
            cmd.getRequest(t).addParameter(1005, 1);
        }
        if (!this.appendToPCFRequest(t, job, cmd.getRequest(t))) {
            this.endUpdate(t, job);
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.actionChange", 300, "Config attributes changed - no queue manager attributes to change for " + this.getTitle());
            }
            if (listener != null) {
                listener.dmActionDone(new DmActionEvent(this, qmRc, 0));
            }
            return configRc;
        }
        this.endUpdate(t, job);
        qmRc = cmd.execute(t, listener);
        return qmRc;
    }

    public int actionRefresh(Trace t, DmActionListener listener) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.actionRefresh", 300, "Refreshing queue manager " + this.getTreeName(t));
        }
        PCFAction cmd = new PCFAction(t, 16, this);
        cmd.getRequest(t).addParameter(1078, 4);
        rc = cmd.execute(t, listener);
        return rc;
    }

    public DmCoreException getException(Trace t) {
        return this.exception;
    }

    @Override
    public boolean equals(Object o) {
        Trace t = Trace.getInstance();
        boolean retValue = false;
        if (!(o instanceof DmQueueManager)) {
            if (o instanceof DmObject) {
                int objectType = ((DmObject)o).getObjectType(t);
                if (Trace.isTracing) {
                    t.data(65, "DmQueueManager.equals", 300, "Not comparing a DmQueueManager object type : " + objectType);
                }
            } else if (Trace.isTracing) {
                t.data(65, "DmQueueManager.equals", 300, "Not comparing a DmObject object type");
            }
            return false;
        }
        QueueManagerHandle qmh = ((DmQueueManager)o).getConnectionHandle().getQueueManagerHandle(t);
        if (this.connectionHandle.equals(qmh)) {
            retValue = true;
        }
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.equals", 300, "Comparing " + this.connectionHandle.getQueueManagerName() + " with " + qmh.getQueueManagerName());
        }
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.equals", 300, "Objects are equal : " + retValue);
        }
        return retValue;
    }

    public void notifyListeners(Trace t) {
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.notifyListeners", 300, "Notifying listeners of " + this.getTreeName(t));
        }
        t.eventReceived("DmQueueManager.notifyListeners", 1, t.formatEventListenerData(t, (Object)this, null, "add", this.getTitle(), "true"));
        DmMonitor.notifyAllQueueManagerListeners(t, this, 1, this.exception);
        if (this.connected) {
            DmMonitor.notifyAllQueueManagerListeners(t, this, 103, null);
        }
        CoreServices.getTempQueueManagers(t).remove(this);
        if (!CoreServices.getQueueManagers(t).contains(this)) {
            CoreServices.getQueueManagers(t).add(this);
        }
        PersistQueueManagerHandles.add(t, this.dmConnectionHandle);
        if (this.isVisible(t)) {
            DmMonitor.notifyAllQueueManagerListeners(t, this, 100, null);
        }
    }

    protected void notifyListeners(Trace t, int notifyType, DmCoreException ex, String key) {
        if (notifyType == 1) {
            this.notifyListeners(t);
        } else {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.notifyListeners", 300, "Notification " + DmObjectEvent.getNotifyName(t, notifyType) + " sent to listeners of " + this.getTreeName(t));
            }
            t.eventReceived("DmQueueManager.notifyListeners", 1, t.formatEventListenerData(t, (Object)this, null, DmObjectEvent.getNotifyName(t, notifyType), this.getTreeName(t), "true"));
            if (key.startsWith("ALL")) {
                DmMonitor.notifyAllQueueManagerListeners(t, this, notifyType, ex);
            } else {
                DmMonitor.notifyQueueManagerListener(t, this, notifyType, ex, true);
            }
        }
    }

    @Override
    public void dmObjectAdded(DmObjectEvent event) {
        Trace t = Trace.getInstance();
        DmObject object = (DmObject)event.getSource();
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.dmObjectAdded", 900, String.valueOf(this.getTreeName(t)) + " dmObjectAdded called for " + object.getTitle());
        }
    }

    @Override
    public void dmObjectChanged(DmObjectEvent event) {
        Trace t = Trace.getInstance();
        DmObject object = (DmObject)event.getSource();
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.dmObjectChanged", 900, "Change event for " + object.getTitle());
            t.data(65, "DmQueueManager.dmObjectChanged", 900, String.valueOf(this.getTreeName(t)) + " attribute change - notify all listeners");
        }
        DmMonitor.notifyAllQueueManagerListeners(t, this, 4, null);
    }

    @Override
    public void dmObjectDeleted(DmObjectEvent event) {
        Trace t = Trace.getInstance();
        DmObject object = (DmObject)event.getSource();
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.dmObjectDeleted", 900, String.valueOf(this.getTreeName(t)) + " dmObjectDeleted called for " + object.getTitle());
        }
    }

    @Override
    public void dmRefreshComplete(DmObjectEvent event) {
        Trace t = Trace.getInstance();
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.dmRefreshComplete", 300, String.valueOf(this.getTreeName(t)) + " refresh config attributes");
        }
        this.refreshConfigAttributes(t);
    }

    @Override
    public void dmObjectListDone(DmObjectListEvent event) {
        Trace t = Trace.getInstance();
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.dmObjectListDone", 300, String.valueOf(this.getTreeName(t)) + " dmObjectListDone ignored");
        }
    }

    public void refreshStarted() {
        Trace t = Trace.getInstance();
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.refreshStarted", 300, "Refresh started event for " + this.getTreeName(t));
        }
        t.eventReceived("DmQueueManager.refreshStarted", 1, t.formatEventListenerData(t, (Object)this, (Object)this, DmObjectEvent.getNotifyName(t, 104), this.getTitle(), "true"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshComplete() {
        Trace t = Trace.getInstance();
        if (!this.isConnected() || this.isDisconnecting()) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.refreshComplete", 300, "Event ignored - queue manager " + this.getTreeName(t) + " disconnected");
            }
            return;
        }
        Object object = this.hashLock;
        synchronized (object) {
            for (String o : this.currentListeners.keySet()) {
                try {
                    DmObjectView objectView = this.currentListeners.get(o);
                    if (Trace.isTracing) {
                        t.data(65, "DmQueueManager.refreshComplete", 300, String.valueOf(this.getTreeName(t)) + " notifying refresh to " + objectView.getListener());
                    }
                    objectView.notifyDmObjectListener(t, this, 104, true);
                }
                catch (ClassCastException cce) {
                    if (!Trace.isTracing) continue;
                    t.data(65, "DmQueueManager.refreshComplete", 900, "Unable to notify listener - invalid object\n" + cce);
                }
            }
        }
        if (this.isConnected()) {
            DmMonitor.notifyAllQueueManagerListeners(t, this, 104, null);
        }
    }

    public boolean isApplicationConnectionSupported(Trace t) {
        boolean appConn = false;
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.isApplicationConnectionSupported", 800, "Command level " + this.commandLevel);
        }
        if (this.commandLevel >= 600) {
            appConn = true;
        }
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.isApplicationConnectionSupported", 800, "Application connections supported : " + appConn);
        }
        return appConn;
    }

    protected void notifyAllViews(Trace t, DmObject object, int eventType, boolean force) {
        this.notifyAllViews(t, object, eventType, force, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllViews(Trace t, DmObject object, int eventType, boolean force, DmCoreException ex) {
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.notifyAllViews", 300, String.valueOf(this.getTreeName(t)) + " Notifying all views of " + DmObjectEvent.getNotifyName(t, eventType) + " event to " + object.getTitle());
        }
        Object object2 = this.hashLock;
        synchronized (object2) {
            for (String o : this.currentListeners.keySet()) {
                try {
                    DmObjectView objectView = this.currentListeners.get(o);
                    if (!force && object.getObjectType(t) != objectView.getDmObjectType(t)) continue;
                    objectView.notifyDmObjectListener(t, object, eventType, true, ex);
                }
                catch (ClassCastException cce) {
                    if (!Trace.isTracing) continue;
                    t.data(65, "DmQueueManager.notifyAllViews", 900, "Unable to notify listener - invalid object\n" + cce);
                }
            }
        }
    }

    public boolean isConnecting() {
        return this.connecting;
    }

    public boolean isDisconnecting() {
        return this.disconnecting;
    }

    public int[] getSupportedSubTypes(Trace t, int objectType) {
        return CoreServices.getSupportedSubTypes(t, objectType, this.commandLevel, this.platform);
    }

    public boolean isObjectSupported(Trace t, int objectType, int subType) {
        return CoreServices.isObjectSupported(t, objectType, subType, this.commandLevel, this.platform);
    }

    public boolean isObjectSupported(Trace t, int objectType) {
        return CoreServices.isObjectSupported(t, objectType, -2, this.commandLevel, this.platform);
    }

    public int getStatusType(Trace t, int type, int subType) {
        int retValue = 0;
        HashMap table = null;
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.getStatusType", 300, "Given object type : " + type);
        }
        switch (type) {
            case 25: {
                table = TableFactory.getHashMap(t, "DmChannel", this.commandLevel, this.platform);
                break;
            }
            case 1009: {
                table = TableFactory.getHashMap(t, "DmChannelStatusCurrent", this.commandLevel, this.platform);
                break;
            }
            case 1010: {
                table = TableFactory.getHashMap(t, "DmChannelStatusSaved", this.commandLevel, this.platform);
                break;
            }
            case 115: {
                table = TableFactory.getHashMap(t, "DmCouplingFacility", this.commandLevel, this.platform);
                break;
            }
            case 1019: {
                table = TableFactory.getHashMap(t, "DmCouplingFacilityStatusBackup", this.commandLevel, this.platform);
                break;
            }
            case 1020: {
                table = TableFactory.getHashMap(t, "DmCouplingFacilityStatusConnect", this.commandLevel, this.platform);
                break;
            }
            case 1021: {
                table = TableFactory.getHashMap(t, "DmCouplingFacilityStatusSummary", this.commandLevel, this.platform);
                break;
            }
            case 1028: {
                table = TableFactory.getHashMap(t, "DmCouplingFacilityStatusSMDS", this.commandLevel, this.platform);
                break;
            }
            case 186: {
                table = TableFactory.getHashMap(t, "DmCouplingFacilitySMDS", this.commandLevel, this.platform);
                break;
            }
            case 199: {
                table = TableFactory.getHashMap(t, "DmCouplingFacilitySMDSCONN", this.commandLevel, this.platform);
                break;
            }
            case 97: {
                table = TableFactory.getHashMap(t, "DmListener", this.commandLevel, this.platform);
                break;
            }
            case 98: {
                table = TableFactory.getHashMap(t, "DmListenerStatus", this.commandLevel, this.platform);
                break;
            }
            case 176: {
                table = TableFactory.getHashMap(t, "DmSubscription", this.commandLevel, this.platform);
                break;
            }
            case 182: {
                table = TableFactory.getHashMap(t, "DmSubscriptionStatus", this.commandLevel, this.platform);
                break;
            }
            case 13: {
                if (subType == 2 || subType == 6 || subType == 3) {
                    if (!Trace.isTracing) break;
                    t.data(65, "DmQueueManager.getStatusType", 300, "Queue subtype " + subType + " has no status");
                    break;
                }
                table = TableFactory.getHashMap(t, "DmQueue", this.commandLevel, this.platform);
                break;
            }
            case 1007: {
                table = TableFactory.getHashMap(t, "DmQueueStatusHandle", this.commandLevel, this.platform);
                break;
            }
            case 1008: {
                table = TableFactory.getHashMap(t, "DmQueueStatusQueue", this.commandLevel, this.platform);
                break;
            }
            case 153: {
                table = TableFactory.getHashMap(t, "DmService", this.commandLevel, this.platform);
                break;
            }
            case 154: {
                table = TableFactory.getHashMap(t, "DmServiceStatus", this.commandLevel, this.platform);
                break;
            }
            case 174: {
                table = TableFactory.getHashMap(t, "DmTopic", this.commandLevel, this.platform);
                break;
            }
            case 183: {
                table = TableFactory.getHashMap(t, "DmTopicStatus", this.commandLevel, this.platform);
                break;
            }
            case 1022: {
                table = TableFactory.getHashMap(t, "DmTopicStatusPub", this.commandLevel, this.platform);
                break;
            }
            case 1023: {
                table = TableFactory.getHashMap(t, "DmTopicStatusSub", this.commandLevel, this.platform);
                break;
            }
            case 2: {
                table = this.attributesByType;
                break;
            }
            case 161: {
                table = TableFactory.getHashMap(t, "DmQueueManagerStatus", this.commandLevel, this.platform);
                break;
            }
            case 185: {
                table = TableFactory.getHashMap(t, "DmPubSubStatus", this.commandLevel, this.platform);
                break;
            }
            case 1031: {
                table = TableFactory.getHashMap(t, "DmNHAStatus", this.commandLevel, this.platform);
                break;
            }
            case 1032: {
                table = TableFactory.getHashMap(t, "DmNHAGroupStatus", this.commandLevel, this.platform);
                break;
            }
            case 1027: {
                table = TableFactory.getHashMap(t, "DmTelemetryChannelStatus", this.commandLevel, this.platform);
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(65, "DmQueueManager.getStatusType", 300, "Using default status type");
            }
        }
        if (table != null) {
            retValue = this.getStatusType(t, table, 12001);
        }
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.getStatusType", 300, "Status type is " + retValue + " for object type " + type + "(subtype " + subType + ")");
        }
        return retValue;
    }

    public DmObject updateStatus(Trace t, ArrayList list, int action) {
        int i = 0;
        while (i < list.size()) {
            Object value;
            DmObject object = (DmObject)list.get(i);
            Attr attr1 = object.getAttribute(t, 1232, 0);
            if (attr1 != null) {
                Integer status = (Integer)attr1.getValue(t);
                this.addAttr(t, this.attributesByType, 1232, 0, status);
                if (Trace.isTracing) {
                    t.data(65, "DmQueueManager.updateStatus", 300, "Updating chinit status of " + this.getTreeName(t) + " to " + status);
                }
            }
            if ((attr1 = object.getAttribute(t, 1230, 0)) != null) {
                Integer count = (Integer)attr1.getValue(t);
                this.addAttr(t, this.attributesByType, 1230, 0, count);
                if (Trace.isTracing) {
                    t.data(65, "DmQueueManager.updateStatus", 300, "Updating connection count of " + this.getTreeName(t) + " to " + count);
                }
            }
            if ((attr1 = object.getAttribute(t, 1325, 0)) != null) {
                value = (Integer)attr1.getValue(t);
                this.addAttr(t, this.attributesByType, 1325, 0, value);
                this.standbyPermitted = (Integer)value == 1;
                if (Trace.isTracing) {
                    t.data(65, "DmQueueManager.updateStatus", 300, "Updating permit standby of " + this.getTreeName(t) + " to " + value);
                }
            }
            if ((attr1 = object.getAttribute(t, 1149, 0)) != null) {
                value = (Integer)attr1.getValue(t);
                this.addAttr(t, this.attributesByType, 1149, 0, value);
                if (Trace.isTracing) {
                    t.data(65, "DmQueueManager.updateStatus", 300, "Updating status of " + this.getTreeName(t) + " to " + value);
                }
            }
            if ((attr1 = object.getAttribute(t, 3175, 0)) != null) {
                value = (String)attr1.getValue(t);
                this.addAttr(t, this.attributesByType, 3175, 0, value);
                if (Trace.isTracing) {
                    t.data(65, "DmQueueManager.updateStatus", 300, "Updating start date of " + this.getTreeName(t) + " to " + (String)value);
                }
            }
            if ((attr1 = object.getAttribute(t, 3176, 0)) != null) {
                value = (String)attr1.getValue(t);
                this.addAttr(t, this.attributesByType, 3176, 0, value);
                if (Trace.isTracing) {
                    t.data(65, "DmQueueManager.updateStatus", 300, "Updating start time of " + this.getTreeName(t) + " to " + (String)value);
                }
            }
            if ((attr1 = object.getAttribute(t, 2116, 0)) != null) {
                value = (String)attr1.getValue(t);
                this.addAttr(t, this.attributesByType, 2116, 0, value);
                if (Trace.isTracing) {
                    t.data(65, "DmQueueManager.updateStatus", 300, "Updating installation name of " + this.getTreeName(t) + " to " + (String)value);
                }
            }
            if ((attr1 = object.getAttribute(t, 2115, 0)) != null) {
                value = (String)attr1.getValue(t);
                this.addAttr(t, this.attributesByType, 2115, 0, value);
                if (Trace.isTracing) {
                    t.data(65, "DmQueueManager.updateStatus", 300, "Updating installation description of " + this.getTreeName(t) + " to " + (String)value);
                }
            }
            ++i;
        }
        return this;
    }

    private boolean compareTables(Trace t, Hashtable currentTable, Hashtable copyTable) {
        boolean equal = true;
        if (currentTable == null || copyTable == null) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.compareTables", 900, "Table(s) not created");
            }
            return false;
        }
        Enumeration e = currentTable.keys();
        while (equal && e.hasMoreElements()) {
            AttrKey key = (AttrKey)e.nextElement();
            if (((Attr)currentTable.get(key)).getAttrType().getPCFType() != 1) continue;
            if (copyTable.containsKey(key)) {
                try {
                    String currentValue = ((Attr)currentTable.get(key)).toString(t);
                    String newValue = ((Attr)copyTable.get(key)).toString(t);
                    if (currentValue.equals(newValue)) {
                        copyTable.remove(key);
                        continue;
                    }
                    if (Trace.isTracing) {
                        t.data(65, "DmQueueManager.compareTables", 300, "Attribute " + key.getAttributeID() + "." + key.getRepeatingIndex() + " changed");
                        t.data(65, "DmQueueManager.compareTables", 300, "Old vlaue = " + newValue + ", new value = " + currentValue);
                    }
                    equal = false;
                }
                catch (NullPointerException nullPointerException) {
                    if (!Trace.isTracing) continue;
                    t.data(65, "DmQueueManager.compareTables", 300, "Attribute " + key.getAttributeID() + "." + key.getRepeatingIndex() + " not found");
                }
                continue;
            }
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.compareTables", 300, "New attribute " + key.getAttributeID() + "." + key.getRepeatingIndex() + " found");
            }
            equal = false;
        }
        if (equal && copyTable.size() > 0) {
            equal = false;
        }
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.compareTables", 300, "Tables equal : " + equal);
        }
        return equal;
    }

    public DmCoreException createException(Trace t, int cmd, int rc, int cc) {
        String msg = ConvertReasonCode.getSystemMessage(t, this, cmd, rc, cc);
        String msgId = CommonServices.getSystemMessageId((Trace)t, (int)rc);
        DmCoreException ex = new DmCoreException(t, msg, msgId, rc, cc, 20);
        return ex;
    }

    @Override
    public void dmObjectSummary(DmObjectSummaryEvent event) {
        Trace t = Trace.getInstance();
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.dmObjectSummary", 300, String.valueOf(this.getTreeName(t)) + " dmObjectSummary ignored");
        }
    }

    protected void setConnectNow(Trace t, boolean b) {
        this.connectNow = b;
    }

    protected void setConnected(Trace t, boolean b) {
        this.connected = b;
    }

    protected void setConnecting(Trace t, boolean b) {
        this.connecting = b;
    }

    public void setException(Trace t, DmCoreException e) {
        this.exception = e;
    }

    protected MQQueueManager getMqQueueManager(Trace t) {
        return this.mqQueueManager;
    }

    public AsyncConnectionToQueueManager getConnectionThread(Trace t) {
        return this.connectionThread;
    }

    public DmQueueManager getViaQueueManager(Trace t) {
        if (this.viaQueueManager != null) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.getViaQueueManager", 300, String.valueOf(this.getTitle()) + " is connected via " + this.viaQueueManager.getTreeName(t));
            }
        } else if (Trace.isTracing) {
            t.data(65, "DmQueueManager.getViaQueueManager", 300, String.valueOf(this.getTreeName(t)) + " is not connected via another queue manager");
        }
        return this.viaQueueManager;
    }

    public boolean isUsingViaQueueManager(Trace t) {
        return this.viaQueueManager != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DmQueueManagerHandle> getListOfViaQueueManagers(Trace t) {
        ArrayList<DmQueueManagerHandle> qms = new ArrayList<DmQueueManagerHandle>();
        Object object = this.lockLookup;
        synchronized (object) {
            int j = 0;
            while (j < CoreServices.getQueueManagers(t).size()) {
                DmQueueManager viaQm;
                DmQueueManager qm = CoreServices.getQueueManagers(t).get(j);
                if (qm != null && (viaQm = qm.getViaQueueManager(t)) != null && viaQm.equals(this)) {
                    if (Trace.isTracing) {
                        t.data(65, "DmQueueManager.getListOfViaQueueManagers", 300, String.valueOf(viaQm.getTreeName(t)) + " is connected via this queue manager " + this.getTreeName(t));
                    }
                    qms.add(qm.getConnectionHandle());
                }
                ++j;
            }
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.getListOfViaQueueManagers", 300, "There are " + qms.size() + " queue managers using this queue manager");
            }
        }
        return qms;
    }

    public boolean isCommandServerRunning(Trace t) {
        boolean running = true;
        try {
            this.getPcfMonitorAgent(t).isCommandServerRunning(t);
        }
        catch (MQException mQException) {
            running = false;
        }
        catch (DmCoreException dmCoreException) {
            running = this.isNativeCommandServerRunning(t);
        }
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.isCommandServerRunning", 300, String.valueOf(this.getTreeName(t)) + " command server is running " + running);
        }
        return running;
    }

    private boolean isNativeCommandServerRunning(Trace t) {
        int status;
        boolean running = true;
        if (this.isLocal(t) && (status = NativeCalls.getCommandServesStatus((Trace)t, (String)this.getTitle())) != 2) {
            running = false;
        }
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.isNativeCommandServerRunning", 300, String.valueOf(this.getTreeName(t)) + " command server runnng is " + running);
        }
        return running;
    }

    public AsyncDisconnectionFromQueueManager getDisconnectionThread() {
        return this.disconnectionThread;
    }

    public int[] getValidAuthorities(Trace t) {
        return DmQueueManager.getValidAuthorities(t, this.attributesByType);
    }

    public int[] getValidAuthorities(Trace t, int type) {
        switch (type) {
            case 7: {
                return DmAuthinfo.getValidAuthorities(t);
            }
            case 6: {
                return DmChannel.getValidAuthorities(t);
            }
            case 1014: {
                return DmClientChannel.getValidAuthorities(t);
            }
            case 9: {
                return DmCommInfo.getValidAuthorities(t);
            }
            case 11: {
                return DmListener.getValidAuthorities(t);
            }
            case 2: {
                return DmNamelist.getValidAuthorities(t);
            }
            case 3: {
                return DmProcess.getValidAuthorities(t);
            }
            case 1: {
                return DmQueue.getValidAuthorities(t);
            }
            case 5: {
                return this.getValidAuthorities(t);
            }
            case 1017: {
                return DmRemoteQueueManagerName.getValidAuthorities(t);
            }
            case 12: {
                return DmService.getValidAuthorities(t);
            }
            case 8: {
                return DmTopic.getValidAuthorities(t);
            }
        }
        return new int[0];
    }

    private void getOamInformation(Trace t) {
        block7: {
            PCFMessage[] response = null;
            int[] options = new int[]{1263, 1262};
            PCFMessage command = new PCFMessage(169);
            command.addParameter(1264, options);
            try {
                this.isCommandServerRunning(t);
                response = this.pcfMonitorAgent.send(command);
                if (response.length > 0) {
                    this.oamInterfaceVersion = response[0].getIntParameterValue(1263);
                    int u = response[0].getIntParameterValue(1262);
                    if (u == 1) {
                        this.oamUseridsSupported = true;
                    }
                    this.oamListOfServices = response[0].getStringListParameterValue(3069);
                }
            }
            catch (MQException e) {
                if (Trace.isTracing) {
                    t.data(65, "DmQueueManager.getOamInformation", 900, String.valueOf(this.getTreeName(t)) + " error getting Oam information\n" + (Object)((Object)e));
                }
            }
            catch (IOException e) {
                if (!Trace.isTracing) break block7;
                t.data(65, "DmQueueManager.getOamInformation", 900, String.valueOf(this.getTreeName(t)) + " error getting Oam information\n" + e);
            }
        }
        if (Trace.isTracing) {
            t.data(65, "DmQueueManager.getOamInformation", 300, String.valueOf(this.getTreeName(t)) + " Oam version " + this.oamInterfaceVersion);
            t.data(65, "DmQueueManager.getOamInformation", 300, String.valueOf(this.getTreeName(t)) + " Oam userids supported " + this.oamUseridsSupported);
            t.data(65, "DmQueueManager.getOamInformation", 300, String.valueOf(this.getTreeName(t)) + " Oam services " + this.oamListOfServices);
        }
    }

    public int getOamInterfaceVersion() {
        return this.oamInterfaceVersion;
    }

    public String[] getOamListOfServices() {
        return this.oamListOfServices;
    }

    public boolean isOamUseridsSupported() {
        return this.oamUseridsSupported;
    }

    public int[] getValidCrtAuthorities(Trace t) {
        int[] authorities = null;
        if (this.attributesByType == null) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.getValidCrtAuthorities", 900, "<All> table has not been created");
            }
            return null;
        }
        AttrTypeEnum at = (AttrTypeEnum)DmQueueManager.getAttributeType(t, this.attributesByType, 12004);
        Integer[] listOfAttrs = at.getEnumerationIds(t);
        authorities = new int[listOfAttrs.length];
        int i = 0;
        while (i < listOfAttrs.length) {
            authorities[i] = listOfAttrs[i];
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.getValidCrtAuthorities", 300, "Valid authority is " + authorities[i]);
            }
            ++i;
        }
        return authorities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addObserver(Trace t, DmObjectListener listener, DmObjectFilter filter) {
        String uniqueName = Trace.NO_LISTENER_INFO;
        DmObjectView objectView = null;
        boolean added = false;
        DmObjectView addedView = null;
        objectView = new DmObjectView(t, this, listener, filter, true);
        if (objectView.isActive()) {
            Object object = this.hashLock;
            synchronized (object) {
                uniqueName = this.getUniqueObjectName(listener);
                addedView = this.currentListeners.put(uniqueName, objectView);
            }
            if (addedView == null) {
                added = true;
                if (Trace.isTracing) {
                    String filterString = filter.toString(t);
                    t.data(65, "DmQueueManager.addObserver", 300, String.valueOf(this.getTreeName(t)) + " adding listener for " + uniqueName + ", add status = true" + "\nfilter = " + filterString);
                }
            } else if (Trace.isTracing) {
                t.data(65, "DmQueueManager.addObserver", 900, String.valueOf(this.getTreeName(t)) + " listener already in list for " + uniqueName);
            }
        } else if (Trace.isTracing) {
            t.data(65, "DmQueueManager.addObserver", 900, String.valueOf(this.getTreeName(t)) + " failed to activate view for " + listener);
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteObserver(Trace t, DmObjectListener listener) {
        String uniqueName = Trace.NO_LISTENER_INFO;
        DmObjectView objectView = null;
        boolean retValue = false;
        Object object = this.hashLock;
        synchronized (object) {
            uniqueName = this.getUniqueObjectName(listener);
            objectView = this.currentListeners.remove(uniqueName);
        }
        if (objectView != null) {
            try {
                if (Trace.isTracing) {
                    t.data(65, "DmQueueManager.deleteObserver", 300, String.valueOf(this.getTreeName(t)) + " remove listener is for " + uniqueName + ", and remove option = true");
                }
                objectView.removeListener(t);
                retValue = true;
            }
            catch (ClassCastException classCastException) {
                if (Trace.isTracing) {
                    t.data(65, "DmQueueManager.deleteObserver", 900, "Unable to remove PCF listener - invalid object");
                }
            }
        } else if (Trace.isTracing) {
            t.data(65, "DmQueueManager.deleteObserver", 900, "Invalid view object");
        }
        if (Trace.isTracing) {
            if (retValue) {
                t.data(65, "DmQueueManager.deleteObserver", 300, String.valueOf(this.getTreeName(t)) + " listener removed from table : " + uniqueName);
            } else {
                t.data(65, "DmQueueManager.deleteObserver", 900, String.valueOf(this.getTreeName(t)) + " listener not found in table : " + uniqueName);
            }
        }
        return retValue;
    }

    @Override
    public String getObservableName() {
        return this.getTitle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshObservable(Trace t) {
        this.refresh(t);
        Object object = this.hashLock;
        synchronized (object) {
            for (String o : this.currentListeners.keySet()) {
                DmObjectView view = this.currentListeners.get(o);
                this.refresh(t, view);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshObservable(Trace t, DmObjectListener listener) {
        Object object = this.hashLock;
        synchronized (object) {
            String uniqueName = this.getUniqueObjectName(listener);
            DmObjectView o = this.currentListeners.get(uniqueName);
            this.refresh(t, o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAllObservers(Trace t) {
        Object object = this.hashLock;
        synchronized (object) {
            for (String o : this.currentListeners.keySet()) {
                DmObjectView view = this.currentListeners.get(o);
                this.removeListener(t, view, true);
            }
        }
    }

    private boolean removeListener(Trace t, Object view, boolean remove) {
        String listenerName = Trace.NO_LISTENER_INFO;
        DmObjectView objectView = null;
        DmObjectListener listener = null;
        boolean removed = false;
        if (view != null) {
            try {
                objectView = (DmObjectView)view;
                listener = objectView.getListener();
                if (Trace.isTracing) {
                    listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(listener.hashCode());
                    t.data(65, "DmQueueManager.removeListener", 300, String.valueOf(this.getTreeName(t)) + " remove listener is for " + listenerName + ", and remove option = " + remove);
                }
                objectView.removeListener(t);
                removed = true;
            }
            catch (ClassCastException classCastException) {
                if (Trace.isTracing) {
                    t.data(65, "DmQueueManager.removeListener", 900, "Unable to remove PCF listener - invalid object");
                }
            }
        } else if (Trace.isTracing) {
            t.data(65, "DmQueueManager.removeListener", 900, "Invalid view object");
        }
        if (Trace.isTracing) {
            if (removed) {
                t.data(65, "DmQueueManager.removeListener", 300, String.valueOf(this.getTreeName(t)) + " listener removed from table : " + listenerName);
            } else {
                t.data(65, "DmQueueManager.removeListener", 900, String.valueOf(this.getTreeName(t)) + " listener not found in table : " + listenerName);
            }
        }
        return removed;
    }

    private void setCommandLevelAndPlatformAttrs(Trace t) {
        this.addAttr(t, allAttributesByType, 31, 0, this.commandLevel);
        this.addAttr(t, allAttributesByType, 32, 0, this.platform);
    }

    private void resetQueueManagerName(Trace t) throws DmCoreException {
        try {
            String realName = this.getPcfMonitorAgent(t).getQManagerName();
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.resetQueueManagerName", 300, "Old queue manager name : " + this.name + com.ibm.mq.commonservices.Common.LINE_SEPARATOR + ", new queue manager name : " + realName);
            }
            this.addAttr(t, allAttributesByType, 2015, 0, realName);
            this.setName(t, 2015);
            this.connectionHandle.resetQueueManagerName(realName);
            this.dmConnectionHandle.resetQueueManagerName(t, realName);
            this.treeName = null;
            this.getTreeName(t);
            if (CoreServices.handleAlreadyExists(t, this.dmConnectionHandle)) {
                this.disconnect(t);
                this.exception = new DmCoreException(t, CommonServices.getSystemMessage((Trace)t, (String)CommonServices.getSystemMessageId((Trace)t, (int)10042), (String)this.getTreeName(t)), CommonServices.getSystemMessageId((Trace)t, (int)10042), 10042, 0, 20);
                throw this.exception;
            }
        }
        catch (DmCoreException e) {
            if (Trace.isTracing) {
                t.data(65, "DmQueueManager.resetQueueManagerName", 900, "Error resetting queue manager name : " + e.toString());
            }
            throw e;
        }
    }

    public boolean attemptAutoReconnect(Trace t) {
        boolean attempt = true;
        if (!this.dmConnectionHandle.isAutoReconnect(t) || this.dmConnectionHandle.isUserDisconnect(t) || !this.dmConnectionHandle.isVisible(t) || !this.shouldReconnect()) {
            attempt = false;
        }
        return attempt;
    }

    private boolean shouldReconnect() {
        boolean shouldReconnect = true;
        if (this.connectionError && !DmMonitor.isUserRefresh()) {
            shouldReconnect = false;
        }
        return shouldReconnect;
    }

    public boolean isStandby() {
        return this.standby;
    }

    private void checkReasonCodeForStandby(Trace t, int i) {
        if (i == 2543) {
            this.standby = true;
        }
    }

    public void setStandbyStatus(Trace t, boolean b) {
        this.standby = b;
        if (b) {
            this.setRunningStatus(t, 13);
        }
    }

    public int getRunningStatus() {
        return this.runningStatus;
    }

    public boolean isRunningElsewhere() {
        return this.runningStatus == 14;
    }

    public boolean isStandbyPermitted() {
        return this.standbyPermitted;
    }

    private void checkCommandLevel(Trace t) throws DmCoreException {
        int oldCommandLevel;
        if (!this.ignoreConnectionCheck && (oldCommandLevel = this.connectionHandle.getCommandLevel()) > 0) {
            int newCommandLevel = 0;
            Attr aCommandLevel = this.getAttribute(t, 31, 0);
            if (aCommandLevel != null) {
                newCommandLevel = (Integer)aCommandLevel.getValue(t);
            }
            if (oldCommandLevel != newCommandLevel) {
                int rc;
                String messageId;
                if (Trace.isTracing) {
                    t.data(65, "DmQueueManager.checkCommandLevel", 300, "Previous command level = " + oldCommandLevel + " and new command level = " + newCommandLevel);
                }
                if (oldCommandLevel < newCommandLevel) {
                    messageId = "AMQ4616";
                    rc = 50059;
                } else {
                    messageId = "AMQ4614";
                    rc = 50058;
                }
                String[] inserts = new String[]{this.name, String.valueOf(oldCommandLevel), String.valueOf(newCommandLevel)};
                String message = CommonServices.getSystemMessage((Trace)t, (String)messageId, (String[])inserts);
                DmCoreException ex = new DmCoreException(t, message, messageId, rc, 2, 10);
                throw ex;
            }
        }
    }

    public void reconnectAsynchronously(Trace t) {
        String key = "ALL";
        this.ignoreConnectionCheck = true;
        this.connectAsynchronously(t, (Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getSslCipherSuites() {
        Object object = this.inquireSslCipherSuitesLock;
        synchronized (object) {
            if (!this.sslCipherSuitesReady) {
                this.updateSslCipherSuites();
            }
            while (!this.sslCipherSuitesReady) {
                try {
                    this.inquireSslCipherSuitesLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.sslCipherSuites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSslCipherSuites() {
        final Trace t = Trace.getInstance();
        if (this.sslCipherSuites == null) {
            Object object = this.updateSslCipherSuitesLock;
            synchronized (object) {
                if (this.sslCipherSuites == null) {
                    this.sslCipherSuites = new HashSet<String>();
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                DmQueueManager.this.inquireSslCipherSuites();
                            }
                            catch (Exception e) {
                                t.FFST(67, "DmQueueManager.updateSslCipherSuites", 1, 2195, 0, 0, e.getClass().getName(), e.getMessage(), null, (Throwable)e);
                            }
                        }
                    };
                    Thread internalThread = new Thread(r);
                    internalThread.setName("DmQueueManager.updateSslCipherSuites");
                    internalThread.start();
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void inquireSslCipherSuites() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [17[CATCHBLOCK]], but top level block is 15[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isEnumerationIdValid(Trace t, int attrId, int enumId) {
        boolean fRC = true;
        block0 : switch (attrId) {
            case 247: {
                switch (enumId) {
                    case 1: 
                    case 2: 
                    case 4: {
                        break block0;
                    }
                }
                fRC = false;
                break;
            }
        }
        return fRC;
    }

    public boolean isAMPQSupported(Trace t) {
        Integer value;
        boolean isAMQPSupported = false;
        Attr at = this.getAttribute(t, 265, 0);
        if (at != null && (value = (Integer)at.getValue(t)) != null && value == 1) {
            isAMQPSupported = true;
        }
        return isAMQPSupported;
    }
}

