/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.PCFAction;
import java.util.HashMap;
import org.osgi.framework.Bundle;

public class DmQueue
extends DmObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/objects/DmQueue.java";
    protected static final String DEFAULT_LOCAL = "SYSTEM.DEFAULT.LOCAL.QUEUE";
    protected static final String DEFAULT_REMOTE = "SYSTEM.DEFAULT.REMOTE.QUEUE";
    protected static final String DEFAULT_MODEL = "SYSTEM.DEFAULT.MODEL.QUEUE";
    protected static final String DEFAULT_ALIAS = "SYSTEM.DEFAULT.ALIAS.QUEUE";
    private static HashMap<Integer, AttrType> allAttributesByType = null;

    protected DmQueue(Trace t, String qn) {
        super(qn, 13);
    }

    public static boolean staticInit(Trace t, Bundle bund) {
        allAttributesByType = DmQueue.initAllAttrTypeTable(t, DmQueue.getClassName(DmQueue.class.getName()), allAttributesByType, bund);
        if (allAttributesByType == null) {
            if (Trace.isTracing) {
                t.data(65, "DmQueue.staticInit", 900, "Error loading allAttributesByType table");
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean init(Trace t) {
        this.addAttr(t, this.attributesByType, 2016, 0, this.getTitle());
        return true;
    }

    public static String getAttributeTitle(Trace t, int id) {
        return DmQueue.getAttributeTitle(t, allAttributesByType, id);
    }

    public static AttrType getAttributeType(Trace t, int id) {
        return DmQueue.getAttributeType(t, allAttributesByType, id);
    }

    public static String getAttributeDefaultValue(Trace t, int id) {
        return DmQueue.getAttributeDefaultValue(t, allAttributesByType, id);
    }

    public static int[] getDisplayColumnSequence(Trace t, int[] ids, boolean zOS) {
        return DmQueue.getDisplayColumnSequence(t, allAttributesByType, ids, zOS);
    }

    public static boolean isAttributeRepeating(Trace t, int id) {
        return DmQueue.isAttributeRepeating(t, allAttributesByType, id);
    }

    public static int[] getAllAttributesByType(Trace t) {
        return DmQueue.getAllAttributesByType(t, allAttributesByType);
    }

    @Override
    public String toString(Trace t) {
        return this.getTitle();
    }

    @Override
    public void close(Trace t) {
    }

    public boolean isTemporaryQueue(Trace t) {
        boolean retValue = false;
        Attr attrQueueDefType = this.getAttribute(t, 7, 0);
        Attr attrQueueType = this.getAttribute(t, 20, 0);
        if (attrQueueDefType != null && attrQueueType != null) {
            int defType = (Integer)attrQueueDefType.getValue(t);
            int queueType = (Integer)attrQueueType.getValue(t);
            if (defType == 3 && queueType == 1) {
                retValue = true;
            }
        }
        t.data(65, "DmQueue.isTemporaryQueue", 300, "Queue : " + this.getTitle() + " temporary : " + retValue);
        return retValue;
    }

    public int actionDelete(Trace t, DmActionListener listener) {
        return this.actionDelete(t, listener, new int[1]);
    }

    @Override
    public int actionDelete(Trace t, DmActionListener listener, Object parms) {
        int rc = 0;
        try {
            if (Trace.isTracing) {
                t.data(65, "DmQueue.actionDelete", 300, "Deleting queue " + this.getTitle());
            }
            PCFAction cmd = new PCFAction(t, 12, this);
            cmd.getRequest(t).addParameter(2016, this.getTitle());
            this.addQSGDispToRequest(t, cmd);
            if (parms != null) {
                int queueType = (Integer)((AttrInt)this.getAttribute(t, 20, 0)).getValue(t);
                if (queueType == 1 && ((int[])parms)[0] == 1) {
                    cmd.getRequest(t).addParameter(1007, 1);
                }
                if (this.getQueueManager().getCommandLevel() >= 710 && this.getQueueManager().getPlatform() != 1) {
                    cmd.getRequest(t).addParameter(1398, ((int[])parms)[1]);
                }
            }
            rc = cmd.execute(t, listener, 2);
        }
        catch (ClassCastException classCastException) {
            if (Trace.isTracing) {
                t.data(65, "DmQueue.actionDelete", 900, "Invalid parameter type");
            }
            rc = 50009;
        }
        return rc;
    }

    public int actionClear(Trace t, DmActionListener listener) {
        int rc = 0;
        Attr a = this.getAttribute(t, 20, 0);
        if (a != null) {
            if ((Integer)a.getValue(t) == 1) {
                if (Trace.isTracing) {
                    t.data(65, "DmQueue.actionClear", 300, "Clearing queue " + this.getTitle());
                }
                PCFAction cmd = new PCFAction(t, 9, this);
                cmd.getRequest(t).addParameter(2016, this.getTitle());
                this.addQSGDispForClear(t, cmd);
                rc = cmd.execute(t, listener);
            } else {
                rc = 4007;
            }
        }
        return rc;
    }

    public int actionResetStatistics(Trace t, DmActionListener listener) {
        int rc = 0;
        Attr a = this.getAttribute(t, 20, 0);
        if (a != null) {
            if ((Integer)a.getValue(t) == 1) {
                if (Trace.isTracing) {
                    t.data(65, "DmQueue.actionResetStatistics", 300, "Reset stats for queue " + this.getTitle());
                }
                PCFAction cmd = new PCFAction(t, 17, this);
                cmd.getRequest(t).addParameter(2016, this.getTitle());
                rc = cmd.execute(t, listener);
            } else {
                rc = 4007;
            }
        }
        return rc;
    }

    @Override
    public int actionCreate(Trace t, DmActionListener listener, Object job) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmQueue.actionCreate", 300, "Creating queue " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 10, this);
        cmd.getRequest(t).addParameter(3001, this.getClonedFrom());
        cmd.getRequest(t).addParameter(3002, this.getTitle());
        int type = (Integer)((AttrInt)this.getAttribute(t, 20, 0)).getValue(t);
        cmd.getRequest(t).addParameter(20, type);
        this.mergeNewWithChangesToPCFRequest(t, job, cmd.getRequest(t));
        this.endUpdate(t, job);
        rc = cmd.execute(t, listener);
        return rc;
    }

    @Override
    public int actionChange(Trace t, DmActionListener listener, Object job, boolean force) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmQueue.actionChange", 300, "Updating queue " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 8, this);
        cmd.getRequest(t).addParameter(2016, this.getTitle());
        int type = (Integer)((AttrInt)this.getAttribute(t, 20, 0)).getValue(t);
        cmd.getRequest(t).addParameter(20, type);
        this.addQSGDispToRequest(t, cmd);
        if (Trace.isTracing) {
            t.data(65, "DmQueue.actionChange", 300, "Force option : " + force);
        }
        if (force) {
            cmd.getRequest(t).addParameter(1005, 1);
        }
        this.appendToPCFRequest(t, job, cmd.getRequest(t));
        this.endUpdate(t, job);
        rc = cmd.execute(t, listener);
        return rc;
    }

    @Override
    public boolean isSystemDefault(Trace t) {
        boolean retValue = false;
        int type = (Integer)((AttrInt)this.getAttribute(t, 20, 0)).getValue(t);
        switch (type) {
            case 3: {
                if (!this.getTitle().equals(DEFAULT_ALIAS)) break;
                retValue = true;
                break;
            }
            case 2: {
                if (!this.getTitle().equals(DEFAULT_MODEL)) break;
                retValue = true;
                break;
            }
            case 1: {
                if (!this.getTitle().equals(DEFAULT_LOCAL)) break;
                retValue = true;
                break;
            }
            case 6: {
                if (!this.getTitle().equals(DEFAULT_REMOTE)) break;
                retValue = true;
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(65, "DmQueue.isSystemDefault", 900, "Unknown queue type : " + type + " for " + this.getTitle());
            }
        }
        return retValue;
    }

    public static String getDefaultName(Trace t, int subType) {
        String retValue = null;
        switch (subType) {
            case 3: {
                retValue = DEFAULT_ALIAS;
                break;
            }
            case 2: {
                retValue = DEFAULT_MODEL;
                break;
            }
            case 1: {
                retValue = DEFAULT_LOCAL;
                break;
            }
            case 6: {
                retValue = DEFAULT_REMOTE;
                break;
            }
            default: {
                if (Trace.isTracing) {
                    t.data(65, "DmQueue.getDefaultName", 900, "Unknown Queue sub-type : " + subType);
                }
                retValue = "[not_found]";
            }
        }
        return retValue;
    }

    @Override
    public int[] getMandatoryIds(Trace t) {
        int[] mandatorIds = DmQueue.getMandatoryIds(this.getObjectSubType(t));
        int qsg = this.getObjectQSGDisp(t);
        if (qsg == 2) {
            int[] tempList = DmQueue.getMandatoryIds(this.getObjectSubType(t));
            mandatorIds = new int[tempList.length + 1];
            int i = 0;
            while (i < tempList.length) {
                mandatorIds[i] = tempList[i];
                ++i;
            }
            mandatorIds[tempList.length] = 2039;
        }
        return mandatorIds;
    }

    public static int[] getMandatoryIds(int subType) {
        return new int[]{2016, 20};
    }

    public static int[] getMandatoryIds(int subType, int qsgType) {
        if (qsgType == 2) {
            return new int[]{2016, 20, 2039};
        }
        return DmQueue.getMandatoryIds(subType);
    }

    @Override
    public int getStatusType(Trace t) {
        Integer i;
        int retValue = 2;
        int subType = this.getObjectSubType(t);
        AttrInt attr = (AttrInt)this.getAttribute(t, 63, 0);
        retValue = attr != null ? ((i = (Integer)attr.getValue(t)) == 3 ? 0 : this.getQueueManager().getStatusType(t, 13, subType)) : this.getQueueManager().getStatusType(t, 13, subType);
        return retValue;
    }

    @Override
    public int getObjectSubType(Trace t) {
        int type = -2;
        AttrInt attr = (AttrInt)this.getAttribute(t, 20, 0);
        if (attr != null) {
            type = (Integer)attr.getValue(t);
        }
        return type;
    }

    @Override
    public int[] getObjectSubTypes(Trace t) {
        return this.getObjectSubTypes(t, this.attributesByType, 20);
    }

    protected void addQSGDispForClear(Trace t, PCFAction cmd) {
        int disp = this.getObjectQSGDisp(t);
        if (disp != -99) {
            if (disp == 0 | disp == 1) {
                disp = 4;
            }
            cmd.getRequest(t).addParameter(63, disp);
            if (Trace.isTracing) {
                t.data(65, "DmQueue.addQSGDispForClear", 300, "QSG disp added to clear command for " + this.getTitle());
            }
        }
    }

    @Override
    public void initialize(Trace t) {
        this.setName(t, 2016);
        Attr attr = this.getAttribute(t, 63, 0);
        if (attr != null) {
            attr.setReadWrite(t, false);
        }
        if ((attr = this.getAttribute(t, 2039, 0)) != null) {
            attr.setReadWrite(t, false);
        }
    }

    public static int[] getValidAuthorities(Trace t) {
        return DmQueue.getValidAuthorities(t, allAttributesByType);
    }

    @Override
    public int getNameAttributeId() {
        return 2016;
    }
}

