/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.objects;

import com.ibm.mq.commonservices.CommonServicesException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.NativeCalls;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrKey;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.StanzaKey;
import com.ibm.mq.explorer.core.internal.attrs.UpdateGroup;
import com.ibm.mq.explorer.core.internal.objects.DmMachine;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.TableFactory;
import com.ibm.mq.explorer.core.internal.utils.CoreServices;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class DmObjectWithConfig
extends DmObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/objects/DmObjectWithConfig.java";
    protected HashMap stanzas = null;
    private static final String XCSPRA_DELIMIT_0 = "\n";
    private static final String XCSPRA_DELIMIT_1 = "\u000b";
    private static final String APIEXIT_COMMON_NAME = "ApiExitCommon";
    private static final String APIEXIT_LOCAL_NAME = "ApiExitLocal";
    private static final String APIEXIT_TEMPLATE_NAME = "ApiExitTemplate";
    private boolean alreadyFFSTd = false;

    public DmObjectWithConfig(String name, int type) {
        super(name, type);
    }

    protected static HashMap initConfigTable(Trace t, String name, HashMap hm) {
        if (hm != null) {
            if (Trace.isTracing) {
                t.data(65, "DmObjectWithConfig.initConfigTable", 300, "Config table already initialized");
            }
            return hm;
        }
        hm = TableFactory.getConfigHashMap(t, name);
        if (hm == null) {
            if (Trace.isTracing) {
                t.data(65, "DmObjectWithConfig.initConfigTable", 900, "Error loading Config table for " + name);
            }
            return null;
        }
        return hm;
    }

    public boolean getStanzaAttrs(Trace t, HashMap typeTable, String qmgrName, HashMap updateGroups) {
        if (updateGroups != null) {
            Set keys = updateGroups.keySet();
            if (keys != null) {
                Iterator iter = updateGroups.keySet().iterator();
                block5: while (iter.hasNext()) {
                    int repeatingIndex = 0;
                    String stanzaName = (String)iter.next();
                    UpdateGroup updateGroup = (UpdateGroup)updateGroups.get(stanzaName);
                    String repeatingAttribute = updateGroup.getAttributeName(updateGroup.getPrimaryAttribute());
                    try {
                        String attrs = NativeCalls.getAttrs((Trace)t, (String)qmgrName, (String)stanzaName);
                        String lastAttrs = "";
                        String repeatingValue = this.parseStanzaAttributes(t, typeTable, updateGroup, stanzaName, repeatingIndex, repeatingAttribute, attrs);
                        ++repeatingIndex;
                        while (repeatingValue != null) {
                            attrs = NativeCalls.getRepeatingAttrs((Trace)t, (String)qmgrName, (String)stanzaName, (String)repeatingAttribute, (String)repeatingValue);
                            if (!lastAttrs.equals(attrs)) {
                                lastAttrs = attrs;
                                repeatingValue = this.parseStanzaAttributes(t, typeTable, updateGroup, stanzaName, repeatingIndex, repeatingAttribute, attrs);
                                ++repeatingIndex;
                                continue;
                            }
                            if (this.alreadyFFSTd) continue block5;
                            this.alreadyFFSTd = true;
                            t.FFST(65, "DmObjectWithConfig.getStanzaAttrs", 2, 50014, "Duplicate stanza " + stanzaName + " for " + qmgrName);
                            continue block5;
                        }
                    }
                    catch (CommonServicesException e) {
                        int reason = e.getReasonCode();
                        switch (reason) {
                            case 0: 
                            case 268460388: {
                                break;
                            }
                            default: {
                                if (!Trace.isTracing) continue block5;
                                t.data(65, "DmObjectWithConfig.getStanzaAttrs", 900, "JNI error code " + reason + ", qmgr " + qmgrName + ", stanza = " + stanzaName + ", repeatingIndex = " + repeatingIndex);
                            }
                        }
                    }
                }
            } else {
                t.FFST(65, "DmObjectWithConfig.getStanzaAttrs", 0, 0, 0, 0, "stanzas.keySet() returned null", null, null);
            }
        } else {
            t.FFST(65, "DmObjectWithConfig.getStanzaAttrs", 1, 0, 0, 0, "stanzas is null", null, null);
        }
        return true;
    }

    private String parseStanzaAttributes(Trace t, HashMap typeTable, UpdateGroup updateGroup, String stanzaName, int repeatingIndex, String repeatingAttribute, String attrs) {
        String repeatingValue = null;
        String fid = "DmObjectWithConfig.parseStanzaAttributes";
        String attributeString = null;
        if (attrs != null) {
            this.saveStanzaString(t, stanzaName, repeatingIndex, attrs);
            StringTokenizer st1 = new StringTokenizer(attrs, XCSPRA_DELIMIT_1);
            try {
                if (XCSPRA_DELIMIT_1.indexOf(attrs.charAt(0)) == -1 && st1.hasMoreTokens()) {
                    attributeString = st1.nextToken();
                    StringTokenizer st2 = new StringTokenizer(attributeString, XCSPRA_DELIMIT_0, true);
                    while (st2.hasMoreTokens()) {
                        String key = st2.nextToken();
                        if (!st2.hasMoreTokens()) continue;
                        st2.nextToken();
                        String value = st2.nextToken();
                        if (value.equals(XCSPRA_DELIMIT_0)) {
                            value = "";
                        } else {
                            st2.nextToken();
                        }
                        int parameter = updateGroup.getPseudoPCFId(key);
                        if (parameter != -1) {
                            t.data(65, fid, 300, String.valueOf(this.getTitle()) + " parsed Stanza " + stanzaName + ":" + key + "." + repeatingIndex + " (PseudoPCF ID = " + parameter + ") = " + value);
                            this.addAttr(t, typeTable, parameter, repeatingIndex, this.convert(t, typeTable, parameter, value));
                            this.loadApiExitType(t, parameter, repeatingIndex);
                            if (!key.equals(repeatingAttribute)) continue;
                            repeatingValue = value;
                            continue;
                        }
                        t.data(65, fid, 300, "No attribute matching for " + stanzaName + ":" + key);
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                t.data(65, fid, 900, "NoSuchElementException error for " + stanzaName + ", string=" + attributeString);
            }
        }
        return repeatingValue;
    }

    public void saveStanzaString(Trace t, String stanzaName, int repeatingIndex, String attributeString) {
        if (this.stanzas == null) {
            this.stanzas = new HashMap();
        }
        this.stanzas.put(new StanzaKey(stanzaName, repeatingIndex), attributeString);
        if (Trace.isTracing) {
            t.data(65, "DmObjectWithConfig.saveStanzaString", 300, "Saving stanza, key = " + stanzaName + "." + repeatingIndex + ", value = " + attributeString);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected int processConfigAttributes(Trace t, Object job, HashMap updateGroups) {
        rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmObjectWithConfig.processConfigAttributes", 300, "Processing " + job.toString());
        }
        updateTable = this.createUpdateTable(t, job);
        copyTable = this.getCopyTable(t, job);
        if (updateTable.size() == 0) {
            if (Trace.isTracing) {
                t.data(65, "DmObjectWithConfig.processConfigAttributes", 300, "No config attributes to update");
            }
            return 0;
        }
        if (copyTable.size() != 0) ** GOTO lbl51
        if (Trace.isTracing) {
            t.data(65, "DmObjectWithConfig.processConfigAttributes", 300, "No copy table for job " + job.toString());
        }
        return 0;
lbl-1000:
        // 1 sources

        {
            aKey = this.getNextAction(t, updateTable);
            if (aKey == null) {
                rc = 0;
                break;
            }
            attr = (Attr)updateTable.get(aKey);
            if (attr == null) {
                rc = 50005;
                break;
            }
            switch (attr.getAction(t)) {
                case 1: {
                    tempUpdateTable = this.createTempUpdateTable(t, updateTable, 1);
                    if (tempUpdateTable.size() == 0) {
                        if (!Trace.isTracing) continue block5;
                        t.data(65, "DmObjectWithConfig.processConfigAttributes", 300, "No config attributes to create");
                        break;
                    }
                    rc = this.processCreates(t, updateGroups, tempUpdateTable, copyTable, updateTable, aKey);
                    break;
                }
                case 2: {
                    tempUpdateTable = this.createTempUpdateTable(t, updateTable, 2);
                    if (tempUpdateTable.size() == 0) {
                        if (!Trace.isTracing) continue block5;
                        t.data(65, "DmObjectWithConfig.processConfigAttributes", 300, "No config attributes to change");
                        break;
                    }
                    rc = this.processChanges(t, updateGroups, tempUpdateTable, copyTable, updateTable, aKey);
                    break;
                }
                case 3: {
                    tempUpdateTable = this.createTempUpdateTable(t, updateTable, 3);
                    if (tempUpdateTable.size() == 0) {
                        if (!Trace.isTracing) continue block5;
                        t.data(65, "DmObjectWithConfig.processConfigAttributes", 300, "No config attributes to delete");
                        break;
                    }
                    rc = this.processDeletes(t, updateGroups, tempUpdateTable, copyTable, updateTable, aKey);
                    break;
                }
                default: {
                    if (Trace.isTracing) {
                        t.data(65, "DmObjectWithConfig.processConfigAttributes", 900, "Action error - terminating");
                    }
                    updateTable.clear();
                }
            }
lbl51:
            // 11 sources

            ** while (updateTable.size() > 0)
        }
lbl52:
        // 3 sources

        return rc;
    }

    private int processCreates(Trace t, HashMap updateGroups, Hashtable tempUpdateTable, Hashtable copyTable, Hashtable updateTable, AttrKey aKey) {
        UpdateGroup updateGroup;
        int[] stanzaIds;
        int rc = 0;
        StringBuffer sb = null;
        int repeatingIndex = aKey.getRepeatingIndex();
        String stanzaName = this.findStanzaName(t, updateGroups, aKey.getAttributeID());
        if (Trace.isTracing) {
            t.data(65, "DmObjectWithConfig.processCreates", 300, "Stanza name : " + stanzaName);
        }
        if ((stanzaIds = (updateGroup = (UpdateGroup)updateGroups.get(stanzaName)).getAttributeIDs(t)) == null) {
            if (Trace.isTracing) {
                t.data(65, "DmObjectWithConfig.processCreates", 900, "No attributes in stanza");
            }
            return rc;
        }
        if (Trace.isTracing) {
            t.data(65, "DmObjectWithConfig.processCreates", 300, "Number of attributes in stanza " + stanzaIds.length);
        }
        sb = new StringBuffer();
        int index = 0;
        while (index < stanzaIds.length) {
            Attr newAttr;
            int id = stanzaIds[index];
            if (Trace.isTracing) {
                t.data(65, "DmObjectWithConfig.processCreates", 300, "Looking in temp table for attribute " + id + "." + repeatingIndex);
            }
            if ((newAttr = (Attr)tempUpdateTable.remove(aKey = new AttrKey(id, repeatingIndex))) == null) {
                if (Trace.isTracing) {
                    t.data(65, "DmObjectWithConfig.processCreates", 300, "Attribute " + id + "." + repeatingIndex + " not found");
                }
            } else {
                Object newValue;
                block12: {
                    updateTable.remove(aKey);
                    newValue = newAttr.getValue(t);
                    try {
                        newAttr = (Attr)copyTable.put(aKey, newAttr.clone());
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        if (!Trace.isTracing) break block12;
                        t.data(65, "DmObjectWithConfig.processCreates", 900, "Error cloning attribute " + id + "." + repeatingIndex);
                    }
                }
                if (Trace.isTracing) {
                    t.data(65, "DmObjectWithConfig.processCreates", 300, "Attribute " + id + "." + repeatingIndex);
                    t.data(65, "DmObjectWithConfig.processCreates", 300, "New attribute value = " + newValue);
                }
                sb = sb.append(String.valueOf(updateGroup.getAttributeName(stanzaIds[index])) + XCSPRA_DELIMIT_0 + newValue + XCSPRA_DELIMIT_0);
            }
            ++index;
        }
        rc = this.applyChange(t, stanzaName, sb, 1, repeatingIndex, true);
        return rc;
    }

    /*
     * Unable to fully structure code
     */
    private int processChanges(Trace t, HashMap updateGroups, Hashtable tempUpdateTable, Hashtable copyTable, Hashtable updateTable, AttrKey aKey) {
        rc = 0;
        action = 2;
        sb = null;
        newValue = null;
        oldValue = null;
        repeatingIndex = aKey.getRepeatingIndex();
        stanzaName = this.findStanzaName(t, updateGroups, aKey.getAttributeID());
        if (Trace.isTracing) {
            t.data(65, "DmObjectWithConfig.processChanges", 300, "Stanza name : " + stanzaName);
        }
        updateGroup = (UpdateGroup)updateGroups.get(stanzaName);
        isRepeating = updateGroup.isRepeating();
        stanzaIds = updateGroup.getAttributeIDs(t);
        if (stanzaIds == null) {
            if (Trace.isTracing) {
                t.data(65, "DmObjectWithConfig.processChanges", 900, "No attributes in stanza");
            }
            return rc;
        }
        if (Trace.isTracing) {
            t.data(65, "DmObjectWithConfig.processChanges", 300, "Number of attributes in stanza " + stanzaIds.length);
        }
        sb = new StringBuffer();
        index = 0;
        while (index < stanzaIds.length) {
            block23: {
                block21: {
                    block25: {
                        block24: {
                            block22: {
                                id = stanzaIds[index];
                                if (Trace.isTracing) {
                                    t.data(65, "DmObjectWithConfig.processChanges", 300, "Looking in temp table for attribute " + id + "." + repeatingIndex);
                                }
                                if ((newAttr = (Attr)tempUpdateTable.remove(aKey = new AttrKey(id, repeatingIndex))) != null) break block21;
                                if (Trace.isTracing) {
                                    t.data(65, "DmObjectWithConfig.processChanges", 300, "Attribute " + id + "." + repeatingIndex + " not found in update table");
                                }
                                if ((newAttr = (Attr)copyTable.get(aKey)) != null) break block22;
                                if (Trace.isTracing) {
                                    t.data(65, "DmObjectWithConfig.processChanges", 300, "Attribute " + id + "." + repeatingIndex + " not found in copy table");
                                }
                                break block23;
                            }
                            if (newAttr.getAction(t) != 3) break block24;
                            if (Trace.isTracing) {
                                t.data(65, "DmObjectWithConfig.processChanges", 300, "Attribute " + id + "." + repeatingIndex + " is going to be deleted");
                            }
                            break block23;
                        }
                        if (Trace.isTracing) {
                            t.data(65, "DmObjectWithConfig.processChanges", 300, "Attribute " + id + "." + repeatingIndex + " found in copy table");
                        }
                        if (!newAttr.isDefaultValueUsed(t)) break block25;
                        if (Trace.isTracing) {
                            t.data(65, "DmObjectWithConfig.processChanges", 300, "Attribute " + id + "." + repeatingIndex + " using default value");
                        }
                        break block23;
                    }
                    newValue = newAttr.getValue(t);
                    ** GOTO lbl-1000
                }
                newValue = newAttr.getNewValue(t);
                updateTable.remove(aKey);
                if (newValue.equals("")) {
                    if (Trace.isTracing) {
                        t.data(65, "DmObjectWithConfig.processChanges", 300, "Attribute " + id + "." + repeatingIndex + " will be removed");
                    }
                } else lbl-1000:
                // 2 sources

                {
                    oldAttr = (Attr)copyTable.get(aKey);
                    if (oldAttr == null) {
                        if (!Trace.isTracing) break;
                        t.data(65, "DmObjectWithConfig.processChanges", 300, "Attribute " + id + "." + repeatingIndex + " not found in copy table");
                        break;
                    }
                    oldValue = oldAttr.getValue(t);
                    if (Trace.isTracing) {
                        t.data(65, "DmObjectWithConfig.processChanges", 300, "Attribute " + id + "." + repeatingIndex);
                        t.data(65, "DmObjectWithConfig.processChanges", 300, "Old attribute value = " + oldValue);
                        t.data(65, "DmObjectWithConfig.processChanges", 300, "New attribute value = " + newValue);
                    }
                    if (id == updateGroup.getPrimaryAttribute()) {
                        action = oldValue.equals(newValue) != false ? 2 : 4;
                    }
                    sb = sb.append(String.valueOf(updateGroup.getAttributeName(stanzaIds[index])) + "\n" + newValue + "\n");
                }
            }
            ++index;
        }
        if ((dataAttrKey = this.checkDataAttributeChange(t, stanzaName, updateTable, repeatingIndex)) != null && (attr = (Attr)updateTable.remove(dataAttrKey)) != null) {
            switch (attr.getAction(t)) {
                case 1: {
                    newValue = attr.getValue(t);
                    sb = sb.append("Data\n" + newValue + "\n");
                }
            }
        }
        rc = this.applyChange(t, stanzaName, sb, action, repeatingIndex, isRepeating);
        return rc;
    }

    private int processDeletes(Trace t, HashMap updateGroups, Hashtable tempUpdateTable, Hashtable copyTable, Hashtable updateTable, AttrKey aKey) {
        int rc = 0;
        StringBuffer sb = null;
        int repeatingIndex = aKey.getRepeatingIndex();
        String stanzaName = this.findStanzaName(t, updateGroups, aKey.getAttributeID());
        if (Trace.isTracing) {
            t.data(65, "DmObjectWithConfig.processDeletes", 300, "Stanza name : " + stanzaName);
        }
        UpdateGroup updateGroup = (UpdateGroup)updateGroups.get(stanzaName);
        boolean isRepeating = updateGroup.isRepeating();
        int[] stanzaIds = updateGroup.getAttributeIDs(t);
        if (stanzaIds == null) {
            if (Trace.isTracing) {
                t.data(65, "DmObjectWithConfig.processDeletes", 900, "No attributes in stanza");
            }
            return rc;
        }
        if (Trace.isTracing) {
            t.data(65, "DmObjectWithConfig.processDeletes", 300, "Number of attributes in stanza " + stanzaIds.length);
        }
        sb = new StringBuffer();
        int index = 0;
        while (index < stanzaIds.length) {
            Attr oldAttr;
            int id = stanzaIds[index];
            if (Trace.isTracing) {
                t.data(65, "DmObjectWithConfig.processDeletes", 300, "Looking in temp table for attribute " + id + "." + repeatingIndex);
            }
            if ((oldAttr = (Attr)tempUpdateTable.remove(aKey = new AttrKey(id, repeatingIndex))) == null) {
                if (Trace.isTracing) {
                    t.data(65, "DmObjectWithConfig.processDeletes", 300, "Attribute " + id + "." + repeatingIndex + " not found");
                }
            } else {
                oldAttr = (Attr)copyTable.remove(aKey);
                updateTable.remove(aKey);
                if (oldAttr.isDefaultValueUsed(t)) {
                    if (Trace.isTracing) {
                        t.data(65, "DmObjectWithConfig.processDeletes", 300, "Attribute " + id + "." + repeatingIndex + " default value used");
                    }
                } else {
                    Object oldValue = oldAttr.getValue(t);
                    if (Trace.isTracing) {
                        t.data(65, "DmObjectWithConfig.processDeletes", 300, "Attribute " + id + "." + repeatingIndex);
                        t.data(65, "DmObjectWithConfig.processDeletes", 300, "Value = " + oldValue);
                    }
                    sb = sb.append(String.valueOf(updateGroup.getAttributeName(stanzaIds[index])) + XCSPRA_DELIMIT_0 + oldValue + XCSPRA_DELIMIT_0);
                }
            }
            ++index;
        }
        rc = this.applyChange(t, stanzaName, sb, 3, repeatingIndex, isRepeating);
        return rc;
    }

    private AttrKey getNextAction(Trace t, Hashtable table) {
        int action = -1;
        int actionSequence = 99999;
        AttrKey actionSequenceKey = null;
        Set tableKeys = table.keySet();
        Iterator i = tableKeys.iterator();
        while (i.hasNext()) {
            try {
                AttrKey ak = (AttrKey)i.next();
                int as = ak.getActionSequenceId();
                if (Trace.isTracing) {
                    t.data(65, "DmObjectWithConfig.getNextAction", 300, "Found attribute " + ak.getAttributeID() + "." + ak.getRepeatingIndex() + ", action sequence id " + as);
                }
                if (as >= actionSequence) continue;
                actionSequence = as;
                actionSequenceKey = ak;
            }
            catch (ClassCastException classCastException) {
                if (!Trace.isTracing) break;
                t.data(65, "DmObjectWithConfig.getNextAction", 900, "Table key is not an AttrKey");
                break;
            }
        }
        if (actionSequenceKey != null) {
            Attr attr = (Attr)table.get(actionSequenceKey);
            action = attr.getAction(t);
            if (Trace.isTracing) {
                t.data(65, "DmObjectWithConfig.getNextAction", 300, "Using attribute " + actionSequenceKey.getAttributeID() + "." + actionSequenceKey.getRepeatingIndex() + ", action " + action);
            }
        } else if (Trace.isTracing) {
            t.data(65, "DmObjectWithConfig.getNextAction", 900, "Action not found in table");
        }
        return actionSequenceKey;
    }

    private Hashtable createTempUpdateTable(Trace t, Hashtable updateTable, int action) {
        Hashtable<AttrKey, Attr> tempUpdateTable = new Hashtable<AttrKey, Attr>();
        Set tableKeys = updateTable.keySet();
        for (AttrKey ak : tableKeys) {
            Attr a = (Attr)updateTable.get(ak);
            if (a.getAttrType().getPCFType() != 1 || a.getAction(t) != action) continue;
            if (a.isReadWrite(t)) {
                if (Trace.isTracing) {
                    t.data(65, "DmObjectWithConfig.createTempUpdateTable", 300, "Adding attribute to temp table : id = " + ak.getAttributeID() + "." + ak.getRepeatingIndex() + ", seq id = " + ak.getActionSequenceId());
                }
                a = tempUpdateTable.put(ak, a);
                continue;
            }
            if (!Trace.isTracing) continue;
            t.data(65, "DmObjectWithConfig.createTempUpdateTable", 900, "Attribute " + ak.getAttributeID() + "." + ak.getRepeatingIndex() + " ignored - read-only (seq id = " + ak.getActionSequenceId() + ")");
        }
        return tempUpdateTable;
    }

    private Hashtable createUpdateTable(Trace t, Object job) {
        Hashtable<AttrKey, Attr> updateTable = this.getUpdateTable(t, job);
        Hashtable<AttrKey, Attr> tempUpdateTable = new Hashtable<AttrKey, Attr>();
        Set<AttrKey> tableKeys = updateTable.keySet();
        for (AttrKey ak : tableKeys) {
            Attr a = updateTable.get(ak);
            if (a.getAttrType().getPCFType() != 1) continue;
            if (a.isReadWrite(t)) {
                if (Trace.isTracing) {
                    t.data(65, "DmObjectWithConfig.createUpdateTable", 300, "Adding attribute to temp table : id = " + ak.getAttributeID() + "." + ak.getRepeatingIndex() + ", seq id = " + ak.getActionSequenceId());
                }
                a = tempUpdateTable.put(ak, a);
                continue;
            }
            if (!Trace.isTracing) continue;
            t.data(65, "DmObjectWithConfig.createUpdateTable", 900, "Attribute " + ak.getAttributeID() + "." + ak.getRepeatingIndex() + " ignored - read-only (seq id = " + ak.getActionSequenceId() + ")");
        }
        return tempUpdateTable;
    }

    private String findStanzaName(Trace t, HashMap updateGroups, int id) {
        String retValue = null;
        String stanzaName2 = null;
        UpdateGroup updateGroup = null;
        Set k = updateGroups.keySet();
        block0: for (String stanzaName2 : k) {
            updateGroup = (UpdateGroup)updateGroups.get(stanzaName2);
            int[] num = updateGroup.getAttributeIDs(t);
            int j = 0;
            while (j < num.length) {
                if (num[j] == id) {
                    retValue = stanzaName2;
                    break block0;
                }
                ++j;
            }
        }
        if (retValue != null) {
            if (Trace.isTracing) {
                t.data(65, "DmObjectWithConfig.findStanzaName", 300, "Stanza for attribute " + id + " is " + stanzaName2);
            }
        } else if (Trace.isTracing) {
            t.data(65, "DmObjectWithConfig.findStanzaName", 300, "Stanza for attribute " + id + " not found");
        }
        return retValue;
    }

    /*
     * Unable to fully structure code
     */
    private int applyChange(Trace t, String stanzaName, StringBuffer sb, int action, int repeatingIndex, boolean isRepeating) {
        rc = 0;
        stanzaKey = new StanzaKey(stanzaName, repeatingIndex);
        oldStanza = (String)this.stanzas.get(stanzaKey);
        dmqm = this.getQueueManager();
        qmName = null;
        if (dmqm != null) {
            qmName = this.getQueueManager().getTitle();
            if (Trace.isTracing) {
                t.data(65, "DmObjectWithConfig.applyChange", 300, "Queue manager config change for " + qmName);
            }
        } else if (Trace.isTracing) {
            t.data(65, "DmObjectWithConfig.applyChange", 300, "Machine config change");
        }
        switch (action) {
            case 1: {
                try {
                    if (oldStanza == null || oldStanza.equals("\u000b")) {
                        if (Trace.isTracing) {
                            t.data(65, "DmObjectWithConfig.applyChange", 300, String.valueOf(qmName) + " action=create for " + stanzaName + " with values\n" + sb.toString());
                        }
                        sb = sb.append('\u000b');
                        rc = NativeCalls.createAttrs((Trace)t, (String)qmName, (String)stanzaName, (String)sb.toString());
                        break;
                    }
                    sb.append(oldStanza);
                    if (Trace.isTracing) {
                        t.data(65, "DmObjectWithConfig.applyChange", 300, String.valueOf(qmName) + " action=set for " + stanzaName + " with values\n" + sb.toString() + "\n-----------\n" + oldStanza);
                    }
                    NativeCalls.setAttrs((Trace)t, (String)qmName, (String)stanzaName, (String)oldStanza, (String)sb.toString());
                }
                catch (CommonServicesException e) {
                    rc = e.getReasonCode();
                    if (!Trace.isTracing) break;
                    t.data(65, "DmObjectWithConfig.applyChange", 900, "Error creating config attrs\n" + (Object)e);
                }
                break;
            }
            case 2: {
                if (oldStanza != null) {
                    if (oldStanza.equals(sb.toString())) {
                        if (!Trace.isTracing) break;
                        t.data(65, "DmObjectWithConfig.applyChange", 300, "No change needed - old stanza same as new");
                        break;
                    }
                    if (isRepeating) {
                        try {
                            if (Trace.isTracing) {
                                t.data(65, "DmObjectWithConfig.applyChange", 300, String.valueOf(qmName) + " action=setrep for " + stanzaName + " with values\n" + sb.toString() + "\n-----------\n" + oldStanza);
                            }
                            sb = sb.append('\u000b');
                            NativeCalls.setRepeatingAttrs((Trace)t, (String)qmName, (String)stanzaName, (String)oldStanza, (String)sb.toString());
                        }
                        catch (CommonServicesException e) {
                            rc = e.getReasonCode();
                            if (!Trace.isTracing) break;
                            t.data(65, "DmObjectWithConfig.applyChange", 900, "Error changing config attrs\n" + (Object)e);
                        }
                        break;
                    }
                    if (Trace.isTracing) {
                        t.data(65, "DmObjectWithConfig.applyChange", 300, String.valueOf(qmName) + " action=set for " + stanzaName + " with values\n" + sb.toString() + "\n-----------\n" + oldStanza);
                    }
                    try {
                        if (sb.toString().isEmpty()) {
                            sb = sb.append('\u000b');
                            NativeCalls.deleteRepeatingAttrs((Trace)t, (String)qmName, (String)stanzaName, (String)sb.toString());
                            break;
                        }
                        sb = sb.append('\u000b');
                        NativeCalls.setAttrs((Trace)t, (String)qmName, (String)stanzaName, (String)oldStanza, (String)sb.toString());
                    }
                    catch (CommonServicesException e) {
                        rc = e.getReasonCode();
                        if (!Trace.isTracing) break;
                        t.data(65, "DmObjectWithConfig.applyChange", 900, "Error changing config attrs\n" + (Object)e);
                    }
                    break;
                }
                if (!Trace.isTracing) break;
                t.data(65, "DmObjectWithConfig.applyChange", 900, "Unable to make change - no old stanza for " + stanzaName);
                break;
            }
            case 3: {
                if (Trace.isTracing) {
                    t.data(65, "DmObjectWithConfig.applyChange", 300, String.valueOf(qmName) + " action=del for " + stanzaName + " with values\n" + sb.toString() + "\n-----------\n" + oldStanza);
                }
                try {
                    sb = sb.append('\u000b');
                    NativeCalls.deleteRepeatingAttrs((Trace)t, (String)qmName, (String)stanzaName, (String)sb.toString());
                }
                catch (CommonServicesException e) {
                    rc = e.getReasonCode();
                    if (!Trace.isTracing) break;
                    t.data(65, "DmObjectWithConfig.applyChange", 900, "Error deleting config attrs\n" + (Object)e);
                }
                break;
            }
            case 4: {
                if (oldStanza == null) ** GOTO lbl114
                if (oldStanza.equals(sb.toString())) {
                    if (!Trace.isTracing) break;
                    t.data(65, "DmObjectWithConfig.applyChange", 300, "No change needed - old stanza same as new");
                    break;
                }
                if (Trace.isTracing) {
                    t.data(65, "DmObjectWithConfig.applyChange", 300, String.valueOf(qmName) + " action=del for " + stanzaName + " with values\n" + sb.toString() + "\n-----------\n" + oldStanza);
                }
                try {
                    sb = sb.append('\u000b');
                    NativeCalls.deleteRepeatingAttrs((Trace)t, (String)qmName, (String)stanzaName, (String)oldStanza);
                }
                catch (CommonServicesException e) {
                    rc = e.getReasonCode();
                    if (!Trace.isTracing) ** GOTO lbl103
                    t.data(65, "DmObjectWithConfig.applyChange", 900, "Error deleting config attrs\n" + (Object)e);
                }
lbl103:
                // 3 sources

                try {
                    if (Trace.isTracing) {
                        t.data(65, "DmObjectWithConfig.applyChange", 300, String.valueOf(qmName) + " action=create for " + stanzaName + " with values\n" + sb.toString() + "\n-----------\n" + oldStanza);
                    }
                    sb = sb.append('\u000b');
                    rc = NativeCalls.createAttrs((Trace)t, (String)qmName, (String)stanzaName, (String)sb.toString());
                }
                catch (CommonServicesException e) {
                    rc = e.getReasonCode();
                    if (!Trace.isTracing) break;
                    t.data(65, "DmObjectWithConfig.applyChange", 900, "Error creating config attrs\n" + (Object)e);
                }
                break;
lbl114:
                // 1 sources

                if (!Trace.isTracing) break;
                t.data(65, "DmObjectWithConfig.applyChange", 900, "Unable to recreate - no old stanza");
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(65, "DmObjectWithConfig.applyChange", 300, "Unknown action type " + action);
            }
        }
        this.stanzas.put(stanzaKey, sb.toString());
        return rc;
    }

    private Object convert(Trace t, HashMap typeTable, int id, String value) {
        Object retValue = null;
        AttrType at = null;
        try {
            at = (AttrType)typeTable.get(id);
        }
        catch (Throwable throwable) {
            if (Trace.isTracing) {
                t.data(65, "DmObjectWithConfig.convert", 1000, "Error - tpe table not initialized");
            }
            return retValue;
        }
        int type = at.getAttributeType();
        switch (type) {
            case 1: 
            case 3: 
            case 4: 
            case 11: {
                try {
                    retValue = Integer.valueOf(value);
                }
                catch (NumberFormatException numberFormatException) {
                    retValue = at.getDefaultValue(t);
                    if (!Trace.isTracing) break;
                    t.data(65, "DmObjectWithConfig.convert", 900, "Error - attr value out of range for attr " + this.getTitle() + " using default value instead - " + retValue);
                }
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 23: 
            case 26: {
                retValue = value;
                break;
            }
            case 10: 
            case 12: 
            case 29: {
                try {
                    retValue = Long.valueOf(value);
                }
                catch (NumberFormatException numberFormatException) {
                    retValue = at.getDefaultValue(t);
                    if (!Trace.isTracing) break;
                    t.data(65, "DmObjectWithConfig.convert", 900, "Error - attr value out of range for attr " + this.getTitle() + " using default value instead - " + retValue);
                }
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(65, "DmObjectWithConfig.convert", 900, "Error - unknown attribute type (" + type + ")");
            }
        }
        return retValue;
    }

    protected void loadDefaultAttributeValues(Trace t, HashMap updateGroups) {
        AttrKey ak = null;
        Attr attr = null;
        int id = 0;
        boolean allAttrsDefault = true;
        if (this.attributesByType != null) {
            Set tableKeys = updateGroups.keySet();
            for (String key : tableKeys) {
                UpdateGroup updateGroup = (UpdateGroup)updateGroups.get(key);
                int[] stanzaIds = updateGroup.getAttributeIDs(t);
                if (stanzaIds == null) {
                    if (!Trace.isTracing) continue;
                    t.data(65, "DmObjectWithConfig.loadDefaultAttributeValues", 300, "No attributes in stanza " + updateGroup.getName());
                    continue;
                }
                int indexes = this.getRepeatingIndexes(t, stanzaIds[0]);
                if (Trace.isTracing) {
                    t.data(65, "DmObjectWithConfig.loadDefaultAttributeValues", 300, "Number of attributes in stanza " + updateGroup.getName() + " is " + stanzaIds.length + " for " + this.getTitle());
                }
                int repeatingIndex = 0;
                while (repeatingIndex < indexes) {
                    int index = 0;
                    while (index < stanzaIds.length) {
                        id = stanzaIds[index];
                        ak = new AttrKey(id, repeatingIndex);
                        if (Trace.isTracing) {
                            t.data(65, "DmObjectWithConfig.loadDefaultAttributeValues", 300, "Looking in attribute table for " + id + "." + repeatingIndex);
                        }
                        if ((attr = (Attr)this.attributes.get(ak)) == null) {
                            if (id != 10504) {
                                this.createDefaultAttribute(t, ak);
                                this.loadApiExitType(t, id, repeatingIndex);
                            }
                        } else if (!attr.isDefaultValueUsed(t)) {
                            allAttrsDefault = false;
                        }
                        ++index;
                    }
                    if (allAttrsDefault) {
                        if (Trace.isTracing) {
                            t.data(65, "DmObjectWithConfig.loadDefaultAttributeValues", 300, "Setting group default value for stanza " + updateGroup.getName() + " for " + this.getTitle());
                        }
                        index = 0;
                        while (index < stanzaIds.length) {
                            id = stanzaIds[index];
                            attr = (Attr)this.attributes.get(new AttrKey(id, repeatingIndex));
                            if (attr != null) {
                                attr.setGroupDefaultValueUsed(t, true);
                                if (Trace.isTracing) {
                                    t.data(65, "DmObjectWithConfig.loadDefaultAttributeValues", 300, "Setting group default value for attribute " + id + "." + repeatingIndex);
                                }
                            }
                            ++index;
                        }
                    } else {
                        if (Trace.isTracing) {
                            t.data(65, "DmObjectWithConfig.loadDefaultAttributeValues", 300, "At least one attribute has a defined value in stanza " + updateGroup.getName() + " for repeating index " + repeatingIndex + " for " + this.getTitle());
                        }
                        allAttrsDefault = true;
                    }
                    ++repeatingIndex;
                }
            }
        }
    }

    protected void removeConfigAttributes(Trace t) {
        if (this.attributes != null) {
            int[] attrIds = this.getAllAttributes(t);
            int i = 0;
            while (i < attrIds.length) {
                int repeats = this.getRepeatingIndexes(t, attrIds[i]);
                int j = 0;
                while (j < repeats) {
                    Attr attr = this.getAttribute(t, attrIds[i], j);
                    if (attr != null && attr.getAttrType().getPCFType() == 1) {
                        Object value;
                        if (Trace.isTracing) {
                            t.data(65, "DmObjectWithConfig.removeConfigAttributes", 300, "Found config attr " + attr.getAttributeID() + ":" + attr.getRepeatingIndex());
                        }
                        if ((value = this.attributes.remove(new AttrKey(attrIds[i], j))) != null) {
                            if (Trace.isTracing) {
                                t.data(65, "DmObjectWithConfig.removeConfigAttributes", 300, "Removed " + attr.getAttributeID() + ":" + attr.getRepeatingIndex());
                            }
                        } else if (Trace.isTracing) {
                            t.data(65, "DmObjectWithConfig.removeConfigAttributes", 900, "Error removing " + attr.getAttributeID() + ":" + attr.getRepeatingIndex());
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    protected Hashtable getConfigAttributes(Trace t) {
        Hashtable<AttrKey, Attr> retTable = new Hashtable<AttrKey, Attr>();
        if (this.attributes != null) {
            int[] attrIds = this.getAllAttributes(t);
            int i = 0;
            while (i < attrIds.length) {
                int repeats = this.getRepeatingIndexes(t, attrIds[i]);
                int j = 0;
                while (j < repeats) {
                    Attr attr = this.getAttribute(t, attrIds[i], j);
                    if (attr != null && attr.getAttrType().getPCFType() == 1) {
                        Attr value;
                        if (Trace.isTracing) {
                            t.data(65, "DmObjectWithConfig.getConfigAttributes", 300, "Found config attr " + attr.getAttributeID() + ":" + attr.getRepeatingIndex());
                        }
                        if ((value = retTable.put(new AttrKey(attrIds[i], j), attr)) == null) {
                            if (Trace.isTracing) {
                                t.data(65, "DmObjectWithConfig.getConfigAttributes", 300, "Config attr " + attr.getAttributeID() + ":" + attr.getRepeatingIndex() + " added");
                            }
                        } else if (Trace.isTracing) {
                            t.data(65, "DmObjectWithConfig.getConfigAttributes", 900, "Config attr " + attr.getAttributeID() + ":" + attr.getRepeatingIndex() + " already added");
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return retTable;
    }

    private void loadApiExitType(Trace t, int id, int index) {
        String value = null;
        switch (id) {
            case 10520: {
                if (Trace.isTracing) {
                    t.data(65, "DmObjectWithConfig.loadApiExitType", 300, "Adding attribute " + id + ":" + index);
                }
                value = CoreServices.message.getMessage(t, "COMMON.title");
                this.addAttr(t, this.getAttributesByType(), 10537, index, value, true);
                break;
            }
            case 10141: {
                if (Trace.isTracing) {
                    t.data(65, "DmObjectWithConfig.loadApiExitType", 300, "Adding attribute " + id + ":" + index);
                }
                value = CoreServices.message.getMessage(t, "LOCAL.title");
                this.addAttr(t, this.getAttributesByType(), 10149, index, value, true);
                break;
            }
            case 10525: {
                if (Trace.isTracing) {
                    t.data(65, "DmObjectWithConfig.loadApiExitType", 300, "Adding attribute " + id + ":" + index);
                }
                value = CoreServices.message.getMessage(t, "TEMPLATE.title");
                this.addAttr(t, this.getAttributesByType(), 10538, index, value, true);
            }
        }
    }

    private AttrKey checkDataAttributeChange(Trace t, String stanzaName, Hashtable table, int repeatingIndex) {
        Attr attr;
        boolean dataChange = false;
        AttrKey aKey = null;
        if (stanzaName.equalsIgnoreCase(APIEXIT_COMMON_NAME)) {
            aKey = new AttrKey(10523, repeatingIndex);
        } else if (stanzaName.equalsIgnoreCase(APIEXIT_LOCAL_NAME)) {
            aKey = new AttrKey(10144, repeatingIndex);
        } else if (stanzaName.equalsIgnoreCase(APIEXIT_TEMPLATE_NAME)) {
            aKey = new AttrKey(10528, repeatingIndex);
        }
        if (aKey != null && (attr = (Attr)table.get(aKey)) != null) {
            switch (attr.getAction(t)) {
                case 1: {
                    dataChange = true;
                    break;
                }
                case 3: {
                    dataChange = true;
                }
            }
        }
        if (!dataChange) {
            aKey = null;
        }
        return aKey;
    }

    protected int getMachineCommandLevel(Trace t) {
        return DmMachine.getCommandLevel(t);
    }

    protected int getMachinePlatform(Trace t) {
        return DmMachine.getPlatform(t);
    }

    protected void addMachineAttributes(Trace t, String qm) {
        String s = "";
        s = CoreServices.getMachine(t).getConfigAttribute(t, qm, 10540);
        this.addAttr(t, this.getAttributesByType(), 10540, 0, s);
    }
}

