/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrKey;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.objects.DmArchive;
import com.ibm.mq.explorer.core.internal.objects.DmArchiveTape;
import com.ibm.mq.explorer.core.internal.objects.DmAuthinfo;
import com.ibm.mq.explorer.core.internal.objects.DmAuthorityRecord;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmChannelAuthenticationRecord;
import com.ibm.mq.explorer.core.internal.objects.DmChannelStatusCurrent;
import com.ibm.mq.explorer.core.internal.objects.DmChannelStatusSaved;
import com.ibm.mq.explorer.core.internal.objects.DmClientChannel;
import com.ibm.mq.explorer.core.internal.objects.DmClusterQueue;
import com.ibm.mq.explorer.core.internal.objects.DmClusterQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmClusterTopic;
import com.ibm.mq.explorer.core.internal.objects.DmCommInfo;
import com.ibm.mq.explorer.core.internal.objects.DmCouplingFacility;
import com.ibm.mq.explorer.core.internal.objects.DmCouplingFacilitySMDS;
import com.ibm.mq.explorer.core.internal.objects.DmCouplingFacilitySMDSCONN;
import com.ibm.mq.explorer.core.internal.objects.DmCouplingFacilityStatusBackup;
import com.ibm.mq.explorer.core.internal.objects.DmCouplingFacilityStatusConnect;
import com.ibm.mq.explorer.core.internal.objects.DmCouplingFacilityStatusSMDS;
import com.ibm.mq.explorer.core.internal.objects.DmCouplingFacilityStatusSummary;
import com.ibm.mq.explorer.core.internal.objects.DmDistQueueManagement;
import com.ibm.mq.explorer.core.internal.objects.DmDistQueueManagementListener;
import com.ibm.mq.explorer.core.internal.objects.DmEntityAuthority;
import com.ibm.mq.explorer.core.internal.objects.DmListener;
import com.ibm.mq.explorer.core.internal.objects.DmListenerStatus;
import com.ibm.mq.explorer.core.internal.objects.DmLog;
import com.ibm.mq.explorer.core.internal.objects.DmLogCopy;
import com.ibm.mq.explorer.core.internal.objects.DmLogStatus;
import com.ibm.mq.explorer.core.internal.objects.DmNHAGroupStatus;
import com.ibm.mq.explorer.core.internal.objects.DmNHAStatus;
import com.ibm.mq.explorer.core.internal.objects.DmNamelist;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmProcess;
import com.ibm.mq.explorer.core.internal.objects.DmPubSubStatus;
import com.ibm.mq.explorer.core.internal.objects.DmQSGMember;
import com.ibm.mq.explorer.core.internal.objects.DmQueue;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerConnection;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerConnectionHandle;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerStatus;
import com.ibm.mq.explorer.core.internal.objects.DmQueueStatusHandle;
import com.ibm.mq.explorer.core.internal.objects.DmQueueStatusQueue;
import com.ibm.mq.explorer.core.internal.objects.DmRemoteQueueManagerName;
import com.ibm.mq.explorer.core.internal.objects.DmSecurity;
import com.ibm.mq.explorer.core.internal.objects.DmSecuritySwitch;
import com.ibm.mq.explorer.core.internal.objects.DmService;
import com.ibm.mq.explorer.core.internal.objects.DmServiceStatus;
import com.ibm.mq.explorer.core.internal.objects.DmStorageClass;
import com.ibm.mq.explorer.core.internal.objects.DmSubscription;
import com.ibm.mq.explorer.core.internal.objects.DmSubscriptionStatus;
import com.ibm.mq.explorer.core.internal.objects.DmSystem;
import com.ibm.mq.explorer.core.internal.objects.DmTelemetryChannel;
import com.ibm.mq.explorer.core.internal.objects.DmTelemetryChannelStatus;
import com.ibm.mq.explorer.core.internal.objects.DmTopic;
import com.ibm.mq.explorer.core.internal.objects.DmTopicStatus;
import com.ibm.mq.explorer.core.internal.objects.DmTopicStatusPub;
import com.ibm.mq.explorer.core.internal.objects.DmTopicStatusSub;
import com.ibm.mq.explorer.core.internal.objects.DmUsage;
import com.ibm.mq.explorer.core.internal.objects.DmUsageBufferPool;
import com.ibm.mq.explorer.core.internal.objects.DmUsageDataset;
import com.ibm.mq.explorer.core.internal.objects.DmUsagePageset;
import com.ibm.mq.explorer.core.internal.objects.DmUsageSMDS;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.core.internal.objects.PCFAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;

public class DmObjectFactory {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/objects/DmObjectFactory.java";
    private static HashMap<Integer, IDmObject> plainObjects = new HashMap();
    private static final String PLAIN_OBJECT_NAME = "$PLAIN OBJECT NAME$\t";

    private DmObjectFactory() {
    }

    public static DmObject create(Trace t, DmQueueManager qmgr, int objectType, String name) {
        DmObject object;
        block68: {
            object = null;
            if (Trace.isTracing) {
                t.data(65, "DmObjectFactory.create", 300, "Creating object called " + name + "(type " + objectType + ")");
            }
            switch (objectType) {
                case 114: {
                    object = new DmArchive(t, name);
                    break;
                }
                case 1013: {
                    object = new DmArchiveTape(t, name);
                    break;
                }
                case 83: {
                    object = new DmAuthinfo(t, name);
                    break;
                }
                case 87: {
                    object = new DmAuthorityRecord(t, name);
                    break;
                }
                case 25: {
                    object = new DmChannel(t, name);
                    break;
                }
                case 1005: {
                    object = new DmClientChannel(t, name);
                    break;
                }
                case 1009: {
                    object = new DmChannelStatusCurrent(t, name);
                    break;
                }
                case 1010: {
                    object = new DmChannelStatusSaved(t, name);
                    break;
                }
                case 204: {
                    object = new DmChannelAuthenticationRecord(t, name);
                    break;
                }
                case 70: {
                    object = new DmClusterQueueManager(t, name);
                    break;
                }
                case 1004: {
                    object = new DmClusterQueue(t, name);
                    break;
                }
                case 1024: {
                    object = new DmClusterTopic(t, name);
                    break;
                }
                case 191: {
                    object = new DmCommInfo(t, name);
                    break;
                }
                case 85: {
                    object = new DmQueueManagerConnection(t, name);
                    break;
                }
                case 1006: {
                    object = new DmQueueManagerConnectionHandle(t, name);
                    break;
                }
                case 115: {
                    object = new DmCouplingFacility(t, name);
                    break;
                }
                case 1019: {
                    object = new DmCouplingFacilityStatusBackup(t, name);
                    break;
                }
                case 1020: {
                    object = new DmCouplingFacilityStatusConnect(t, name);
                    break;
                }
                case 1021: {
                    object = new DmCouplingFacilityStatusSummary(t, name);
                    break;
                }
                case 1028: {
                    object = new DmCouplingFacilityStatusSMDS(t, name);
                    break;
                }
                case 186: {
                    object = new DmCouplingFacilitySMDS(t, name);
                    break;
                }
                case 199: {
                    object = new DmCouplingFacilitySMDSCONN(t, name);
                    break;
                }
                case 1000: {
                    object = new DmDistQueueManagement(t, name);
                    break;
                }
                case 1015: {
                    object = new DmDistQueueManagementListener(t, name);
                    break;
                }
                case 88: {
                    object = new DmEntityAuthority(t, name);
                    break;
                }
                case 97: {
                    object = new DmListener(t, name);
                    break;
                }
                case 98: {
                    object = new DmListenerStatus(t, name);
                    break;
                }
                case 120: {
                    object = new DmLog(t, name);
                    break;
                }
                case 1011: {
                    object = new DmLogCopy(t, name);
                    break;
                }
                case 1012: {
                    object = new DmLogStatus(t, name);
                    break;
                }
                case 36: {
                    object = new DmNamelist(t, name);
                    break;
                }
                case 7: {
                    object = new DmProcess(t, name);
                    break;
                }
                case 185: {
                    object = new DmPubSubStatus(t, name);
                    break;
                }
                case 1031: {
                    object = new DmNHAStatus(t, name);
                    break;
                }
                case 1032: {
                    object = new DmNHAGroupStatus(t, name);
                    break;
                }
                case 161: {
                    object = new DmQueueManagerStatus(t, name);
                    break;
                }
                case 13: {
                    object = new DmQueue(t, name);
                    break;
                }
                case 1030: {
                    object = new DmRemoteQueueManagerName(t, name);
                    break;
                }
                case 176: {
                    object = new DmSubscription(t, name);
                    break;
                }
                case 182: {
                    object = new DmSubscriptionStatus(t, name);
                    break;
                }
                case 119: {
                    object = new DmQSGMember(t, name);
                    break;
                }
                case 1007: {
                    object = new DmQueueStatusHandle(t, name);
                    break;
                }
                case 1008: {
                    object = new DmQueueStatusQueue(t, name);
                    break;
                }
                case 121: {
                    object = new DmSecurity(t, name);
                    break;
                }
                case 1014: {
                    object = new DmSecuritySwitch(t, name);
                    break;
                }
                case 153: {
                    object = new DmService(t, name);
                    break;
                }
                case 154: {
                    object = new DmServiceStatus(t, name);
                    break;
                }
                case 122: {
                    object = new DmStorageClass(t, name);
                    break;
                }
                case 123: {
                    object = new DmSystem(t, name);
                    break;
                }
                case 174: {
                    object = new DmTopic(t, name);
                    break;
                }
                case 183: {
                    object = new DmTopicStatus(t, name);
                    break;
                }
                case 1022: {
                    object = new DmTopicStatusPub(t, name);
                    break;
                }
                case 1023: {
                    object = new DmTopicStatusSub(t, name);
                    break;
                }
                case 126: {
                    object = new DmUsage(t, name);
                    break;
                }
                case 1016: {
                    object = new DmUsageBufferPool(t, name);
                    break;
                }
                case 1017: {
                    object = new DmUsageDataset(t, name);
                    break;
                }
                case 1018: {
                    object = new DmUsagePageset(t, name);
                    break;
                }
                case 1029: {
                    object = new DmUsageSMDS(t, name);
                    break;
                }
                case 1026: {
                    object = new DmTelemetryChannel(t, name);
                    break;
                }
                case 1027: {
                    object = new DmTelemetryChannelStatus(t, name);
                    break;
                }
                default: {
                    if (Trace.isTracing) {
                        t.data(65, "DmObjectFactory.create", 900, "Invalid Dm object type : " + objectType);
                    }
                    return null;
                }
            }
            if (object != null && qmgr != null) {
                object.setQueueManager(t, qmgr);
                object.setParent(t, qmgr);
                object.initAttrTypeTable(t, qmgr.getCommandLevel(), qmgr.getPlatform());
                object.initAttrTypeTable(t, qmgr);
                try {
                    if (!name.equals(PLAIN_OBJECT_NAME)) {
                        object.init(t);
                    }
                }
                catch (DmCoreException dmCoreException) {
                    if (!Trace.isTracing) break block68;
                    t.data(65, "DmObjectFactory.create", 900, "Error initialising : " + name);
                }
            }
        }
        return object;
    }

    public static DmObject create(Trace t, DmObject oldObject, String name) {
        DmObject newObject = null;
        DmQueueManager qmgr = oldObject.getQueueManager();
        if (Trace.isTracing) {
            t.data(65, "DmObjectFactory.create", 300, "Owner of " + name + " is " + qmgr.getTitle());
        }
        int objectType = oldObject.getObjectType(t);
        if (Trace.isTracing) {
            t.data(65, "DmObjectFactory.create", 300, "New object type : " + objectType);
        }
        newObject = DmObjectFactory.create(t, qmgr, objectType, name);
        newObject.getAttributesTable(t).clear();
        newObject.setAttributesTable(t, DmObjectFactory.createNewAttributeTable(t, oldObject));
        newObject.addAttr(t, newObject.getAttributesByType(), PCFAction.getPCFNameId(t, objectType), 0, name);
        return newObject;
    }

    private static Hashtable<AttrKey, Attr> createNewAttributeTable(Trace t, DmObject oldObject) {
        Hashtable<AttrKey, Attr> newAttrTable = new Hashtable<AttrKey, Attr>();
        Set<AttrKey> tableKeys = oldObject.getAttributesTable(t).keySet();
        for (AttrKey ak : tableKeys) {
            Attr attr = oldObject.getAttributesTable(t).get(ak);
            AttrType attrType = attr.getAttrType();
            attr.setReadWrite(t, attrType.isReadWrite());
            if (!attr.isReadWrite(t, true) && !oldObject.isMandatoryId(t, ak.getAttributeID())) continue;
            if (Trace.isTracing) {
                t.data(65, "DmObjectFactory.createNewAttributeTable", 300, "Adding attribute id " + ak.getAttributeID() + "." + ak.getRepeatingIndex() + " to new table");
            }
            Attr newAttr = null;
            try {
                newAttr = (Attr)attr.clone();
                newAttrTable.put(ak, newAttr);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                if (!Trace.isTracing) continue;
                t.data(65, "DmObjectFactory.createNewAttributeTable", 900, "Error cloning attribute id " + ak.getAttributeID() + "." + ak.getRepeatingIndex());
            }
        }
        return newAttrTable;
    }

    public static IDmObject createDefault(Trace t, DmQueueManager qmgr, int type, int subType, String name) {
        DmObject dmObject = DmObjectFactory.create(t, qmgr, type, name);
        if (dmObject != null) {
            if (subType != -2) {
                HashMap<Integer, AttrType> table = dmObject.getAttributesByType();
                if (table != null) {
                    dmObject.addAttr(t, table, PCFAction.getPCFTypeId(t, type), 0, subType);
                } else if (Trace.isTracing) {
                    t.data(65, "DmObjectFactory.createDefault", 900, "Error getting attribute type table for " + qmgr.getTitle() + ", type=" + type + ", subtype=" + subType);
                }
            }
            dmObject.initializeWithDefaults(t);
        }
        return dmObject;
    }

    public static IDmObject getPlainObject(Trace t, int type) {
        IDmObject dmObject = plainObjects.get(type);
        if (dmObject == null) {
            dmObject = DmObjectFactory.create(t, null, type, PLAIN_OBJECT_NAME);
            if (dmObject != null) {
                plainObjects.put(type, dmObject);
                if (Trace.isTracing) {
                    t.data(65, "DmObjectFactory.getPlainObject", 300, "Created new plain object name=$PLAIN OBJECT NAME$\t, type=" + type);
                }
            } else if (Trace.isTracing) {
                t.data(65, "DmObjectFactory.getPlainObject", 900, "Error creating plain object name=$PLAIN OBJECT NAME$\t, type=" + type);
            }
        }
        return dmObject;
    }
}

