/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrBoolean;
import com.ibm.mq.explorer.core.internal.attrs.AttrByteArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrIntArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrIntArrayEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrIntArrayEnumRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrJob;
import com.ibm.mq.explorer.core.internal.attrs.AttrKey;
import com.ibm.mq.explorer.core.internal.attrs.AttrLong;
import com.ibm.mq.explorer.core.internal.attrs.AttrString;
import com.ibm.mq.explorer.core.internal.attrs.AttrStringArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeBitEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeBoolean;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeByteArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeDateTime;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeEnumRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthString;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthStringEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthStringEnumRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthStringListItem;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthWMQNameListItem;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeIPAddress;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeIntArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeIntArrayEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeIntArrayEnumRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeLong;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeObject;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeString;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeStringArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeUnsignedInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeWMQName;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.filter.DmObjectResponse;
import com.ibm.mq.explorer.core.internal.filter.IDmObjectResponse;
import com.ibm.mq.explorer.core.internal.objects.DmAuthinfo;
import com.ibm.mq.explorer.core.internal.objects.DmAuthorityRecord;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmChannelAuthenticationRecord;
import com.ibm.mq.explorer.core.internal.objects.DmClientChannel;
import com.ibm.mq.explorer.core.internal.objects.DmCommInfo;
import com.ibm.mq.explorer.core.internal.objects.DmCouplingFacility;
import com.ibm.mq.explorer.core.internal.objects.DmDistQueueManagementListener;
import com.ibm.mq.explorer.core.internal.objects.DmListener;
import com.ibm.mq.explorer.core.internal.objects.DmNamelist;
import com.ibm.mq.explorer.core.internal.objects.DmObjectFactory;
import com.ibm.mq.explorer.core.internal.objects.DmProcess;
import com.ibm.mq.explorer.core.internal.objects.DmQueue;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmRemoteQueueManagerName;
import com.ibm.mq.explorer.core.internal.objects.DmService;
import com.ibm.mq.explorer.core.internal.objects.DmStorageClass;
import com.ibm.mq.explorer.core.internal.objects.DmSubscription;
import com.ibm.mq.explorer.core.internal.objects.DmTelemetryChannel;
import com.ibm.mq.explorer.core.internal.objects.DmTopic;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.core.internal.objects.PCFAction;
import com.ibm.mq.explorer.core.internal.objects.TableFactory;
import com.ibm.mq.explorer.trace.weaving.TraceAspect;
import com.ibm.mq.pcf.PCFConstants;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.PCFParameter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import org.osgi.framework.Bundle;

public abstract class DmObject
implements IDmObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/objects/DmObject.java";
    protected String dmTitle = "[not_defined]";
    protected String name = "[not_defined]";
    protected Hashtable<AttrKey, Attr> attributes = null;
    protected Hashtable<AttrJob, Hashtable<AttrKey, Attr>> copyTables = null;
    protected Hashtable<AttrJob, Hashtable<AttrKey, Attr>> updateTables = null;
    protected HashMap<Integer, AttrType> attributesByType = null;
    protected DmQueueManager queueManager = null;
    protected DmObject parent = null;
    protected ArrayList<IDmObject> listOfStatus = new ArrayList(10);
    private Date lastUpdate = null;
    public static final String NOT_FOUND = "[not_found]";
    public static final String NOT_DEFINED = "[not_defined]";
    private IDmObject clonedFrom = null;
    private boolean trimmedTitle = false;
    public static final int SUBTYPE_NOT_SUPPORTED = -1;
    public static final int TYPE_NOT_SUPPORTED = -3;
    public static final int SUBTYPE_NOT_KNOWN = -2;
    public static final int QSGDISP_NOT_DEFINED = -99;
    public static final int TRPTYPE_NOT_DEFINED = -3;
    public static final int SECITEM_NOT_NEEDED = -1;
    private int objectType = 0;
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_QMGR = 2;
    public static final int TYPE_QUEUE = 13;
    public static final int TYPE_CHANNEL = 25;
    public static final int TYPE_CHLAUTH = 204;
    public static final int TYPE_PROCESS = 7;
    public static final int TYPE_AUTHINFO = 83;
    public static final int TYPE_COMMINFO = 191;
    public static final int TYPE_NAMELIST = 36;
    public static final int TYPE_LISTENER = 97;
    public static final int TYPE_SERVICE = 153;
    public static final int TYPE_COUPLING_FACILITY = 115;
    public static final int TYPE_CF_SMDS = 186;
    public static final int TYPE_CF_SMDSCONN = 199;
    public static final int TYPE_QSG_MEMBER = 119;
    public static final int TYPE_STORAGE_CLASS = 122;
    public static final int TYPE_SUBSCRIPTION = 176;
    public static final int TYPE_SUBSCRIPTION_STATUS = 182;
    public static final int TYPE_QMGR_STATUS = 161;
    public static final int TYPE_SERVICE_STATUS = 154;
    public static final int TYPE_LISTENER_STATUS = 98;
    public static final int TYPE_USAGE = 126;
    public static final int TYPE_SYSTEM = 123;
    public static final int TYPE_LOG = 120;
    public static final int TYPE_ARCHIVE = 114;
    public static final int TYPE_SECURITY = 121;
    public static final int TYPE_CONNECTION = 85;
    public static final int TYPE_CLUSTER_QMGR = 70;
    public static final int TYPE_AUTHORITY_RECORD = 87;
    public static final int TYPE_ENTITY_AUTHORITY = 88;
    public static final int TYPE_TOPIC = 174;
    public static final int TYPE_TOPIC_STATUS = 183;
    public static final int TYPE_PUBSUB_STATUS = 185;
    public static final int TYPE_DIST_QUEUE_MANAGEMENT = 1000;
    public static final int TYPE_MACHINE = 1001;
    public static final int TYPE_QMGR_HANDLE = 1002;
    public static final int TYPE_ERROR_LISTENER = 1003;
    public static final int TYPE_CLUSTER_QUEUE = 1004;
    public static final int TYPE_CLIENT_CHANNEL = 1005;
    public static final int TYPE_CONNECTION_HANDLE = 1006;
    public static final int TYPE_QUEUE_STATUS_HANDLE = 1007;
    public static final int TYPE_QUEUE_STATUS_QUEUE = 1008;
    public static final int TYPE_CHANNEL_STATUS_CURRENT = 1009;
    public static final int TYPE_CHANNEL_STATUS_SAVED = 1010;
    public static final int TYPE_LOG_COPY = 1011;
    public static final int TYPE_LOG_STATUS = 1012;
    public static final int TYPE_ARCHIVE_TAPE = 1013;
    public static final int TYPE_SECURITY_SWITCH = 1014;
    public static final int TYPE_DIST_QUEUE_MANAGEMENT_LISTENER = 1015;
    public static final int TYPE_USAGE_BUFFER_POOL = 1016;
    public static final int TYPE_USAGE_DATASET = 1017;
    public static final int TYPE_USAGE_PAGESET = 1018;
    public static final int TYPE_CF_STATUS_BACKUP = 1019;
    public static final int TYPE_CF_STATUS_CONNECT = 1020;
    public static final int TYPE_CF_STATUS_SUMMARY = 1021;
    public static final int TYPE_TOPIC_STATUS_PUB = 1022;
    public static final int TYPE_TOPIC_STATUS_SUB = 1023;
    public static final int TYPE_CLUSTER_TOPIC = 1024;
    public static final int TYPE_QMGR_HANDLE_INSTANCE = 1025;
    public static final int TYPE_TELEMETRY_CHANNEL = 1026;
    public static final int TYPE_TELEMETRY_CHANNEL_STATUS = 1027;
    public static final int TYPE_CF_STATUS_SMDS = 1028;
    public static final int TYPE_USAGE_SMDS = 1029;
    public static final int TYPE_RQMNAME = 1030;
    public static final int TYPE_NHA_STATUS = 1031;
    public static final int TYPE_NHA_GROUP_STATUS = 1032;
    public static final String SYSTEM_NAME = "SYSTEM.";
    public static final int STATUS_NONE = 0;
    public static final int STATUS_SINGLE = 1;
    public static final int STATUS_MULTI = 2;
    public static final int STATUS_MULTI_TREE = 3;
    public static final String DEFAULT_AUTHINFO_LDAP = "SYSTEM.DEFAULT.AUTHINFO.CRLLDAP";
    public static final String DEFAULT_AUTHINFO_OCSP = "SYSTEM.DEFAULT.AUTHINFO.OCSP";
    public static final String DEFAULT_AUTHINFO_IDPW_OS = "SYSTEM.DEFAULT.AUTHINFO.IDPWOS";
    public static final String DEFAULT_AUTHINFO_IDPW_LDAP = "SYSTEM.DEFAULT.AUTHINFO.IDPWLDAP";
    public static final String DEFAULT_COMMINFO_MULTICAST = "SYSTEM.DEFAULT.COMMINFO.MULTICAST";
    public static final String DEFAULT_CHLAUTH_BLOCKUSER = "SYSTEM.DEF.BLOCKUSER";
    public static final String DEFAULT_CHLAUTH_BLOCKADDR = "*";
    public static final String DEFAULT_CHLAUTH_SSLPEERMAP = "SYSTEM.DEF.SSLPEER";
    public static final String DEFAULT_CHLAUTH_ADDRESSMAP = "SYSTEM.DEF.ADDRESS";
    public static final String DEFAULT_CHLAUTH_USERMAP = "SYSTEM.DEF.USER";
    public static final String DEFAULT_CHLAUTH_QMGRMAP = "SYSTEM.DEF.QMGR";
    public static final String DEFAULT_CLUSRCVR_CHANNEL = "SYSTEM.DEF.CLUSRCVR";
    public static final String DEFAULT_CLUSSDR_CHANNEL = "SYSTEM.DEF.CLUSSDR";
    public static final String DEFAULT_RECEIVER_CHANNEL = "SYSTEM.DEF.RECEIVER";
    public static final String DEFAULT_REQUESTER_CHANNEL = "SYSTEM.DEF.REQUESTER";
    public static final String DEFAULT_SENDER_CHANNEL = "SYSTEM.DEF.SENDER";
    public static final String DEFAULT_SERVER_CHANNEL = "SYSTEM.DEF.SERVER";
    public static final String DEFAULT_SVRCONN_CHANNEL = "SYSTEM.DEF.SVRCONN";
    public static final String DEFAULT_CLNTCONN_CHANNEL = "SYSTEM.DEF.CLNTCONN";
    public static final String DEFAULT_AMQP_CHANNEL = "SYSTEM.DEF.AMQP";
    public static final String DEFAULT_TCP_LISTENER = "SYSTEM.DEFAULT.LISTENER.TCP";
    public static final String DEFAULT_LU62_LISTENER = "SYSTEM.DEFAULT.LISTENER.LU62";
    public static final String DEFAULT_NETBIOS_LISTENER = "SYSTEM.DEFAULT.LISTENER.NETBIOS";
    public static final String DEFAULT_SPX_LISTENER = "SYSTEM.DEFAULT.LISTENER.SPX";
    public static final String DEFAULT_NAMELIST = "SYSTEM.DEFAULT.NAMELIST";
    public static final String DEFAULT_TOPIC = "SYSTEM.DEFAULT.TOPIC";
    public static final String DEFAULT_PROCESS = "SYSTEM.DEFAULT.PROCESS";
    public static final String DEFAULT_LOCAL_QUEUE = "SYSTEM.DEFAULT.LOCAL.QUEUE";
    public static final String DEFAULT_REMOTE_QUEUE = "SYSTEM.DEFAULT.REMOTE.QUEUE";
    public static final String DEFAULT_MODEL_QUEUE = "SYSTEM.DEFAULT.MODEL.QUEUE";
    public static final String DEFAULT_ALIAS_QUEUE = "SYSTEM.DEFAULT.ALIAS.QUEUE";
    public static final String DEFAULT_SERVICE = "SYSTEM.DEFAULT.SERVICE";
    public static final String DEFAULT_STORAGE_CLASS = "SYSTEMST";
    public static final String DEFAULT_SUBSCRIPTION = "SYSTEM.DEFAULT.SUB";
    public static final String DEFAULT_COUPLING_FACILITY = "DEFAULT";
    private static int jobId = 0;
    protected IDmObjectResponse objectResponse = null;

    public abstract void close(Trace var1);

    public DmObject(String _name, int _type) {
        this.name = _name;
        this.dmTitle = _name;
        this.objectType = _type;
        this.attributes = new Hashtable();
        this.copyTables = new Hashtable();
        this.updateTables = new Hashtable();
        this.lastUpdate = new Date();
    }

    protected Attr getAttribute(Trace t, Hashtable<AttrKey, Attr> table, int id, int index) {
        if (table == null) {
            return null;
        }
        return table.get(new AttrKey(id, index));
    }

    @Override
    public Attr getAttribute(Trace t, int id, int index) {
        return this.getAttribute(t, this.attributes, id, index);
    }

    @Override
    public String getAttributeValue(Trace t, int id, int index) {
        String retValue = NOT_FOUND;
        Attr a = this.getAttribute(t, id, index);
        if (a != null) {
            retValue = a.toString(t);
        }
        if (Trace.isTracing) {
            String trcValue = retValue;
            if (TraceAspect.isSensitivePCF((Object)id) && !retValue.equals("") && !retValue.equals(NOT_FOUND)) {
                trcValue = "********";
            }
            t.data(65, "DmObject.getAttributeValue", 300, "Attribute id = " + id + "." + index + ", value = " + trcValue);
        }
        return retValue;
    }

    protected static String getAttributeTitle(Trace t, HashMap<Integer, AttrType> hm, int id) {
        if (hm == null) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.getAttributeTitle", 900, "<All> table for attribute id " + id + " has not been created");
            }
            return null;
        }
        AttrType at = hm.get(id);
        if (at == null) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.getAttributeTitle", 900, "No attribute type in table for attribute id " + id);
            }
            return null;
        }
        String s = at.getDisplayTitle();
        if (Trace.isTracing) {
            t.data(65, "DmObject.getAttributeTitle", 300, "Attribute id = " + id + ", title = " + s);
        }
        return s;
    }

    protected static AttrType getAttributeType(Trace t, HashMap<Integer, AttrType> hm, int id) {
        if (hm == null) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.getAttributeType", 900, "<All> table for attribute id " + id + " has not been created");
            }
            return null;
        }
        AttrType at = hm.get(id);
        if (at == null) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.getAttributeType", 900, "No attribute type in table for attribute id " + id);
            }
            return null;
        }
        int type = at.getAttributeType();
        if (Trace.isTracing) {
            t.data(65, "DmObject.getAttributeType", 300, "Attribute id = " + id + ", type = " + type);
        }
        return at;
    }

    protected static String getAttributeDefaultValue(Trace t, HashMap<Integer, AttrType> hm, int id) {
        if (hm == null) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.getAttributeDefaultValue", 900, "<All> table for attribute id " + id + " has not been created");
            }
            return null;
        }
        AttrType at = hm.get(id);
        if (at == null) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.getAttributeDefaultValue", 900, "No attribute type in table for attribute id " + id);
            }
            return null;
        }
        String s = at.toDefaultString(t);
        if (Trace.isTracing) {
            t.data(65, "DmObject.getAttributeDefaultValue", 300, "Attribute id = " + id + ", value = " + s);
        }
        return s;
    }

    protected static int[] getDisplayColumnSequence(Trace t, HashMap<Integer, AttrType> hm, int[] ids, boolean zOS) {
        int[] retValue = new int[ids.length];
        if (hm == null) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.getDisplayColumnSequence", 900, "<All> table has not been created");
            }
            return null;
        }
        if (Trace.isTracing) {
            if (zOS) {
                t.data(65, "DmObject.getDisplayColumnSequence", 300, "Getting the zOS display column sequence");
            } else {
                t.data(65, "DmObject.getDisplayColumnSequence", 300, "Getting the distributed display column sequence");
            }
        }
        int i = 0;
        while (i < ids.length) {
            AttrType at = hm.get(ids[i]);
            if (at == null) {
                retValue[i] = -1;
                if (Trace.isTracing) {
                    t.data(65, "DmObject.getDisplayColumnSequence", 900, "No attribute type in table for attribute id " + ids[i]);
                }
            } else {
                retValue[i] = zOS ? at.getZosDisplayColumnSequence() : at.getDisplayColumnSequence();
                if (Trace.isTracing) {
                    t.data(65, "DmObject.getDisplayColumnSequence", 300, "Attribute id = " + ids[i] + ", display sequence = " + retValue[i]);
                }
            }
            ++i;
        }
        return retValue;
    }

    protected static boolean isAttributeRepeating(Trace t, HashMap<Integer, AttrType> hm, int id) {
        if (hm == null) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.isAttributeRepeating", 900, "<All> table for attribute id " + id + " has not been created");
            }
            return false;
        }
        AttrType at = hm.get(id);
        if (at == null) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.isAttributeRepeating", 900, "No attribute type in table for attribute id " + id);
            }
            return false;
        }
        boolean repeating = at.isRepeating();
        if (Trace.isTracing) {
            t.data(65, "DmObject.isAttributeRepeating", 300, "Attribute id = " + id + ", repeating = " + Boolean.toString(repeating));
        }
        return repeating;
    }

    @Override
    public int getRepeatingIndexes(Trace t, int id) {
        int index = 1;
        if (this.attributes.size() > 0) {
            Attr a;
            while ((a = this.attributes.get(new AttrKey(id, index))) != null) {
                ++index;
            }
        }
        if (Trace.isTracing) {
            t.data(65, "DmObject.getRepeatingIndexes", 300, "Attribute id = " + id + ", repeating indexes = " + (index - 1));
        }
        return index;
    }

    @Override
    public boolean isEnumerationIdValid(Trace t, int attrId, int enumId) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getKnownAttributes(Trace t) {
        int[] ids = new int[]{};
        int index = 0;
        if (this.attributes.size() > 0) {
            Hashtable<AttrKey, Attr> hashtable = this.attributes;
            synchronized (hashtable) {
                ids = new int[this.getKnownAttributes0(t)];
                Set<AttrKey> k = this.attributes.keySet();
                for (AttrKey ak : k) {
                    if (ak.getRepeatingIndex() != 0) continue;
                    ids[index] = ak.getAttributeID();
                    ++index;
                }
            }
        }
        return ids;
    }

    private int getKnownAttributes0(Trace t) {
        int count = 0;
        if (this.attributes.size() > 0) {
            Set<AttrKey> k = this.attributes.keySet();
            for (AttrKey ak : k) {
                if (ak.getRepeatingIndex() != 0) continue;
                ++count;
            }
        }
        if (Trace.isTracing) {
            t.data(65, "DmObject.getKnownAttributes0", 300, "There are " + count + " unique ids in the attributes table");
        }
        return count;
    }

    @Override
    public int[] getAllAttributes(Trace t) {
        return this.getAllAttributes(t, false);
    }

    public int[] getAllAttributes(Trace t, boolean update) {
        int[] ids = new int[]{};
        ids = this.getKnownAttributes(t);
        return ids;
    }

    protected boolean initAttrTypeTable(Trace t, int commandLevel, int platform) {
        if (Trace.isTracing) {
            t.data(65, "DmObject.initAttrTypeTable", 800, "Loading table " + this.getTitle() + " for version " + commandLevel + " and platform " + platform);
        }
        if (this.attributesByType != null) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.initAttrTypeTable", 300, "AttrType table already initialized");
            }
            return true;
        }
        this.attributesByType = TableFactory.getHashMap(t, DmObject.getClassName(this.getClass().getName()), commandLevel, platform);
        if (this.attributesByType == null) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.initAttrTypeTable", 900, "Error loading attributesByType table");
            }
            return false;
        }
        return true;
    }

    protected void initAttrTypeTable(Trace t, DmQueueManager qmgr) {
    }

    protected static HashMap<Integer, AttrType> initAllAttrTypeTable(Trace t, String name, HashMap<Integer, AttrType> hm, Bundle bund) {
        if (hm != null) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.initAllAttrTypeTable", 300, "allAttributesByType table already initialized");
            }
            return hm;
        }
        hm = TableFactory.getHashMap(t, name, bund);
        if (hm == null) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.initAllAttrTypeTable", 900, "Error loading allAttributesByType table for " + name);
            }
            return null;
        }
        return hm;
    }

    protected void addAttr(Trace t, HashMap<Integer, AttrType> typeTable, PCFParameter p) {
        block8: {
            Object value = "";
            int id = p.getParameter();
            switch (p.getType()) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    value = p.getValue();
                    if (!Trace.isTracing) break;
                    t.data(65, "DmObject.addAttr", 300, "PCF attribute " + p.getParameter() + ", PCF type " + p.getType());
                    break;
                }
                case 23: {
                    Long longValue = (Long)p.getValue();
                    int intValue = longValue.intValue();
                    value = intValue;
                    if (!Trace.isTracing) break;
                    t.data(65, "DmObject.addAttr", 300, "PCF attribute " + p.getParameter() + ", PCF type " + p.getType());
                    break;
                }
                default: {
                    if (Trace.isTracing) {
                        t.data(65, "DmObject.addAttr", 900, "Unsupported PCF type : " + p.getType());
                    }
                    return;
                }
            }
            try {
                this.addAttr(t, typeTable, id, 0, value);
            }
            catch (ClassCastException cce) {
                String idName = PCFConstants.lookupParameter((int)id);
                if (idName == null) {
                    idName = "unknown";
                }
                if (!Trace.isTracing) break block8;
                t.data(65, "DmObject.addAttr", 900, "ClassCastException for attribute id " + id + ".0 (" + cce.getMessage() + ")");
                t.data(65, "DmObject.addAttr", 900, "Attribute " + id + "(" + idName + ") type defined incorrectly. Actual type is " + MQConstants.lookup((int)p.getType(), (String)"MQCFT.*"));
            }
        }
    }

    protected boolean addAttr(Trace t, HashMap<Integer, AttrType> typeTable, int id, int repeatIndex, Object value) {
        return this.addAttr(t, this.attributes, typeTable, id, repeatIndex, value);
    }

    protected boolean addAttr(Trace t, HashMap<Integer, AttrType> typeTable, int id, int repeatIndex, Object value, boolean defaultValue) {
        return this.addAttr(t, this.attributes, typeTable, id, repeatIndex, value, defaultValue);
    }

    private boolean addAttr(Trace t, Hashtable<AttrKey, Attr> attrsTable, HashMap<Integer, AttrType> typeTable, int id, int repeatIndex, Object value) {
        return this.addAttr(t, attrsTable, typeTable, id, repeatIndex, value, false);
    }

    private boolean addAttr(Trace t, Hashtable<AttrKey, Attr> attrsTable, HashMap<Integer, AttrType> typeTable, int id, int repeatIndex, Object value, boolean defaultValue) {
        if (typeTable == null) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.addAttr", 900, "Attribute type table not initialized for " + this.name);
            }
            return false;
        }
        boolean trimString = true;
        Integer attrID = id;
        Object oldValue = null;
        AttrType aType = typeTable.get(attrID);
        if (aType == null) {
            String idName = PCFConstants.lookupParameter((int)id);
            if (idName == null) {
                idName = "unknown";
            }
            if (Trace.isTracing) {
                t.data(65, "DmObject.addAttr", 900, "Attribute id " + id + "(" + idName + ") not found in object type (" + this.objectType + ") table for " + this.name);
            }
            System.out.println("A queue manager has new attributes that are not supported by MQ Explorer. Update MQ Explorer to a version that supports the new attributes. If no update is available, contact IBM Support.");
            return false;
        }
        int type = aType.getAttributeType();
        if (Trace.isTracing) {
            t.data(65, "DmObject.addAttr", 300, "Attribute id " + id + ", attribute type " + type);
        }
        if (value == null) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.addAttr", 900, "Null value given for attribute id " + id + " in type (" + this.objectType + ") table for " + this.name);
            }
            return false;
        }
        AttrKey attrKey = new AttrKey(id, repeatIndex);
        Attr attr = null;
        if ((type == 15 || type == 8 || type == 21) && value instanceof String) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.addAttr", 300, "Resetting String to String []");
            }
            value = ((String)value).startsWith(" ") ? new String[]{} : new String[]{(String)value};
        }
        if (aType instanceof AttrTypeString) {
            trimString = ((AttrTypeString)aType).isTrimmed();
        }
        switch (type) {
            case 1: {
                attr = new AttrInt(t, id, repeatIndex, (Integer)value, (AttrTypeInt)aType, this);
                break;
            }
            case 2: {
                if (trimString) {
                    attr = new AttrString(t, id, repeatIndex, ((String)value).trim(), (AttrTypeString)aType, this);
                    break;
                }
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeString)aType, this);
                break;
            }
            case 6: {
                if (trimString) {
                    attr = new AttrString(t, id, repeatIndex, ((String)value).trim(), (AttrTypeFixedLengthString)aType, this);
                    break;
                }
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeFixedLengthString)aType, this);
                break;
            }
            case 4: {
                attr = new AttrInt(t, id, repeatIndex, (Integer)value, (AttrTypeRange)aType, this);
                break;
            }
            case 29: {
                attr = new AttrLong(t, id, repeatIndex, (Long)value, (AttrTypeLong)aType, this);
                break;
            }
            case 3: {
                attr = new AttrInt(t, id, repeatIndex, (Integer)value, (AttrTypeEnum)aType, this);
                break;
            }
            case 5: {
                if (trimString) {
                    attr = new AttrString(t, id, repeatIndex, ((String)value).trim(), (AttrTypeIPAddress)aType, this);
                    break;
                }
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeIPAddress)aType, this);
                break;
            }
            case 7: {
                if (trimString) {
                    attr = new AttrString(t, id, repeatIndex, ((String)value).trim(), (AttrTypeWMQName)aType, this);
                    break;
                }
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeWMQName)aType, this);
                break;
            }
            case 9: {
                attr = new AttrString(t, id, repeatIndex, ((String)value).trim(), (AttrTypeFixedLengthStringEnum)aType, this);
                break;
            }
            case 11: {
                attr = new AttrInt(t, id, repeatIndex, (Integer)value, (AttrTypeEnumRange)aType, this);
                break;
            }
            case 12: {
                attr = new AttrLong(t, id, repeatIndex, Long.parseLong(((String)value).trim()), (AttrTypeLong)aType, this);
                break;
            }
            case 10: {
                long l = (long)((Integer)value).intValue() & 0xFFFFFFFFL;
                attr = new AttrLong(t, id, repeatIndex, l, (AttrTypeUnsignedInt)aType, this);
                break;
            }
            case 13: {
                if (trimString) {
                    attr = new AttrString(t, id, repeatIndex, ((String)value).trim(), (AttrTypeFixedLengthStringEnumRange)aType, this);
                    break;
                }
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeFixedLengthStringEnumRange)aType, this);
                break;
            }
            case 14: {
                attr = new AttrIntArray(t, id, repeatIndex, (int[])value, (AttrTypeIntArray)aType, this);
                break;
            }
            case 18: {
                attr = new AttrIntArrayEnum(t, id, repeatIndex, (int[])value, (AttrTypeIntArrayEnum)aType, (IDmObject)this);
                break;
            }
            case 22: {
                attr = new AttrIntArrayEnumRange(t, id, repeatIndex, (int[])value, (AttrTypeIntArrayEnumRange)aType, (IDmObject)this);
                break;
            }
            case 15: {
                attr = new AttrStringArray(t, id, repeatIndex, value, (AttrTypeStringArray)aType, this);
                break;
            }
            case 8: {
                attr = new AttrStringArray(t, id, repeatIndex, value, (AttrTypeFixedLengthStringListItem)aType, this);
                break;
            }
            case 21: {
                attr = new AttrStringArray(t, id, repeatIndex, value, (AttrTypeFixedLengthWMQNameListItem)aType, this);
                break;
            }
            case 16: {
                attr = new AttrByteArray(t, id, repeatIndex, (byte[])value, (AttrTypeByteArray)aType, this);
                break;
            }
            case 19: {
                attr = new AttrByteArray(t, id, repeatIndex, (byte[])value, (AttrTypeByteArray)aType, this);
                break;
            }
            case 20: {
                attr = new AttrInt(t, id, repeatIndex, (Integer)value, (AttrTypeBitEnum)aType, this);
                break;
            }
            case 23: {
                if (trimString) {
                    attr = new AttrString(t, id, repeatIndex, ((String)value).trim(), (AttrTypeDateTime)aType, this);
                    break;
                }
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeDateTime)aType, this);
                break;
            }
            case 25: {
                attr = new AttrBoolean(t, id, repeatIndex, (Boolean)value, (AttrTypeBoolean)aType, this);
                break;
            }
            case 26: {
                if (trimString) {
                    attr = new AttrString(t, id, repeatIndex, ((String)value).trim(), (AttrTypeObject)aType, this);
                    break;
                }
                attr = new AttrString(t, id, repeatIndex, (String)value, (AttrTypeObject)aType, this);
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(65, "DmObject.addAttr", 900, "Error - unknown attribute type (" + aType.getAttributeType() + ")");
            }
        }
        if (attr != null) {
            oldValue = attrsTable.put(attrKey, attr);
            if (defaultValue) {
                attr.setDefaultValueUsed(t, true);
            }
        }
        if (Trace.isTracing && oldValue != null && !((Attr)oldValue).toString(t).equals(value)) {
            String trcValue = value.toString();
            if (TraceAspect.isSensitivePCF((Object)id) && !value.equals("")) {
                trcValue = "********";
            }
            t.data(65, "DmObject.addAttr", 300, "Updating attribute " + id + "." + repeatIndex + " with value = " + trcValue);
        }
        return true;
    }

    protected static void addAttrByType(Trace t, HashMap<Integer, AttrType> table, int i, AttrType a) {
        AttrType oldValue = table.put(i, a);
        if (oldValue != null && Trace.isTracing) {
            t.data(65, "DmObject.addAttrByType", 300, "Replacing attr type for key = " + i);
        }
    }

    @Override
    public String getTitle() {
        if (!this.trimmedTitle) {
            Trace t = Trace.getInstance();
            this.name = this.getObjectResponse(t).trimTitle(t, this.name);
            this.trimmedTitle = true;
        }
        return this.name;
    }

    public String getDmTitle() {
        return this.dmTitle.trim();
    }

    public void setName(Trace t, int id) {
        this.name = this.getAttributeValue(t, id, 0);
        if (this.name.equals(NOT_FOUND)) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.setName", 900, "Error setting name of " + this.dmTitle + ", attribute " + id + " not found");
            }
            this.name = this.dmTitle;
        }
    }

    @Override
    public void initialize(Trace t) {
        this.name = this.dmTitle;
    }

    @Override
    public void initializeWithDefaults(Trace t) {
        Set<Integer> tableKeys = this.attributesByType.keySet();
        for (Integer key : tableKeys) {
            AttrType at = this.attributesByType.get(key);
            Object value = at.getDefaultValue(t);
            if (value == null) continue;
            this.addAttr(t, this.attributesByType, key, 0, value);
        }
    }

    protected static String getClassName(String className) {
        if (className.lastIndexOf(46) > 0) {
            return className.substring(className.lastIndexOf(46) + 1);
        }
        return className;
    }

    @Override
    public DmQueueManager getQueueManager() {
        return this.queueManager;
    }

    public DmObject getParent() {
        return this.parent;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    protected HashMap<Integer, AttrType> getAttributesByType() {
        return this.attributesByType;
    }

    protected static int[] getAllAttributesByType(Trace t, HashMap<Integer, AttrType> hm) {
        int[] ids = new int[]{};
        int index = 0;
        if (hm != null && hm.size() > 0) {
            ids = new int[hm.size()];
            Set<Integer> k = hm.keySet();
            Iterator<Integer> i = k.iterator();
            while (i.hasNext()) {
                ids[index] = i.next();
                ++index;
            }
        }
        return ids;
    }

    @Override
    public void debug(Trace t) {
        Set<AttrKey> s = this.attributes.keySet();
        Iterator<AttrKey> i = s.iterator();
        while (i.hasNext()) {
            Attr a = this.attributes.get(i.next());
            a.debug(t);
        }
    }

    public void mergeAttrFromPCFResponse(Trace t, PCFMessage pcfMessage) {
        if (Trace.isTracing) {
            t.data(65, "DmObject.mergeAttrFromPCFResponse", 300, "Retrieved " + pcfMessage.getParameterCount() + " attributes for " + this.getTitle());
        }
        Enumeration e = pcfMessage.getParameters();
        while (e.hasMoreElements()) {
            PCFParameter p = (PCFParameter)e.nextElement();
            Attr attr = this.getAttribute(t, p.getParameter(), 0);
            if (attr == null) {
                if (Trace.isTracing) {
                    t.data(65, "DmObject.mergeAttrFromPCFResponse", 300, "Merge attribute " + p.getParameter() + ".0 for " + this.getTitle());
                }
                this.addAttr(t, this.attributesByType, p);
                continue;
            }
            if (!Trace.isTracing) continue;
            t.data(65, "DmObject.mergeAttrFromPCFResponse", 300, "Merge ignored for attribute " + p.getParameter() + ".0 for " + this.getTitle());
        }
    }

    public synchronized void addAttrFromPCFResponse(Trace t, PCFMessage pcfMessage) {
        if (Trace.isTracing) {
            t.data(65, "DmObject.addAttrFromPCFResponse", 300, "Retrieved " + pcfMessage.getParameterCount() + " attributes for " + this.getTitle());
        }
        Enumeration e = pcfMessage.getParameters();
        while (e.hasMoreElements()) {
            PCFParameter p = (PCFParameter)e.nextElement();
            this.addAttr(t, this.attributesByType, p);
        }
    }

    protected void addAttrFromPCFResponse(PCFMessage pcfMessage) {
        Trace t = Trace.getInstance();
        this.addAttrFromPCFResponse(t, pcfMessage);
    }

    @Override
    public boolean setAttributeValue(Trace t, Object job, int id, int index, Object value) {
        return this.setAttributeValue(t, job, id, index, value, false);
    }

    public boolean setAttributeValue(Trace t, Object job, int id, int index, Object value, boolean create) {
        boolean retValue = false;
        Attr a = this.getAttribute(t, id, index);
        if (a == null) {
            if (create) {
                Attr aNew = this.createAttribute(t, job, id, index, value);
                if (aNew != null) {
                    retValue = true;
                }
                return retValue;
            }
            if (Trace.isTracing) {
                t.data(65, "DmObject.setAttributeValue", 900, "Attribute " + id + "." + index + " not in current table for " + this.getTitle());
            }
            return retValue;
        }
        if (a.isDefaultValueUsed(t)) {
            Attr aNew = this.createAttribute(t, job, id, index, value);
            if (aNew != null) {
                retValue = true;
            }
            return retValue;
        }
        Hashtable<AttrKey, Attr> table = this.getUpdateTable(t, job);
        Attr aClone = null;
        try {
            aClone = (Attr)a.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.setAttributeValue", 900, "Attribute " + id + "." + index + " cannot be cloned for " + this.getTitle());
            }
            return false;
        }
        boolean valid = aClone.setNewValue(t, value);
        if (!valid) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.setAttributeValue", 300, "Attribute " + id + "." + index + ", invalid new value = " + value.toString());
            }
            return false;
        }
        aClone.setAction(t, 2);
        AttrKey key = new AttrKey(id, index);
        key.setActionSequenceId(this.getJobSequenceId(t, job));
        table.put(key, aClone);
        if (Trace.isTracing) {
            String trcValue = value.toString();
            if (TraceAspect.isSensitivePCF((Object)id) && !value.equals("")) {
                trcValue = "********";
            }
            t.data(65, "DmObject.setAttributeValue", 300, "Job action sequence id = " + key.getActionSequenceId() + ", attribute = " + id + "." + index + ", new value = " + trcValue);
        }
        this.updateJobSequenceId(t, job);
        return true;
    }

    @Override
    public Object beginUpdate(Trace t) {
        int nextJobId = this.getNextJobId(t);
        AttrJob job = new AttrJob(nextJobId);
        if (Trace.isTracing) {
            t.data(65, "DmObject.beginUpdate", 300, "Creating new job " + nextJobId + ", for " + this.name);
        }
        this.updateTables.put(job, new Hashtable());
        Hashtable copy = (Hashtable)this.attributes.clone();
        this.copyTables.put(job, copy);
        return job;
    }

    @Override
    public void endUpdate(Trace t, Object job) {
        Hashtable<AttrKey, Attr> table = this.updateTables.remove(job);
        if (table != null) {
            table.clear();
        }
        if ((table = this.copyTables.remove(job)) != null) {
            table.clear();
        }
    }

    protected Hashtable<AttrKey, Attr> getUpdateTable(Trace t, Object job) {
        Hashtable<AttrKey, Attr> table = this.updateTables.get(job);
        return table;
    }

    protected Hashtable<AttrKey, Attr> getCopyTable(Trace t, Object job) {
        Hashtable<AttrKey, Attr> table = this.copyTables.get(job);
        return table;
    }

    protected boolean mergeNewWithChangesToPCFRequest(Trace t, Object job, PCFMessage request) {
        boolean retValue = false;
        Hashtable<AttrKey, Attr> updateTable = this.getUpdateTable(t, job);
        Set<AttrKey> keys = this.attributes.keySet();
        for (AttrKey ak : keys) {
            Attr a;
            Attr currentAttr = this.attributes.get(ak);
            int id = ak.getAttributeID();
            AttrType at = currentAttr.getAttrType();
            if (at.isPseudoPCF()) {
                if (!Trace.isTracing) continue;
                t.data(65, "DmObject.mergeNewWithChangesToPCFRequest", 300, "Attribute " + id + "." + ak.getRepeatingIndex() + " is pseudo - update ignored");
                continue;
            }
            if (!currentAttr.isReadWrite(t, true)) {
                if (!Trace.isTracing) continue;
                t.data(65, "DmObject.mergeNewWithChangesToPCFRequest", 300, "Attribute " + id + "." + ak.getRepeatingIndex() + " is read only - update ignored");
                continue;
            }
            Attr changedAttr = updateTable.get(ak);
            retValue = changedAttr != null ? this.appendToPCFRequest(t, id, at, updateTable, request, true) : ((a = this.clonedFrom.getAttribute(t, id, 0)) != null && !currentAttr.getValue(t).equals(a.getValue(t)) ? this.appendToPCFRequest(t, id, at, this.attributes, request, false) : (a.getAttributeID() == 63 ? this.appendToPCFRequest(t, id, at, this.attributes, request, false) : true));
            if (!retValue) break;
        }
        return retValue;
    }

    protected boolean appendToPCFRequest(Trace t, Object job, PCFMessage request) {
        boolean retValue = false;
        Hashtable<AttrKey, Attr> table = this.getUpdateTable(t, job);
        if (table.size() == 0) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.appendToPCFRequest", 300, "No attributes to update");
            }
            return false;
        }
        Set<AttrKey> k = table.keySet();
        for (AttrKey ak : k) {
            Attr attr = table.get(ak);
            int id = ak.getAttributeID();
            AttrType at = attr.getAttrType();
            if (at.isPseudoPCF()) {
                if (!Trace.isTracing) continue;
                t.data(65, "DmObject.appendToPCFRequest", 300, "Attribute " + id + "." + ak.getRepeatingIndex() + " is pseudo - update ignored");
                continue;
            }
            retValue = attr.getAction(t) == 2 ? this.appendToPCFRequest(t, id, at, table, request, true) : this.appendToPCFRequest(t, id, at, table, request, false);
            if (!retValue) break;
        }
        return retValue;
    }

    private boolean appendToPCFRequest(Trace t, int id, AttrType at, Hashtable<AttrKey, Attr> table, PCFMessage request, boolean change) {
        int iValue = 0;
        long lValue = 0L;
        String sValue = null;
        ArrayList arrayList = null;
        String[] slValue = null;
        ByteBuffer byteBufferValue = null;
        switch (at.getAttributeType()) {
            case 1: 
            case 3: 
            case 4: 
            case 10: 
            case 11: {
                iValue = change ? ((Integer)((AttrInt)this.getAttribute(t, table, id, 0)).getNewValue(t)).intValue() : ((Integer)((AttrInt)this.getAttribute(t, table, id, 0)).getValue(t)).intValue();
                if (Trace.isTracing) {
                    t.data(65, "DmObject.appendToPCFRequest", 300, "Adding int attribute " + id + ", value = " + iValue + " to PCF request");
                }
                request.addParameter(id, iValue);
                break;
            }
            case 12: 
            case 29: {
                lValue = change ? ((Long)((AttrLong)this.getAttribute(t, table, id, 0)).getNewValue(t)).longValue() : ((Long)((AttrLong)this.getAttribute(t, table, id, 0)).getValue(t)).longValue();
                if (Trace.isTracing) {
                    t.data(65, "DmObject.appendToPCFRequest", 300, "Adding long attribute " + id + ", value = " + iValue + " to PCF request");
                }
                request.addParameter(id, lValue);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 23: 
            case 26: {
                sValue = change ? ((AttrString)this.getAttribute(t, table, id, 0)).getNewValue(t).toString() : ((AttrString)this.getAttribute(t, table, id, 0)).getValue(t).toString();
                boolean isSValueEmpty = false;
                if (sValue.length() < 1) {
                    sValue = " ";
                    isSValueEmpty = true;
                }
                if (id == 2094 && isSValueEmpty) {
                    if (!Trace.isTracing) break;
                    t.data(65, "DmObject.appendToPCFRequest", 300, "Ignoring TOPIC STRING attribute " + id + ", value = " + sValue + " from PCF request, as it is empty");
                    break;
                }
                if (Trace.isTracing) {
                    String trcValue = sValue;
                    if (TraceAspect.isSensitivePCF((Object)id) && !trcValue.equals(" ")) {
                        trcValue = "********";
                    }
                    t.data(65, "DmObject.appendToPCFRequest", 300, "Adding string attribute " + id + ", value = " + trcValue + " to PCF request");
                }
                request.addParameter(id, sValue);
                break;
            }
            case 8: 
            case 15: 
            case 21: {
                arrayList = change ? (ArrayList)((AttrStringArray)this.getAttribute(t, table, id, 0)).getNewValue(t) : (ArrayList)((AttrStringArray)this.getAttribute(t, table, id, 0)).getValue(t);
                if (arrayList.size() == 0) {
                    slValue = new String[]{" "};
                } else {
                    slValue = new String[arrayList.size()];
                    int j = 0;
                    while (j < arrayList.size()) {
                        sValue = (String)arrayList.get(j);
                        if (sValue.length() < 1) {
                            sValue = " ";
                        }
                        slValue[j] = sValue;
                        ++j;
                    }
                }
                if (Trace.isTracing) {
                    t.data(65, "DmObject.appendToPCFRequest", 300, "Adding string-list attribute " + id + ", value = " + this.arrayStringToString(t, slValue) + " to PCF request");
                }
                request.addParameter(id, this.padStringList(t, slValue));
                break;
            }
            case 14: 
            case 18: 
            case 22: {
                arrayList = change ? (ArrayList)((AttrIntArray)this.getAttribute(t, table, id, 0)).getNewValue(t) : (ArrayList)((AttrIntArray)this.getAttribute(t, table, id, 0)).getValue(t);
                int[] ii = new int[arrayList.size()];
                int j = 0;
                while (j < arrayList.size()) {
                    ii[j] = (Integer)arrayList.get(j);
                    ++j;
                }
                if (Trace.isTracing) {
                    t.data(65, "DmObject.appendToPCFRequest", 300, "Adding int-list attribute " + id + ", value = " + ii + " to PCF request");
                }
                request.addParameter(id, ii);
                break;
            }
            case 16: {
                byteBufferValue = change ? (ByteBuffer)((AttrByteArray)this.getAttribute(t, table, id, 0)).getNewValue(t) : (ByteBuffer)((AttrByteArray)this.getAttribute(t, table, id, 0)).getValue(t);
                byte[] bb = new byte[byteBufferValue.capacity()];
                int j = 0;
                while (j < byteBufferValue.capacity()) {
                    bb[j] = byteBufferValue.get(j);
                    ++j;
                }
                if (Trace.isTracing) {
                    t.data(65, "DmObject.appendToPCFRequest", 300, "Adding byte-array attribute " + id + ", value = " + bb + " to PCF request");
                }
                request.addParameter(id, bb);
                break;
            }
            default: {
                if (Trace.isTracing) {
                    t.data(65, "DmObject.appendToPCFRequest", 900, "Invalid attr type : " + at.getAttributeType());
                }
                return false;
            }
        }
        return true;
    }

    protected boolean checkForAsynUpdates(Trace t, Object job, int id, int index) {
        Hashtable<AttrKey, Attr> copy = this.getCopyTable(t, job);
        return !this.getAttributeValue(t, id, index).equals(this.getAttribute(t, copy, id, index).toString(t));
    }

    @Override
    public boolean equals(Object o) {
        boolean retValue = false;
        if (!(o instanceof DmObject)) {
            if (Trace.isTracing) {
                Trace.data((Level)Level.FINEST, (String)"DmObject", (String)"equals", (String)"Not comparing same object types");
            }
            return false;
        }
        if (this.dmTitle.equals(((DmObject)o).getDmTitle())) {
            retValue = true;
            if (Trace.isTracing) {
                Trace.data((Level)Level.FINEST, (String)"DmObject", (String)"equals", (String)"Objects are equal");
            }
        } else if (Trace.isTracing) {
            Trace.data((Level)Level.FINEST, (String)"DmObject", (String)"equals", (String)"Objects are not equal");
        }
        return retValue;
    }

    public Hashtable<AttrKey, Attr> getAttributesTable(Trace t) {
        return this.attributes;
    }

    public static synchronized IDmObject getDmObject(Trace t, ArrayList<IDmObject> al, String name) {
        DmObject retValue = null;
        boolean found = false;
        int index = 0;
        index = 0;
        while (index < al.size()) {
            block8: {
                try {
                    retValue = (DmObject)al.get(index);
                    if (name.equals(retValue.getDmTitle()) || name.equals(retValue.getTitle())) {
                        found = true;
                        break;
                    }
                }
                catch (ClassCastException cce) {
                    if (!Trace.isTracing) break block8;
                    t.data(65, "DmObject.getDmObject", 1000, "Error getting Dm object : " + cce.getMessage());
                }
            }
            ++index;
        }
        if (!found) {
            retValue = null;
        }
        if (Trace.isTracing) {
            if (found) {
                t.data(65, "DmObject.getDmObject", 300, "Title " + name + " found in list");
            } else {
                t.data(65, "DmObject.getDmObject", 300, "Title " + name + " not found in list");
            }
        }
        return retValue;
    }

    @Override
    public boolean isSystemObject(Trace t) {
        boolean retValue = false;
        if (this.getTitle().startsWith(SYSTEM_NAME)) {
            retValue = true;
        }
        if (Trace.isTracing) {
            t.data(65, "DmObject.isSystemObject", 300, "System object : " + retValue);
        }
        return retValue;
    }

    @Override
    public boolean isSystemDefault(Trace t) {
        return false;
    }

    @Override
    public int getObjectType(Trace t) {
        return this.objectType;
    }

    @Override
    public int getObjectSubType(Trace t) {
        return -1;
    }

    @Override
    public int getStatusType(Trace t) {
        return 0;
    }

    @Deprecated
    public ArrayList<IDmObject> getStatusList(Trace t) {
        return this.listOfStatus;
    }

    @Override
    public int actionDelete(Trace t, DmActionListener listener, Object parms) {
        return 2043;
    }

    @Override
    public int actionChange(Trace t, DmActionListener listener, Object job, boolean force) {
        return 2043;
    }

    @Override
    public int actionCreate(Trace t, DmActionListener listener, Object job) {
        return 2043;
    }

    protected void createDefaultAttribute(Trace t, AttrKey ak) {
        int id = ak.getAttributeID();
        int repeatingIndex = ak.getRepeatingIndex();
        AttrType at = this.attributesByType.get(id);
        if (at != null) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.createDefaultAttribute", 300, "Create default attribute " + id + "." + repeatingIndex);
            }
            Object o = this.attributesByType.get(id).getDefaultValue(t);
            this.addAttr(t, this.attributesByType, id, repeatingIndex, o, true);
        } else if (Trace.isTracing) {
            t.data(65, "DmObject.createDefaultAttribute", 300, "Attribute " + id + "." + repeatingIndex + " not in current attrtype table");
        }
    }

    @Override
    public Attr createAttribute(Trace t, Object job, int id, int repeatingIndex, Object value) {
        Attr a = null;
        Hashtable<AttrKey, Attr> table = this.getUpdateTable(t, job);
        if (repeatingIndex == -1) {
            a = this.getAttribute(t, id, 0);
            if (a == null) {
                if (Trace.isTracing) {
                    t.data(65, "DmObject.createAttribute", 300, "Attribute " + id + ".0" + " not in current table for " + this.getTitle());
                }
                repeatingIndex = 0;
            } else {
                repeatingIndex = this.getRepeatingIndexes(t, id);
            }
        }
        this.addAttr(t, this.attributesByType, id, repeatingIndex, value);
        a = this.getAttribute(t, id, repeatingIndex);
        a.setAction(t, 1);
        AttrKey key = new AttrKey(id, repeatingIndex);
        key.setActionSequenceId(this.getJobSequenceId(t, job));
        table.put(key, a);
        if (Trace.isTracing) {
            String trcValue = value.toString();
            if (TraceAspect.isSensitivePCF((Object)id) && !value.equals("")) {
                trcValue = "********";
            }
            t.data(65, "DmObject.createAttribute", 300, "Job action sequence id = " + key.getActionSequenceId() + ", attribute = " + id + "." + repeatingIndex + ", new value = " + trcValue);
        }
        this.updateJobSequenceId(t, job);
        return a;
    }

    @Override
    public boolean deleteAttribute(Trace t, Object job, int id, int repeatingIndex) {
        boolean retValue = false;
        Hashtable<AttrKey, Attr> table = this.getUpdateTable(t, job);
        Attr a = this.getAttribute(t, id, repeatingIndex);
        if (a != null) {
            a.setAction(t, 3);
            AttrKey key = new AttrKey(id, repeatingIndex);
            key.setActionSequenceId(this.getJobSequenceId(t, job));
            table.put(key, a);
            if (Trace.isTracing) {
                t.data(65, "DmObject.deleteAttribute", 300, "Job action sequence id = " + key.getActionSequenceId() + ", attribute = " + id + "." + repeatingIndex);
            }
            retValue = true;
            this.updateJobSequenceId(t, job);
        } else if (Trace.isTracing) {
            t.data(65, "DmObject.deleteAttribute", 900, "Attribute " + id + "." + repeatingIndex + " not in current table for " + this.getTitle());
        }
        return retValue;
    }

    @Override
    public IDmObject clone(Trace t, String n) {
        DmObject object = null;
        object = DmObjectFactory.create(t, this, n);
        object.setClonedFrom(this);
        return object;
    }

    public static DmObject clone(Trace t, DmQueueManager qMgr, String name, int type, int subType) {
        DmObject object = null;
        DmObject defaultObject = null;
        String defaultName = DmObject.getDefaultName(t, type, subType);
        if (!defaultName.equals(NOT_FOUND)) {
            DmObjectFilter query = new DmObjectFilter(t, defaultName, type, subType);
            ArrayList list = new ArrayList(0);
            try {
                list = qMgr.getObjects(t, query, false);
                if (list.size() == 1) {
                    defaultObject = (DmObject)list.get(0);
                    object = DmObjectFactory.create(t, defaultObject, name);
                    object.setClonedFrom(defaultObject);
                }
            }
            catch (DmCoreException dmCoreException) {}
        }
        if (Trace.isTracing) {
            if (object == null) {
                t.data(65, "DmObject.clone", 900, "Error creating new object called " + name);
            } else {
                t.data(65, "DmObject.clone", 300, "Created new object called " + name);
            }
        }
        return object;
    }

    protected void setAttributesTable(Trace t, Hashtable<AttrKey, Attr> newTable) {
        this.attributes.clear();
        this.attributes = newTable;
    }

    public static String getDefaultName(Trace t, int type, int subType) {
        String retValue = null;
        switch (type) {
            case 83: {
                retValue = DmAuthinfo.getDefaultName(t, subType);
                break;
            }
            case 191: {
                retValue = DmCommInfo.getDefaultName(t, subType);
                break;
            }
            case 25: {
                retValue = DmChannel.getDefaultName(t, subType);
                break;
            }
            case 204: {
                retValue = DmChannelAuthenticationRecord.getDefaultName(t, subType);
                break;
            }
            case 1005: {
                retValue = DmChannel.getDefaultName(t, 6);
                break;
            }
            case 115: {
                retValue = DEFAULT_COUPLING_FACILITY;
                break;
            }
            case 97: {
                retValue = DmListener.getDefaultName(t, subType);
                break;
            }
            case 36: {
                retValue = DEFAULT_NAMELIST;
                break;
            }
            case 7: {
                retValue = DEFAULT_PROCESS;
                break;
            }
            case 13: {
                retValue = DmQueue.getDefaultName(t, subType);
                break;
            }
            case 174: {
                retValue = DmTopic.getDefaultName(t);
                break;
            }
            case 176: {
                retValue = DmSubscription.getDefaultName(t);
                break;
            }
            case 153: {
                retValue = DEFAULT_SERVICE;
                break;
            }
            case 122: {
                retValue = DEFAULT_STORAGE_CLASS;
                break;
            }
            default: {
                if (Trace.isTracing) {
                    t.data(65, "DmObject.getDefaultName", 900, "Unknown object type/subtype : " + type + "/" + subType);
                }
                retValue = NOT_FOUND;
            }
        }
        return retValue;
    }

    public static String getTypeName(Trace t, int objectType) {
        switch (objectType) {
            case 114: {
                return "DmArchive";
            }
            case 1013: {
                return "DmArchiveTape";
            }
            case 83: {
                return "DmAuthinfo";
            }
            case 191: {
                return "DmCommInfo";
            }
            case 87: {
                return "DmAuthorityRecord";
            }
            case 25: {
                return "DmChannel";
            }
            case 1009: {
                return "DmChannelStatusCurrent";
            }
            case 1010: {
                return "DmChannelStatusSaved";
            }
            case 204: {
                return "DmChannelAuthenticationRecord";
            }
            case 1005: {
                return "DmClientChannel";
            }
            case 70: {
                return "DmClusterQueueManager";
            }
            case 1004: {
                return "DmClusterQueue";
            }
            case 1024: {
                return "DmClusterTopic";
            }
            case 115: {
                return "DmCouplingFacility";
            }
            case 186: {
                return "DmCouplingFacilitySMDS";
            }
            case 199: {
                return "DmCouplingFacilitySMDSCONN";
            }
            case 1019: {
                return "DmCouplingFacilityStatusBackup";
            }
            case 1020: {
                return "DmCouplingFacilityStatusConnect";
            }
            case 1021: {
                return "DmCouplingFacilityStatusSummary";
            }
            case 1028: {
                return "DmCouplingFacilityStatusSMDS";
            }
            case 1000: {
                return "DmDistQueueManagement";
            }
            case 1015: {
                return "DmDistQueueManagementListener";
            }
            case 88: {
                return "DmEntityAuthority";
            }
            case 97: {
                return "DmListener";
            }
            case 98: {
                return "DmListenerStatus";
            }
            case 120: {
                return "DmLog";
            }
            case 1011: {
                return "DmLogCopy";
            }
            case 1012: {
                return "DmLogStatus";
            }
            case 1001: {
                return "DmMachine";
            }
            case 36: {
                return "DmNamelist";
            }
            case 7: {
                return "DmProcess";
            }
            case 185: {
                return "DmPubSubStatus";
            }
            case 1031: {
                return "DmNHAStatus";
            }
            case 1032: {
                return "DmNHAGroupStatus";
            }
            case 119: {
                return "DmQSGMember";
            }
            case 13: {
                return "DmQueue";
            }
            case 174: {
                return "DmTopic";
            }
            case 183: {
                return "DmTopicStatus";
            }
            case 176: {
                return "DmSubscription";
            }
            case 182: {
                return "DmSubscriptionStatus";
            }
            case 2: {
                return "DmQueueManager";
            }
            case 85: {
                return "DmQueueManagerConnection";
            }
            case 1006: {
                return "DmQueueManagerConnectionHandle";
            }
            case 1002: {
                return "DmQueueManagerHandle";
            }
            case 161: {
                return "DmQueueManagerStatus";
            }
            case 1007: {
                return "DmQueueStatusHandle";
            }
            case 1008: {
                return "DmQueueStatusQueue";
            }
            case 1030: {
                return "DmRemoteQueueManagerName";
            }
            case 121: {
                return "DmSecurity";
            }
            case 1014: {
                return "DmSecuritySwitch";
            }
            case 153: {
                return "DmService";
            }
            case 154: {
                return "DmServiceStatus";
            }
            case 122: {
                return "DmStorageClass";
            }
            case 123: {
                return "DmSystem";
            }
            case 126: {
                return "DmUsage";
            }
            case 1016: {
                return "DmUsageBufferPool";
            }
            case 1017: {
                return "DmUsageDataset";
            }
            case 1018: {
                return "DmUsagePageset";
            }
            case 1029: {
                return "DmUsageSMDS";
            }
        }
        if (Trace.isTracing) {
            t.data(65, "DmObject.getTypeName", 900, "Unknown object type : " + objectType);
        }
        return NOT_FOUND;
    }

    public IDmObject getClonedFromObject() {
        return this.clonedFrom;
    }

    public void setClonedFrom(IDmObject o) {
        this.clonedFrom = o;
    }

    public String getClonedFrom() {
        if (this.clonedFrom != null) {
            return this.clonedFrom.getTitle();
        }
        return NOT_DEFINED;
    }

    public static int[] getMandatoryIds(Trace t, int type, int subType) {
        int[] ids = null;
        switch (type) {
            case 83: {
                ids = DmAuthinfo.getMandatoryIds(subType);
                break;
            }
            case 191: {
                ids = DmCommInfo.getMandatoryIds(subType);
                break;
            }
            case 87: {
                ids = DmAuthorityRecord.getMandatoryIds();
                break;
            }
            case 25: {
                ids = DmChannel.getMandatoryIds(subType);
                break;
            }
            case 204: {
                ids = DmChannelAuthenticationRecord.getMandatoryIds(subType);
                break;
            }
            case 1005: {
                ids = DmClientChannel.getMandatoryIds(6);
                break;
            }
            case 115: {
                ids = DmCouplingFacility.getMandatoryIds();
                break;
            }
            case 1015: {
                ids = DmDistQueueManagementListener.getMandatoryIds();
                break;
            }
            case 97: {
                ids = DmListener.getMandatoryIds(subType);
                break;
            }
            case 36: {
                ids = DmNamelist.getMandatoryIds();
                break;
            }
            case 7: {
                ids = DmProcess.getMandatoryIds();
                break;
            }
            case 13: {
                ids = DmQueue.getMandatoryIds(subType);
                break;
            }
            case 1030: {
                ids = DmRemoteQueueManagerName.getMandatoryIds();
                break;
            }
            case 174: {
                ids = DmTopic.getMandatoryIds();
                break;
            }
            case 176: {
                ids = DmSubscription.getMandatoryIds();
                break;
            }
            case 153: {
                ids = DmService.getMandatoryIds();
                break;
            }
            case 122: {
                ids = DmStorageClass.getMandatoryIds();
                break;
            }
            case 1026: {
                ids = DmTelemetryChannel.getMandatoryIds(subType);
                break;
            }
            default: {
                if (Trace.isTracing) {
                    t.data(65, "DmObject.getMandatoryIds", 900, "Unknown object type : " + type + ", subType = " + subType);
                }
                ids = new int[]{};
            }
        }
        return ids;
    }

    public DmObject updateStatus(Trace t, ArrayList<IDmObject> list, int action) {
        if (Trace.isTracing) {
            t.data(65, "DmObject.updateStatus", 800, "Default updateStatus() called for list (type " + this.getObjectType(t) + ") " + this.arrayListToString(t, list));
        }
        return null;
    }

    @Override
    public boolean isFilteringSupported(Trace t) {
        boolean filtering = false;
        if (this.queueManager != null) {
            int commandLevel = this.queueManager.getCommandLevel();
            if (Trace.isTracing) {
                t.data(65, "DmObject.isFilteringSupported", 800, "Command level " + commandLevel);
            }
            if (commandLevel >= 600) {
                filtering = true;
            }
        }
        if (Trace.isTracing) {
            t.data(65, "DmObject.isFilteringSupported", 800, "Filtering supported : " + filtering);
        }
        return filtering;
    }

    @Override
    public int[] getObjectSubTypes(Trace t) {
        return new int[0];
    }

    protected int[] getObjectSubTypes(Trace t, HashMap<Integer, AttrType> table, int id) {
        int[] retValue = new int[]{};
        if (table == null) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.getObjectSubTypes", 900, "Table for attribute id " + id + " has not been created");
            }
            return retValue;
        }
        AttrType at = table.get(id);
        if (at == null) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.getObjectSubTypes", 900, "No attribute type in table for attribute id " + id);
            }
            return retValue;
        }
        try {
            Integer[] enums = ((AttrTypeEnum)at).getEnumerationIds(t);
            if (Trace.isTracing) {
                t.data(65, "DmObject.getObjectSubTypes", 300, String.valueOf(enums.length) + " types found for " + this.name);
            }
            retValue = new int[enums.length];
            int i = 0;
            while (i < enums.length) {
                retValue[i] = enums[i];
                if (Trace.isTracing) {
                    t.data(65, "DmObject.getObjectSubTypes", 300, "Type " + retValue[i] + " found for " + this.name);
                }
                ++i;
            }
        }
        catch (ClassCastException classCastException) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.getObjectSubTypes", 900, "Conversion error for attribute type in table for attribute id " + id);
            }
            return retValue;
        }
        return retValue;
    }

    protected int getStatusType(Trace t, HashMap<Integer, AttrType> table, int id) {
        int retValue = 0;
        if (table == null) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.getStatusType", 900, "Table for attribute id " + id + " has not been created");
            }
            return retValue;
        }
        AttrType at = table.get(id);
        if (at == null) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.getStatusType", 900, "No attribute type in table for attribute id " + id);
            }
            return retValue;
        }
        try {
            Integer value = (Integer)((AttrTypeInt)at).getDefaultValue(t);
            retValue = value;
            if (Trace.isTracing) {
                t.data(65, "DmObject.getStatusType", 300, "Status type " + retValue + " found for " + this.name);
            }
        }
        catch (ClassCastException classCastException) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.getStatusType", 900, "Conversion error for attribute type in table for attribute id " + id);
            }
            return retValue;
        }
        return retValue;
    }

    @Override
    public int[] getMandatoryIds(Trace t) {
        return new int[0];
    }

    public synchronized int getNextJobId(Trace t) {
        return ++jobId;
    }

    public int getJobSequenceId(Trace t, Object job) {
        int seqId = 0;
        if (job instanceof AttrJob) {
            seqId = ((AttrJob)job).getActionSequenceId();
            if (Trace.isTracing) {
                t.data(65, "DmObject.getJobSequenceId", 300, "Job action sequence id is " + seqId);
            }
        } else if (Trace.isTracing) {
            t.data(65, "DmObject.getJobSequenceId", 900, "Job object not an AttrJob");
        }
        return seqId;
    }

    public void updateJobSequenceId(Trace t, Object job) {
        int seqId = 0;
        if (job instanceof AttrJob) {
            seqId = ((AttrJob)job).getActionSequenceId() + 1;
            ((AttrJob)job).setActionSequenceId(seqId);
            if (Trace.isTracing) {
                t.data(65, "DmObject.updateJobSequenceId", 300, "Setting job action sequence id to " + seqId);
            }
        } else if (Trace.isTracing) {
            t.data(65, "DmObject.updateJobSequenceId", 900, "Job object not an AttrJob");
        }
    }

    protected String[] padStringList(Trace t, String[] inList) {
        String[] retValue = new String[]{};
        if (Trace.isTracing) {
            t.data(65, "DmObject.padStringList", 300, "Input string list = " + inList.toString());
        }
        if (inList.length > 0) {
            int l;
            int sLength = inList[0].length();
            boolean change = false;
            int j = 0;
            while (j < inList.length) {
                l = inList[j].length();
                if (l != sLength) {
                    change = true;
                }
                if (l > sLength) {
                    sLength = l;
                }
                ++j;
            }
            if (Trace.isTracing) {
                t.data(65, "DmObject.padStringList", 300, "Longest string length is " + sLength);
            }
            if (change) {
                retValue = new String[inList.length];
                j = 0;
                while (j < inList.length) {
                    l = inList[j].length();
                    if (l < sLength) {
                        StringBuffer sb = new StringBuffer(inList[j]);
                        int padLength = sLength - l;
                        int i = 0;
                        while (i < padLength) {
                            sb.append(" ");
                            ++i;
                        }
                        retValue[j] = sb.toString();
                    } else {
                        retValue[j] = inList[j];
                    }
                    ++j;
                }
            } else {
                retValue = inList;
            }
        }
        if (Trace.isTracing) {
            t.data(65, "DmObject.padStringList", 300, "Ouput string list = " + retValue.toString());
        }
        return retValue;
    }

    private String arrayStringToString(Trace t, String[] inList) {
        StringBuffer retValue = new StringBuffer();
        int j = 0;
        while (j < inList.length) {
            retValue.append("\"" + inList[j].toString() + "\", ");
            ++j;
        }
        return retValue.toString();
    }

    private String arrayListToString(Trace t, ArrayList<IDmObject> inList) {
        StringBuffer retValue = new StringBuffer();
        int i = 0;
        while (i < inList.size()) {
            try {
                DmObject object = (DmObject)inList.get(i);
                retValue.append(String.valueOf(object.getTitle()) + ", ");
            }
            catch (ClassCastException classCastException) {
                retValue.append("Item " + i + " not a DmObject, ");
            }
            ++i;
        }
        return retValue.toString();
    }

    public int getObjectQSGDisp(Trace t) {
        int disp = -99;
        AttrInt attr = (AttrInt)this.getAttribute(t, 63, 0);
        if (attr != null) {
            disp = (Integer)attr.getValue(t);
        }
        if (Trace.isTracing) {
            t.data(65, "DmObject.getObjectQSGDisp", 300, "QSG disp for " + this.getTitle() + " is " + disp);
        }
        return disp;
    }

    protected void addQSGDispToRequest(Trace t, PCFAction cmd) {
        int disp = this.getObjectQSGDisp(t);
        if (disp != -99) {
            cmd.getRequest(t).addParameter(63, disp);
            if (Trace.isTracing) {
                t.data(65, "DmObject.addQSGDispToRequest", 300, "QSG disp added to request for " + this.getTitle());
            }
        }
    }

    public static int getCommandId(Trace t) {
        return -1;
    }

    @Override
    public String getParentName(Trace t) {
        return this.queueManager.getTitle();
    }

    @Override
    public boolean replaceAttributeValue(Trace t, int id, int index, Object value) {
        return this.replaceAttributeValue(t, id, index, value, true);
    }

    public boolean replaceAttributeValue(Trace t, int id, int index, Object value, boolean checkReadOnly) {
        boolean replaced = false;
        Attr attr = this.getAttribute(t, id, index);
        if (attr == null) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.replaceAttributeValue", 900, "Attribute " + id + "." + index + " not in current table for " + this.getTitle());
            }
            return false;
        }
        if (checkReadOnly && !attr.isReadWrite(t)) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.replaceAttributeValue", 900, "Attribute " + id + "." + index + " is read-only for " + this.getTitle());
            }
            return false;
        }
        replaced = attr.replaceValue(t, value);
        if (Trace.isTracing) {
            if (replaced) {
                t.data(65, "DmObject.replaceAttributeValue", 900, "Current value of attribute " + id + "." + index + " updated for " + this.getTitle());
            } else {
                t.data(65, "DmObject.replaceAttributeValue", 900, "Current value of attribute " + id + "." + index + " not updated for " + this.getTitle());
            }
        }
        return replaced;
    }

    public boolean compareAttributes(Trace t, PCFMessage pcfMessage) {
        boolean changes = false;
        Hashtable<AttrKey, Attr> table = new Hashtable<AttrKey, Attr>(0);
        PCFParameter p = null;
        if (Trace.isTracing) {
            t.data(65, "DmObject.compareAttributes", 300, "Examining " + pcfMessage.getParameterCount() + " attributes for " + this.getTitle());
        }
        Enumeration e = pcfMessage.getParameters();
        while (e.hasMoreElements()) {
            p = (PCFParameter)e.nextElement();
            Object value = p.getValue();
            try {
                this.addAttr(t, table, this.attributesByType, p.getParameter(), 0, value);
                Attr a = this.getAttribute(t, table, p.getParameter(), 0);
                Attr b = this.getAttribute(t, this.attributes, p.getParameter(), 0);
                if (a != null && b != null) {
                    if (a.equals(t, b)) continue;
                    changes = true;
                    break;
                }
                changes = true;
                break;
            }
            catch (ClassCastException cce) {
                int id = p.getParameter();
                String idName = PCFConstants.lookupParameter((int)id);
                if (idName == null) {
                    idName = "unknown";
                }
                if (!Trace.isTracing) continue;
                t.data(65, "DmObject.compareAttributes", 900, "ClassCastException for attribute id " + id + ".0 (" + cce.getMessage() + ")");
                t.data(65, "DmObject.compareAttributes", 900, "Attribute " + id + "(" + idName + ") type defined incorrectly");
            }
        }
        if (Trace.isTracing) {
            if (changes) {
                t.data(65, "DmObject.compareAttributes", 300, "Attribute " + p.getParameter() + " value changed for " + this.getTitle());
            } else {
                t.data(65, "DmObject.compareAttributes", 300, "No changes detected for " + this.getTitle());
            }
        }
        table.clear();
        return changes;
    }

    public boolean isMandatoryId(Trace t, int id) {
        boolean retValue = false;
        int type = this.getObjectType(t);
        int subType = this.getObjectSubType(t);
        int[] mandatoryIds = DmObject.getMandatoryIds(t, type, subType);
        int i = 0;
        while (i < mandatoryIds.length) {
            if (mandatoryIds[i] == id) {
                retValue = true;
                break;
            }
            ++i;
        }
        if (Trace.isTracing) {
            if (retValue) {
                t.data(65, "DmObject.isMandatoryId", 300, "Attribute " + id + " is a mandatory id");
            } else {
                t.data(65, "DmObject.isMandatoryId", 300, "Attribute " + id + " is not a mandatory id");
            }
        }
        return retValue;
    }

    public static int[] getValidAuthorities(Trace t, HashMap<Integer, AttrType> hm) {
        int[] authorities = null;
        if (hm == null) {
            if (Trace.isTracing) {
                t.data(65, "DmObject.getValidAuthorities", 900, "<All> table has not been created");
            }
            return null;
        }
        AttrTypeEnum at = (AttrTypeEnum)DmObject.getAttributeType(t, hm, 12002);
        Integer[] listOfAttrs = at.getEnumerationIds(t);
        authorities = new int[listOfAttrs.length];
        int i = 0;
        while (i < listOfAttrs.length) {
            authorities[i] = listOfAttrs[i];
            if (Trace.isTracing) {
                t.data(65, "DmObject.getValidAuthorities", 300, "Valid authority is " + authorities[i]);
            }
            ++i;
        }
        return authorities;
    }

    protected String getUniqueObjectName(Object object) {
        String uniqueName = String.valueOf(object.getClass().getName()) + "@" + System.identityHashCode(object);
        return uniqueName;
    }

    public void setQueueManager(Trace t, DmQueueManager qmgr) {
        this.queueManager = qmgr;
    }

    public void setParent(Trace t, DmObject p) {
        this.parent = p;
    }

    public IDmObjectResponse getObjectResponse(Trace t) {
        if (this.objectResponse == null) {
            this.objectResponse = new DmObjectResponse(t);
        }
        return this.objectResponse;
    }

    protected boolean init(Trace t) throws DmCoreException {
        DmObject plain = (DmObject)DmObjectFactory.getPlainObject(t, this.objectType);
        this.objectResponse = plain != null ? plain.getObjectResponse(t) : new DmObjectResponse(t);
        return true;
    }

    @Override
    public int getAttributeDifferenceCount(Trace t, IDmObject dmObject2) {
        int countChanged = 0;
        int[] attrIds1 = this.getAllAttributes(t);
        int i = 0;
        while (i < attrIds1.length) {
            Attr attr1 = null;
            Attr attr2 = null;
            String attrValue1 = null;
            String attrValue2 = null;
            boolean attrPresent1 = true;
            boolean attrPresent2 = true;
            boolean repeating = false;
            int index = 0;
            do {
                attr1 = this.getAttribute(t, attrIds1[i], index);
                attr2 = dmObject2.getAttribute(t, attrIds1[i], index);
                attrPresent1 = true;
                attrPresent2 = true;
                if (attr1 != null) {
                    attrValue1 = attr1.toString(t);
                } else {
                    attrPresent1 = false;
                }
                if (attr2 != null) {
                    attrValue2 = attr2.toString(t);
                } else {
                    attrPresent2 = false;
                }
                if (index == 0) {
                    repeating = attr1.getAttrType().isRepeating();
                }
                ++index;
                if (attrPresent1 == attrPresent2 && (!attrPresent1 || !attrPresent2 || attrValue1 == null || attrValue2 == null || attrValue1.compareTo(attrValue2) == 0)) continue;
                ++countChanged;
                break;
            } while (repeating && attrPresent1 && attrPresent2);
            ++i;
        }
        if (Trace.isTracing) {
            t.data(65, "DmObject.getAttributeDifferenceCount", 300, "There are " + countChanged + " different attributes between " + this.getTitle() + " and " + dmObject2.getTitle());
        }
        return countChanged;
    }

    @Override
    public int getNameAttributeId() {
        return -1;
    }
}

