/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.PCFAction;
import java.util.HashMap;
import org.osgi.framework.Bundle;

public class DmNamelist
extends DmObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/objects/DmNamelist.java";
    protected static final String DEFAULT = "SYSTEM.DEFAULT.NAMELIST";
    private static HashMap<Integer, AttrType> allAttributesByType = null;

    protected DmNamelist(Trace t, String nn) {
        super(nn, 36);
    }

    public static boolean staticInit(Trace t, Bundle bund) {
        allAttributesByType = DmNamelist.initAllAttrTypeTable(t, DmNamelist.getClassName(DmNamelist.class.getName()), allAttributesByType, bund);
        if (allAttributesByType == null) {
            if (Trace.isTracing) {
                t.data(65, "DmNamelist.staticInit", 900, "Error loading allAttributesByType table");
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean init(Trace t) {
        this.addAttr(t, this.attributesByType, 2010, 0, this.getTitle());
        return true;
    }

    public static String getAttributeTitle(Trace t, int id) {
        return DmNamelist.getAttributeTitle(t, allAttributesByType, id);
    }

    public static AttrType getAttributeType(Trace t, int id) {
        return DmNamelist.getAttributeType(t, allAttributesByType, id);
    }

    public static String getAttributeDefaultValue(Trace t, int id) {
        return DmNamelist.getAttributeDefaultValue(t, allAttributesByType, id);
    }

    public static int[] getDisplayColumnSequence(Trace t, int[] ids, boolean zOS) {
        return DmNamelist.getDisplayColumnSequence(t, allAttributesByType, ids, zOS);
    }

    public static boolean isAttributeRepeating(Trace t, int id) {
        return DmNamelist.isAttributeRepeating(t, allAttributesByType, id);
    }

    public static int[] getAllAttributesByType(Trace t) {
        return DmNamelist.getAllAttributesByType(t, allAttributesByType);
    }

    @Override
    public String toString(Trace t) {
        return this.getTitle();
    }

    @Override
    public void close(Trace t) {
    }

    public int actionDelete(Trace t, DmActionListener listener) {
        return this.actionDelete(t, listener, null);
    }

    @Override
    public int actionDelete(Trace t, DmActionListener listener, Object parms) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmNamelist.actionDelete", 300, "Deleting namelist " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 35, this);
        cmd.getRequest(t).addParameter(2010, this.getTitle());
        this.addQSGDispToRequest(t, cmd);
        rc = cmd.execute(t, listener, 2);
        return rc;
    }

    @Override
    public int actionCreate(Trace t, DmActionListener listener, Object job) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmNamelist.actionCreate", 300, "Creating namelist " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 33, this);
        cmd.getRequest(t).addParameter(3005, this.getClonedFrom());
        cmd.getRequest(t).addParameter(3006, this.getTitle());
        this.mergeNewWithChangesToPCFRequest(t, job, cmd.getRequest(t));
        rc = cmd.execute(t, listener);
        return rc;
    }

    @Override
    public int actionChange(Trace t, DmActionListener listener, Object job, boolean force) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmNamelist.actionChange", 300, "Changing namelist " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 32, this);
        cmd.getRequest(t).addParameter(2010, this.getTitle());
        this.addQSGDispToRequest(t, cmd);
        this.appendToPCFRequest(t, job, cmd.getRequest(t));
        this.endUpdate(t, job);
        rc = cmd.execute(t, listener);
        return rc;
    }

    @Override
    public boolean isSystemDefault(Trace t) {
        boolean retValue = false;
        if (this.getTitle().equals(DEFAULT)) {
            retValue = true;
        }
        return retValue;
    }

    public static String getDefaultName(Trace t) {
        return DEFAULT;
    }

    @Override
    public int[] getMandatoryIds(Trace t) {
        return DmNamelist.getMandatoryIds();
    }

    public static int[] getMandatoryIds() {
        return new int[]{2010};
    }

    @Override
    public void initialize(Trace t) {
        this.setName(t, 2010);
        Attr attr = this.getAttribute(t, 63, 0);
        if (attr != null) {
            attr.setReadWrite(t, false);
        }
    }

    public static int[] getValidAuthorities(Trace t) {
        return DmNamelist.getValidAuthorities(t, allAttributesByType);
    }

    @Override
    public int getNameAttributeId() {
        return 2010;
    }
}

