/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrKey;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.base.IDmObservable;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.event.DmMonitor;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.objects.DmObjectWithConfig;
import com.ibm.mq.explorer.core.internal.utils.CoreServices;
import java.util.HashMap;
import java.util.Hashtable;
import org.osgi.framework.Bundle;

public class DmMachine
extends DmObjectWithConfig
implements IDmObservable {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/objects/DmMachine.java";
    private static HashMap<Integer, AttrType> allAttributesByType = null;
    private static HashMap updateGroupsByName = null;
    private static int platform = 0;
    private static int commandLevel = 0;

    public DmMachine(Trace t) {
        super("Machine", 1001);
        this.init(t);
        this.refreshAttributes(t);
    }

    @Override
    public boolean init(Trace t) {
        this.initAttrTypeTable(t, commandLevel, platform);
        if (CommonServices.isMqjbnd()) {
            this.getStanzaAttrs(t, this.attributesByType, null, updateGroupsByName);
        }
        this.addAttr(t, allAttributesByType, 10539, 0, "Machine config", false);
        return true;
    }

    public static boolean staticInit(Trace t, Bundle bund) {
        boolean retValue = false;
        DmMachine.setCommandLevel();
        DmMachine.setPlatform(t);
        allAttributesByType = DmMachine.initAllAttrTypeTable(t, DmMachine.getClassName(DmMachine.class.getName()), allAttributesByType, bund);
        updateGroupsByName = DmMachine.initConfigTable(t, DmMachine.getClassName(DmMachine.class.getName()), updateGroupsByName);
        return retValue;
    }

    public static String getAttributeTitle(Trace t, int id) {
        return DmMachine.getAttributeTitle(t, allAttributesByType, id);
    }

    public static AttrType getAttributeType(Trace t, int id) {
        return DmMachine.getAttributeType(t, allAttributesByType, id);
    }

    public static String getAttributeDefaultValue(Trace t, int id) {
        return DmMachine.getAttributeDefaultValue(t, allAttributesByType, id);
    }

    public static int[] getDisplayColumnSequence(Trace t, int[] ids, boolean zOS) {
        return DmMachine.getDisplayColumnSequence(t, allAttributesByType, ids, zOS);
    }

    public static boolean isAttributeRepeating(Trace t, int id) {
        return DmMachine.isAttributeRepeating(t, allAttributesByType, id);
    }

    public static int[] getAllAttributesByType(Trace t) {
        return DmMachine.getAllAttributesByType(t, allAttributesByType);
    }

    @Override
    public String toString(Trace t) {
        return this.getTitle();
    }

    public boolean refreshAttributes(Trace t) {
        return this.refreshAttributes(t, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refreshAttributes(Trace t, DmObjectListener listener) {
        boolean retValue = true;
        if (CommonServices.isMqjbnd()) {
            Hashtable hashtable = this.attributes;
            synchronized (hashtable) {
                this.attributes.clear();
                retValue = this.getStanzaAttrs(t, this.attributesByType, null, updateGroupsByName);
                if (Trace.isTracing) {
                    if (!retValue) {
                        t.data(65, "DmMachine.refreshAttributes", 300, "Error refreshing config attributes for DmMachine");
                    } else {
                        t.data(65, "DmMachine.refreshAttributes", 300, "Config attributes refreshed for DmMachine");
                    }
                }
                this.loadDefaultAttributeValues(t, updateGroupsByName);
            }
            this.listQueueManagers(t);
            if (listener != null) {
                DmMonitor.notifyMachineListener(t, listener);
            } else {
                DmMonitor.notifyMachineListeners(t);
            }
        }
        return retValue;
    }

    @Override
    public void close(Trace t) {
    }

    private void listQueueManagers(Trace t) {
        if (this.attributes.size() > 0) {
            AttrKey key;
            Attr attr;
            int index = 0;
            while ((attr = (Attr)this.attributes.get(key = new AttrKey(10504, index))) != null) {
                String qm = attr.toString(t);
                if (Trace.isTracing) {
                    t.data(65, "DmMachine.listQueueManagers", 300, "Found queue manager " + qm);
                }
                ++index;
            }
        }
    }

    @Override
    public int actionChange(Trace t, DmActionListener listener, Object job, boolean force) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmMachine.actionChange", 300, "Changing machine");
        }
        if ((rc = this.processConfigAttributes(t, job, updateGroupsByName)) == 0) {
            this.refreshAttributes(t);
        }
        if (listener != null) {
            if (rc != 0) {
                DmCoreException ex = DmCoreException.create(t, this, 0, rc, 2);
                listener.dmActionDone(new DmActionEvent(this, rc, 2, ex));
            } else {
                listener.dmActionDone(new DmActionEvent(this, rc, 0));
            }
        }
        return rc;
    }

    private static void setCommandLevel() {
        commandLevel = 944;
    }

    private static void setPlatform(Trace t) {
        platform = CoreServices.determineWMQPlatform();
        if (Trace.isTracing) {
            t.data(65, "DmMachine.setPlatform", 900, "Machine platform is " + platform);
        }
    }

    public static int getPlatform(Trace t) {
        return platform;
    }

    public static int getCommandLevel(Trace t) {
        return commandLevel;
    }

    @Override
    public boolean addObserver(Trace t, DmObjectListener listener, DmObjectFilter filter) {
        DmMonitor.addMachineListener(t, listener);
        return true;
    }

    @Override
    public boolean deleteObserver(Trace t, DmObjectListener listener) {
        DmMonitor.removeMachineListener(t, listener);
        return true;
    }

    @Override
    public String getObservableName() {
        return "The Machine (DmMachine)";
    }

    @Override
    public void refreshObservable(Trace t) {
        this.refreshAttributes(t);
    }

    @Override
    public void refreshObservable(Trace t, DmObjectListener listener) {
        this.refreshObservable(t);
    }

    protected String getConfigAttribute(Trace t, String qm, int id) {
        String value = "";
        if (this.attributes.size() > 0) {
            String s;
            int index = 0;
            while (!"[not_found]".equals(s = this.getAttributeValue(t, 10504, index))) {
                if (Trace.isTracing) {
                    t.data(65, "DmMachine.getConfigAttribute", 300, "Queue manager name " + s + " found at index " + index);
                }
                if (qm.equals(s)) {
                    s = this.getAttributeValue(t, id, index);
                    if ("[not_found]".equals(s)) break;
                    value = s;
                    if (!Trace.isTracing) break;
                    t.data(65, "DmMachine.getConfigAttribute", 300, "Found config attribute " + s);
                    break;
                }
                ++index;
            }
        }
        return value;
    }
}

