/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.objects;

import com.ibm.mq.MQException;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.Common;
import com.ibm.mq.explorer.core.internal.base.CorePlugin;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.utils.QueueManagerHandle;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;

public class DmMQQueueManager
extends Thread {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/objects/DmMQQueueManager.java";
    private MQQueueManager queueManager = null;
    private String queueManagerName = null;
    private String hostName = null;
    private String channelName = null;
    private int portAddress = 0;
    private int connectionType = 0;
    private String channelDefTable = null;
    private String errorMessage = "";
    private int reasonCode = 0;
    private int completionCode = 0;
    private QueueManagerHandle connHandle = null;

    public DmMQQueueManager(Trace t, String qm) {
        this.queueManagerName = qm;
        this.connectionType = 1;
        if (Trace.isTracing) {
            t.data(65, "DmMQQueueManager.DmMQQueueManager", 300, "Queue manager : " + qm);
        }
    }

    public DmMQQueueManager(Trace t, String qm, String hn, int p, String ch) {
        this.queueManagerName = qm;
        this.hostName = hn;
        this.portAddress = p;
        this.channelName = ch;
        this.connectionType = 2;
        if (Trace.isTracing) {
            t.data(65, "DmMQQueueManager.DmMQQueueManager", 300, "Queue manager : " + qm + ", host name : " + hn + ", port : " + p + ", channel : " + ch);
        }
    }

    public DmMQQueueManager(Trace t, String qm, String chanDefTable) {
        this.queueManagerName = qm;
        this.connectionType = 4;
        this.channelDefTable = chanDefTable;
        if (Trace.isTracing) {
            t.data(65, "DmMQQueueManager.DmMQQueueManager", 300, "Queue manager : " + qm + ", channel defintion table : " + chanDefTable);
        }
    }

    public void connect(Trace t) {
        if (Trace.isTracing) {
            t.data(65, "DmMQQueueManager.connect", 300, "Create connection to queue manager : " + this.queueManagerName + " in separate thread");
        }
        this.setDaemon(true);
        this.start();
    }

    public boolean isConnected(Trace t) {
        boolean retValue = false;
        if (this.queueManager != null) {
            retValue = this.queueManager.isConnected();
        }
        if (Trace.isTracing) {
            t.data(65, "DmMQQueueManager.isConnected", 300, "Queue manager connected : " + retValue);
        }
        return retValue;
    }

    public MQQueueManager getQueueManager(Trace t) {
        return this.queueManager;
    }

    @Override
    public void run() {
        Trace t = Trace.getInstance();
        this.queueManager = this.createConnection(t);
    }

    public MQQueueManager createConnection(Trace t) {
        Hashtable<Object, Object> parms = null;
        if (Trace.isTracing) {
            t.data(65, "DmMQQueueManager.createConnection", 300, "Creating MQQueueManager to : " + this.queueManagerName);
        }
        try {
            switch (this.connectionType) {
                case 2: 
                case 5: {
                    parms = this.connHandle == null ? new Hashtable(7) : this.connHandle.getSecurityOptions(t);
                    parms.put("hostname", this.hostName);
                    parms.put("port", this.portAddress);
                    parms.put("channel", this.channelName);
                    parms.put("transport", "MQSeries Client");
                    parms.put("APPNAME", Common.CLIENT_CONNECTION_APPNAME);
                    parms.put("CCSID", CorePlugin.getCCSID());
                    try {
                        if (!parms.containsKey("userID")) {
                            String userID = System.getProperty("user.name", "");
                            parms.put("userID", userID);
                        }
                        this.queueManager = new MQQueueManager(this.queueManagerName, parms);
                        if (Trace.isTracing) {
                            t.data(65, "DmMQQueueManager.createConnection", 300, "Client connection to : " + this.queueManagerName);
                        }
                    }
                    catch (SecurityException securityException) {
                        String messageId = "AMQ4127";
                        this.errorMessage = CommonServices.getSystemMessage((Trace)t, (String)messageId);
                        this.reasonCode = 50013;
                        this.completionCode = 2;
                        this.queueManager = null;
                    }
                    break;
                }
                case 1: {
                    int connectOptions = CorePlugin.getMQConnectOptions();
                    parms = this.connHandle == null ? new Hashtable(2) : this.connHandle.getSecurityOptions(t);
                    parms.put("CCSID", CorePlugin.getCCSID());
                    parms.put("connectOptions", connectOptions);
                    parms.put("APPNAME", Common.CLIENT_CONNECTION_APPNAME);
                    this.queueManager = new MQQueueManager(this.queueManagerName, parms);
                    if (Trace.isTracing) {
                        t.data(65, "DmMQQueueManager.createConnection", 300, "Server connection to : " + this.queueManagerName);
                    }
                    break;
                }
                case 4: {
                    parms = this.connHandle == null ? new Hashtable(2) : this.connHandle.getSecurityOptions(t);
                    parms.put("CCSID", CorePlugin.getCCSID());
                    if (!parms.containsKey("userID")) {
                        String userID = System.getProperty("user.name", "");
                        parms.put("userID", userID);
                    }
                    URL chanDefTableURL = new URL(this.channelDefTable);
                    this.queueManager = new MQQueueManager(this.queueManagerName, parms, chanDefTableURL);
                    if (Trace.isTracing) {
                        t.data(65, "DmMQQueueManager.createConnection", 300, "Using channel definition table to connect to : " + this.queueManagerName);
                    }
                    break;
                }
                default: {
                    if (Trace.isTracing) {
                        t.data(65, "DmMQQueueManager.createConnection", 900, "Unknown connection type : " + this.connectionType);
                    }
                    break;
                }
            }
        }
        catch (MQException e) {
            if (Trace.isTracing) {
                t.data(65, "DmMQQueueManager.createConnection", 900, "Error creating MQQueueManager to : " + this.queueManagerName);
                t.data(65, "DmMQQueueManager.createConnection", 900, e.toString());
            }
            this.errorMessage = e.getMessage();
            this.reasonCode = e.reasonCode;
            this.completionCode = e.completionCode;
            this.queueManager = null;
        }
        catch (MalformedURLException me) {
            if (Trace.isTracing) {
                t.data(65, "DmMQQueueManager.createConnection", 900, "Error creating URL to : " + this.queueManagerName);
                t.data(65, "DmMQQueueManager.createConnection", 900, me.toString());
            }
            this.errorMessage = me.getMessage();
            this.reasonCode = 50013;
            this.completionCode = 2;
            this.queueManager = null;
        }
        catch (DmCoreException e) {
            if (Trace.isTracing) {
                t.data(65, "DmMQQueueManager.createConnection", 900, "Error creating MQQueueManager to : " + this.queueManagerName);
                t.data(65, "DmMQQueueManager.createConnection", 900, e.toString());
            }
            this.errorMessage = e.getMessage();
            this.reasonCode = e.getReasonCode();
            this.completionCode = e.getCompCode();
            this.queueManager = null;
        }
        return this.queueManager;
    }

    public String getErrorMessage(Trace t) {
        return this.errorMessage;
    }

    public int getReasonCode(Trace t) {
        return this.reasonCode;
    }

    public int getCompletionCode(Trace t) {
        return this.completionCode;
    }

    public void setConnHandle(QueueManagerHandle qmHandle) {
        this.connHandle = qmHandle;
    }
}

