/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.PCFAction;
import java.util.ArrayList;
import java.util.HashMap;
import org.osgi.framework.Bundle;

public class DmListener
extends DmObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/objects/DmListener.java";
    protected static final String DEFAULT_TCP = "SYSTEM.DEFAULT.LISTENER.TCP";
    protected static final String DEFAULT_LU62 = "SYSTEM.DEFAULT.LISTENER.LU62";
    protected static final String DEFAULT_NETBIOS = "SYSTEM.DEFAULT.LISTENER.NETBIOS";
    protected static final String DEFAULT_SPX = "SYSTEM.DEFAULT.LISTENER.SPX";
    private static HashMap<Integer, AttrType> allAttributesByType = null;

    protected DmListener(Trace t, String nn) {
        super(nn, 97);
    }

    public static boolean staticInit(Trace t, Bundle bund) {
        allAttributesByType = DmListener.initAllAttrTypeTable(t, DmListener.getClassName(DmListener.class.getName()), allAttributesByType, bund);
        if (allAttributesByType == null) {
            if (Trace.isTracing) {
                t.data(65, "DmListener.staticInit", 900, "Error loading allAttributesByType table");
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean init(Trace t) {
        this.addAttr(t, this.attributesByType, 3554, 0, this.getTitle());
        this.addAttr(t, this.attributesByType, 1599, 0, 0);
        return true;
    }

    public static String getAttributeTitle(Trace t, int id) {
        return DmListener.getAttributeTitle(t, allAttributesByType, id);
    }

    public static AttrType getAttributeType(Trace t, int id) {
        return DmListener.getAttributeType(t, allAttributesByType, id);
    }

    public static String getAttributeDefaultValue(Trace t, int id) {
        return DmListener.getAttributeDefaultValue(t, allAttributesByType, id);
    }

    public static int[] getDisplayColumnSequence(Trace t, int[] ids, boolean zOS) {
        return DmListener.getDisplayColumnSequence(t, allAttributesByType, ids, zOS);
    }

    public static boolean isAttributeRepeating(Trace t, int id) {
        return DmListener.isAttributeRepeating(t, allAttributesByType, id);
    }

    public static int[] getAllAttributesByType(Trace t) {
        return DmListener.getAllAttributesByType(t, allAttributesByType);
    }

    @Override
    public String toString(Trace t) {
        return this.getTitle();
    }

    @Override
    public void close(Trace t) {
    }

    @Override
    public int actionDelete(Trace t, DmActionListener listener, Object parms) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmListener.actionDelete", 300, "Deleting listener " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 96, this);
        cmd.getRequest(t).addParameter(3554, this.getTitle());
        rc = cmd.execute(t, listener, 2);
        return rc;
    }

    @Override
    public int actionCreate(Trace t, DmActionListener listener, Object job) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmListener.actionCreate", 300, "Creating listener " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 94, this);
        cmd.getRequest(t).addParameter(3124, this.getClonedFrom());
        cmd.getRequest(t).addParameter(3125, this.getTitle());
        this.mergeNewWithChangesToPCFRequest(t, job, cmd.getRequest(t));
        rc = cmd.execute(t, listener);
        return rc;
    }

    @Override
    public int actionChange(Trace t, DmActionListener listener, Object job, boolean force) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmListener.actionChange", 300, "Changing listener " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 93, this);
        cmd.getRequest(t).addParameter(3554, this.getTitle());
        int type = (Integer)((AttrInt)this.getAttribute(t, 1501, 0)).getValue(t);
        cmd.getRequest(t).addParameter(1501, type);
        this.appendToPCFRequest(t, job, cmd.getRequest(t));
        this.endUpdate(t, job);
        rc = cmd.execute(t, listener);
        return rc;
    }

    public int actionStart(Trace t, DmActionListener listener) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmListener.actionStart", 300, "Starting listener " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 31, this);
        cmd.getRequest(t).addParameter(3554, this.getTitle());
        rc = cmd.execute(t, listener);
        return rc;
    }

    public int actionStop(Trace t, DmActionListener listener) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmListener.actionStop", 300, "Stopping listener " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 142, this);
        cmd.getRequest(t).addParameter(3554, this.getTitle());
        rc = cmd.execute(t, listener);
        return rc;
    }

    @Override
    public boolean isSystemDefault(Trace t) {
        boolean retValue = false;
        int type = (Integer)((AttrInt)this.getAttribute(t, 1501, 0)).getValue(t);
        switch (type) {
            case 2: {
                if (!this.getTitle().equals(DEFAULT_TCP)) break;
                retValue = true;
                break;
            }
            case 1: {
                if (!this.getTitle().equals(DEFAULT_LU62)) break;
                retValue = true;
                break;
            }
            case 3: {
                if (!this.getTitle().equals(DEFAULT_NETBIOS)) break;
                retValue = true;
                break;
            }
            case 4: {
                if (!this.getTitle().equals(DEFAULT_SPX)) break;
                retValue = true;
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(65, "DmListener.isSystemDefault", 900, "Unknown Listener type : " + type + " for " + this.getTitle());
            }
        }
        return retValue;
    }

    public static String getDefaultName(Trace t, int subType) {
        String retValue = null;
        switch (subType) {
            case 2: {
                retValue = DEFAULT_TCP;
                break;
            }
            case 3: {
                retValue = DEFAULT_NETBIOS;
                break;
            }
            case 1: {
                retValue = DEFAULT_LU62;
                break;
            }
            case 4: {
                retValue = DEFAULT_SPX;
                break;
            }
            default: {
                if (Trace.isTracing) {
                    t.data(65, "DmListener.getDefaultName", 900, "Unknown Listener sub-type : " + subType);
                }
                retValue = "[not_found]";
            }
        }
        return retValue;
    }

    @Override
    public int[] getMandatoryIds(Trace t) {
        return DmListener.getMandatoryIds(this.getObjectSubType(t));
    }

    public static int[] getMandatoryIds(int subType) {
        return new int[]{3554, 1501};
    }

    @Override
    public int getStatusType(Trace t) {
        return this.getQueueManager().getStatusType(t, 97, 0);
    }

    public DmObject updateStatus(Trace t, ArrayList list, int action) {
        int i = 0;
        while (i < list.size()) {
            DmObject object = (DmObject)list.get(i);
            Attr attr1 = object.getAttribute(t, 3554, 0);
            if (attr1 != null) {
                Attr attr2;
                String value = (String)attr1.getValue(t);
                if (this.getTitle().equals(value) && (attr2 = object.getAttribute(t, 1599, 0)) != null) {
                    Integer status = (Integer)attr2.getValue(t);
                    this.addAttr(t, this.attributesByType, 1599, 0, status);
                }
            }
            ++i;
        }
        return this;
    }

    public boolean isStarted(Trace t) {
        boolean running;
        block4: {
            running = false;
            Attr a = this.getAttribute(t, 1599, 0);
            if (a != null) {
                try {
                    int i = (Integer)a.getValue(t);
                    if (i == 2) {
                        running = true;
                    }
                }
                catch (Exception e) {
                    if (!Trace.isTracing) break block4;
                    t.data(65, "DmListener.isStarted", 900, "Error getting CMQCFC.MQIACH_LISTENER_STATUS : " + e.toString());
                }
            }
        }
        return running;
    }

    @Override
    public int getObjectSubType(Trace t) {
        int type = -2;
        AttrInt attr = (AttrInt)this.getAttribute(t, 1501, 0);
        if (attr != null) {
            type = (Integer)attr.getValue(t);
        }
        return type;
    }

    @Override
    public int[] getObjectSubTypes(Trace t) {
        return this.getObjectSubTypes(t, this.attributesByType, 1501);
    }

    @Override
    public void initialize(Trace t) {
        this.setName(t, 3554);
    }

    public static int[] getValidAuthorities(Trace t) {
        return DmListener.getValidAuthorities(t, allAttributesByType);
    }

    @Override
    public int getNameAttributeId() {
        return 3554;
    }
}

