/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.PCFAction;
import java.util.HashMap;
import org.osgi.framework.Bundle;

public class DmDistQueueManagementListener
extends DmObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/objects/DmDistQueueManagementListener.java";
    private static final String DEFAULT_IPADDR = "*";
    private static HashMap<Integer, AttrType> allAttributesByType = null;

    protected DmDistQueueManagementListener(Trace t, String name) {
        super(name, 1015);
    }

    public static boolean staticInit(Trace t, Bundle bund) {
        allAttributesByType = DmDistQueueManagementListener.initAllAttrTypeTable(t, DmDistQueueManagementListener.getClassName(DmDistQueueManagementListener.class.getName()), allAttributesByType, bund);
        if (allAttributesByType == null) {
            if (Trace.isTracing) {
                t.data(65, "DmDistQueueManagementListener.staticInit", 900, "Error loading allAttributesByType table");
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean init(Trace t) {
        return true;
    }

    public static String getAttributeTitle(Trace t, int id) {
        return DmDistQueueManagementListener.getAttributeTitle(t, allAttributesByType, id);
    }

    public static AttrType getAttributeType(Trace t, int id) {
        return DmDistQueueManagementListener.getAttributeType(t, allAttributesByType, id);
    }

    public static String getAttributeDefaultValue(Trace t, int id) {
        return DmDistQueueManagementListener.getAttributeDefaultValue(t, allAttributesByType, id);
    }

    public static int[] getDisplayColumnSequence(Trace t, int[] ids, boolean zOS) {
        return DmDistQueueManagementListener.getDisplayColumnSequence(t, allAttributesByType, ids, zOS);
    }

    public static boolean isAttributeRepeating(Trace t, int id) {
        return DmDistQueueManagementListener.isAttributeRepeating(t, allAttributesByType, id);
    }

    public static int[] getAllAttributesByType(Trace t) {
        return DmDistQueueManagementListener.getAllAttributesByType(t, allAttributesByType);
    }

    @Override
    public String toString(Trace t) {
        return this.getTitle();
    }

    @Override
    public void close(Trace t) {
    }

    @Override
    public int actionCreate(Trace t, DmActionListener listener, Object job) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmDistQueueManagementListener.actionCreate", 300, "Starting channel listener " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 31, this);
        int protocol = this.getObjectSubType(t);
        cmd.getRequest(t).addParameter(1501, protocol);
        this.appendToPCFRequest(t, job, cmd.getRequest(t));
        rc = cmd.execute(t, listener);
        return rc;
    }

    public int actionStart(Trace t, DmActionListener listener) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmDistQueueManagementListener.actionStart", 300, "Starting channel listener " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 31, this);
        int protocol = this.getObjectSubType(t);
        cmd.getRequest(t).addParameter(1501, protocol);
        int inBoundDisp = this.getInboundDisposition(t);
        cmd.getRequest(t).addParameter(1581, inBoundDisp);
        switch (protocol) {
            case 2: {
                String ipAddress = this.getAttributeValue(t, 3552, 0);
                if (!"[not_found]".equals(ipAddress) && !DEFAULT_IPADDR.equals(ipAddress)) {
                    cmd.getRequest(t).addParameter(3552, ipAddress);
                }
                int port = this.getPort(t);
                cmd.getRequest(t).addParameter(1574, port);
                break;
            }
            case 1: {
                String luName = this.getAttributeValue(t, 3551, 0);
                if ("[not_found]".equals(luName)) break;
                cmd.getRequest(t).addParameter(3551, luName);
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(65, "DmDistQueueManagementListener.actionStart", 900, "Unsupported transmit protocol " + protocol);
            }
        }
        rc = cmd.execute(t, listener);
        return rc;
    }

    public int actionStop(Trace t, DmActionListener listener) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmDistQueueManagementListener.actionStop", 300, "Stopping channel listener " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 142, this);
        int protocol = this.getObjectSubType(t);
        cmd.getRequest(t).addParameter(1501, protocol);
        int inBoundDisp = this.getInboundDisposition(t);
        cmd.getRequest(t).addParameter(1581, inBoundDisp);
        switch (protocol) {
            case 2: {
                String ipAddress = this.getAttributeValue(t, 3552, 0);
                if (!"[not_found]".equals(ipAddress) && !DEFAULT_IPADDR.equals(ipAddress)) {
                    cmd.getRequest(t).addParameter(3552, ipAddress);
                }
                int port = this.getPort(t);
                cmd.getRequest(t).addParameter(1574, port);
                break;
            }
            case 1: {
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(65, "DmDistQueueManagementListener.actionStop", 900, "Unsupported transmit protocol " + protocol);
            }
        }
        rc = cmd.execute(t, listener);
        return rc;
    }

    public boolean isStarted(Trace t) {
        boolean running;
        block4: {
            running = false;
            Attr a = this.getAttribute(t, 1599, 0);
            if (a != null) {
                try {
                    int i = (Integer)a.getValue(t);
                    if (i == 2) {
                        running = true;
                    }
                }
                catch (Exception e) {
                    if (!Trace.isTracing) break block4;
                    t.data(65, "DmDistQueueManagementListener.isStarted", 900, "Error getting CMQCFC.MQIACH_LISTENER_STATUS : " + e.toString());
                }
            }
        }
        return running;
    }

    @Override
    public int getObjectSubType(Trace t) {
        int type = -2;
        AttrInt attr = (AttrInt)this.getAttribute(t, 1501, 0);
        if (attr != null) {
            type = (Integer)attr.getValue(t);
        }
        return type;
    }

    private int getInboundDisposition(Trace t) {
        int type = -99;
        AttrInt attr = (AttrInt)this.getAttribute(t, 1581, 0);
        if (attr != null) {
            type = (Integer)attr.getValue(t);
        }
        return type;
    }

    private int getPort(Trace t) {
        int type = -2;
        AttrInt attr = (AttrInt)this.getAttribute(t, 1574, 0);
        if (attr != null) {
            type = (Integer)attr.getValue(t);
        }
        return type;
    }

    @Override
    public boolean isSystemDefault(Trace t) {
        return false;
    }

    @Override
    public int[] getObjectSubTypes(Trace t) {
        return this.getObjectSubTypes(t, this.attributesByType, 1501);
    }

    public static int[] getMandatoryIds() {
        return new int[0];
    }

    @Override
    public void initializeWithDefaults(Trace t) {
        Object value = null;
        AttrType attrType = null;
        attrType = DmDistQueueManagementListener.getAttributeType(t, allAttributesByType, 1581);
        if (attrType != null && (value = attrType.getDefaultValue(t)) != null) {
            this.addAttr(t, this.attributesByType, 1581, 0, value);
        }
        int protocol = this.getObjectSubType(t);
        switch (protocol) {
            case 2: {
                attrType = DmDistQueueManagementListener.getAttributeType(t, allAttributesByType, 3552);
                if (attrType != null && (value = attrType.getDefaultValue(t)) != null) {
                    this.addAttr(t, this.attributesByType, 3552, 0, value);
                }
                if ((attrType = DmDistQueueManagementListener.getAttributeType(t, allAttributesByType, 1574)) == null || (value = attrType.getDefaultValue(t)) == null) break;
                this.addAttr(t, this.attributesByType, 1574, 0, value);
                break;
            }
            case 1: {
                attrType = DmDistQueueManagementListener.getAttributeType(t, allAttributesByType, 3551);
                if (attrType == null || (value = attrType.getDefaultValue(t)) == null) break;
                this.addAttr(t, this.attributesByType, 3551, 0, value);
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(65, "DmDistQueueManagementListener.initializeWithDefaults", 900, "Unsupported transmit protocol " + protocol);
            }
        }
    }

    @Override
    public int[] getMandatoryIds(Trace t) {
        int subType = this.getObjectSubType(t);
        switch (subType) {
            case 1: {
                return new int[]{3551};
            }
        }
        return DmDistQueueManagementListener.getMandatoryIds();
    }
}

