/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.PCFAction;
import java.util.HashMap;
import org.osgi.framework.Bundle;

public class DmCommInfo
extends DmObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/objects/DmCommInfo.java";
    protected static final String DEFAULT_MULTICAST = "SYSTEM.DEFAULT.COMMINFO.MULTICAST";
    private static HashMap<Integer, AttrType> allAttributesByType = null;

    protected DmCommInfo(Trace t, String an) {
        super(an, 191);
    }

    public static boolean staticInit(Trace t, Bundle bund) {
        allAttributesByType = DmCommInfo.initAllAttrTypeTable(t, DmCommInfo.getClassName(DmCommInfo.class.getName()), allAttributesByType, bund);
        if (allAttributesByType == null) {
            if (Trace.isTracing) {
                t.data(65, "DmCommInfo.staticInit", 900, "Error loading allAttributesByType table");
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean init(Trace t) {
        this.addAttr(t, this.attributesByType, 2110, 0, this.getTitle());
        return true;
    }

    public static String getAttributeTitle(Trace t, int id) {
        return DmCommInfo.getAttributeTitle(t, allAttributesByType, id);
    }

    public static AttrType getAttributeType(Trace t, int id) {
        return DmCommInfo.getAttributeType(t, allAttributesByType, id);
    }

    public static String getAttributeDefaultValue(Trace t, int id) {
        return DmCommInfo.getAttributeDefaultValue(t, allAttributesByType, id);
    }

    public static int[] getDisplayColumnSequence(Trace t, int[] ids, boolean zOS) {
        return DmCommInfo.getDisplayColumnSequence(t, allAttributesByType, ids, zOS);
    }

    public static boolean isAttributeRepeating(Trace t, int id) {
        return DmCommInfo.isAttributeRepeating(t, allAttributesByType, id);
    }

    public static int[] getAllAttributesByType(Trace t) {
        return DmCommInfo.getAllAttributesByType(t, allAttributesByType);
    }

    @Override
    public String toString(Trace t) {
        return this.getTitle();
    }

    @Override
    public void close(Trace t) {
    }

    public int actionDelete(Trace t, DmActionListener listener) {
        return this.actionDelete(t, listener, null);
    }

    @Override
    public int actionDelete(Trace t, DmActionListener listener, Object parms) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmCommInfo.actionDelete", 300, "Deleting comminfo " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 194, this);
        cmd.getRequest(t).addParameter(2110, this.getTitle());
        this.addQSGDispToRequest(t, cmd);
        rc = cmd.execute(t, listener, 2);
        return rc;
    }

    @Override
    public int actionCreate(Trace t, DmActionListener listener, Object job) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmCommInfo.actionCreate", 300, "Creating comminfo " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 193, this);
        cmd.getRequest(t).addParameter(3177, this.getClonedFrom());
        cmd.getRequest(t).addParameter(3178, this.getTitle());
        int type = (Integer)((AttrInt)this.getAttribute(t, 223, 0)).getValue(t);
        cmd.getRequest(t).addParameter(223, type);
        this.mergeNewWithChangesToPCFRequest(t, job, cmd.getRequest(t));
        this.endUpdate(t, job);
        rc = cmd.execute(t, listener);
        return rc;
    }

    @Override
    public int actionChange(Trace t, DmActionListener listener, Object job, boolean force) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmCommInfo.actionChange", 300, "Changing comminfo " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 192, this);
        cmd.getRequest(t).addParameter(2110, this.getTitle());
        int type = (Integer)((AttrInt)this.getAttribute(t, 223, 0)).getValue(t);
        cmd.getRequest(t).addParameter(223, type);
        this.addQSGDispToRequest(t, cmd);
        this.appendToPCFRequest(t, job, cmd.getRequest(t));
        this.endUpdate(t, job);
        rc = cmd.execute(t, listener);
        return rc;
    }

    @Override
    public boolean isSystemDefault(Trace t) {
        boolean retValue = false;
        int type = (Integer)((AttrInt)this.getAttribute(t, 223, 0)).getValue(t);
        switch (type) {
            case 1: {
                if (!this.getTitle().equals(DEFAULT_MULTICAST)) break;
                retValue = true;
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(65, "DmCommInfo.isSystemDefault", 900, "Unknown comminfo type : " + type + " for " + this.getTitle());
            }
        }
        return retValue;
    }

    public static String getDefaultName(Trace t, int subType) {
        String retValue = null;
        switch (subType) {
            case 1: {
                retValue = DEFAULT_MULTICAST;
                break;
            }
            default: {
                if (Trace.isTracing) {
                    t.data(65, "DmCommInfo.getDefaultName", 900, "Unknown Comminfo sub-type : " + subType);
                }
                retValue = "[not_found]";
            }
        }
        return retValue;
    }

    @Override
    public int[] getMandatoryIds(Trace t) {
        int subType = this.getObjectSubType(t);
        return DmCommInfo.getMandatoryIds(subType);
    }

    public static int[] getMandatoryIds(int subType) {
        switch (subType) {
            case 1: {
                return new int[]{2110, 223};
            }
        }
        return new int[0];
    }

    @Override
    public void initialize(Trace t) {
        this.setName(t, 2110);
        Attr attr = this.getAttribute(t, 63, 0);
        if (attr != null) {
            attr.setReadWrite(t, false);
        }
    }

    public static int[] getValidAuthorities(Trace t) {
        return DmCommInfo.getValidAuthorities(t, allAttributesByType);
    }

    @Override
    public int getObjectSubType(Trace t) {
        int type = -2;
        AttrInt attr = (AttrInt)this.getAttribute(t, 223, 0);
        if (attr != null) {
            type = (Integer)attr.getValue(t);
        }
        if (Trace.isTracing) {
            t.data(65, "DmCommInfo.getObjectSubType", 300, "Sub-type for " + this.getTitle() + " is " + type);
        }
        return type;
    }

    @Override
    public int getNameAttributeId() {
        return 2110;
    }
}

