/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.PCFAction;
import java.util.HashMap;
import org.osgi.framework.Bundle;

public class DmClientChannel
extends DmObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/objects/DmClientChannel.java";
    protected static final String DEFAULT_CLNTCONN = "SYSTEM.DEF.CLNTCONN";
    private static HashMap<Integer, AttrType> allAttributesByType = null;

    protected DmClientChannel(Trace t, String cn) {
        super(cn, 1005);
    }

    public static boolean staticInit(Trace t, Bundle bund) {
        allAttributesByType = DmClientChannel.initAllAttrTypeTable(t, DmClientChannel.getClassName(DmClientChannel.class.getName()), allAttributesByType, bund);
        if (allAttributesByType == null) {
            if (Trace.isTracing) {
                t.data(65, "DmClientChannel.staticInit", 900, "Error loading allAttributesByType table");
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean init(Trace t) {
        this.addAttr(t, this.attributesByType, 3501, 0, this.getTitle());
        return true;
    }

    public static String getAttributeTitle(Trace t, int id) {
        return DmClientChannel.getAttributeTitle(t, allAttributesByType, id);
    }

    public static AttrType getAttributeType(Trace t, int id) {
        return DmClientChannel.getAttributeType(t, allAttributesByType, id);
    }

    public static String getAttributeDefaultValue(Trace t, int id) {
        return DmClientChannel.getAttributeDefaultValue(t, allAttributesByType, id);
    }

    public static int[] getDisplayColumnSequence(Trace t, int[] ids, boolean zOS) {
        return DmClientChannel.getDisplayColumnSequence(t, allAttributesByType, ids, zOS);
    }

    public static boolean isAttributeRepeating(Trace t, int id) {
        return DmClientChannel.isAttributeRepeating(t, allAttributesByType, id);
    }

    public static int[] getAllAttributesByType(Trace t) {
        return DmClientChannel.getAllAttributesByType(t, allAttributesByType);
    }

    @Override
    public String toString(Trace t) {
        return this.getTitle();
    }

    @Override
    public void close(Trace t) {
    }

    public int actionDelete(Trace t, DmActionListener listener) {
        return this.actionDelete(t, listener, new int[]{2});
    }

    @Override
    public int actionDelete(Trace t, DmActionListener listener, Object parms) {
        int rc = 0;
        try {
            if (Trace.isTracing) {
                t.data(65, "DmClientChannel.actionDelete", 300, "Deleting channel " + this.getTitle());
            }
            PCFAction cmd = new PCFAction(t, 24, this);
            cmd.getRequest(t).addParameter(3501, this.getTitle());
            if (parms != null) {
                int channelTable = ((int[])parms)[0];
                cmd.getRequest(t).addParameter(1526, channelTable);
            } else {
                cmd.getRequest(t).addParameter(1526, 2);
            }
            rc = cmd.execute(t, listener, 2);
        }
        catch (ClassCastException classCastException) {
            if (Trace.isTracing) {
                t.data(65, "DmClientChannel.actionDelete", 900, "Invalid parameter type");
            }
            rc = 50009;
        }
        return rc;
    }

    @Override
    public int actionCreate(Trace t, DmActionListener listener, Object job) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmClientChannel.actionCreate", 300, "Creating channel " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 22, this);
        cmd.getRequest(t).addParameter(3007, this.getClonedFrom());
        cmd.getRequest(t).addParameter(3008, this.getTitle());
        int type = (Integer)((AttrInt)this.getAttribute(t, 1511, 0)).getValue(t);
        cmd.getRequest(t).addParameter(1511, type);
        this.mergeNewWithChangesToPCFRequest(t, job, cmd.getRequest(t));
        this.endUpdate(t, job);
        rc = cmd.execute(t, listener);
        return rc;
    }

    @Override
    public int actionChange(Trace t, DmActionListener listener, Object job, boolean force) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmClientChannel.actionChange", 300, "Changing channel " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 21, this);
        cmd.getRequest(t).addParameter(3501, this.getTitle());
        int type = this.getObjectSubType(t);
        cmd.getRequest(t).addParameter(1511, type);
        this.addQSGDispToRequest(t, cmd);
        this.appendToPCFRequest(t, job, cmd.getRequest(t));
        this.endUpdate(t, job);
        rc = cmd.execute(t, listener);
        return rc;
    }

    @Override
    public boolean isSystemDefault(Trace t) {
        boolean retValue = false;
        if (this.getTitle().equals(DEFAULT_CLNTCONN)) {
            retValue = true;
        }
        return retValue;
    }

    @Override
    public boolean isEnumerationIdValid(Trace t, int attrId, int enumId) {
        boolean retValue = false;
        block0 : switch (attrId) {
            case 1576: {
                switch (enumId) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 4: 
                    case 16: 
                    case 32: {
                        retValue = true;
                        break block0;
                    }
                }
                break;
            }
            case 1575: {
                switch (enumId) {
                    case 0: 
                    case 8: {
                        retValue = true;
                        break block0;
                    }
                }
            }
        }
        if (Trace.isTracing) {
            if (retValue) {
                t.data(65, "DmClientChannel.isEnumerationIdValid", 300, "Valid enumeration type : " + enumId + " for " + this.getTitle());
            } else {
                t.data(65, "DmClientChannel.isEnumerationIdValid", 900, "Invalid enumeration type : " + enumId + " for " + this.getTitle());
            }
        }
        return retValue;
    }

    public static String getDefaultName(Trace t, int subType) {
        return DEFAULT_CLNTCONN;
    }

    @Override
    public int[] getMandatoryIds(Trace t) {
        return DmClientChannel.getMandatoryIds(this.getObjectSubType(t));
    }

    public static int[] getMandatoryIds(int subType) {
        return new int[]{3501, 1511, 3506, 1501};
    }

    @Override
    public int getStatusType(Trace t) {
        int retValue = 0;
        int subType = this.getObjectSubType(t);
        retValue = this.getQueueManager().getStatusType(t, 25, subType);
        return retValue;
    }

    public boolean isRunning(Trace t) {
        boolean running;
        block4: {
            running = false;
            Attr a = this.getAttribute(t, 1527, 0);
            if (a != null) {
                try {
                    int i = (Integer)a.getValue(t);
                    if (i == 3) {
                        running = true;
                    }
                }
                catch (Exception e) {
                    if (!Trace.isTracing) break block4;
                    t.data(65, "DmClientChannel.isRunning", 900, "Error getting CMQCFC.MQIACH_CHANNEL_STATUS : " + e.toString());
                }
            }
        }
        return running;
    }

    @Override
    public int getObjectSubType(Trace t) {
        return 6;
    }

    @Override
    public void initialize(Trace t) {
        this.setName(t, 3501);
    }

    public static int[] getValidAuthorities(Trace t) {
        return DmClientChannel.getValidAuthorities(t, allAttributesByType);
    }

    @Override
    public int getNameAttributeId() {
        return 3501;
    }
}

