/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrKey;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.PCFAction;
import com.ibm.mq.explorer.core.internal.utils.ConvertReasonCode;
import com.ibm.mq.pcf.PCFMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import org.osgi.framework.Bundle;

public class DmChannelAuthenticationRecord
extends DmObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/objects/DmChannelAuthenticationRecord.java";
    protected static final String DEFAULT_BLOCKADDR = "*";
    protected static final String DEFAULT_BLOCKUSER = "SYSTEM.DEF.BLOCKUSER";
    protected static final String DEFAULT_SSLPEERMAP = "SYSTEM.DEF.SSLPEER";
    protected static final String DEFAULT_ADDRESSMAP = "SYSTEM.DEF.ADDRESS";
    protected static final String DEFAULT_USERMAP = "SYSTEM.DEF.USER";
    protected static final String DEFAULT_QMGRMAP = "SYSTEM.DEF.QMGR";
    protected static final String EMPTY_STRING = "";
    protected static final String NON_EMPTY_STRING = "{dummy}";
    private static HashMap<Integer, AttrType> allAttributesByType = null;

    protected DmChannelAuthenticationRecord(Trace t, String an) {
        super(an, 204);
    }

    public static boolean staticInit(Trace t, Bundle bund) {
        allAttributesByType = DmChannelAuthenticationRecord.initAllAttrTypeTable(t, DmChannelAuthenticationRecord.getClassName(DmChannelAuthenticationRecord.class.getName()), allAttributesByType, bund);
        if (allAttributesByType == null) {
            if (Trace.isTracing) {
                t.data(65, "DmChannelAuthenticationRecord.staticInit", 900, "Error loading allAttributesByType table");
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean init(Trace t) {
        this.addAttr(t, this.attributesByType, 3501, 0, this.getTitle());
        return true;
    }

    public static String getAttributeTitle(Trace t, int id) {
        return DmChannelAuthenticationRecord.getAttributeTitle(t, allAttributesByType, id);
    }

    public static AttrType getAttributeType(Trace t, int id) {
        return DmChannelAuthenticationRecord.getAttributeType(t, allAttributesByType, id);
    }

    public static String getAttributeDefaultValue(Trace t, int id) {
        return DmChannelAuthenticationRecord.getAttributeDefaultValue(t, allAttributesByType, id);
    }

    public static int[] getDisplayColumnSequence(Trace t, int[] ids, boolean zOS) {
        return DmChannelAuthenticationRecord.getDisplayColumnSequence(t, allAttributesByType, ids, zOS);
    }

    public static boolean isAttributeRepeating(Trace t, int id) {
        return DmChannelAuthenticationRecord.isAttributeRepeating(t, allAttributesByType, id);
    }

    public static int[] getAllAttributesByType(Trace t) {
        return DmChannelAuthenticationRecord.getAllAttributesByType(t, allAttributesByType);
    }

    @Override
    public String toString(Trace t) {
        return this.getTitle();
    }

    @Override
    public void close(Trace t) {
    }

    @Override
    public int getObjectSubType(Trace t) {
        int type = -2;
        AttrInt attr = (AttrInt)this.getAttribute(t, 1352, 0);
        if (attr != null) {
            type = (Integer)attr.getValue(t);
        }
        if (Trace.isTracing) {
            t.data(65, "DmChannelAuthenticationRecord.getObjectSubType", 300, "Type for " + this.getTitle() + " is " + type);
        }
        return type;
    }

    public int actionDelete(Trace t, DmActionListener listener) {
        return this.actionDelete(t, listener, null);
    }

    @Override
    public int actionDelete(Trace t, DmActionListener listener, Object parms) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmChannelAuthenticationRecord.actionDelete", 300, "Deleting channel authentication record " + this.getTitle());
        }
        String title = this.getTitle();
        int type = this.getObjectSubType(t);
        PCFAction cmd = new PCFAction(t, 203, this);
        cmd.getRequest(t).addParameter(3501, title);
        cmd.getRequest(t).addParameter(1352, type);
        this.addQSGDispToRequest(t, cmd);
        if (type != 1 && type != 2) {
            cmd.getRequest(t).addParameter(1086, 7);
            this.appendToChlAuthPCFRequest(t, type, 7, null, cmd.getRequest(t));
        } else {
            cmd.getRequest(t).addParameter(1086, 8);
        }
        rc = cmd.execute(t, listener);
        return rc;
    }

    @Override
    public int actionCreate(Trace t, DmActionListener listener, Object job) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmChannelAuthenticationRecord.actionCreate", 300, "Creating channel authentication record " + this.getTitle());
        }
        int type = this.getObjectSubType(t);
        String title = this.getTitle();
        PCFAction cmd = new PCFAction(t, 203, this);
        cmd.getRequest(t).addParameter(3501, title);
        cmd.getRequest(t).addParameter(1352, type);
        cmd.getRequest(t).addParameter(1086, 5);
        this.appendToChlAuthPCFRequest(t, type, 5, job, cmd.getRequest(t));
        this.endUpdate(t, job);
        rc = this.synchronousRunPCF(t, cmd, listener);
        return rc;
    }

    @Override
    public int actionChange(Trace t, DmActionListener listener, Object job, boolean force) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmChannelAuthenticationRecord.actionChange", 300, "Changing channel authentication record " + this.getTitle());
        }
        String title = this.getTitle();
        int type = this.getObjectSubType(t);
        PCFAction cmd = new PCFAction(t, 203, this);
        cmd.getRequest(t).addParameter(3501, title);
        cmd.getRequest(t).addParameter(1352, type);
        cmd.getRequest(t).addParameter(1086, 6);
        this.addQSGDispToRequest(t, cmd);
        this.appendToChlAuthPCFRequest(t, type, 6, job, cmd.getRequest(t));
        this.endUpdate(t, job);
        if (this.synchronousRunPCF(t, cmd, listener) == 0) {
            this.addAttrFromPCFResponse(t, cmd.getRequest(t));
        }
        return rc;
    }

    /*
     * Unable to fully structure code
     */
    public boolean appendToChlAuthPCFRequest(Trace t, int type, int action, Object job, PCFMessage request) {
        rc = true;
        try {
            allTable = this.getAttributesTable(t);
            updateTable = null;
            if (job != null) {
                updateTable = this.getUpdateTable(t, job);
            }
            k = allTable.keySet();
            block11: for (AttrKey ak : k) {
                attr = allTable.get(ak);
                id = ak.getAttributeID();
                at = attr.getAttrType();
                if (at.isPseudoPCF()) continue;
                t1 = null;
                switch (id) {
                    case 3527: {
                        t1 = this.getChlAuthAttributeValue(t, updateTable, 1638);
                        if (t1 == null || (Integer)t1 != 0 || action == 7) {
                            break;
                        }
                        ** GOTO lbl46
                    }
                    case 1639: {
                        t1 = this.getChlAuthAttributeValue(t, updateTable, 1638);
                        if (type != 1 && type != 2 && (t1 == null || (Integer)t1 != 1) || action == 7) {
                            break;
                        }
                        ** GOTO lbl46
                    }
                    case 258: {
                        t1 = this.getChlAuthAttributeValue(t, updateTable, 1638);
                        if (type == 1 || type == 2 || type == 6 || t1 != null && (Integer)t1 == 1 || action == 7 || this.getQueueManager().getCommandLevel() < 800) {
                            break;
                        }
                        ** GOTO lbl46
                    }
                    case 3506: {
                        t1 = this.getChlAuthAttributeValue(t, updateTable, 3506);
                        if (type == 1 || type == 2 || t1.toString().equalsIgnoreCase("")) {
                            break;
                        }
                        ** GOTO lbl46
                    }
                    case 2130: {
                        t1 = this.getChlAuthAttributeValue(t, updateTable, 2130);
                        if (type != 3 || t1 != null && t1.toString().equalsIgnoreCase("") || this.getQueueManager().getCommandLevel() < 800) {
                            break;
                        }
                        ** GOTO lbl46
                    }
                    case 1638: 
                    case 2118: 
                    case 2119: {
                        if (action == 7) {
                            break;
                        }
                        ** GOTO lbl46
                    }
                    case 1086: 
                    case 1352: 
                    case 2027: 
                    case 2028: 
                    case 3070: 
                    case 3501: 
                    case 7004: {
                        break;
                    }
lbl46:
                    // 7 sources

                    default: {
                        v1 = this.getChlAuthAttributeValue(t, updateTable, id);
                        if (v1 instanceof String) {
                            s1 = v1.toString();
                            if (s1.length() < 1) {
                                s1 = " ";
                            }
                            request.addParameter(id, s1);
                            break;
                        }
                        if (v1 instanceof ArrayList) {
                            arrayList = (ArrayList)v1;
                            sList = null;
                            if (arrayList.size() == 0) {
                                sList = new String[]{" "};
                            } else {
                                sList = new String[arrayList.size()];
                                j = 0;
                                while (j < arrayList.size()) {
                                    s1 = (String)arrayList.get(j);
                                    if (s1.length() < 1) {
                                        s1 = " ";
                                    }
                                    sList[j] = s1;
                                    ++j;
                                }
                            }
                            request.addParameter(id, this.padStringList(t, sList));
                            break;
                        }
                        if (!(v1 instanceof Integer)) continue block11;
                        request.addParameter(id, ((Integer)v1).intValue());
                    }
                }
            }
        }
        catch (Exception e) {
            if (Trace.isTracing) {
                t.data(65, "DmChannelAuthenticationRecord.appendToChlAuthPCFRequest", 900, "Unable to update PCF request for object " + this.getTitle() + "\n" + e);
            }
            rc = false;
        }
        return rc;
    }

    private int synchronousRunPCF(Trace t, PCFAction cmd, DmActionListener listener) {
        int rc = cmd.execute(t);
        int cmdId = cmd.getRequest(t).getCommand();
        int cc = cmd.getRequest(t).getCompCode();
        if (rc == 0) {
            if (listener != null) {
                listener.dmActionDone(new DmActionEvent(this, cmdId, rc));
            }
        } else if (listener != null) {
            String msg = ConvertReasonCode.getSystemMessage(t, this, cmdId, rc, cc);
            String msgId = CommonServices.getSystemMessageId((Trace)t, (int)rc);
            int severity = CommonServices.getSystemMessageSeverity((Trace)t, (String)msgId);
            DmCoreException dmCoreException = new DmCoreException(t, msg, msgId, rc, cc, severity);
            listener.dmActionDone(new DmActionEvent(this, cmdId, rc, dmCoreException));
        }
        return rc;
    }

    @Override
    public int[] getMandatoryIds(Trace t) {
        int type = this.getObjectSubType(t);
        return DmChannelAuthenticationRecord.getMandatoryIds(type);
    }

    public static int[] getMandatoryIds(int type) {
        int[] ids = null;
        switch (type) {
            case 1: {
                ids = new int[]{3501, 1352, 3568};
                break;
            }
            case 2: {
                ids = new int[]{3501, 1352, 3566};
                break;
            }
            case 3: {
                ids = new int[]{3501, 1352, 3545};
                break;
            }
            case 4: {
                ids = new int[]{3501, 1352, 3506};
                break;
            }
            case 5: {
                ids = new int[]{3501, 1352, 3567};
                break;
            }
            case 6: {
                ids = new int[]{3501, 1352, 2017};
                break;
            }
            default: {
                ids = new int[]{};
            }
        }
        return ids;
    }

    @Override
    public void initialize(Trace t) {
        this.setName(t, 3501);
        this.addPseudoChlAuthGroup(t);
        Attr attr = this.getAttribute(t, 63, 0);
        if (attr != null) {
            attr.setReadWrite(t, false);
        }
    }

    private void addPseudoChlAuthGroup(Trace t) {
        String combinedChlAuthGroup = EMPTY_STRING;
        Attr attr = this.getAttribute(t, 1638, 0);
        if (attr != null) {
            Integer usrcValue = (Integer)attr.getValue(t);
            if (usrcValue == 0) {
                combinedChlAuthGroup = this.getAttributeValue(t, 3527, 0);
            } else if (usrcValue == 1) {
                combinedChlAuthGroup = this.getAttributeValue(t, 1639, 0);
            } else if (usrcValue == 2) {
                combinedChlAuthGroup = NON_EMPTY_STRING;
            }
        }
        this.addAttr(t, this.attributesByType, 11601, 0, combinedChlAuthGroup);
        if (Trace.isTracing) {
            t.data(65, "DmChannelAuthenticationRecord.addPseudoChlAuthGroup", 300, "Added PARAM_CHLAUTH_CUSTOM_GROUP attribute for " + this.getTitle());
        }
    }

    @Override
    public int getNameAttributeId() {
        return 3501;
    }

    private Object getChlAuthAttributeValue(Trace t, Hashtable<AttrKey, Attr> update, int id) {
        Attr a;
        Object obj = null;
        if (obj == null && update != null) {
            Set<AttrKey> ku = update.keySet();
            for (AttrKey ak : ku) {
                if (ak.getAttributeID() != id) continue;
                Attr attr = update.get(ak);
                if (attr == null) break;
                if (attr.getAction(t) == 2) {
                    obj = attr.getNewValue(t);
                    break;
                }
                obj = attr.getValue(t);
                break;
            }
        }
        if (obj == null && (a = this.getAttribute(t, id, 0)) != null) {
            obj = a.getAction(t) == 2 ? a.getNewValue(t) : a.getValue(t);
        }
        return obj;
    }

    public static String getDefaultName(Trace t, int subType) {
        String defName = "[not_found]";
        switch (subType) {
            case 1: {
                defName = DEFAULT_BLOCKUSER;
                break;
            }
            case 2: {
                defName = DEFAULT_BLOCKADDR;
                break;
            }
            case 3: {
                defName = DEFAULT_SSLPEERMAP;
                break;
            }
            case 4: {
                defName = DEFAULT_ADDRESSMAP;
                break;
            }
            case 5: {
                defName = DEFAULT_USERMAP;
                break;
            }
            case 6: {
                defName = DEFAULT_QMGRMAP;
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(65, "DmChannelAuthenticationRecord.getDefaultName", 900, "Unknown channel authentication type : " + subType);
            }
        }
        return defName;
    }
}

