/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.core.internal.objects.PCFAction;
import java.util.ArrayList;
import java.util.HashMap;
import org.osgi.framework.Bundle;

public class DmChannel
extends DmObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/objects/DmChannel.java";
    protected static final String DEFAULT_CLUSRCVR = "SYSTEM.DEF.CLUSRCVR";
    protected static final String DEFAULT_CLUSSDR = "SYSTEM.DEF.CLUSSDR";
    protected static final String DEFAULT_RECEIVER = "SYSTEM.DEF.RECEIVER";
    protected static final String DEFAULT_REQUESTER = "SYSTEM.DEF.REQUESTER";
    protected static final String DEFAULT_SENDER = "SYSTEM.DEF.SENDER";
    protected static final String DEFAULT_SERVER = "SYSTEM.DEF.SERVER";
    protected static final String DEFAULT_SVRCONN = "SYSTEM.DEF.SVRCONN";
    protected static final String DEFAULT_CLNTCONN = "SYSTEM.DEF.CLNTCONN";
    protected static final String DEFAULT_AMQP = "SYSTEM.DEF.AMQP";
    private static HashMap<Integer, AttrType> allAttributesByType = null;

    protected DmChannel(Trace t, String cn) {
        super(cn, 25);
    }

    public DmChannel(String cn, int type) {
        super(cn, type);
    }

    public static boolean staticInit(Trace t, Bundle bund) {
        allAttributesByType = DmChannel.initAllAttrTypeTable(t, DmChannel.getClassName(DmChannel.class.getName()), allAttributesByType, bund);
        if (allAttributesByType == null) {
            if (Trace.isTracing) {
                t.data(65, "DmChannel.staticInit", 900, "Error loading allAttributesByType table");
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean init(Trace t) {
        this.addAttr(t, this.attributesByType, 3501, 0, this.getTitle());
        this.addAttr(t, this.attributesByType, 1527, 0, 0);
        return true;
    }

    public static String getAttributeTitle(Trace t, int id) {
        return DmChannel.getAttributeTitle(t, allAttributesByType, id);
    }

    public static AttrType getAttributeType(Trace t, int id) {
        return DmChannel.getAttributeType(t, allAttributesByType, id);
    }

    public static String getAttributeDefaultValue(Trace t, int id) {
        return DmChannel.getAttributeDefaultValue(t, allAttributesByType, id);
    }

    public static int[] getDisplayColumnSequence(Trace t, int[] ids, boolean zOS) {
        return DmChannel.getDisplayColumnSequence(t, allAttributesByType, ids, zOS);
    }

    public static boolean isAttributeRepeating(Trace t, int id) {
        return DmChannel.isAttributeRepeating(t, allAttributesByType, id);
    }

    public static int[] getAllAttributesByType(Trace t) {
        return DmChannel.getAllAttributesByType(t, allAttributesByType);
    }

    @Override
    public String toString(Trace t) {
        return this.getTitle();
    }

    @Override
    public void close(Trace t) {
    }

    public int actionStart(Trace t, DmActionListener listener) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmChannel.actionStart", 300, "Starting channel " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 28, this);
        cmd.getRequest(t).addParameter(3501, this.getTitle());
        rc = cmd.execute(t, listener);
        return rc;
    }

    public int actionStop(Trace t, DmActionListener listener) {
        return this.actionStop(t, listener, 1, 6, null, null);
    }

    public int actionStop(Trace t, DmActionListener listener, int mode, int state, String connName, String qmName) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmChannel.actionStop", 300, "Stopping channel " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 29, this);
        cmd.getRequest(t).addParameter(3501, this.getTitle());
        if (Trace.isTracing) {
            t.data(65, "DmChannel.actionStop", 300, "Stopping mode = " + mode);
        }
        cmd.getRequest(t).addParameter(1008, mode);
        if (this.isStopStateSupported(t)) {
            if (Trace.isTracing) {
                t.data(65, "DmChannel.actionStop", 300, "New state will be " + state);
            }
            cmd.getRequest(t).addParameter(1527, state);
        }
        if (connName != null) {
            cmd.getRequest(t).addParameter(3506, connName);
        }
        if (qmName != null) {
            cmd.getRequest(t).addParameter(2015, qmName);
        }
        rc = cmd.execute(t, listener);
        return rc;
    }

    public int actionPing(Trace t, DmActionListener listener) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmChannel.actionPing", 300, "Pinging channel " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 26, this);
        cmd.getRequest(t).addParameter(3501, this.getTitle());
        rc = cmd.execute(t, listener);
        return rc;
    }

    public int actionReset(Trace t, DmActionListener listener) {
        return this.actionReset(t, listener, 1);
    }

    public int actionReset(Trace t, DmActionListener listener, int sequenceNumber) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmChannel.actionReset", 300, "Resetting channel " + this.getTitle() + ", sequence number " + sequenceNumber);
        }
        PCFAction cmd = new PCFAction(t, 27, this);
        cmd.getRequest(t).addParameter(3501, this.getTitle());
        cmd.getRequest(t).addParameter(1514, sequenceNumber);
        rc = cmd.execute(t, listener);
        return rc;
    }

    public int actionPurge(Trace t, DmActionListener listener) {
        return this.actionPurge(t, listener, null);
    }

    public int actionPurge(Trace t, DmActionListener listener, String clientId) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmChannel.actionPurge", 300, "Purging channel " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 195, this);
        cmd.getRequest(t).addParameter(3501, this.getTitle());
        if (clientId != null) {
            cmd.getRequest(t).addParameter(3564, clientId);
        }
        rc = cmd.execute(t, listener);
        return rc;
    }

    public int actionResolve(Trace t, DmActionListener listener) {
        return this.actionReset(t, listener, 2);
    }

    public int actionResolve(Trace t, DmActionListener listener, int inDoubt) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmChannel.actionResolve", 300, "Resolving channel " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 39, this);
        cmd.getRequest(t).addParameter(3501, this.getTitle());
        cmd.getRequest(t).addParameter(1516, inDoubt);
        rc = cmd.execute(t, listener);
        return rc;
    }

    public int actionDelete(Trace t, DmActionListener listener) {
        return this.actionDelete(t, listener, new int[]{1});
    }

    @Override
    public int actionDelete(Trace t, DmActionListener listener, Object parms) {
        int rc = 0;
        int retries = 2;
        try {
            if (Trace.isTracing) {
                t.data(65, "DmChannel.actionDelete", 300, "Deleting channel " + this.getTitle());
            }
            PCFAction cmd = new PCFAction(t, 24, this);
            cmd.getRequest(t).addParameter(3501, this.getTitle());
            this.addQSGDispToRequest(t, cmd);
            if (parms != null) {
                int channelTable = ((int[])parms)[0];
                cmd.getRequest(t).addParameter(1526, channelTable);
            } else {
                cmd.getRequest(t).addParameter(1526, 1);
            }
            rc = cmd.execute(t, listener, 2);
            int retryCount = 0;
            while (rc == 4004 && retryCount < retries) {
                if (Trace.isTracing) {
                    t.data(65, "DmChannel.actionDelete", 300, "Retry deleting channel " + this.getTitle());
                }
                rc = cmd.execute(t, listener, 2);
                ++retryCount;
            }
        }
        catch (ClassCastException classCastException) {
            if (Trace.isTracing) {
                t.data(65, "DmChannel.actionDelete", 900, "Invalid parameter type");
            }
            rc = 50009;
        }
        return rc;
    }

    @Override
    public int actionCreate(Trace t, DmActionListener listener, Object job) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmChannel.actionCreate", 300, "Creating channel " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 22, this);
        cmd.getRequest(t).addParameter(3007, this.getClonedFrom());
        cmd.getRequest(t).addParameter(3008, this.getTitle());
        int type = (Integer)((AttrInt)this.getAttribute(t, 1511, 0)).getValue(t);
        cmd.getRequest(t).addParameter(1511, type);
        this.mergeNewWithChangesToPCFRequest(t, job, cmd.getRequest(t));
        this.endUpdate(t, job);
        rc = cmd.execute(t, listener);
        return rc;
    }

    @Override
    public int actionChange(Trace t, DmActionListener listener, Object job, boolean force) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmChannel.actionChange", 300, "Changing channel " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 21, this);
        cmd.getRequest(t).addParameter(3501, this.getTitle());
        int type = this.getObjectSubType(t);
        cmd.getRequest(t).addParameter(1511, type);
        this.addQSGDispToRequest(t, cmd);
        this.appendToPCFRequest(t, job, cmd.getRequest(t));
        this.endUpdate(t, job);
        rc = cmd.execute(t, listener);
        return rc;
    }

    @Override
    public boolean isSystemDefault(Trace t) {
        boolean retValue = false;
        int type = (Integer)((AttrInt)this.getAttribute(t, 1511, 0)).getValue(t);
        switch (type) {
            case 1: {
                if (!this.getTitle().equals(DEFAULT_SENDER)) break;
                retValue = true;
                break;
            }
            case 2: {
                if (!this.getTitle().equals(DEFAULT_SERVER)) break;
                retValue = true;
                break;
            }
            case 4: {
                if (!this.getTitle().equals(DEFAULT_REQUESTER)) break;
                retValue = true;
                break;
            }
            case 3: {
                if (!this.getTitle().equals(DEFAULT_RECEIVER)) break;
                retValue = true;
                break;
            }
            case 7: {
                if (!this.getTitle().equals(DEFAULT_SVRCONN)) break;
                retValue = true;
                break;
            }
            case 6: {
                if (!this.getTitle().equals(DEFAULT_CLNTCONN)) break;
                retValue = true;
                break;
            }
            case 9: {
                if (!this.getTitle().equals(DEFAULT_CLUSSDR)) break;
                retValue = true;
                break;
            }
            case 8: {
                if (!this.getTitle().equals(DEFAULT_CLUSRCVR)) break;
                retValue = true;
                break;
            }
            case 11: {
                if (!this.getTitle().equals(DEFAULT_AMQP)) break;
                retValue = true;
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(65, "DmChannel.isSystemDefault", 900, "Unknown channel type : " + type + " for " + this.getTitle());
            }
        }
        return retValue;
    }

    @Override
    public boolean isEnumerationIdValid(Trace t, int attrId, int enumId) {
        boolean retValue = true;
        int type = (Integer)((AttrInt)this.getAttribute(t, 1511, 0)).getValue(t);
        block0 : switch (type) {
            case 1: {
                block9 : switch (attrId) {
                    case 1646: {
                        switch (enumId) {
                            case 0: 
                            case 1: {
                                break block9;
                            }
                        }
                        retValue = false;
                    }
                }
                break;
            }
            case 2: {
                block15 : switch (attrId) {
                    case 1646: {
                        switch (enumId) {
                            case 0: 
                            case 1: {
                                break block15;
                            }
                        }
                        retValue = false;
                    }
                }
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                switch (attrId) {
                    case 1576: {
                        switch (enumId) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 4: 
                            case 16: 
                            case 32: {
                                break block0;
                            }
                        }
                        retValue = false;
                        break block0;
                    }
                    case 1575: {
                        switch (enumId) {
                            case 0: 
                            case 8: {
                                break block0;
                            }
                        }
                        retValue = false;
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                block31 : switch (attrId) {
                    case 1646: {
                        switch (enumId) {
                            case 0: 
                            case 2: {
                                break block31;
                            }
                        }
                        retValue = false;
                    }
                }
                break;
            }
            case 3: {
                switch (attrId) {
                    case 1576: {
                        switch (enumId) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 4: 
                            case 16: 
                            case 32: 
                            case 0xFFFFFFF: {
                                break block0;
                            }
                        }
                        retValue = false;
                        break block0;
                    }
                    case 1575: {
                        switch (enumId) {
                            case 0: 
                            case 8: {
                                break block0;
                            }
                        }
                        retValue = false;
                        break block0;
                    }
                    case 1646: {
                        switch (enumId) {
                            case 0: 
                            case 2: {
                                break block0;
                            }
                        }
                        retValue = false;
                        break block0;
                    }
                }
                break;
            }
            case 7: {
                switch (attrId) {
                    case 1576: {
                        switch (enumId) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 4: 
                            case 16: 
                            case 32: 
                            case 0xFFFFFFF: {
                                break block0;
                            }
                        }
                        retValue = false;
                        break block0;
                    }
                    case 1575: {
                        switch (enumId) {
                            case 0: 
                            case 8: {
                                break block0;
                            }
                        }
                        retValue = false;
                        break block0;
                    }
                    case 1508: {
                        switch (enumId) {
                            case 2: 
                            case 4: {
                                retValue = false;
                                break block0;
                            }
                        }
                        break block0;
                    }
                }
                break;
            }
            case 11: {
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(65, "DmChannel.isEnumerationIdValid", 900, "Unknown channel type : " + type + " for " + this.getTitle());
            }
        }
        if (Trace.isTracing) {
            if (retValue) {
                t.data(65, "DmChannel.isEnumerationIdValid", 300, "Valid enumeration type : " + enumId + " for " + this.getTitle());
            } else {
                t.data(65, "DmChannel.isEnumerationIdValid", 900, "Invalid enumeration type : " + enumId + " for " + this.getTitle());
            }
        }
        return retValue;
    }

    public static String getDefaultName(Trace t, int subType) {
        String retValue = null;
        switch (subType) {
            case 1: {
                retValue = DEFAULT_SENDER;
                break;
            }
            case 2: {
                retValue = DEFAULT_SERVER;
                break;
            }
            case 4: {
                retValue = DEFAULT_REQUESTER;
                break;
            }
            case 3: {
                retValue = DEFAULT_RECEIVER;
                break;
            }
            case 7: {
                retValue = DEFAULT_SVRCONN;
                break;
            }
            case 6: {
                retValue = DEFAULT_CLNTCONN;
                break;
            }
            case 9: {
                retValue = DEFAULT_CLUSSDR;
                break;
            }
            case 8: {
                retValue = DEFAULT_CLUSRCVR;
                break;
            }
            case 11: {
                retValue = DEFAULT_AMQP;
                break;
            }
            default: {
                if (Trace.isTracing) {
                    t.data(65, "DmChannel.getDefaultName", 900, "Unknown channel sub-type : " + subType);
                }
                retValue = "[not_found]";
            }
        }
        return retValue;
    }

    @Override
    public int[] getMandatoryIds(Trace t) {
        int subType = this.getObjectSubType(t);
        switch (subType) {
            case 8: {
                int trType = this.getTransportType(t);
                if (trType == 2) {
                    return new int[]{3501, 1511};
                }
                return DmChannel.getMandatoryIds(subType);
            }
        }
        return DmChannel.getMandatoryIds(subType);
    }

    public static int[] getMandatoryIds(int subType) {
        switch (subType) {
            case 1: {
                return new int[]{3501, 1511, 3506, 1501, 3505};
            }
            case 2: {
                return new int[]{3501, 1511, 1501, 3505};
            }
            case 9: {
                return new int[]{3501, 1511, 3506};
            }
            case 8: {
                return new int[]{3501, 1511, 3506};
            }
            case 6: {
                return new int[]{3501, 1511, 3506, 1501};
            }
            case 4: {
                return new int[]{3501, 1511, 3506, 1501};
            }
            case 3: {
                return new int[]{3501, 1511, 1501};
            }
            case 7: {
                return new int[]{3501, 1511, 1501};
            }
            case 11: {
                return new int[]{3501, 1511};
            }
        }
        return new int[0];
    }

    @Override
    public DmObject updateStatus(Trace t, ArrayList<IDmObject> list, int action) {
        int i = 0;
        while (i < list.size()) {
            DmObject object = (DmObject)list.get(i);
            Attr attr1 = object.getAttribute(t, 3501, 0);
            if (attr1 != null) {
                String value = (String)attr1.getValue(t);
                if (this.getTitle().equals(value)) {
                    switch (action) {
                        case 1: {
                            if (this.listOfStatus.contains(object)) {
                                this.listOfStatus.remove(object);
                            }
                            this.listOfStatus.add(object);
                            break;
                        }
                        case 4: {
                            if (this.listOfStatus.contains(object)) {
                                this.listOfStatus.remove(object);
                            }
                            this.listOfStatus.add(object);
                            break;
                        }
                        case 2: {
                            this.listOfStatus.remove(object);
                        }
                    }
                }
            }
            ++i;
        }
        this.updateOverallStatus(t);
        return this;
    }

    private void updateOverallStatus(Trace t) {
        switch (this.listOfStatus.size()) {
            case 0: {
                this.addAttr(t, this.attributesByType, 1527, 0, 0);
                break;
            }
            case 1: {
                DmObject object = (DmObject)this.listOfStatus.get(0);
                Attr attr = object.getAttribute(t, 1527, 0);
                if (attr == null) break;
                Integer status = (Integer)attr.getValue(t);
                this.addAttr(t, this.attributesByType, 1527, 0, status);
                break;
            }
            default: {
                Integer status = 0;
                DmObject object = (DmObject)this.listOfStatus.get(0);
                Attr attr = object.getAttribute(t, 1527, 0);
                if (attr != null) {
                    status = (Integer)attr.getValue(t);
                }
                int iStatus = status;
                int i = 1;
                while (i < this.listOfStatus.size()) {
                    object = (DmObject)this.listOfStatus.get(i);
                    attr = object.getAttribute(t, 1527, 0);
                    if (attr != null) {
                        status = (Integer)attr.getValue(t);
                        if (iStatus != status) {
                            iStatus = 12005;
                            break;
                        }
                        iStatus = status;
                    }
                    ++i;
                }
                this.addAttr(t, this.attributesByType, 1527, 0, iStatus);
            }
        }
    }

    @Override
    public int getStatusType(Trace t) {
        int retValue = 0;
        int subType = this.getObjectSubType(t);
        retValue = this.getQueueManager().getStatusType(t, 25, subType);
        return retValue;
    }

    public boolean isRunning(Trace t) {
        boolean running;
        block4: {
            running = false;
            Attr a = this.getAttribute(t, 1527, 0);
            if (a != null) {
                try {
                    int i = (Integer)a.getValue(t);
                    if (i == 3) {
                        running = true;
                    }
                }
                catch (Exception e) {
                    if (!Trace.isTracing) break block4;
                    t.data(65, "DmChannel.isRunning", 900, "Error getting CMQCFC.MQIACH_CHANNEL_STATUS : " + e.toString());
                }
            }
        }
        return running;
    }

    @Override
    public int getObjectSubType(Trace t) {
        int type = -2;
        AttrInt attr = (AttrInt)this.getAttribute(t, 1511, 0);
        if (attr != null) {
            type = (Integer)attr.getValue(t);
        }
        if (Trace.isTracing) {
            t.data(65, "DmChannel.getObjectSubType", 300, "Sub-type for " + this.getTitle() + " is " + type);
        }
        return type;
    }

    private int getTransportType(Trace t) {
        int type = -3;
        AttrInt attr = (AttrInt)this.getAttribute(t, 1501, 0);
        if (attr != null) {
            type = (Integer)attr.getValue(t);
        }
        if (Trace.isTracing) {
            t.data(65, "DmChannel.getTransportType", 300, "Transport-type for " + this.getTitle() + " is " + type);
        }
        return type;
    }

    @Override
    public int[] getObjectSubTypes(Trace t) {
        return this.getObjectSubTypes(t, this.attributesByType, 1511);
    }

    @Override
    public void initialize(Trace t) {
        this.setName(t, 3501);
        Attr attr = this.getAttribute(t, 63, 0);
        if (attr != null) {
            attr.setReadWrite(t, false);
        }
    }

    public boolean isStopStateSupported(Trace t) {
        boolean supported = false;
        if (this.queueManager.getCommandLevel() >= 530) {
            supported = true;
        }
        return supported;
    }

    public static int[] getValidAuthorities(Trace t) {
        return DmChannel.getValidAuthorities(t, allAttributesByType);
    }

    @Override
    public int getNameAttributeId() {
        return 3501;
    }
}

