/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmObjectLink;
import com.ibm.mq.explorer.core.internal.objects.PCFAction;
import com.ibm.mq.pcf.PCFMessage;
import java.util.ArrayList;
import java.util.HashMap;
import org.osgi.framework.Bundle;

public class DmAuthorityRecord
extends DmObjectLink {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/objects/DmAuthorityRecord.java";
    private static HashMap<Integer, AttrType> allAttributesByType = null;

    protected DmAuthorityRecord(Trace t, String nn) {
        super(nn, 87);
    }

    public static boolean staticInit(Trace t, Bundle bund) {
        allAttributesByType = DmAuthorityRecord.initAllAttrTypeTable(t, DmAuthorityRecord.getClassName(DmAuthorityRecord.class.getName()), allAttributesByType, bund);
        if (allAttributesByType == null) {
            if (Trace.isTracing) {
                t.data(65, "DmAuthorityRecord.staticInit", 900, "Error loading allAttributesByType table");
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean init(Trace t) {
        return true;
    }

    public static String getAttributeTitle(Trace t, int id) {
        return DmAuthorityRecord.getAttributeTitle(t, allAttributesByType, id);
    }

    public static AttrType getAttributeType(Trace t, int id) {
        return DmAuthorityRecord.getAttributeType(t, allAttributesByType, id);
    }

    public static String getAttributeDefaultValue(Trace t, int id) {
        return DmAuthorityRecord.getAttributeDefaultValue(t, allAttributesByType, id);
    }

    public static int[] getDisplayColumnSequence(Trace t, int[] ids, boolean zOS) {
        return DmAuthorityRecord.getDisplayColumnSequence(t, allAttributesByType, ids, zOS);
    }

    public static boolean isAttributeRepeating(Trace t, int id) {
        return DmAuthorityRecord.isAttributeRepeating(t, allAttributesByType, id);
    }

    public static int[] getAllAttributesByType(Trace t) {
        return DmAuthorityRecord.getAllAttributesByType(t, allAttributesByType);
    }

    @Override
    public String toString(Trace t) {
        return this.getTitle();
    }

    @Override
    public void close(Trace t) {
    }

    @Override
    public int actionDelete(Trace t, DmActionListener listener, Object parms) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmAuthorityRecord.actionDelete", 300, "Deleting authority record " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 89, this);
        cmd.getRequest(t).addParameter(3067, this.getTitle());
        this.addObjectTypeToRequest(t, cmd.getRequest(t));
        this.addEntityNameToRequest(t, cmd.getRequest(t));
        rc = cmd.execute(t, listener);
        return rc;
    }

    @Override
    public int actionCreate(Trace t, DmActionListener listener, Object job) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmAuthorityRecord.actionCreate", 300, "Creating authority record " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 90, this);
        cmd.getRequest(t).addParameter(3067, this.getTitle());
        this.addObjectTypeToRequest(t, cmd.getRequest(t));
        this.appendToPCFRequest(t, job, cmd.getRequest(t));
        this.endUpdate(t, job);
        rc = cmd.execute(t, listener);
        return rc;
    }

    @Override
    public int actionChange(Trace t, DmActionListener listener, Object job, boolean force) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmAuthorityRecord.actionChange", 300, "Changing authority record " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 90, this);
        cmd.getRequest(t).addParameter(3067, this.getTitle());
        this.addObjectTypeToRequest(t, cmd.getRequest(t));
        this.appendToPCFRequest(t, job, cmd.getRequest(t));
        this.endUpdate(t, job);
        rc = cmd.execute(t, listener);
        return rc;
    }

    @Override
    public void initialize(Trace t) {
        block7: {
            this.setName(t, 3067);
            Attr authListAttr = this.getAttribute(t, 1115, 0);
            Attr objectTypeAttr = this.getAttribute(t, 1016, 0);
            if (authListAttr != null && objectTypeAttr != null) {
                try {
                    int objectType = (Integer)objectTypeAttr.getValue(t);
                    int[] authority = this.getQueueManager().getValidAuthorities(t, objectType);
                    int i = 0;
                    while (i < authority.length) {
                        this.createAttr(t, authority[i], false);
                        ++i;
                    }
                    ArrayList listOfAuthorities = (ArrayList)authListAttr.getValue(t);
                    int i2 = 0;
                    while (i2 < listOfAuthorities.size()) {
                        int value = (Integer)listOfAuthorities.get(i2);
                        this.createAttr(t, value, true);
                        ++i2;
                    }
                    break block7;
                }
                catch (Exception exception) {
                    if (Trace.isTracing) {
                        t.data(65, "DmAuthorityRecord.initialize", 900, "Error getting list of authorities for " + this.getTitle());
                    }
                    break block7;
                }
            }
            if (Trace.isTracing) {
                t.data(65, "DmAuthorityRecord.initialize", 900, "Attribute authority list not defined for " + this.getTitle());
            }
        }
        this.addCumulativeName(t);
    }

    protected void createAttr(Trace t, int authority, boolean value) {
        block28: {
            try {
                switch (authority) {
                    case 0: 
                    case 14001: {
                        this.addAttr(t, this.attributesByType, 14001, 0, value);
                        break;
                    }
                    case 1: 
                    case 14002: {
                        this.addAttr(t, this.attributesByType, 14002, 0, value);
                        break;
                    }
                    case 2: 
                    case 14003: {
                        this.addAttr(t, this.attributesByType, 14003, 0, value);
                        break;
                    }
                    case 3: 
                    case 14004: {
                        this.addAttr(t, this.attributesByType, 14004, 0, value);
                        break;
                    }
                    case 4: 
                    case 14005: {
                        this.addAttr(t, this.attributesByType, 14005, 0, value);
                        break;
                    }
                    case 5: 
                    case 14006: {
                        this.addAttr(t, this.attributesByType, 14006, 0, value);
                        break;
                    }
                    case 6: 
                    case 14007: {
                        this.addAttr(t, this.attributesByType, 14007, 0, value);
                        break;
                    }
                    case 7: 
                    case 14008: {
                        this.addAttr(t, this.attributesByType, 14008, 0, value);
                        break;
                    }
                    case 8: 
                    case 14009: {
                        this.addAttr(t, this.attributesByType, 14009, 0, value);
                        break;
                    }
                    case 9: 
                    case 14010: {
                        this.addAttr(t, this.attributesByType, 14010, 0, value);
                        break;
                    }
                    case 10: 
                    case 14011: {
                        this.addAttr(t, this.attributesByType, 14011, 0, value);
                        break;
                    }
                    case 11: 
                    case 14012: {
                        this.addAttr(t, this.attributesByType, 14012, 0, value);
                        break;
                    }
                    case 12: 
                    case 14013: {
                        this.addAttr(t, this.attributesByType, 14013, 0, value);
                        break;
                    }
                    case 13: 
                    case 14014: {
                        this.addAttr(t, this.attributesByType, 14014, 0, value);
                        break;
                    }
                    case 14: 
                    case 14015: {
                        this.addAttr(t, this.attributesByType, 14015, 0, value);
                        break;
                    }
                    case 15: 
                    case 14016: {
                        this.addAttr(t, this.attributesByType, 14016, 0, value);
                        break;
                    }
                    case 16: 
                    case 14017: {
                        this.addAttr(t, this.attributesByType, 14017, 0, value);
                        break;
                    }
                    case 17: 
                    case 14018: {
                        this.addAttr(t, this.attributesByType, 14018, 0, value);
                        break;
                    }
                    case 18: 
                    case 14019: {
                        this.addAttr(t, this.attributesByType, 14019, 0, value);
                        break;
                    }
                    case 19: 
                    case 14031: {
                        this.addAttr(t, this.attributesByType, 14031, 0, value);
                        break;
                    }
                    case 20: 
                    case 14032: {
                        this.addAttr(t, this.attributesByType, 14032, 0, value);
                        break;
                    }
                    case 21: 
                    case 14033: {
                        this.addAttr(t, this.attributesByType, 14033, 0, value);
                        break;
                    }
                    case 22: 
                    case 14034: {
                        this.addAttr(t, this.attributesByType, 14034, 0, value);
                        break;
                    }
                    default: {
                        if (Trace.isTracing) {
                            t.data(65, "DmAuthorityRecord.createAttr", 900, "Unknown authority type " + authority);
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                if (!Trace.isTracing) break block28;
                t.data(65, "DmAuthorityRecord.createAttr", 900, "Error adding authority attribute (" + authority + ") for authority record " + authority);
            }
        }
    }

    private void addObjectTypeToRequest(Trace t, PCFMessage request) {
        block2: {
            try {
                Integer objectType = (Integer)this.getAttribute(t, 1016, 0).getValue(t);
                request.addParameter(1016, objectType.intValue());
            }
            catch (Exception e) {
                if (!Trace.isTracing) break block2;
                t.data(65, "DmAuthorityRecord.addObjectTypeToRequest", 900, "Error getting WMQ object type for " + this.getTitle() + "\n" + e);
            }
        }
    }

    private void addEntityNameToRequest(Trace t, PCFMessage request) {
        block7: {
            String[] n;
            block6: {
                try {
                    ArrayList names = (ArrayList)this.getAttribute(t, 3065, 0).getValue(t);
                    if (names != null && names.size() > 0) {
                        n = new String[names.size()];
                        names.toArray(n);
                        request.addParameter(3065, n);
                    }
                }
                catch (Exception exception) {
                    if (!Trace.isTracing) break block6;
                    t.data(65, "DmAuthorityRecord.addEntityNameToRequest", 900, "No principal entity names for " + this.getTitle());
                }
            }
            try {
                ArrayList groups = (ArrayList)this.getAttribute(t, 3066, 0).getValue(t);
                if (groups != null && groups.size() > 0) {
                    n = new String[groups.size()];
                    groups.toArray(n);
                    request.addParameter(3066, n);
                }
            }
            catch (Exception exception) {
                if (!Trace.isTracing) break block7;
                t.data(65, "DmAuthorityRecord.addEntityNameToRequest", 900, "No group entity names for " + this.getTitle());
            }
        }
    }

    public static int getRealAuthority(int id) {
        switch (id) {
            case 14001: {
                return 0;
            }
            case 14002: {
                return 1;
            }
            case 14003: {
                return 2;
            }
            case 14004: {
                return 3;
            }
            case 14005: {
                return 4;
            }
            case 14006: {
                return 5;
            }
            case 14007: {
                return 6;
            }
            case 14008: {
                return 7;
            }
            case 14009: {
                return 8;
            }
            case 14010: {
                return 9;
            }
            case 14011: {
                return 10;
            }
            case 14012: {
                return 11;
            }
            case 14013: {
                return 12;
            }
            case 14014: {
                return 13;
            }
            case 14015: {
                return 14;
            }
            case 14016: {
                return 15;
            }
            case 14017: {
                return 16;
            }
            case 14018: {
                return 17;
            }
            case 14019: {
                return 18;
            }
            case 14031: {
                return 19;
            }
            case 14032: {
                return 20;
            }
            case 14033: {
                return 21;
            }
            case 14034: {
                return 22;
            }
        }
        return id;
    }

    public static int[] getMandatoryIds() {
        return new int[]{3067, 3068, 1016, 1118, 1228, 1115};
    }

    public boolean addAttr(Trace t, int id, int repeatIndex, Object value) {
        return this.addAttr(t, allAttributesByType, id, repeatIndex, value);
    }

    private void addCumulativeName(Trace t) {
        String entityName = this.getAttributeValue(t, 3068, 0);
        String profileName = this.getAttributeValue(t, 3067, 0);
        String name = String.valueOf(entityName) + " (" + profileName + ")";
        this.addAttr(t, this.attributesByType, 14020, 0, name);
        if (Trace.isTracing) {
            t.data(65, "DmAuthorityRecord.addCumulativeName", 300, "Added OAM_CUMULATIVE_NAME attribute for " + this.getTitle());
        }
    }

    public String getEntityName(Trace t) {
        String eName = "[not_defined]";
        eName = this.getAttributeValue(t, 3068, 0);
        if (Trace.isTracing) {
            t.data(65, "DmAuthorityRecord.getEntityName", 300, "Entity name is " + eName);
        }
        return eName;
    }

    public int getEntityType(Trace t) {
        int eType;
        block4: {
            eType = -3;
            Attr objectTypeAttr = this.getAttribute(t, 1118, 0);
            if (objectTypeAttr != null) {
                try {
                    eType = (Integer)objectTypeAttr.getValue(t);
                }
                catch (Exception exception) {
                    if (!Trace.isTracing) break block4;
                    t.data(65, "DmAuthorityRecord.getEntityType", 900, "Error getting entity type for " + this.getTitle());
                }
            }
        }
        if (Trace.isTracing) {
            t.data(65, "DmAuthorityRecord.getEntityType", 300, "Entity type is " + eType);
        }
        return eType;
    }

    public String getProfileName(Trace t) {
        String pName = "[not_defined]";
        pName = this.getAttributeValue(t, 3067, 0);
        if (Trace.isTracing) {
            t.data(65, "DmAuthorityRecord.getProfileName", 300, "Profile name is " + pName);
        }
        return pName;
    }

    public int getProfileType(Trace t) {
        int pType;
        block4: {
            pType = -3;
            Attr objectTypeAttr = this.getAttribute(t, 1016, 0);
            if (objectTypeAttr != null) {
                try {
                    pType = (Integer)objectTypeAttr.getValue(t);
                }
                catch (Exception exception) {
                    if (!Trace.isTracing) break block4;
                    t.data(65, "DmAuthorityRecord.getProfileType", 900, "Error getting profile type for " + this.getTitle());
                }
            }
        }
        if (Trace.isTracing) {
            t.data(65, "DmAuthorityRecord.getProfileType", 300, "Profile type is " + pType);
        }
        return pType;
    }

    @Override
    public int getNameAttributeId() {
        return 3067;
    }
}

