/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.PCFAction;
import java.util.HashMap;
import org.osgi.framework.Bundle;

public class DmAuthinfo
extends DmObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/objects/DmAuthinfo.java";
    protected static final String DEFAULT_LDAP = "SYSTEM.DEFAULT.AUTHINFO.CRLLDAP";
    protected static final String DEFAULT_OCSP = "SYSTEM.DEFAULT.AUTHINFO.OCSP";
    protected static final String DEFAULT_IDPW_OS = "SYSTEM.DEFAULT.AUTHINFO.IDPWOS";
    protected static final String DEFAULT_IDPW_LDAP = "SYSTEM.DEFAULT.AUTHINFO.IDPWLDAP";
    private static HashMap<Integer, AttrType> allAttributesByType = null;

    protected DmAuthinfo(Trace t, String an) {
        super(an, 83);
    }

    public static boolean staticInit(Trace t, Bundle bund) {
        allAttributesByType = DmAuthinfo.initAllAttrTypeTable(t, DmAuthinfo.getClassName(DmAuthinfo.class.getName()), allAttributesByType, bund);
        if (allAttributesByType == null) {
            if (Trace.isTracing) {
                t.data(65, "DmAuthinfo.staticInit", 900, "Error loading allAttributesByType table");
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean init(Trace t) {
        this.addAttr(t, this.attributesByType, 2045, 0, this.getTitle());
        return true;
    }

    public static String getAttributeTitle(Trace t, int id) {
        return DmAuthinfo.getAttributeTitle(t, allAttributesByType, id);
    }

    public static AttrType getAttributeType(Trace t, int id) {
        return DmAuthinfo.getAttributeType(t, allAttributesByType, id);
    }

    public static String getAttributeDefaultValue(Trace t, int id) {
        return DmAuthinfo.getAttributeDefaultValue(t, allAttributesByType, id);
    }

    public static int[] getDisplayColumnSequence(Trace t, int[] ids, boolean zOS) {
        return DmAuthinfo.getDisplayColumnSequence(t, allAttributesByType, ids, zOS);
    }

    public static boolean isAttributeRepeating(Trace t, int id) {
        return DmAuthinfo.isAttributeRepeating(t, allAttributesByType, id);
    }

    public static int[] getAllAttributesByType(Trace t) {
        return DmAuthinfo.getAllAttributesByType(t, allAttributesByType);
    }

    @Override
    public String toString(Trace t) {
        return this.getTitle();
    }

    @Override
    public void close(Trace t) {
    }

    public int actionDelete(Trace t, DmActionListener listener) {
        return this.actionDelete(t, listener, null);
    }

    @Override
    public int actionDelete(Trace t, DmActionListener listener, Object parms) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmAuthinfo.actionDelete", 300, "Deleting authinfo " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 82, this);
        cmd.getRequest(t).addParameter(2045, this.getTitle());
        this.addQSGDispToRequest(t, cmd);
        rc = cmd.execute(t, listener, 2);
        return rc;
    }

    @Override
    public int actionCreate(Trace t, DmActionListener listener, Object job) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmAuthinfo.actionCreate", 300, "Creating authinfo " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 80, this);
        cmd.getRequest(t).addParameter(3009, this.getClonedFrom());
        cmd.getRequest(t).addParameter(3010, this.getTitle());
        int type = (Integer)((AttrInt)this.getAttribute(t, 66, 0)).getValue(t);
        cmd.getRequest(t).addParameter(66, type);
        this.mergeNewWithChangesToPCFRequest(t, job, cmd.getRequest(t));
        this.endUpdate(t, job);
        rc = cmd.execute(t, listener);
        return rc;
    }

    @Override
    public int actionChange(Trace t, DmActionListener listener, Object job, boolean force) {
        int rc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmAuthinfo.actionChange", 300, "Changing authinfo " + this.getTitle());
        }
        PCFAction cmd = new PCFAction(t, 79, this);
        cmd.getRequest(t).addParameter(2045, this.getTitle());
        int type = (Integer)((AttrInt)this.getAttribute(t, 66, 0)).getValue(t);
        cmd.getRequest(t).addParameter(66, type);
        this.addQSGDispToRequest(t, cmd);
        this.appendToPCFRequest(t, job, cmd.getRequest(t));
        this.endUpdate(t, job);
        rc = cmd.execute(t, listener);
        return rc;
    }

    @Override
    public boolean isSystemDefault(Trace t) {
        boolean retValue = false;
        int type = (Integer)((AttrInt)this.getAttribute(t, 66, 0)).getValue(t);
        switch (type) {
            case 1: {
                if (!this.getTitle().equals(DEFAULT_LDAP)) break;
                retValue = true;
                break;
            }
            case 2: {
                if (!this.getTitle().equals(DEFAULT_OCSP)) break;
                retValue = true;
                break;
            }
            case 3: {
                if (!this.getTitle().equals(DEFAULT_IDPW_OS)) break;
                retValue = true;
                break;
            }
            case 4: {
                if (!this.getTitle().equals(DEFAULT_IDPW_LDAP)) break;
                retValue = true;
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(65, "DmAuthinfo.isSystemDefault", 900, "Unknown authinfo type : " + type + " for " + this.getTitle());
            }
        }
        return retValue;
    }

    public static String getDefaultName(Trace t, int subType) {
        String retValue = null;
        switch (subType) {
            case 1: {
                retValue = DEFAULT_LDAP;
                break;
            }
            case 2: {
                retValue = DEFAULT_OCSP;
                break;
            }
            case 3: {
                retValue = DEFAULT_IDPW_OS;
                break;
            }
            case 4: {
                retValue = DEFAULT_IDPW_LDAP;
                break;
            }
            default: {
                if (Trace.isTracing) {
                    t.data(65, "DmAuthinfo.getDefaultName", 900, "Unknown Authinfo sub-type : " + subType);
                }
                retValue = "[not_found]";
            }
        }
        return retValue;
    }

    @Override
    public int[] getMandatoryIds(Trace t) {
        int subType = this.getObjectSubType(t);
        return DmAuthinfo.getMandatoryIds(subType);
    }

    public static int[] getMandatoryIds(int subType) {
        switch (subType) {
            case 1: {
                return new int[]{2045, 2053, 66};
            }
            case 2: {
                return new int[]{2045, 2109, 66};
            }
            case 3: {
                return new int[]{2045, 66};
            }
            case 4: {
                return new int[]{2045, 2053, 2127, 66};
            }
        }
        return new int[0];
    }

    @Override
    public void initialize(Trace t) {
        this.setName(t, 2045);
        Attr attr = this.getAttribute(t, 63, 0);
        if (attr != null) {
            attr.setReadWrite(t, false);
        }
    }

    public static int[] getValidAuthorities(Trace t) {
        return DmAuthinfo.getValidAuthorities(t, allAttributesByType);
    }

    @Override
    public int getObjectSubType(Trace t) {
        int type = -2;
        AttrInt attr = (AttrInt)this.getAttribute(t, 66, 0);
        if (attr != null) {
            type = (Integer)attr.getValue(t);
        }
        if (Trace.isTracing) {
            t.data(65, "DmAuthinfo.getObjectSubType", 300, "Sub-type for " + this.getTitle() + " is " + type);
        }
        return type;
    }

    @Override
    public int getNameAttributeId() {
        return 2045;
    }

    @Override
    public boolean isEnumerationIdValid(Trace t, int attrId, int enumId) {
        return true;
    }
}

