/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.event.DmMonitor;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.utils.CoreServices;
import java.util.ArrayList;

public class CreateDmQueueManager
extends Thread {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/objects/CreateDmQueueManager.java";
    private DmQueueManagerHandle handle = null;
    private Object notifyID = null;
    private static Object creationLock = new Object();

    public CreateDmQueueManager(Trace t, DmQueueManagerHandle dmqmh, Object id) {
        this.handle = dmqmh;
        this.notifyID = id;
        this.setDaemon(true);
        String qmName = dmqmh.getTitle();
        this.setName("IBM MQ creating : " + qmName);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Trace t = Trace.getInstance();
        String key = (String)this.notifyID;
        if (Trace.isTracing) {
            t.data(65, "CreateDmQueueManager.run", 300, "Creating new DmQueueManager called " + this.handle.getQueueManagerHandle(t).getQueueManagerName());
        }
        DmQueueManager qm = null;
        Object object = creationLock;
        synchronized (object) {
            qm = new DmQueueManager(t, this.handle, (String)this.notifyID);
            if (Trace.isTracing) {
                t.data(65, "CreateDmQueueManager.run", 300, "Add " + qm.getTitle() + " to list of queue managers");
            }
            if (Trace.isTracing) {
                t.data(65, "CreateDmQueueManager.run", 300, "Notifying listeners of " + qm.getTitle());
            }
            t.eventReceived("CreateDmQueueManager.run", 1, t.formatEventListenerData(t, (Object)this, null, "add", qm.getTitle(), "true"));
            if (key.startsWith("ALL")) {
                ArrayList<DmQueueManager> queueManagers;
                ArrayList<DmQueueManager> arrayList = queueManagers = CoreServices.getQueueManagers(t);
                synchronized (arrayList) {
                    queueManagers.add(qm);
                }
                DmMonitor.notifyAllQueueManagerListeners(t, qm, 1, qm.getException(t));
            } else {
                ArrayList<DmQueueManager> tempQueueManagers;
                ArrayList<DmQueueManager> arrayList = tempQueueManagers = CoreServices.getTempQueueManagers(t);
                synchronized (arrayList) {
                    tempQueueManagers.add(qm);
                }
                DmMonitor.notifyQueueManagerListener(t, qm, 1, qm.getException(t), true);
            }
        }
        if (qm.getException(t) == null) {
            boolean connected = qm.connectSynchronously(t, key);
            if (!connected && qm.isLocal(t)) {
                qm.reconnectAsynchronously(t);
            }
        } else {
            if (Trace.isTracing) {
                t.data(65, "CreateDmQueueManager.run", 900, "Connection not attempted - error creating DmQueueManager for " + qm.getTitle() + "\n" + qm.getException(t).toString());
            }
            if (key.startsWith("ALL")) {
                DmMonitor.notifyAllQueueManagerListeners(t, qm, 102, qm.getException(t));
            } else {
                DmMonitor.notifyQueueManagerListener(t, qm, 102, qm.getException(t), true);
            }
        }
    }

    public String toString(Trace t) {
        return super.toString();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + "@" + Integer.toHexString(this.hashCode());
    }
}

