/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;

public class AsyncDisconnectionFromQueueManager
extends Thread {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/objects/AsyncDisconnectionFromQueueManager.java";
    private DmQueueManager owner = null;
    private boolean active = false;
    private AsyncDisconnectionFromQueueManager myself = null;
    private int reasonCode = 0;

    public AsyncDisconnectionFromQueueManager(Trace t, DmQueueManager o, int rc) {
        this.owner = o;
        if (Trace.isTracing) {
            t.data(65, "AsyncDisconnectionFromQueueManager.AsyncDisconnectionFromQueueManager", 300, "Created AsyncDisconnectionFromQueueManager for " + this.owner.getTreeName(t));
        }
        this.myself = this;
        this.setName("IBM MQ disconnecting from " + this.owner.getTreeName(t));
        this.setDaemon(true);
        this.start();
    }

    @Override
    public void run() {
        Trace t = Trace.getInstance();
        this.active = true;
        if (Trace.isTracing) {
            t.data(65, "AsyncDisconnectionFromQueueManager.run", 300, "Async disconnect from " + this.owner.getTreeName(t));
        }
        this.owner.disconnect(t, true, false, this.reasonCode);
        this.active = false;
        if (Trace.isTracing) {
            t.data(65, "AsyncDisconnectionFromQueueManager.run", 300, "Async disconnect from " + this.owner.getTreeName(t) + " complete");
        }
    }

    public void stop(Trace t) {
        if (Trace.isTracing) {
            t.data(65, "AsyncDisconnectionFromQueueManager.stop", 300, "Connection thread active status is " + this.active);
        }
        if (this.active) {
            if (Trace.isTracing) {
                t.data(65, "AsyncDisconnectionFromQueueManager.stop", 300, "Interrupt sent");
            }
            this.myself.interrupt();
        }
    }
}

