/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.utils.CoreServices;
import com.ibm.mq.explorer.core.internal.utils.PersistQueueManagerHandles;

public class AsyncConnectionToQueueManager
extends Thread {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/objects/AsyncConnectionToQueueManager.java";
    private DmQueueManager owner = null;
    private String key = null;
    private boolean active = false;
    private AsyncConnectionToQueueManager myself = null;

    public AsyncConnectionToQueueManager(Trace t, DmQueueManager o, String k) {
        this.owner = o;
        this.key = k;
        this.myself = this;
        this.setName("IBM MQ connecting to " + this.owner.getTitle());
        this.setDaemon(true);
        this.start();
    }

    @Override
    public void run() {
        Trace t = Trace.getInstance();
        this.active = true;
        if (Trace.isTracing) {
            t.data(65, "AsyncConnectionToQueueManager.run", 300, "Making connection to " + this.owner.getTitle());
        }
        try {
            this.owner.init(t);
            this.owner.setConnectNow(t, false);
            boolean connected = this.owner.getMqQueueManager(t).isConnected();
            this.owner.setConnected(t, connected);
            if (Trace.isTracing) {
                t.data(65, "AsyncConnectionToQueueManager.run", 300, "Connection status to " + this.owner.getTitle() + " is " + connected);
            }
            this.owner.notifyListeners(t, 103, null, this.key);
            this.owner.setConnecting(t, false);
        }
        catch (DmCoreException dmce) {
            if (Trace.isTracing) {
                t.data(65, "AsyncConnectionToQueueManager.run", 300, "Connection to " + this.owner.getTitle() + " failed");
            }
            this.owner.setConnecting(t, false);
            this.owner.setConnected(t, false);
            this.owner.setConnectNow(t, false);
            this.owner.setException(t, dmce);
            if (dmce.getReasonCode() != 50045) {
                this.owner.notifyListeners(t, 102, dmce, this.key);
            }
        }
        catch (Exception exception) {
            if (Trace.isTracing) {
                t.data(65, "AsyncConnectionToQueueManager.run", 300, "Connection to " + this.owner.getTitle() + " failed");
            }
            this.owner.setConnected(t, false);
            this.owner.setConnectNow(t, false);
            dmce = this.owner.createException(t, 0, 50013, 2);
            this.owner.setException(t, dmce);
            this.owner.notifyListeners(t, 102, dmce, this.key);
        }
        this.active = false;
    }

    public void stop(Trace t) {
        if (Trace.isTracing) {
            t.data(65, "AsyncConnectionToQueueManager.stop", 300, "Connection thread active status is " + this.active);
        }
        if (this.active) {
            if (Trace.isTracing) {
                t.data(65, "AsyncConnectionToQueueManager.stop", 300, "Interrupt sent");
            }
            if (CoreServices.systemReset) {
                DmQueueManagerHandle dmqmh = this.owner.getConnectionHandle();
                dmqmh.getQueueManagerHandle(t).setAutoConnect(t, false);
                dmqmh.refreshAttributes(t);
                PersistQueueManagerHandles.add(t, dmqmh);
            }
            this.myself.interrupt();
        }
    }
}

