/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.event;

import com.ibm.mq.MQException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmCommonObjectView;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectSummaryEvent;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmObjectFactory;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.core.internal.objects.IDmObjectLink;
import com.ibm.mq.explorer.core.internal.objects.PCFAction;
import com.ibm.mq.explorer.core.internal.pcf.PCFCommands;
import com.ibm.mq.explorer.core.internal.trace.GenerateFFST;
import com.ibm.mq.explorer.core.internal.utils.ConvertReasonCode;
import com.ibm.mq.explorer.core.internal.utils.CoreServices;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.event.ErrorListener;
import com.ibm.mq.pcf.event.PCFEvent;
import com.ibm.mq.pcf.event.PCFFilter;
import com.ibm.mq.pcf.event.PCFListener;
import com.ibm.mq.pcf.event.PCFQuery;
import com.ibm.mq.pcf.event.PCFStatusEvent;
import com.ibm.mq.pcf.event.PCFSummaryEvent;
import java.util.ArrayList;

public class DmObjectView
extends DmCommonObjectView
implements PCFListener,
ErrorListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/event/DmObjectView.java";
    private DmObjectListener objectListener = null;
    private boolean active = false;
    private boolean sentFirstSummary = false;
    private PCFQuery currentStatusAMQPQuery = null;
    private PCFQuery savedStatusAMQPQuery = null;
    private PCFQuery clientidStatusAMQPQuery = null;

    public DmObjectView(Trace t, DmQueueManager qMgr, DmObjectListener listener, DmObjectFilter filter, boolean addStatus) {
        super(t, qMgr, filter);
        this.objectListener = listener;
        if (Trace.isTracing) {
            t.data(65, "DmObjectView.DmObjectView", 300, "Getting objects of type " + this.getDmObjectType(t) + "\n" + this.getObjectFilter(t).getQuery().toString());
        }
        if (this.addListener(t)) {
            if (addStatus) {
                int objectType = filter.getType();
                int statusObjectType = PCFAction.getStatusQueryObjectType(t, objectType);
                if (statusObjectType != -1) {
                    int statusType = this.getQueueManager(t).getStatusType(t, objectType, 0);
                    if (statusType != 0) {
                        this.addStatusListener(t, objectType, statusObjectType);
                    }
                } else if (Trace.isTracing) {
                    t.data(65, "DmObjectView.DmObjectView", 300, "No status associated with object type " + objectType);
                }
            } else if (Trace.isTracing) {
                t.data(65, "DmObjectView.DmObjectView", 300, "Status not requested");
            }
            this.refresh(t, false);
        }
    }

    private boolean addListener(Trace t) {
        block6: {
            try {
                t.eventListenerAdded("DmObjectView.addListener", 1, t.formatEventListenerData(t, (Object)this, (Object)this.objectListener, DmObject.getTypeName(t, this.getObjectFilter(t).getType())));
                this.getQueueManager(t).getPcfMonitorAgent(t).addErrorListener(t, (ErrorListener)this);
                this.active = true;
                this.getQueueManager(t).getPcfMonitorAgent(t).addPCFListener(t, (PCFListener)this, this.getObjectFilter(t).getQuery());
                if (this.getQueueManager(t).isAMPQSupported(t)) {
                    int objectType = this.getDmObjectType(t);
                    if (objectType == 1009) {
                        this.getQueueManager(t).getPcfMonitorAgent(t).addPCFListener(t, (PCFListener)this, this.getAMQPClientIdStatusQuery(t));
                    } else if (objectType == 1010) {
                        this.getQueueManager(t).getPcfMonitorAgent(t).addPCFListener(t, (PCFListener)this, this.getAMQPSavedStatusQuery(t));
                    }
                }
                this.report(t, this.getObjectFilter(t).getQuery());
            }
            catch (DmCoreException dmCoreException) {
                if (!Trace.isTracing) break block6;
                t.data(65, "DmObjectView.addListener", 900, "Error adding listener - PCFMonitorAgent not defined");
            }
        }
        return this.active;
    }

    private void addStatusListener(Trace t, int objectType, int statusObjectType) {
        block6: {
            try {
                this.setStatusQuery(t, PCFAction.getStatusQuery(t, this.getQueueManager(t).getUUID(), objectType, this.getObjectFilter(t).getName()));
                if (this.getStatusQuery(t) != null) {
                    t.eventListenerAdded("DmObjectView.addStatusListener", 1, t.formatEventListenerData(t, (Object)this, (Object)this.objectListener, DmObject.getTypeName(t, statusObjectType)));
                    this.setDmStatusObjectType(t, statusObjectType);
                    this.getQueueManager(t).getPcfMonitorAgent(t).addPCFListener(t, (PCFListener)this, this.getStatusQuery(t));
                    if (objectType == 25 && this.getQueueManager(t).isAMPQSupported(t)) {
                        if (statusObjectType == 1009) {
                            this.getQueueManager(t).getPcfMonitorAgent(t).addPCFListener(t, (PCFListener)this, this.getAMQPCurrentStatusQuery(t));
                        }
                        if (statusObjectType == 1010) {
                            this.getQueueManager(t).getPcfMonitorAgent(t).addPCFListener(t, (PCFListener)this, this.getAMQPSavedStatusQuery(t));
                        }
                    }
                    this.report(t, this.getStatusQuery(t));
                }
            }
            catch (DmCoreException dmCoreException) {
                if (!Trace.isTracing) break block6;
                t.data(65, "DmObjectView.addStatusListener", 900, "Error adding status listener - PCFMonitorAgent not defined");
            }
        }
    }

    public void removeListener(Trace t) {
        this.active = false;
        t.eventListenerRemoved("DmObjectView.removeListener", 1, t.formatEventListenerData(t, (Object)this, (Object)this.objectListener, DmObject.getTypeName(t, this.getObjectFilter(t).getType())));
        this.removePCFListener(t);
    }

    public void handleEvent(PCFEvent event) {
        Trace t = Trace.getInstance();
        ArrayList<IDmObject> list = this.getListOfObjects(t);
        DmObject object = this.getQueueManager(t);
        String title = object.getTitle();
        String key = object.getTitle();
        if (event.getObjectName() == null) {
            t.eventReceived("DmObjectView.handleEvent", 1, t.formatEventListenerData(t, (Object)this, (Object)this.objectListener, DmObjectEvent.getNotifyName(t, event.getType()), String.valueOf(object.getTitle()) + "(" + event.getCommand() + ")", Boolean.toString(event.isLast())));
        } else {
            t.eventReceived("DmObjectView.handleEvent", 1, t.formatEventListenerData(t, (Object)this, (Object)this.objectListener, DmObjectEvent.getNotifyName(t, event.getType()), String.valueOf(event.getObjectName().trim()) + "(" + event.getCommand() + ")", Boolean.toString(event.isLast())));
        }
        if (Trace.isTracing) {
            t.data(65, "DmObjectView.handleEvent", 300, "Event type " + DmObjectEvent.getNotifyName(t, event.getType()) + ", for " + event.getObjectName());
        }
        if (!this.getQueueManager(t).isConnected() || this.getQueueManager(t).isDisconnecting()) {
            if (Trace.isTracing) {
                t.data(65, "DmObjectView.handleEvent", 300, "Event ignored - queue manager " + this.getQueueManager(t).getTreeName(t) + " disconnected");
            }
            return;
        }
        int objectType = this.getDmObjectType(t);
        int eventObjectType = event.getCommand();
        if (Trace.isTracing) {
            t.data(65, "DmObjectView.handleEvent", 300, "Event object type " + eventObjectType + " (original type " + objectType + ")");
        }
        if (event instanceof PCFSummaryEvent) {
            this.processSummaryEvent(t, (PCFSummaryEvent)event, object);
        } else {
            PCFMessage pcfMessage = event.getPCFMessage();
            title = event.getObjectName();
            if (title == null) {
                if (Trace.isTracing) {
                    t.data(65, "DmObjectView.handleEvent", 300, "Ignored event type : " + event.getType() + ", name is null");
                }
                return;
            }
            title = this.getResponseFilter(t).trimTitle(t, title);
            if (eventObjectType != 2) {
                if (this.getObjectFilter(t).performLocalFilter() && this.ignorePCFMessage(t, pcfMessage, eventObjectType, objectType)) {
                    if (Trace.isTracing) {
                        t.data(65, "DmObjectView.handleEvent", 300, "Ignoring PCF response for " + title);
                    }
                    return;
                }
                if (objectType == 25 && this.ignoreClientConnChannel(t, pcfMessage)) {
                    if (Trace.isTracing) {
                        t.data(65, "DmObjectView.handleEvent", 300, "Ignoring client conn channel");
                    }
                    return;
                }
                if (eventObjectType == 118 && this.ignoreChannelInitiator(t, pcfMessage)) {
                    if (Trace.isTracing) {
                        t.data(65, "DmObjectView.handleEvent", 300, "Ignoring chinit response");
                    }
                    return;
                }
                if (event instanceof PCFStatusEvent) {
                    key = String.valueOf(title) + "@" + ((PCFStatusEvent)event).getChildIndex();
                    if (Trace.isTracing) {
                        t.data(65, "DmObjectView.handleEvent", 300, "PCFStatusEvent key = " + key);
                    }
                    objectType = this.getDmObjectType(t);
                } else {
                    try {
                        key = (String)event.getKey();
                        key = this.getResponseFilter(t).trimTitle(t, key);
                    }
                    catch (NullPointerException nullPointerException) {
                        if (Trace.isTracing) {
                            t.data(65, "DmObjectView.handleEvent", 900, "Ignoring PCF response for " + title + ", key is null");
                        }
                        return;
                    }
                    if (Trace.isTracing) {
                        t.data(65, "DmObjectView.handleEvent", 300, "PCFEvent key = " + key);
                    }
                }
                if (this.getStatusQuery(t) != null && eventObjectType == this.getStatusQuery(t).getCommand()) {
                    list = this.getListOfStatusObjects(t);
                    objectType = this.getDmStatusObjectType(t);
                    if (Trace.isTracing) {
                        t.data(65, "DmObjectView.handleEvent", 300, "Using listOfStatusObjects - type " + objectType);
                    }
                }
                if (title.equals(key)) {
                    if (Trace.isTracing) {
                        t.data(65, "DmObjectView.handleEvent", 300, "Looking for object with title = " + title);
                    }
                    object = (DmObject)DmObject.getDmObject(t, list, title);
                } else {
                    if (Trace.isTracing) {
                        t.data(65, "DmObjectView.handleEvent", 300, "Looking for object with key = " + key);
                    }
                    object = (DmObject)DmObject.getDmObject(t, list, key);
                    title = key;
                }
            }
            switch (event.getType()) {
                case 1: {
                    if (object == null) {
                        this.addDmObject(t, pcfMessage, object, title, objectType, list, event.isLast());
                        break;
                    }
                    this.changeDmObject(t, pcfMessage, object, title, objectType, event.isLast());
                    break;
                }
                case 4: {
                    if (object != null) {
                        this.changeDmObject(t, pcfMessage, object, title, objectType, event.isLast());
                        break;
                    }
                    this.addDmObject(t, pcfMessage, object, title, objectType, list, event.isLast());
                    break;
                }
                case 2: {
                    this.deleteDmObject(t, object, objectType, list, event.isLast());
                    break;
                }
                default: {
                    if (!Trace.isTracing) break;
                    t.data(65, "DmObjectView.handleEvent", 900, "Unknown event type : " + event.getType() + ", for : " + event.getObjectName());
                }
            }
        }
    }

    public synchronized void notifyDmObjectListener(Trace t, DmObject source, int notifyType, boolean last) {
        this.notifyDmObjectListener(t, source, notifyType, last, null);
    }

    public synchronized void notifyDmObjectListener(Trace t, DmObject source, int notifyType, boolean last, DmCoreException ex) {
        block17: {
            block16: {
                if (!this.getQueueManager(t).isConnected() || !this.active || CoreServices.isClosing(t)) break block16;
                int dmType = source.getObjectType(t);
                String title = source.getTitle();
                String listenerName = this.objectListener.toString();
                t.eventListenerNotified("DmObjectView.notifyDmObjectListener", 1, t.formatEventListenerData(t, (Object)this, (Object)this.objectListener, DmObjectEvent.getNotifyName(t, notifyType), String.valueOf(source.getTitle().trim()) + "(" + dmType + ")", Boolean.toString(last)));
                switch (notifyType) {
                    case 1: {
                        if (Trace.isTracing) {
                            t.data(65, "DmObjectView.notifyDmObjectListener", 300, "Notifying " + listenerName + " for new object : " + title);
                        }
                        this.objectListener.dmObjectAdded(new DmObjectEvent(source, dmType, last, this, ex, 1));
                        break;
                    }
                    case 4: {
                        if (this.getQueueManager(t).isConnected()) {
                            if (Trace.isTracing) {
                                t.data(65, "DmObjectView.notifyDmObjectListener", 300, "Notifying " + listenerName + " for changes to object : " + title);
                            }
                            this.objectListener.dmObjectChanged(new DmObjectEvent(source, dmType, last, this, ex, 4));
                            break;
                        }
                        if (Trace.isTracing) {
                            t.data(65, "DmObjectView.notifyDmObjectListener", 300, "Change notification ignored - queue manager " + this.getQueueManager(t).getTitle() + " not connected");
                            break;
                        }
                        break block17;
                    }
                    case 2: {
                        if (Trace.isTracing) {
                            t.data(65, "DmObjectView.notifyDmObjectListener", 300, "Notifying " + listenerName + " for deleted object : " + title);
                        }
                        this.objectListener.dmObjectDeleted(new DmObjectEvent(source, dmType, last, this, ex, 2));
                        break;
                    }
                    case 104: {
                        if (Trace.isTracing) {
                            t.data(65, "DmObjectView.notifyDmObjectListener", 300, "Notifying " + listenerName + " for refresh object : " + title);
                        }
                        this.objectListener.dmRefreshComplete(new DmObjectEvent(source, dmType, last, this, ex, 104));
                        break;
                    }
                    case 0: {
                        if (Trace.isTracing) {
                            t.data(65, "DmObjectView.notifyDmObjectListener", 300, "Notifying " + listenerName + " for summary : " + title);
                        }
                        this.sendSummaryEvent(t, source, dmType, 0, ex, false);
                        break;
                    }
                    default: {
                        if (Trace.isTracing) {
                            t.data(65, "DmObjectView.notifyDmObjectListener", 900, "Unknown notify type : " + notifyType);
                            break;
                        }
                        break block17;
                    }
                }
                break block17;
            }
            if (Trace.isTracing) {
                t.data(65, "DmObjectView.notifyDmObjectListener", 300, "Event ignored - listener was not notified");
            }
        }
    }

    private void addDmObject(Trace t, PCFMessage pcfMessage, DmObject object, String title, int objectType, ArrayList<IDmObject> list, boolean last) {
        boolean notified = false;
        if (object == null) {
            DmObject newObject = DmObjectFactory.create(t, this.getQueueManager(t), objectType, title);
            if (newObject != null) {
                list.add(newObject);
                newObject.addAttrFromPCFResponse(t, pcfMessage);
                newObject.initialize(t);
                if (this.getObjectFilter(t).performLocalFilter()) {
                    this.updateInitToSet(t, newObject);
                }
                if (this.getStatusQuery(t) != null) {
                    notified = this.updateStatusAttrs(t, newObject, objectType, last, 1);
                }
                if (!notified && (this.getStatusQuery(t) == null || this.getStatusQuery(t) != null && objectType != this.getDmStatusObjectType(t))) {
                    this.notifyDmObjectListener(t, newObject, 1, last);
                }
            }
        } else if (objectType != 2) {
            if (Trace.isTracing) {
                t.data(65, "DmObjectView.addDmObject", 900, "Object " + title + " already known");
            }
        } else if (Trace.isTracing) {
            t.data(65, "DmObjectView.addDmObject", 300, "Add notification ignored - queue manager " + title);
        }
    }

    private void changeDmObject(Trace t, PCFMessage pcfMessage, DmObject object, String title, int objectType, boolean last) {
        boolean notified = false;
        if (Trace.isTracing) {
            t.data(65, "DmObjectView.changeDmObject", 300, String.valueOf(title) + " has been changed");
        }
        if (object != null) {
            if (this.getObjectFilter(t).performLocalFilter()) {
                int pcfTypeId = PCFAction.getPCFTypeId(t, objectType);
                if (Trace.isTracing) {
                    t.data(65, "DmObjectView.changeDmObject", 300, "PCF type id " + pcfTypeId + " for " + object.getDmTitle());
                }
                int subType = this.getObjectTypeFromPCFMessage(t, pcfMessage, pcfTypeId);
                if (Trace.isTracing) {
                    t.data(65, "DmObjectView.changeDmObject", 300, "Sub-type from pcf message " + subType);
                }
                if (subType == 11 || pcfTypeId == 1157) {
                    object.addAttrFromPCFResponse(t, pcfMessage);
                } else {
                    object.mergeAttrFromPCFResponse(t, pcfMessage);
                }
            } else {
                object.addAttrFromPCFResponse(t, pcfMessage);
            }
            object.initialize(t);
            if (this.getStatusQuery(t) != null) {
                notified = this.updateStatusAttrs(t, object, objectType, last, 4);
            }
            if (!notified && (this.getStatusQuery(t) == null || this.getStatusQuery(t) != null && objectType != this.getDmStatusObjectType(t))) {
                this.notifyDmObjectListener(t, object, 4, last);
            }
        } else if (Trace.isTracing) {
            t.data(65, "DmObjectView.changeDmObject", 900, "Object not known " + title);
        }
    }

    private void deleteDmObject(Trace t, DmObject object, int objectType, ArrayList<IDmObject> list, boolean last) {
        boolean removed = false;
        boolean notified = false;
        if (object != null) {
            if (Trace.isTracing) {
                t.data(65, "DmObjectView.deleteDmObject", 300, "Removing object " + object.getDmTitle());
            }
            this.removeLink(t, object);
            if (this.getStatusQuery(t) != null) {
                notified = this.updateStatusAttrs(t, object, objectType, last, 2);
            }
            if (!notified && (this.getStatusQuery(t) == null || this.getStatusQuery(t) != null && objectType != this.getDmStatusObjectType(t))) {
                this.notifyDmObjectListener(t, object, 2, last);
            }
            removed = list.remove(object);
            if (Trace.isTracing) {
                if (removed) {
                    if (Trace.isTracing) {
                        t.data(65, "DmObjectView.deleteDmObject", 300, "Object " + object.getDmTitle() + " removed from local list");
                    }
                } else if (Trace.isTracing) {
                    t.data(65, "DmObjectView.deleteDmObject", 300, "Object " + object.getDmTitle() + " not found in local list");
                }
            }
        }
    }

    private void removePCFListener(Trace t) {
        block5: {
            try {
                this.getQueueManager(t).getPcfMonitorAgent(t).removeListener(t, (PCFListener)this, this.getObjectFilter(t).getQuery());
                if (this.getQueueManager(t).isAMPQSupported(t)) {
                    this.removeAMQPListener(t);
                }
                if (this.getStatusQuery(t) != null) {
                    this.getQueueManager(t).getPcfMonitorAgent(t).removeListener(t, (PCFListener)this, this.getStatusQuery(t));
                    if (this.getQueueManager(t).isAMPQSupported(t)) {
                        this.removeAMQPListener(t);
                    }
                }
                this.getQueueManager(t).getPcfMonitorAgent(t).removeErrorListener(t, (ErrorListener)this);
            }
            catch (DmCoreException dmCoreException) {
                if (!Trace.isTracing) break block5;
                t.data(65, "DmObjectView.removePCFListener", 900, "Error removing listener - PCFMonitorAgent not defined");
            }
        }
    }

    public void refresh(Trace t, boolean sync) {
        block8: {
            if (!this.active) {
                if (Trace.isTracing) {
                    t.data(65, "DmObjectView.refresh", 300, "View not active " + this.toString());
                }
                return;
            }
            try {
                if (sync) {
                    if (Trace.isTracing) {
                        t.data(65, "DmObjectView.refresh", 800, "Performing synchronous refresh");
                    }
                    this.getQueueManager(t).getPcfMonitorAgent(t).refresh(t, (PCFListener)this);
                } else {
                    if (Trace.isTracing) {
                        t.data(65, "DmObjectView.refresh", 800, "Performing asynchronous refresh");
                    }
                    this.getQueueManager(t).getPcfMonitorAgent(t).refreshAsync(t, (PCFListener)this);
                }
            }
            catch (Exception e) {
                if (!Trace.isTracing) break block8;
                t.data(65, "DmObjectView.refresh", 900, "Error performing refresh\n" + e.toString());
            }
        }
    }

    public void onError(MQException mqe) {
        int cmd;
        int cc;
        int rc;
        PCFMessage pcfMessage;
        Trace t;
        block6: {
            t = Trace.getInstance();
            pcfMessage = null;
            if (Trace.isTracing) {
                t.data(65, "DmObjectView.onError", 900, "PCF exception : " + mqe.toString());
            }
            rc = mqe.reasonCode;
            cc = mqe.completionCode;
            cmd = this.getObjectFilter(t).getQuery().getCommand();
            try {
                Object object = mqe.exceptionSource;
                if (object instanceof PCFMessage[]) {
                    PCFMessage[] msgs = (PCFMessage[])mqe.exceptionSource;
                    pcfMessage = msgs[0];
                }
            }
            catch (Exception e) {
                if (!Trace.isTracing) break block6;
                t.data(65, "DmObjectView.onError", 900, "Error extracting PCFMessage from MQException : " + e.toString());
            }
        }
        if (!this.ignoreReasonCode(t, cmd, rc, pcfMessage)) {
            String msgId = CommonServices.getSystemMessageId((Trace)t, (int)rc);
            String msg = ConvertReasonCode.getSystemMessage(t, this.getQueueManager(t), cmd, rc, cc);
            DmCoreException ex = new DmCoreException(t, msg, msgId, rc, cc, 20);
            this.sendSummaryEvent(t, this.getQueueManager(t), cmd, 0, ex, true);
        }
        if (!GenerateFFST.ignoreFFST(t, mqe.reasonCode)) {
            t.FFST(65, "DmObjectView.onError", 0, rc, mqe.getMessage());
        }
    }

    public DmObjectListener getListener() {
        return this.objectListener;
    }

    private boolean updateStatusAttrs(Trace t, DmObject object, int type, boolean last, int eventType) {
        boolean notified = false;
        if (Trace.isTracing) {
            t.data(65, "DmObjectView.updateStatusAttrs", 300, "Object " + object.getDmTitle() + ", type " + type + ", event type " + eventType);
            t.data(65, "DmObjectView.updateStatusAttrs", 300, "Size of listOfObjects is " + this.getListOfObjects(t).size() + ", listOfStatusObjects " + this.getListOfStatusObjects(t).size());
        }
        if (type == 161) {
            if (Trace.isTracing) {
                t.data(65, "DmObjectView.updateStatusAttrs", 300, "Updating queue manager status " + object.getDmTitle());
            }
            this.getQueueManager(t).updateStatus(t, (ArrayList)this.getListOfStatusObjects(t), eventType);
            this.notifyDmObjectListener(t, this.getQueueManager(t), 4, last);
            return true;
        }
        if (type == this.getDmStatusObjectType(t) && this.getListOfObjects(t).size() > 0) {
            DmObject owner;
            if (Trace.isTracing) {
                t.data(65, "DmObjectView.updateStatusAttrs", 300, "Using status object " + object.getDmTitle());
            }
            if ((owner = object.updateStatus(t, this.getListOfObjects(t), eventType)) != null) {
                this.notifyDmObjectListener(t, owner, 4, last);
                notified = true;
            }
            return notified;
        }
        if (type != this.getDmStatusObjectType(t) && this.getListOfStatusObjects(t).size() > 0) {
            if (Trace.isTracing) {
                t.data(65, "DmObjectView.updateStatusAttrs", 300, "Updating object " + object.getDmTitle() + " from status objects");
            }
            object.updateStatus(t, this.getListOfStatusObjects(t), eventType);
            this.notifyDmObjectListener(t, object, eventType, last);
            notified = true;
        }
        return notified;
    }

    private void sendSummaryEvent(Trace t, DmObject object, int objectType, int count, DmCoreException ex, boolean log) {
        DmObjectSummaryEvent summaryEvent = new DmObjectSummaryEvent(this.getQueueManager(t), this, count, ex);
        this.objectListener.dmObjectSummary(summaryEvent);
        if (log) {
            t.eventListenerNotified("DmObjectView.sendSummaryEvent", 1, t.formatEventListenerData(t, (Object)this, (Object)this.objectListener, DmObjectEvent.getNotifyName(t, 0), String.valueOf(object.getTitle().trim()) + "(" + objectType + "/" + count + ")", "true"));
        }
    }

    private boolean ignoreReasonCode(Trace t, int cmd, int rc, PCFMessage msg) {
        boolean ignore = false;
        switch (rc) {
            case 2009: 
            case 2033: 
            case 2161: 
            case 2162: {
                ignore = true;
                break;
            }
            case 2322: {
                break;
            }
            default: {
                if (msg != null) {
                    if (cmd == msg.getCommand()) {
                        if (cmd == 25 && this.ignoreChannel(msg)) {
                            ignore = true;
                            break;
                        }
                        int errorParmId = -1;
                        try {
                            errorParmId = msg.getIntParameterValue(1012);
                        }
                        catch (PCFException pCFException) {}
                        PCFFilter pcfFilter = this.getObjectFilter(t).getFilter();
                        if (pcfFilter == null) break;
                        int filterParmId = pcfFilter.getParameter();
                        if (errorParmId == filterParmId) {
                            ignore = false;
                            break;
                        }
                        ignore = true;
                        break;
                    }
                    ignore = true;
                    break;
                }
                ignore = true;
            }
        }
        if (Trace.isTracing) {
            t.data(65, "DmObjectView.ignoreReasonCode", 900, "Reason code " + rc + " for " + this.getQueueManager(t).getTreeName(t) + " ignored = " + ignore);
        }
        return ignore;
    }

    private boolean ignoreChannel(PCFMessage msg) {
        boolean ignore = false;
        Trace t = Trace.getInstance();
        Integer channelType = (Integer)msg.getParameterValue(1511);
        DmObjectFilter filter = this.getObjectFilter(t);
        if (channelType.intValue() != filter.getSubType()) {
            ignore = true;
        }
        return ignore;
    }

    private void removeLink(Trace t, DmObject object) {
        block11: {
            IDmObjectLink oLink = null;
            if (this.getListOfObjects(t).size() < 2) {
                try {
                    IDmObjectLink[] child;
                    oLink = (IDmObjectLink)((Object)object);
                    IDmObjectLink parent = oLink.getParent(t);
                    if (parent != null) {
                        parent.removeChild(t, oLink);
                        if (Trace.isTracing) {
                            t.data(65, "DmObjectView.removeLink", 300, "Removing child info from parent " + ((DmObject)((Object)parent)).getDmTitle());
                        }
                    }
                    oLink.setParent(t, null);
                    if (Trace.isTracing) {
                        t.data(65, "DmObjectView.removeLink", 300, "Removing parent info for " + object.getDmTitle());
                    }
                    if ((child = oLink.getChildren(t)) != null) {
                        int i = 0;
                        while (i < child.length) {
                            if (Trace.isTracing) {
                                t.data(65, "DmObjectView.removeLink", 300, "Removing parent info from " + ((DmObject)((Object)child[i])).getDmTitle());
                            }
                            child[i].setParent(t, null);
                            ++i;
                        }
                    }
                    break block11;
                }
                catch (ClassCastException classCastException) {
                    if (Trace.isTracing) {
                        t.data(65, "DmObjectView.removeLink", 300, "No parent/child info for " + object.getDmTitle());
                    }
                    break block11;
                }
            }
            if (Trace.isTracing) {
                t.data(65, "DmObjectView.removeLink", 300, "Ignoring parent/child info for " + object.getDmTitle());
            }
        }
    }

    private void processSummaryEvent(Trace t, PCFSummaryEvent event, DmObject object) {
        int eventObjectType = event.getCommand();
        int count = event.getEventCount();
        if (count == 0) {
            if (this.getStatusQuery(t) != null && event.getCommand() == this.getStatusQuery(t).getCommand()) {
                if (Trace.isTracing) {
                    t.data(65, "DmObjectView.processSummaryEvent", 300, "Summary event ignored - object has status");
                }
            } else if (this.sentFirstSummary) {
                this.sendSummaryEvent(t, object, eventObjectType, count, null, true);
            }
        } else if (!this.sentFirstSummary && this.getStatusQuery(t) != null && event.getCommand() == this.getStatusQuery(t).getCommand()) {
            if (Trace.isTracing) {
                t.data(65, "DmObjectView.processSummaryEvent", 300, "First summary event ignored - object has status");
            }
        } else {
            this.sentFirstSummary = true;
            this.sendSummaryEvent(t, object, eventObjectType, count, null, true);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    private PCFQuery getAMQPCurrentStatusQuery(Trace t) {
        if (this.currentStatusAMQPQuery == null) {
            this.currentStatusAMQPQuery = new PCFQuery(PCFCommands.createTemplate(t, this.getQueueManager(t).getUUID(), 69), this.getObjectFilter(t).getName());
        }
        return this.currentStatusAMQPQuery;
    }

    private PCFQuery getAMQPSavedStatusQuery(Trace t) {
        if (this.savedStatusAMQPQuery == null) {
            this.savedStatusAMQPQuery = new PCFQuery(PCFCommands.createTemplate(t, this.getQueueManager(t).getUUID(), 70), this.getObjectFilter(t).getName());
        }
        return this.savedStatusAMQPQuery;
    }

    private PCFQuery getAMQPClientIdStatusQuery(Trace t) {
        if (this.clientidStatusAMQPQuery == null) {
            this.clientidStatusAMQPQuery = new PCFQuery(PCFCommands.createTemplate(t, this.getQueueManager(t).getUUID(), 71), this.getObjectFilter(t).getName());
        }
        return this.clientidStatusAMQPQuery;
    }

    private void removeAMQPListener(Trace t) {
        block5: {
            int objectType = this.getDmObjectType(t);
            int statusObjectType = this.getDmStatusObjectType(t);
            try {
                if ((objectType == 1009 || statusObjectType == 1009) && this.currentStatusAMQPQuery != null) {
                    this.getQueueManager(t).getPcfMonitorAgent(t).removeListener(t, (PCFListener)this, this.currentStatusAMQPQuery);
                    this.currentStatusAMQPQuery = null;
                }
                if ((objectType == 1010 || statusObjectType == 1010) && this.savedStatusAMQPQuery != null) {
                    this.getQueueManager(t).getPcfMonitorAgent(t).removeListener(t, (PCFListener)this, this.savedStatusAMQPQuery);
                    this.savedStatusAMQPQuery = null;
                }
                if ((objectType == 1009 || statusObjectType == 1009) && this.clientidStatusAMQPQuery != null) {
                    this.getQueueManager(t).getPcfMonitorAgent(t).removeListener(t, (PCFListener)this, this.clientidStatusAMQPQuery);
                    this.clientidStatusAMQPQuery = null;
                }
            }
            catch (DmCoreException dmCoreException) {
                if (!Trace.isTracing) break block5;
                t.data(65, "DmObjectView.removeAMPQListener", 900, "Error removing AMQP listener - PCFMonitorAgent not defined");
            }
        }
    }
}

