/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.event;

import com.ibm.mq.MQException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmCommonObjectView;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmObjectFactory;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.core.internal.objects.PCFAction;
import com.ibm.mq.explorer.core.internal.utils.ConvertReasonCode;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.event.PCFQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;

public class DmObjectListView
extends DmCommonObjectView
implements Runnable {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/event/DmObjectListView.java";
    private DmObjectListListener objectListener = null;
    private PCFMessage[] responses = null;
    private Hashtable<String, Integer> indexTable = new Hashtable();
    private Object hashLock = new Object();

    public DmObjectListView(Trace t, DmQueueManager qMgr, DmObjectListListener listener, DmObjectFilter filter) {
        super(t, qMgr, filter);
        this.objectListener = listener;
        if (this.objectListener != null) {
            t.eventListenerAdded("DmObjectListView.DmObjectListView", 1, t.formatEventListenerData(t, (Object)this, (Object)this.objectListener, DmObject.getTypeName(t, this.getObjectFilter(t).getType())));
        }
    }

    public ArrayList<IDmObject> getList(Trace t) throws DmCoreException {
        return this.getList(t, true);
    }

    public ArrayList<IDmObject> getList(Trace t, boolean addStatus) throws DmCoreException {
        int objectType = this.getDmObjectType(t);
        if (Trace.isTracing) {
            t.data(65, "DmObjectListView.getList", 300, "Getting objects of type " + objectType);
        }
        this.createList(t, this.getObjectFilter(t).getQuery(), objectType, false);
        if (addStatus) {
            if (!PCFAction.isStatusQuery(t, objectType)) {
                int statusType = this.getQueueManager(t).getStatusType(t, objectType, 0);
                if (Trace.isTracing) {
                    t.data(65, "DmObjectListView.getList", 300, "Status type for " + objectType + " is " + statusType);
                }
                if (statusType != 0) {
                    int statusObjectType;
                    if (Trace.isTracing) {
                        t.data(65, "DmObjectListView.getList", 300, "Getting status objects for type " + objectType);
                    }
                    if ((statusObjectType = PCFAction.getStatusQueryObjectType(t, objectType)) != -1) {
                        this.setDmStatusObjectType(t, statusObjectType);
                        this.createList(t, PCFAction.getStatusQuery(t, this.getQueueManager(t).getUUID(), objectType, this.getObjectFilter(t).getName()), this.getDmStatusObjectType(t), true);
                        if (objectType == 2) {
                            this.getQueueManager(t).updateStatus(t, (ArrayList)this.getListOfStatusObjects(t), 1);
                        } else {
                            this.updateStatusAttrs(t);
                        }
                    }
                }
            }
        } else if (Trace.isTracing) {
            t.data(65, "DmObjectListView.getList", 300, "Status attributes not requested");
        }
        if (this.getObjectFilter(t).getSubType() == 11 && this.getListOfObjects(t).size() == 1) {
            DmObject o = (DmObject)this.getListOfObjects(t).get(0);
            o.replaceAttributeValue(t, 1175, 0, 11, false);
        }
        return this.getListOfObjects(t);
    }

    protected void createList(Trace t, PCFQuery query, int dmObjectType, boolean useStatusList) throws DmCoreException {
        int rc = 0;
        int cc = 0;
        if (Trace.isTracing) {
            t.data(65, "DmObjectListView.createList", 300, "Sending snapshot to " + this.getQueueManager(t).getTitle() + "\n" + query.getTemplate().toString());
        }
        this.report(t, query);
        try {
            this.responses = this.getQueueManager(t).getPcfMonitorAgent(t).snapshot(t, query, true);
            if (this.responses != null && this.responses.length > 0) {
                PCFMessage message = this.responses[0];
                if (!query.getTemplate().isExpected(message.getReason())) {
                    rc = message.getReason();
                    cc = message.getCompCode();
                }
                if (Trace.isTracing) {
                    t.data(65, "DmObjectListView.createList", 300, "Reason code " + rc + ", completion code " + cc);
                }
                if (rc == 0) {
                    if (Trace.isTracing) {
                        t.data(65, "DmObjectListView.createList", 300, String.valueOf(this.responses.length) + " response(s) in the reply");
                    }
                    int i = 0;
                    while (i < this.responses.length) {
                        this.processResponse(t, this.responses[i], dmObjectType, useStatusList);
                        ++i;
                    }
                }
            }
        }
        catch (NullPointerException e) {
            if (Trace.isTracing) {
                t.data(65, "DmObjectListView.createList", 900, "NullPointerException : " + e.getMessage());
            }
        }
        catch (PCFException e) {
            if (Trace.isTracing) {
                t.data(65, "DmObjectListView.createList", 900, "PCFException : " + e.getMessage());
            }
            rc = e.reasonCode;
            cc = e.completionCode;
        }
        catch (IOException e) {
            if (Trace.isTracing) {
                t.data(65, "DmObjectListView.createList", 900, "IOException : " + e.getMessage());
            }
        }
        catch (MQException e) {
            if (Trace.isTracing) {
                t.data(65, "DmObjectListView.createList", 900, "MQException : " + e.getMessage());
            }
            rc = e.reasonCode;
            cc = e.completionCode;
        }
        catch (DmCoreException e) {
            if (Trace.isTracing) {
                t.data(65, "DmObjectListView.createList", 900, "DmCoreException : " + e.getMessage());
            }
            throw e;
        }
        if (rc != 0) {
            this.getQueueManager(t).checkForDisconnection(t, rc);
            String msgId = CommonServices.getSystemMessageId((Trace)t, (int)rc);
            String msg = ConvertReasonCode.getSystemMessage(t, this.getQueueManager(t), query.getCommand(), rc, cc);
            DmCoreException ex = new DmCoreException(t, msg, msgId, rc, cc, 20);
            this.setException(t, ex);
            throw ex;
        }
    }

    private void processResponse(Trace t, PCFMessage pcfMessage, int dmObjectType, boolean useStatusList) {
        String title = "[not_found]";
        DmObject object = null;
        boolean newObject = false;
        if (pcfMessage.getType() == 17 || pcfMessage.getType() == 19) {
            if (Trace.isTracing) {
                t.data(65, "DmObjectListView.processResponse", 300, "Ignoring PCF response - MQCFT_XR_MSG or MQCFT_XR_SUMMARY");
            }
            return;
        }
        int command = pcfMessage.getCommand();
        try {
            title = (String)this.getObjectFilter(t).getQuery().getTemplate().getKey(pcfMessage);
        }
        catch (NullPointerException nullPointerException) {
            if (Trace.isTracing) {
                t.data(65, "DmObjectListView.processResponse", 900, "Ignoring PCF response, key is null");
            }
            return;
        }
        if (title != null) {
            title = this.getResponseFilter(t).trimTitle(t, title);
            if (Trace.isTracing) {
                t.data(65, "DmObjectListView.processResponse", 300, "Received object " + title + ", type " + command + " (Dm type " + dmObjectType + ")");
            }
        }
        if (this.getObjectFilter(t).performLocalFilter()) {
            if (this.ignorePCFMessage(t, pcfMessage, command, dmObjectType)) {
                if (Trace.isTracing) {
                    t.data(65, "DmObjectListView.processResponse", 300, "Ignoring PCF response " + title);
                }
                return;
            }
        } else if (Trace.isTracing) {
            t.data(65, "DmObjectListView.processResponse", 300, "Local filter not performed");
        }
        if (command == 25 && this.ignoreClientConnChannel(t, pcfMessage)) {
            if (Trace.isTracing) {
                t.data(65, "DmObjectListView.processResponse", 300, "Ignoring client conn channel " + title);
            }
            return;
        }
        if (command == 118 && this.ignoreChannelInitiator(t, pcfMessage)) {
            if (Trace.isTracing) {
                t.data(65, "DmObjectListView.processResponse", 300, "Ignoring chinit response");
            }
            return;
        }
        if (title != null) {
            if (PCFAction.isStatusQuery(t, this.getDmObjectType(t))) {
                title = String.valueOf(title) + "@" + this.getStatusIndex(t, title);
            }
            if (command == 2) {
                if (Trace.isTracing) {
                    t.data(65, "DmObjectListView.processResponse", 300, "Received object is a queue manager");
                }
                object = this.getQueueManager(t);
            } else {
                if (Trace.isTracing) {
                    t.data(65, "DmObjectListView.processResponse", 300, "Looking for existing object with title = " + title);
                }
                if ((object = useStatusList ? (DmObject)DmObject.getDmObject(t, this.getListOfStatusObjects(t), title) : (DmObject)DmObject.getDmObject(t, this.getListOfObjects(t), title)) == null) {
                    if (Trace.isTracing) {
                        t.data(65, "DmObjectListView.processResponse", 300, "Creating new object " + title);
                    }
                    object = DmObjectFactory.create(t, this.getQueueManager(t), dmObjectType, title);
                    newObject = true;
                }
            }
            if (object != null) {
                object.addAttrFromPCFResponse(t, pcfMessage);
                object.initialize(t);
                if (newObject) {
                    boolean added = false;
                    if (useStatusList) {
                        added = this.getListOfStatusObjects(t).add(object);
                        if (Trace.isTracing) {
                            if (added) {
                                t.data(65, "DmObjectListView.processResponse", 300, "Object " + title + " added to status list");
                            } else {
                                t.data(65, "DmObjectListView.processResponse", 900, "Error adding object " + title + " to status list");
                            }
                        }
                    } else {
                        added = this.getListOfObjects(t).add(object);
                        if (Trace.isTracing) {
                            if (added) {
                                t.data(65, "DmObjectListView.processResponse", 300, "Object " + title + " added to list");
                            } else {
                                t.data(65, "DmObjectListView.processResponse", 900, "Error adding object " + title + " to list");
                            }
                        }
                    }
                }
            }
        } else if (Trace.isTracing) {
            t.data(65, "DmObjectListView.processResponse", 300, "Error getting title from " + pcfMessage.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListener(Trace t) {
        String uniqueName = Trace.NO_LISTENER_INFO;
        DmObjectListView objectView = null;
        Object object = this.hashLock;
        synchronized (object) {
            block8: {
                uniqueName = this.getUniqueObjectName(this.objectListener);
                try {
                    objectView = this.getQueueManager(t).getListOfObjectListViews(t).remove(uniqueName);
                }
                catch (ClassCastException classCastException) {
                    if (!Trace.isTracing) break block8;
                    t.data(65, "DmObjectListView.removeListener", 900, "Unable to remove getObjects listener - invalid object");
                }
            }
        }
        if (Trace.isTracing) {
            if (objectView != null) {
                t.data(65, "DmObjectListView.removeListener", 300, "Get objects listener removed from table : " + this.objectListener.toString());
            } else {
                t.data(65, "DmObjectListView.removeListener", 900, "Get objects listener not found in table : " + this.objectListener.toString());
            }
        }
        this.indexTable.clear();
    }

    private void notifyListener(Trace t) {
        this.objectListener.dmObjectListDone(new DmObjectListEvent(this.getQueueManager(t), this, this.getListOfObjects(t), this.getException(t)));
        this.removeListener(t);
        t.eventListenerRemoved("DmObjectListView.notifyListener", 1, t.formatEventListenerData(t, (Object)this, (Object)this.objectListener, DmObject.getTypeName(t, this.getObjectFilter(t).getType())));
    }

    @Override
    public void run() {
        Trace t = Trace.getInstance();
        try {
            this.getList(t);
        }
        catch (DmCoreException e) {
            this.setException(t, e);
        }
        this.notifyListener(t);
    }

    private void updateStatusAttrs(Trace t) {
        ArrayList<IDmObject> list = this.getListOfObjects(t);
        if (Trace.isTracing) {
            t.data(65, "DmObjectListView.updateStatusAttrs", 300, "Updating status for " + list.size() + " objects");
        }
        int i = 0;
        while (i < list.size()) {
            DmObject object = (DmObject)list.get(i);
            if (Trace.isTracing) {
                t.data(65, "DmObjectListView.updateStatusAttrs", 300, "Updating object " + object.getTitle() + " from status objects");
            }
            object.updateStatus(t, this.getListOfStatusObjects(t), 1);
            ++i;
        }
    }

    private int getStatusIndex(Trace t, String name) {
        int index = 0;
        Integer value = this.indexTable.get(name);
        if (value == null) {
            this.indexTable.put(name, 0);
        } else {
            index = value + 1;
            this.indexTable.put(name, index);
        }
        if (Trace.isTracing) {
            t.data(65, "DmObjectListView.getStatusIndex", 300, "Status object " + name + ", index value " + index);
        }
        return index;
    }

    protected String getUniqueObjectName(Object object) {
        String uniqueName = String.valueOf(object.getClass().getName()) + "@" + System.identityHashCode(object);
        return uniqueName;
    }
}

