/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.event;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.base.CorePlugin;
import com.ibm.mq.explorer.core.internal.pcf.PCFCommands;
import com.ibm.mq.pcf.MQCFBS;
import com.ibm.mq.pcf.MQCFIL;
import com.ibm.mq.pcf.MQCFIN;
import com.ibm.mq.pcf.MQCFST;
import com.ibm.mq.pcf.PCFParameter;
import com.ibm.mq.pcf.event.PCFFilter;
import com.ibm.mq.pcf.event.PCFQuery;
import com.ibm.mq.pcf.event.PCFQueryTemplate;

public class DmObjectFilter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/event/DmObjectFilter.java";
    private static final int NOT_SET = -99;
    private int objectType = -99;
    private int objectSubType = -99;
    private int objectDisp = -99;
    private int messagingProvider = -99;
    private String objectName = "*";
    private byte[] byteObjectName = PCFQuery.ALL_BINARY_NAMES;
    protected PCFFilter pcfFilter = null;
    protected PCFQuery pcfQuery = null;
    private boolean localFilter = false;
    private int entityType = -99;
    private String entityName = "*";
    private int authorityOptions = 33;
    private String cfstructName = "";
    private int responseRestartPoint = -1;
    private int maxResponses = -1;

    protected DmObjectFilter() {
    }

    public DmObjectFilter(Trace t, String name, int dmType, int subType, PCFFilter filter) {
        this.objectName = name;
        this.objectType = dmType;
        this.pcfFilter = filter;
        this.objectSubType = subType;
    }

    public DmObjectFilter(Trace t, byte[] name, int dmType, int subType, PCFFilter filter) {
        this.byteObjectName = name;
        this.objectName = new String(this.byteObjectName);
        this.objectType = dmType;
        this.pcfFilter = filter;
        this.objectSubType = subType;
    }

    public DmObjectFilter(Trace t, int dmType, int subType, PCFFilter filter) {
        this.objectType = dmType;
        this.pcfFilter = filter;
        this.objectSubType = subType;
    }

    public DmObjectFilter(Trace t, String name, int dmType, PCFFilter filter) {
        this.objectName = name;
        this.objectType = dmType;
        this.pcfFilter = filter;
    }

    public DmObjectFilter(Trace t, byte[] name, int dmType, PCFFilter filter) {
        this.byteObjectName = name;
        this.objectName = new String(this.byteObjectName);
        this.objectType = dmType;
        this.pcfFilter = filter;
    }

    public DmObjectFilter(Trace t, int dmType, PCFFilter filter) {
        this.objectType = dmType;
        this.pcfFilter = filter;
    }

    public DmObjectFilter(Trace t, String name, int dmType, int subType) {
        this.objectName = name;
        this.objectType = dmType;
        this.objectSubType = subType;
    }

    public DmObjectFilter(Trace t, byte[] name, int dmType, int subType) {
        this.byteObjectName = name;
        this.objectName = new String(this.byteObjectName);
        this.objectType = dmType;
        this.objectSubType = subType;
    }

    public DmObjectFilter(Trace t, String name, int dmType) {
        this.objectName = name;
        this.objectType = dmType;
    }

    public DmObjectFilter(Trace t, byte[] name, int dmType) {
        this.byteObjectName = name;
        this.objectName = new String(this.byteObjectName);
        this.objectType = dmType;
    }

    public DmObjectFilter(Trace t, int dmType, int subType) {
        this.objectType = dmType;
        this.objectSubType = subType;
    }

    public DmObjectFilter(Trace t, int dmType) {
        this.objectType = dmType;
    }

    public String getName() {
        return this.objectName;
    }

    public byte[] getByteName() {
        return this.byteObjectName;
    }

    public int getType() {
        return this.objectType;
    }

    public int getSubType() {
        return this.objectSubType;
    }

    public PCFFilter getFilter() {
        return this.pcfFilter;
    }

    public PCFQuery getQuery() {
        return this.pcfQuery;
    }

    public int getDisp() {
        return this.objectDisp;
    }

    public int getEntityType() {
        return this.entityType;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public boolean performLocalFilter() {
        return this.localFilter;
    }

    public void setDisp(Trace t, int disp) {
        this.objectDisp = disp;
        if (Trace.isTracing) {
            t.data(65, "DmObjectFilter.setDisp", 300, "Setting QSG disp to " + disp);
        }
    }

    public boolean equals(Object o) {
        Trace t = Trace.getInstance();
        boolean retValue = false;
        if (!(o instanceof DmObjectFilter)) {
            if (Trace.isTracing) {
                t.data(65, "DmObjectFilter.equals", 300, "Not comparing same object types");
            }
            return false;
        }
        boolean filersEqual = false;
        int ot = ((DmObjectFilter)o).getType();
        int ost = ((DmObjectFilter)o).getSubType();
        PCFFilter filter = ((DmObjectFilter)o).getFilter();
        if (this.pcfFilter == null && filter == null) {
            filersEqual = true;
        }
        if (this.pcfFilter != null && filter != null) {
            filersEqual = this.pcfFilter.equals((Object)filter);
        }
        String name = ((DmObjectFilter)o).getName();
        if (this.objectType == ot && this.objectSubType == ost && filersEqual && this.objectName.equals(name)) {
            retValue = true;
        }
        if (Trace.isTracing) {
            if (retValue) {
                t.data(65, "DmObjectFilter.equals", 300, "Filters are equal :\n" + this.toString(t));
            } else if (this.pcfFilter == null) {
                t.data(65, "DmObjectFilter.equals", 300, "Filters are not equal :\n" + this.toString(t) + "\n other filter is null");
            } else {
                t.data(65, "DmObjectFilter.equals", 300, "Filters are not equal :\n" + this.toString(t) + "\n" + ((DmObjectFilter)o).toString(t));
            }
        }
        return retValue;
    }

    public void generatePCFQuery(Trace t, String id) {
        PCFQueryTemplate template = null;
        PCFParameter[] pcfParameter = null;
        try {
            switch (this.objectType) {
                case 114: {
                    template = PCFCommands.createTemplate(t, id, 0);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    this.localFilter = true;
                    break;
                }
                case 1013: {
                    template = PCFCommands.createTemplate(t, id, 0);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    this.localFilter = true;
                    this.objectSubType = 1175;
                    break;
                }
                case 83: {
                    if (this.objectDisp != -99) {
                        template = PCFCommands.createTemplate(t, id, 2);
                        this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFST(2045, this.objectName), new MQCFIN(63, this.objectDisp)}, this.pcfFilter);
                    } else {
                        template = PCFCommands.createTemplate(t, id, 1);
                        this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    }
                    break;
                }
                case 87: {
                    if (this.objectName.equals("*")) {
                        if (this.entityType != -99) {
                            template = PCFCommands.createTemplate(t, id, 4);
                            this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFIN(1228, this.authorityOptions), new MQCFIN(1016, this.objectSubType), new MQCFIN(1118, this.entityType), new MQCFST(3068, this.entityName)}, this.pcfFilter);
                        } else {
                            template = PCFCommands.createTemplate(t, id, 3);
                            this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFIN(1228, this.authorityOptions), new MQCFIN(1016, this.objectSubType)}, this.pcfFilter);
                        }
                    } else if (this.entityType != -99) {
                        template = PCFCommands.createTemplate(t, id, 4);
                        this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFIN(1228, this.authorityOptions), new MQCFST(3067, this.objectName), new MQCFIN(1016, this.objectSubType), new MQCFIN(1118, this.entityType), new MQCFST(3068, this.entityName)}, this.pcfFilter);
                    } else {
                        template = PCFCommands.createTemplate(t, id, 3);
                        this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFIN(1228, this.authorityOptions), new MQCFST(3067, this.objectName), new MQCFIN(1016, this.objectSubType)}, this.pcfFilter);
                    }
                    break;
                }
                case 25: {
                    if (this.objectSubType == -99) {
                        if (this.objectDisp != -99) {
                            template = PCFCommands.createTemplate(t, id, 6);
                            this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFST(3501, this.objectName), new MQCFIN(63, this.objectDisp)}, this.pcfFilter);
                        } else {
                            template = PCFCommands.createTemplate(t, id, 5);
                            this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                        }
                    } else if (this.objectDisp != -99) {
                        if (this.pcfFilter != null && this.pcfFilter.getParameter() == 1511) {
                            template = PCFCommands.createTemplate(t, id, 6);
                            this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFST(3501, this.objectName), new MQCFIN(63, this.objectDisp)}, this.pcfFilter);
                        } else {
                            template = PCFCommands.createTemplate(t, id, 57);
                            this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFST(3501, this.objectName), new MQCFIN(1511, this.objectSubType), new MQCFIN(63, this.objectDisp)}, this.pcfFilter);
                        }
                    } else {
                        template = PCFCommands.createTemplate(t, id, 5);
                        this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFST(3501, this.objectName), new MQCFIN(1511, this.objectSubType)}, this.pcfFilter);
                    }
                    break;
                }
                case 1009: {
                    template = PCFCommands.createTemplate(t, id, 7);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    break;
                }
                case 1010: {
                    template = PCFCommands.createTemplate(t, id, 8);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    break;
                }
                case 204: {
                    if (this.objectSubType == -99) {
                        template = PCFCommands.createTemplate(t, id, 65);
                        this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    } else {
                        template = PCFCommands.createTemplate(t, id, 65);
                        this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFST(3501, this.objectName), new MQCFIN(1352, this.objectSubType)}, this.pcfFilter);
                    }
                    break;
                }
                case 1005: {
                    if (this.objectDisp != -99) {
                        template = PCFCommands.createTemplate(t, id, 54);
                        this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFST(3501, this.objectName), new MQCFIN(63, this.objectDisp)}, this.pcfFilter);
                    } else {
                        template = PCFCommands.createTemplate(t, id, 9);
                        this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    }
                    break;
                }
                case 1004: {
                    template = PCFCommands.createTemplate(t, id, 11);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    break;
                }
                case 1024: {
                    template = PCFCommands.createTemplate(t, id, 53);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    break;
                }
                case 70: {
                    template = PCFCommands.createTemplate(t, id, 10);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    break;
                }
                case 191: {
                    template = PCFCommands.createTemplate(t, id, 58);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    break;
                }
                case 85: {
                    template = PCFCommands.createTemplate(t, id, 12);
                    this.pcfQuery = this.byteObjectName.equals(PCFQuery.ALL_BINARY_NAMES) ? new PCFQuery(template, new PCFParameter[]{new MQCFBS(7007, PCFQuery.ALL_BINARY_NAMES)}, this.pcfFilter) : new PCFQuery(template, new PCFParameter[]{new MQCFBS(7006, this.byteObjectName)}, this.pcfFilter);
                    break;
                }
                case 1006: {
                    template = PCFCommands.createTemplate(t, id, 13);
                    this.pcfQuery = this.byteObjectName.equals(PCFQuery.ALL_BINARY_NAMES) ? new PCFQuery(template, new PCFParameter[]{new MQCFBS(7007, PCFQuery.ALL_BINARY_NAMES)}, this.pcfFilter) : new PCFQuery(template, new PCFParameter[]{new MQCFBS(7006, this.byteObjectName)}, this.pcfFilter);
                    break;
                }
                case 115: {
                    if (this.objectDisp != -99) {
                        template = PCFCommands.createTemplate(t, id, 55);
                        this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFST(2039, this.objectName), new MQCFIN(63, this.objectDisp)}, this.pcfFilter);
                    } else {
                        template = PCFCommands.createTemplate(t, id, 14);
                        this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    }
                    break;
                }
                case 186: {
                    template = PCFCommands.createTemplate(t, id, 64);
                    pcfParameter = new PCFParameter[]{new MQCFST(2039, this.cfstructName)};
                    this.pcfQuery = new PCFQuery(template, pcfParameter, this.pcfFilter);
                    break;
                }
                case 199: {
                    template = PCFCommands.createTemplate(t, id, 66);
                    pcfParameter = new PCFParameter[]{new MQCFST(2039, this.cfstructName)};
                    this.pcfQuery = new PCFQuery(template, pcfParameter, this.pcfFilter);
                    break;
                }
                case 1019: {
                    template = PCFCommands.createTemplate(t, id, 15);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    break;
                }
                case 1020: {
                    template = PCFCommands.createTemplate(t, id, 16);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    break;
                }
                case 1021: {
                    template = PCFCommands.createTemplate(t, id, 17);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    break;
                }
                case 1028: {
                    template = PCFCommands.createTemplate(t, id, 67);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    break;
                }
                case 1000: {
                    template = PCFCommands.createTemplate(t, id, 18);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    break;
                }
                case 1015: {
                    template = PCFCommands.createTemplate(t, id, 19);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    break;
                }
                case 88: {
                    template = PCFCommands.createTemplate(t, id, 20);
                    this.pcfQuery = this.objectName.equals("*") ? new PCFQuery(template, new PCFParameter[]{new MQCFIN(1228, 256), new MQCFIN(1016, this.objectSubType), new MQCFIN(1118, this.entityType), new MQCFST(3068, this.entityName), new MQCFIL(1114, PCFQuery.ALL_ATTRS)}, this.pcfFilter) : new PCFQuery(template, new PCFParameter[]{new MQCFIN(1228, 256), new MQCFIN(1016, this.objectSubType), new MQCFIN(1118, this.entityType), new MQCFST(3068, this.entityName), new MQCFST(3046, this.objectName), new MQCFIL(1114, PCFQuery.ALL_ATTRS)}, this.pcfFilter);
                    break;
                }
                case 97: {
                    template = PCFCommands.createTemplate(t, id, 21);
                    this.pcfQuery = this.objectSubType == -99 || this.objectSubType == 0 ? new PCFQuery(template, this.objectName, this.pcfFilter) : new PCFQuery(template, new PCFParameter[]{new MQCFST(3554, this.objectName), new MQCFIN(1501, this.objectSubType)}, this.pcfFilter);
                    break;
                }
                case 98: {
                    template = PCFCommands.createTemplate(t, id, 22);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    break;
                }
                case 120: {
                    template = PCFCommands.createTemplate(t, id, 23);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    this.localFilter = true;
                    break;
                }
                case 1011: {
                    template = PCFCommands.createTemplate(t, id, 23);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    this.localFilter = true;
                    this.objectSubType = 12;
                    break;
                }
                case 1012: {
                    template = PCFCommands.createTemplate(t, id, 23);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    this.localFilter = true;
                    this.objectSubType = 13;
                    break;
                }
                case 36: {
                    if (this.objectDisp != -99) {
                        template = PCFCommands.createTemplate(t, id, 25);
                        this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFST(2010, this.objectName), new MQCFIN(63, this.objectDisp)}, this.pcfFilter);
                    } else {
                        template = PCFCommands.createTemplate(t, id, 24);
                        this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    }
                    break;
                }
                case 7: {
                    if (this.objectDisp != -99) {
                        template = PCFCommands.createTemplate(t, id, 27);
                        this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFST(2012, this.objectName), new MQCFIN(63, this.objectDisp)}, this.pcfFilter);
                    } else {
                        template = PCFCommands.createTemplate(t, id, 26);
                        this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    }
                    break;
                }
                case 185: {
                    template = PCFCommands.createTemplate(t, id, 52);
                    this.pcfQuery = new PCFQuery(template);
                    break;
                }
                case 1031: {
                    template = PCFCommands.createTemplate(t, id, 72);
                    this.pcfQuery = new PCFQuery(template);
                    break;
                }
                case 1032: {
                    template = PCFCommands.createTemplate(t, id, 73);
                    this.pcfQuery = new PCFQuery(template);
                    break;
                }
                case 2: {
                    this.pcfQuery = new PCFQuery(PCFQuery.INQUIRE_Q_MGR);
                    break;
                }
                case 161: {
                    template = PCFCommands.createTemplate(t, id, 30);
                    this.pcfQuery = new PCFQuery(template);
                    break;
                }
                case 13: {
                    this.generatePCFQueueQuery(t, id);
                    break;
                }
                case 119: {
                    template = PCFCommands.createTemplate(t, id, 33);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    break;
                }
                case 1007: {
                    template = PCFCommands.createTemplate(t, id, 31);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    break;
                }
                case 1008: {
                    template = PCFCommands.createTemplate(t, id, 32);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    break;
                }
                case 121: {
                    template = PCFCommands.createTemplate(t, id, 34);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    this.objectSubType = 1152;
                    break;
                }
                case 1014: {
                    template = PCFCommands.createTemplate(t, id, 35);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    this.objectSubType = 1154;
                    break;
                }
                case 153: {
                    template = PCFCommands.createTemplate(t, id, 36);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    break;
                }
                case 154: {
                    template = PCFCommands.createTemplate(t, id, 37);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    break;
                }
                case 122: {
                    if (this.objectDisp != -99) {
                        template = PCFCommands.createTemplate(t, id, 39);
                        this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFST(2022, this.objectName), new MQCFIN(63, this.objectDisp)}, this.pcfFilter);
                    } else {
                        template = PCFCommands.createTemplate(t, id, 38);
                        this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    }
                    break;
                }
                case 176: {
                    if (this.objectSubType == -99) {
                        template = PCFCommands.createTemplate(t, id, 47);
                        this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    } else {
                        template = PCFCommands.createTemplate(t, id, 47);
                        if (this.objectSubType == -2) {
                            this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFST(3152, this.objectName), new MQCFIN(1289, -1)}, this.pcfFilter);
                        } else {
                            if (this.objectSubType == 0) {
                                this.objectSubType = -1;
                            }
                            this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFST(3152, this.objectName), new MQCFIN(1289, this.objectSubType)}, this.pcfFilter);
                        }
                    }
                    break;
                }
                case 182: {
                    template = PCFCommands.createTemplate(t, id, 48);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    break;
                }
                case 123: {
                    template = PCFCommands.createTemplate(t, id, 40);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    this.localFilter = true;
                    break;
                }
                case 174: {
                    if (this.objectDisp != -99) {
                        template = PCFCommands.createTemplate(t, id, 46);
                        this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFST(2092, this.objectName), new MQCFIN(63, this.objectDisp)}, this.pcfFilter);
                    } else {
                        template = PCFCommands.createTemplate(t, id, 45);
                        this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    }
                    break;
                }
                case 183: {
                    template = PCFCommands.createTemplate(t, id, 49);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    break;
                }
                case 1022: {
                    template = PCFCommands.createTemplate(t, id, 50);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    break;
                }
                case 1023: {
                    template = PCFCommands.createTemplate(t, id, 51);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    break;
                }
                case 126: {
                    template = PCFCommands.createTemplate(t, id, 41);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    break;
                }
                case 1016: {
                    template = PCFCommands.createTemplate(t, id, 42);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    this.localFilter = true;
                    this.objectSubType = 1170;
                    break;
                }
                case 1017: {
                    template = PCFCommands.createTemplate(t, id, 43);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    break;
                }
                case 1018: {
                    template = PCFCommands.createTemplate(t, id, 44);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    this.localFilter = true;
                    this.objectSubType = 1168;
                    break;
                }
                case 1029: {
                    template = PCFCommands.createTemplate(t, id, 68);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    this.localFilter = true;
                    this.objectSubType = 1335;
                    break;
                }
                case 1026: {
                    template = PCFCommands.createTemplate(t, id, 60);
                    this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFST(3501, this.objectName)}, this.pcfFilter);
                    break;
                }
                case 1027: {
                    template = PCFCommands.createTemplate(t, id, 62);
                    this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
                    this.pcfQuery.setResponseRestartPoint(0);
                    this.pcfQuery.setMaxResponses(CorePlugin.getDefault().getMaxResponses());
                    break;
                }
                default: {
                    if (Trace.isTracing) {
                        t.data(65, "DmObjectFilter.generatePCFQuery", 900, "Unable to create PCFQuery for object type " + this.objectType);
                    }
                    return;
                }
            }
        }
        catch (Throwable th) {
            if (Trace.isTracing) {
                t.data(65, "DmObjectFilter.generatePCFQuery", 900, th.getMessage());
            }
            return;
        }
        if (Trace.isTracing) {
            t.data(65, "DmObjectFilter.generatePCFQuery", 300, "DmObjectFilter =\n" + this.toString(t));
        }
    }

    public void setCFStruct(Trace t, String name) {
        this.cfstructName = name;
        if (Trace.isTracing) {
            t.data(65, "DmObjectFilter.setCFStruct", 300, "Setting CFStruct name/type to " + name);
        }
    }

    public void setEntity(Trace t, String name, int type) {
        this.entityType = type;
        this.entityName = name;
        if (Trace.isTracing) {
            t.data(65, "DmObjectFilter.setEntity", 300, "Setting entity name/type to " + name + "/" + type);
        }
    }

    public void setEntity(Trace t, String name, int type, int authOptions) {
        this.entityType = type;
        this.entityName = name;
        this.authorityOptions = authOptions;
        if (Trace.isTracing) {
            t.data(65, "DmObjectFilter.setEntity", 300, "Setting entity name/type/auths to " + name + "/" + type + "/" + authOptions);
        }
    }

    public void setAuthorityOptions(Trace t, int authOptions) {
        this.authorityOptions = authOptions;
        if (Trace.isTracing) {
            t.data(65, "DmObjectFilter.setAuthorityOptions", 300, "Setting authority options to " + authOptions);
        }
    }

    public int getAuthorityOptions() {
        return this.authorityOptions;
    }

    public int getMessagingProvider() {
        return this.messagingProvider;
    }

    public void setMessagingProvider(int mp) {
        this.messagingProvider = mp;
    }

    public int getResponseRestartPoint() {
        return this.responseRestartPoint;
    }

    public void setResponseRestartPoint(int responseRestartPoint) {
        this.responseRestartPoint = responseRestartPoint;
    }

    public int getMaxResponses() {
        return this.maxResponses;
    }

    public void setMaxResponses(int maxResponses) {
        this.maxResponses = maxResponses;
    }

    public void resetDisp() {
        this.objectDisp = -99;
    }

    public String toString(Trace t) {
        if (this.pcfQuery == null) {
            return String.valueOf(this.getClass().getName()) + "@" + Integer.toHexString(this.hashCode()) + "\n" + " [name=" + this.objectName + ", Dm type=" + this.objectType + ", subType=" + this.objectSubType + ", PCFFilter=null]\n" + ", PCFQuery=null]";
        }
        if (this.pcfFilter == null) {
            return String.valueOf(this.getClass().getName()) + "@" + Integer.toHexString(this.hashCode()) + "\n" + " [name=" + this.objectName + ", Dm type=" + this.objectType + ", subType=" + this.objectSubType + ", PCFFilter=null]\n" + this.pcfQuery.getTemplate().toString();
        }
        return String.valueOf(this.getClass().getName()) + "@" + Integer.toHexString(this.hashCode()) + "\n" + " [name=" + this.objectName + ", Dm type=" + this.objectType + ", subType=" + this.objectSubType + ", " + this.pcfFilter.toString() + "]\n" + this.pcfQuery.getTemplate().toString();
    }

    private void generatePCFQueueQuery(Trace t, String id) {
        PCFQueryTemplate template = null;
        boolean useQTypeAttr = true;
        if (this.pcfFilter != null && this.pcfFilter.getParameter() == 20) {
            useQTypeAttr = false;
        }
        if (this.objectSubType == -99) {
            if (this.objectDisp != -99) {
                template = useQTypeAttr ? PCFCommands.createTemplate(t, id, 56) : PCFCommands.createTemplate(t, id, 29);
                this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFST(2016, this.objectName), new MQCFIN(63, this.objectDisp)}, this.pcfFilter);
            } else {
                template = useQTypeAttr ? PCFCommands.createTemplate(t, id, 59) : PCFCommands.createTemplate(t, id, 28);
                this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
            }
        } else if (this.objectDisp != -99) {
            if (useQTypeAttr) {
                template = PCFCommands.createTemplate(t, id, 56);
                this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFST(2016, this.objectName), new MQCFIN(20, this.objectSubType), new MQCFIN(63, this.objectDisp)}, this.pcfFilter);
            } else {
                template = PCFCommands.createTemplate(t, id, 29);
                this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFST(2016, this.objectName), new MQCFIN(63, this.objectDisp)}, this.pcfFilter);
            }
        } else if (useQTypeAttr) {
            template = PCFCommands.createTemplate(t, id, 59);
            this.pcfQuery = new PCFQuery(template, new PCFParameter[]{new MQCFST(2016, this.objectName), new MQCFIN(20, this.objectSubType)}, this.pcfFilter);
        } else {
            template = PCFCommands.createTemplate(t, id, 28);
            this.pcfQuery = new PCFQuery(template, this.objectName, this.pcfFilter);
        }
    }
}

