/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.event;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmObjectView;
import java.util.EventObject;

public class DmObjectEvent
extends EventObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/event/DmObjectEvent.java";
    private int objectType = 0;
    private int eventType = 0;
    private boolean last = true;
    private DmCoreException exception = null;
    private DmObjectView view = null;
    public static final int OBJECT_SUMMARY = 0;
    public static final int OBJECT_ADDED = 1;
    public static final int OBJECT_REMOVED = 2;
    public static final int OBJECT_CHANGED = 4;
    public static final int OBJECT_SHOW = 100;
    public static final int OBJECT_HIDE = 101;
    public static final int OBJECT_DISCONNECT = 102;
    public static final int OBJECT_CONNECT = 103;
    public static final int OBJECT_REFRESH = 104;
    public static final int OBJECT_LIST_DONE = 105;
    public static final int OBJECT_CONNECTING = 106;
    public static final int UNKNOWN = 107;

    private DmObjectEvent(Object source) {
        super(source);
    }

    public DmObjectEvent(Object source, int ot, boolean lf, int et) {
        this(source);
        this.last = lf;
        this.objectType = ot;
        this.eventType = et;
    }

    public DmObjectEvent(Object source, int ot, boolean lf, DmCoreException ex, int et) {
        this(source, ot, lf, et);
        this.exception = ex;
    }

    public DmObjectEvent(Object source, int ot, boolean lf, DmObjectView v, int et) {
        super(source);
        this.last = lf;
        this.objectType = ot;
        this.eventType = et;
        this.view = v;
    }

    public DmObjectEvent(Object source, int ot, boolean lf, DmObjectView v, DmCoreException ex, int et) {
        this(source, ot, lf, v, et);
        this.exception = ex;
    }

    public int getObjectType() {
        return this.objectType;
    }

    public int getEventType() {
        return this.eventType;
    }

    public Object getView() {
        return this.view;
    }

    public boolean isLast() {
        return this.last;
    }

    public DmCoreException getException() {
        return this.exception;
    }

    public static String getNotifyName(Trace t, int notifyType) {
        switch (notifyType) {
            case 1: {
                return "add";
            }
            case 4: {
                return "chg";
            }
            case 103: {
                return "con";
            }
            case 102: {
                return "dsc";
            }
            case 101: {
                return "hde";
            }
            case 2: {
                return "rem";
            }
            case 100: {
                return "shw";
            }
            case 104: {
                return "rfr";
            }
            case 105: {
                return "lst";
            }
            case 106: {
                return "ctg";
            }
            case 0: {
                return "sum";
            }
        }
        if (Trace.isTracing) {
            t.data(65, "DmObjectEvent.getNotifyName", 900, "Unknown notify type : " + notifyType);
        }
        return "???";
    }
}

