/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.event;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.NativeCalls;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrKey;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectSummaryEvent;
import com.ibm.mq.explorer.core.internal.event.DmQueueManagerListener;
import com.ibm.mq.explorer.core.internal.objects.CreateDmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmMachine;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.utils.CoreServices;
import com.ibm.mq.explorer.core.internal.utils.OtherQueueManager;
import com.ibm.mq.explorer.core.internal.utils.QueueManagerHandle;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class DmMonitor
extends Thread {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/event/DmMonitor.java";
    public static final String ALL = "ALL";
    public static final String MY_NAME = "IBM MQ DmMonitor";
    public static final int MILLI_SECONDS = 1000;
    protected static ArrayList<DmObjectListener> machineListeners = new ArrayList(10);
    protected static Hashtable<String, DmQueueManagerListener> queueManagerListeners = new Hashtable(10);
    protected static Hashtable<AttrKey, Attr> machineConfigAttrs = new Hashtable(10);
    protected static DmMachine machine = null;
    private static DmMonitor monitor = null;
    private static boolean closing = false;
    private static boolean userRefresh = false;
    private static int refreshInterval = 60;
    public static final int CONNECTION_TIMEOUT = 30;
    private static int counter = 0;

    public DmMonitor(Trace t) {
        monitor = this;
        if (Trace.isTracing) {
            t.data(65, "DmMonitor.DmMonitor", 300, "New DmMonitor created");
        }
        this.setDaemon(true);
        this.setName(MY_NAME);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMachineListener(Trace t, DmObjectListener listener) {
        boolean added = false;
        ArrayList<DmObjectListener> arrayList = machineListeners;
        synchronized (arrayList) {
            added = machineListeners.add(listener);
        }
        if (Trace.isTracing) {
            if (!added) {
                t.data(65, "DmMonitor.addMachineListener", 900, "Error adding DmMachine listener for " + listener.toString());
            } else {
                t.data(65, "DmMonitor.addMachineListener", 300, "Added DmMachine listener for " + listener.toString());
            }
        }
        t.eventListenerAdded("DmMonitor.addMachineListener", 1, t.formatEventListenerData(t, (Object)monitor, (Object)listener, "Machine"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMachineListener(Trace t, DmObjectListener listener) {
        boolean removed = false;
        ArrayList<DmObjectListener> arrayList = machineListeners;
        synchronized (arrayList) {
            removed = machineListeners.remove(listener);
        }
        if (Trace.isTracing) {
            if (!removed) {
                t.data(65, "DmMonitor.removeMachineListener", 900, "Error removing DmMachine listener for " + listener.toString());
            } else {
                t.data(65, "DmMonitor.removeMachineListener", 300, "Removed DmMachine listener for " + listener.toString());
            }
        }
        t.eventListenerRemoved("DmMonitor.removeMachineListener", 1, t.formatEventListenerData(t, (Object)monitor, (Object)listener, "Machine"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object addQueueManagerListener(Trace t, DmQueueManagerListener listener, boolean all) {
        DmQueueManagerListener oldValue = null;
        String key = null;
        Hashtable<String, DmQueueManagerListener> hashtable = queueManagerListeners;
        synchronized (hashtable) {
            String uniqueID = String.valueOf(++counter);
            key = all ? ALL + uniqueID : uniqueID;
            oldValue = queueManagerListeners.put(key, listener);
        }
        t.eventListenerAdded("DmMonitor.addQueueManagerListener", 1, t.formatEventListenerData(t, (Object)monitor, (Object)listener, "QueueManagers"));
        if (oldValue != null) {
            if (Trace.isTracing) {
                t.data(65, "DmMonitor.addQueueManagerListener", 900, "Key \"" + key + "\" already in table for " + listener.toString());
            }
        } else {
            if (Trace.isTracing) {
                t.data(65, "DmMonitor.addQueueManagerListener", 300, "Key \"" + key + "\" added to table for " + listener.toString());
            }
            if (all) {
                DmMonitor.notifyNewListener(t, listener);
            }
        }
        return key;
    }

    public static void removeQueueManagerListener(Trace t, DmQueueManagerListener listener, Object id) {
        DmQueueManagerListener oldValue = null;
        oldValue = queueManagerListeners.remove(id);
        if (Trace.isTracing) {
            if (oldValue == null) {
                t.data(65, "DmMonitor.removeQueueManagerListener", 1000, "Key \"" + id + "\" not found in table");
            } else {
                t.data(65, "DmMonitor.removeQueueManagerListener", 300, "Key \"" + id + "\" removed from table for " + oldValue.toString());
            }
        }
        t.eventListenerRemoved("DmMonitor.removeQueueManagerListener", 1, t.formatEventListenerData(t, (Object)monitor, (Object)listener, "QueueManagers"));
    }

    public static void notifyAllQueueManagerListeners(Trace t, DmQueueManager qm, int notifyType, DmCoreException ex) {
        DmMonitor.notifyAllQueueManagerListeners(t, qm, notifyType, ex, false);
    }

    public static void notifyAllQueueManagerListeners(Trace t, DmQueueManager qm, int notifyType, DmCoreException ex, boolean ignoreCheck) {
        DmQueueManagerListener listener = null;
        if (!closing) {
            Enumeration<String> e = queueManagerListeners.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                listener = queueManagerListeners.get(key);
                if (!key.startsWith(ALL)) continue;
                DmMonitor.notifyListener(t, qm, notifyType, ex, listener, true, ignoreCheck);
            }
        } else if (Trace.isTracing) {
            t.data(65, "DmMonitor.notifyAllQueueManagerListeners", 300, "Notifying all queue managers ignored - data model closing");
        }
    }

    public static void notifyQueueManagerListener(Trace t, DmQueueManager qm, int notifyType, DmCoreException ex, boolean ignoreCheck) {
        String searchKey = qm.getNotifyID(t);
        DmQueueManagerListener listener = null;
        if (!closing) {
            Enumeration<String> e = queueManagerListeners.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                listener = queueManagerListeners.get(key);
                if (!key.equals(searchKey)) continue;
                DmMonitor.notifyListener(t, qm, notifyType, ex, listener, true, ignoreCheck);
            }
        } else if (Trace.isTracing) {
            t.data(65, "DmMonitor.notifyQueueManagerListener", 300, "Notifying queue manager ignored - data model closing");
        }
    }

    private static void notifyListener(Trace t, DmQueueManager qm, int notifyType, DmCoreException ex, DmQueueManagerListener listener, boolean sendSummary, boolean ignoreCheck) {
        if (CoreServices.isClosing(t) || closing) {
            if (Trace.isTracing) {
                t.data(65, "DmMonitor.notifyListener", 300, "Notification of queue manager " + qm + " ignored - data model closing");
            }
            return;
        }
        if (listener == null) {
            if (Trace.isTracing) {
                t.data(65, "DmMonitor.notifyListener", 900, "Notification of queue manager " + qm + " ignored - no listener info");
            }
            return;
        }
        if (qm == null) {
            if (Trace.isTracing) {
                t.data(65, "DmMonitor.notifyListener", 900, "Notification of queue manager ignored - no queue manager info");
            }
            return;
        }
        t.eventListenerNotified("DmMonitor.notifyListener", 1, t.formatEventListenerData(t, (Object)monitor, (Object)listener, DmObjectEvent.getNotifyName(t, notifyType), qm.getTitle(), "true"));
        switch (notifyType) {
            case 1: {
                if (Trace.isTracing) {
                    t.data(65, "DmMonitor.notifyListener", 300, "Notifying " + listener.toString() + " of new queue manager " + qm.getTitle());
                }
                listener.dmObjectAdded(new DmObjectEvent((Object)qm, 2, true, ex, 1));
                if (!sendSummary) break;
                DmMonitor.sendSummaryEvent(t, listener, qm.getTitle(), 1);
                break;
            }
            case 4: {
                if (ignoreCheck || qm.isConnected()) {
                    if (Trace.isTracing) {
                        t.data(65, "DmMonitor.notifyListener", 300, "Notifying " + listener.toString() + " of changes to " + qm.getTitle());
                    }
                    listener.dmObjectChanged(new DmObjectEvent(qm, 2, true, 4));
                    if (!sendSummary) break;
                    DmMonitor.sendSummaryEvent(t, listener, qm.getTitle(), 1);
                    break;
                }
                if (!Trace.isTracing) break;
                t.data(65, "DmMonitor.notifyListener", 300, "Change notification ignored - queue manager " + qm.getTitle() + " not connected");
                break;
            }
            case 2: {
                if (Trace.isTracing) {
                    t.data(65, "DmMonitor.notifyListener", 300, "Notifying " + listener.toString() + " of deleted queue manager " + qm.getTitle());
                }
                listener.dmObjectDeleted(new DmObjectEvent(qm, 2, true, 2));
                if (!sendSummary) break;
                DmMonitor.sendSummaryEvent(t, listener, qm.getTitle(), 1);
                break;
            }
            case 100: {
                if (Trace.isTracing) {
                    t.data(65, "DmMonitor.notifyListener", 300, "Notifying " + listener.toString() + " to show queue manager " + qm.getTitle());
                }
                listener.dmQueueManagerShown(new DmObjectEvent(qm, 2, true, 100));
                if (!sendSummary) break;
                DmMonitor.sendSummaryEvent(t, listener, qm.getTitle(), 1);
                break;
            }
            case 101: {
                if (Trace.isTracing) {
                    t.data(65, "DmMonitor.notifyListener", 300, "Notifying " + listener.toString() + " to hide queue manager " + qm.getTitle());
                }
                listener.dmQueueManagerHidden(new DmObjectEvent(qm, 2, true, 101));
                if (!sendSummary) break;
                DmMonitor.sendSummaryEvent(t, listener, qm.getTitle(), 1);
                break;
            }
            case 103: {
                if (Trace.isTracing) {
                    t.data(65, "DmMonitor.notifyListener", 300, "Notifying " + listener.toString() + " of connection to queue manager " + qm.getTitle());
                }
                listener.dmQueueManagerConnected(new DmObjectEvent(qm, 2, true, 103));
                if (!sendSummary) break;
                DmMonitor.sendSummaryEvent(t, listener, qm.getTitle(), 1);
                break;
            }
            case 102: {
                if (!ignoreCheck && !DmMonitor.knownQueueManager(t, qm.getTreeName(t))) break;
                if (Trace.isTracing) {
                    t.data(65, "DmMonitor.notifyListener", 300, "Notifying " + listener.toString() + " of disconnection from queue manager " + qm.getTitle());
                }
                listener.dmQueueManagerDisconnected(new DmObjectEvent((Object)qm, 2, true, ex, 102));
                if (!sendSummary) break;
                DmMonitor.sendSummaryEvent(t, listener, qm.getTitle(), 1);
                break;
            }
            case 104: {
                if (Trace.isTracing) {
                    t.data(65, "DmMonitor.notifyListener", 300, "Notifying " + listener.toString() + " of refresh from queue manager " + qm.getTitle());
                }
                listener.dmRefreshComplete(new DmObjectEvent((Object)qm, 2, true, ex, 104));
                break;
            }
            case 106: {
                if (Trace.isTracing) {
                    t.data(65, "DmMonitor.notifyListener", 300, "Notifying " + listener.toString() + " of connecting from queue manager " + qm.getTitle());
                }
                listener.dmQueueManagerConnecting(new DmObjectEvent((Object)qm, 2, true, ex, 106));
                if (!sendSummary) break;
                DmMonitor.sendSummaryEvent(t, listener, qm.getTitle(), 1);
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(65, "DmMonitor.notifyListener", 900, "Unknown notification type : " + notifyType);
            }
        }
    }

    public static void notifyMachineListeners(Trace t) {
        DmObjectListener listener = null;
        if (!closing) {
            int i = 0;
            while (i < machineListeners.size()) {
                listener = machineListeners.get(i);
                DmMonitor.notifyMachineListener(t, listener);
                ++i;
            }
        } else if (Trace.isTracing) {
            t.data(65, "DmMonitor.notifyMachineListeners", 300, "Notifying machine listener ignored - data model closing");
        }
    }

    public static void notifyMachineListener(Trace t, DmObjectListener listener) {
        if (!closing) {
            if (Trace.isTracing) {
                t.data(65, "DmMonitor.notifyMachineListener", 300, "Notifying " + listener.toString() + " for config changes to DmMachine");
            }
            listener.dmObjectChanged(new DmObjectEvent(CoreServices.getMachine(t), 1001, true, 4));
            t.eventListenerNotified("DmMonitor.notifyMachineListener", 1, t.formatEventListenerData(t, (Object)monitor, (Object)listener, "chg", "Machine", "true"));
            DmMonitor.sendSummaryEvent(t, listener, "Machine", 1);
        } else if (Trace.isTracing) {
            t.data(65, "DmMonitor.notifyMachineListener", 300, "Notifying machine listener ignored - data model closing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyRefreshListeners(Trace t) {
        DmObjectListener listener = null;
        if (!closing) {
            Cloneable cloneable = machineListeners;
            synchronized (cloneable) {
                int i = 0;
                while (i < machineListeners.size()) {
                    listener = machineListeners.get(i);
                    if (Trace.isTracing) {
                        t.data(65, "DmMonitor.notifyRefreshListeners", 300, "Notifying " + listener.toString() + " for refreshes to DmMachine");
                    }
                    listener.dmRefreshComplete(new DmObjectEvent(CoreServices.getMachine(t), 1001, true, 104));
                    t.eventListenerNotified("DmMonitor.notifyRefreshListeners", 1, t.formatEventListenerData(t, (Object)monitor, (Object)listener, "rfr", "Machine", "true"));
                    ++i;
                }
            }
            cloneable = queueManagerListeners;
            synchronized (cloneable) {
                Enumeration<String> e = queueManagerListeners.keys();
                while (e.hasMoreElements()) {
                    String key = e.nextElement();
                    listener = queueManagerListeners.get(key);
                    if (!key.startsWith(ALL)) continue;
                    if (Trace.isTracing) {
                        t.data(65, "DmMonitor.notifyRefreshListeners", 300, "Notifying " + listener.toString() + " for refreshes to DmMachine");
                    }
                    listener.dmRefreshComplete(new DmObjectEvent(CoreServices.getMachine(t), 2, true, 104));
                    t.eventListenerNotified("DmMonitor.notifyRefreshListeners", 1, t.formatEventListenerData(t, (Object)monitor, (Object)listener, "rfr", "Machine", "true"));
                }
            }
        }
        if (Trace.isTracing) {
            t.data(65, "DmMonitor.notifyRefreshListeners", 300, "Notifying refresh listener ignored - data model closing");
        }
    }

    @Override
    public void run() {
        boolean interruptedRefresh = false;
        Trace t = Trace.getInstance();
        machine = CoreServices.getMachine(t);
        if (Trace.isTracing) {
            t.data(65, "DmMonitor.run", 300, "DmMonitor started");
        }
        DmMonitor.copyConfigTables(t);
        while (!closing) {
            block8: {
                try {
                    Thread.sleep(refreshInterval * 1000);
                }
                catch (InterruptedException interruptedException) {
                    interruptedRefresh = true;
                    if (Trace.isTracing) {
                        t.data(65, "DmMonitor.run", 900, "DmMonitor interrupted");
                    }
                    if (closing) break;
                    if (!Trace.isTracing) break block8;
                    t.data(65, "DmMonitor.run", 900, "Refreshing cache");
                }
            }
            if (closing) break;
            if (interruptedRefresh) {
                interruptedRefresh = false;
            } else {
                DmMonitor.setUserRefresh(true);
            }
            DmMonitor.refreshConfigAttributes(t);
            this.checkForMachineChanges(t);
            DmMonitor.copyConfigTables(t);
            DmMonitor.checkConnectionStatus(t);
            DmMonitor.notifyRefreshListeners(t);
        }
        if (Trace.isTracing) {
            t.data(65, "DmMonitor.run", 300, "DmMonitor ended");
        }
    }

    public void close(Trace t) {
        closing = true;
        this.interrupt();
    }

    public boolean isClosing(Trace t) {
        return closing;
    }

    private static void copyConfigTables(Trace t) {
        machineConfigAttrs = (Hashtable)machine.getAttributesTable(t).clone();
    }

    private static void refreshConfigAttributes(Trace t) {
        if (Trace.isTracing) {
            t.data(65, "DmMonitor.refreshConfigAttributes", 300, "Refreshing config attributes for DmMachine");
        }
        machine.refreshAttributes(t);
    }

    public static void setRefreshInterval(Trace t, int i) {
        refreshInterval = i;
        if (Trace.isTracing) {
            t.data(65, "DmMonitor.setRefreshInterval", 300, "Refresh interval set to " + i + " secs");
        }
    }

    public static int getRefreshInterval(Trace t) {
        return refreshInterval;
    }

    private void checkForMachineChanges(Trace t) {
        Hashtable<AttrKey, Attr> currentTable = machine.getAttributesTable(t);
        DmMonitor.checkForNewQueueManagers(t, currentTable, machineConfigAttrs);
        if (!DmMonitor.compareTables(t, currentTable, machineConfigAttrs)) {
            DmMonitor.notifyMachineListeners(t);
        }
    }

    private static boolean compareTables(Trace t, Hashtable<AttrKey, Attr> currentTable, Hashtable<AttrKey, Attr> copyTable) {
        boolean equal = true;
        if (currentTable == null || copyTable == null) {
            if (Trace.isTracing) {
                t.data(65, "DmMonitor.compareTables", 300, "Table(s) not created");
            }
            return false;
        }
        Enumeration<AttrKey> e = currentTable.keys();
        while (equal && e.hasMoreElements()) {
            AttrKey key = e.nextElement();
            if (currentTable.get(key).getAttrType().getPCFType() != 1) continue;
            if (copyTable.containsKey(key)) {
                String newValue;
                String currentValue = currentTable.get(key).toString(t);
                if (currentValue.equals(newValue = copyTable.get(key).toString(t))) {
                    copyTable.remove(key);
                    continue;
                }
                if (Trace.isTracing) {
                    t.data(65, "DmMonitor.compareTables", 300, "Attribute " + key.getAttributeID() + "." + key.getRepeatingIndex() + " changed");
                    t.data(65, "DmMonitor.compareTables", 300, "Old vlaue = " + newValue + ", new value = " + currentValue);
                }
                equal = false;
                continue;
            }
            if (Trace.isTracing) {
                t.data(65, "DmMonitor.compareTables", 300, "New attribute " + key.getAttributeID() + "." + key.getRepeatingIndex() + "found");
            }
            equal = false;
        }
        if (equal && copyTable.size() > 0) {
            equal = false;
        }
        copyTable.clear();
        return equal;
    }

    private static boolean shouldShowQM(Trace t, String name, Attr instAttr, String installation, boolean got70) {
        boolean addQM = false;
        String inst = DmMonitor.getInstallationName(t, instAttr);
        if (inst != null) {
            addQM = inst.equals(installation);
        } else {
            boolean bl = addQM = !got70;
        }
        if (Trace.isTracing && !addQM) {
            String msg = "Not showing queue manager " + name;
            msg = inst != null ? String.valueOf(msg) + " from installation " + inst : String.valueOf(msg) + " as MQ 7.0 is installed";
            t.data(65, "DmMonitor.shouldShowQM", 300, msg);
        }
        return addQM;
    }

    private static String getInstallationName(Trace t, Attr instAttr) {
        String inst = null;
        if (instAttr != null) {
            inst = instAttr.toString(t);
        }
        if (inst != null && inst.length() == 0) {
            inst = null;
        }
        return inst;
    }

    private static void checkForNewQueueManagers(Trace t, Hashtable<AttrKey, Attr> currentTable, Hashtable<AttrKey, Attr> oldTable) {
        AttrKey nameKey;
        Attr nameAttr;
        if (currentTable == null || oldTable == null) {
            if (Trace.isTracing) {
                t.data(65, "DmMonitor.checkForNewQueueManagers", 300, "Table(s) not created");
            }
            return;
        }
        String thisInstall = CommonServices.getInstallationName((Trace)t);
        if (thisInstall == null || thisInstall.length() == 0) {
            if (Trace.isTracing) {
                t.data(65, "DmMonitor.checkForNewQueueManagers", 300, "No current installation name");
            }
            return;
        }
        boolean got70 = CoreServices.isMQ70installed(t);
        ArrayList<String> tempTable = new ArrayList<String>();
        int index = 0;
        while ((nameAttr = oldTable.get(nameKey = new AttrKey(10504, index))) != null) {
            AttrKey instKey = new AttrKey(10541, index);
            Attr instAttr = oldTable.get(instKey);
            String qm = nameAttr.toString(t);
            if (DmMonitor.shouldShowQM(t, qm, instAttr, thisInstall, got70)) {
                if (Trace.isTracing) {
                    t.data(65, "DmMonitor.checkForNewQueueManagers", 300, "Adding " + qm + " to temp copy list");
                }
                tempTable.add(qm);
            }
            ++index;
        }
        ArrayList<OtherQueueManager> tempOtherInstalls = new ArrayList<OtherQueueManager>();
        if (currentTable.size() > 0) {
            AttrKey key;
            Attr attr;
            index = 0;
            while ((attr = currentTable.get(key = new AttrKey(10504, index))) != null) {
                AttrKey instKey = new AttrKey(10541, index);
                Attr instAttr = currentTable.get(instKey);
                String qm = attr.toString(t);
                if (DmMonitor.shouldShowQM(t, qm, instAttr, thisInstall, got70)) {
                    if (!tempTable.contains(qm)) {
                        if (Trace.isTracing) {
                            t.data(65, "DmMonitor.checkForNewQueueManagers", 300, "About to create " + qm);
                        }
                        QueueManagerHandle qmh = new QueueManagerHandle(t, qm);
                        new CreateDmQueueManager(t, new DmQueueManagerHandle(t, qmh), (Object)ALL);
                    } else {
                        if (Trace.isTracing) {
                            t.data(65, "DmMonitor.checkForNewQueueManagers", 300, "Removing " + qm + " from temp copy list");
                        }
                        tempTable.remove(qm);
                    }
                } else {
                    String inst = DmMonitor.getInstallationName(t, instAttr);
                    if (inst == null) {
                        inst = "Installation0";
                    }
                    OtherQueueManager otherQueueManager = new OtherQueueManager(qm, inst);
                    tempOtherInstalls.add(otherQueueManager);
                }
                ++index;
            }
        }
        CoreServices.setQueueManagersFromOtherInstallations(tempOtherInstalls);
        if (Trace.isTracing) {
            t.data(65, "DmMonitor.checkForNewQueueManagers", 300, String.valueOf(tempTable.size()) + " queue manager(s) to delete");
        }
        for (String qm : tempTable) {
            if (Trace.isTracing) {
                t.data(65, "DmMonitor.checkForNewQueueManagers", 300, "About to remove " + qm);
            }
            DmMonitor.removeQueueManager(t, qm);
        }
    }

    public static void checkStatusOfQueueManager(Trace t, DmQueueManager dmqm) {
        boolean connected = dmqm.isConnected();
        boolean lastStatus = dmqm.getOldConnectionStatus();
        boolean commandServerRunning = dmqm.isCommandServerRunning(t);
        if (Trace.isTracing) {
            t.data(65, "DmMonitor.checkStatusOfQueueManager", 300, "Queue manager " + dmqm.getTreeName(t) + ", currentStatus=" + connected + ", lastStatus=" + lastStatus + ", cmdServerStatus=" + commandServerRunning);
        }
        if (!lastStatus && !connected) {
            if (commandServerRunning && dmqm.attemptAutoReconnect(t)) {
                dmqm.connectAsynchronously(t, ALL);
            }
        } else if (!lastStatus && connected) {
            if (commandServerRunning) {
                DmMonitor.notifyAllQueueManagerListeners(t, dmqm, 103, null);
            } else {
                dmqm.disconnectAsync(t, 2322);
            }
        } else if (lastStatus && !connected) {
            if (commandServerRunning && dmqm.attemptAutoReconnect(t)) {
                dmqm.connectAsynchronously(t, ALL);
            } else {
                DmMonitor.notifyAllQueueManagerListeners(t, dmqm, 4, null, true);
            }
        }
        dmqm.setOldConnectionStatus(connected);
        if (Trace.isTracing) {
            t.data(65, "DmMonitor.checkStatusOfQueueManager", 300, "Queue manager " + dmqm.getTitle() + ", setting connected to " + connected);
        }
        DmMonitor.checkRunningStatusOfQueueManager(t, dmqm);
    }

    private static void checkRunningStatusOfQueueManager(Trace t, DmQueueManager dmqm) {
        if (dmqm.isLocal()) {
            int lastRunningStatus = dmqm.getRunningStatus();
            int newRunning = NativeCalls.getQueueManagerStatus((Trace)t, (String)dmqm.getTitle());
            if (Trace.isTracing) {
                t.data(65, "DmMonitor.checkRunningStatusOfQueueManager", 300, "Queue manager " + dmqm.getTitle() + ", currentRunning status=" + lastRunningStatus + ", newRunning status=" + newRunning);
            }
            dmqm.setRunningStatus(t, newRunning);
            if (lastRunningStatus != newRunning) {
                switch (lastRunningStatus) {
                    case 0: 
                    case 13: 
                    case 14: {
                        if (newRunning != 0) {
                            DmMonitor.notifyAllQueueManagerListeners(t, dmqm, 102, null);
                            break;
                        }
                        if (lastRunningStatus == newRunning) break;
                        DmMonitor.notifyAllQueueManagerListeners(t, dmqm, 4, null, true);
                        break;
                    }
                    default: {
                        if (lastRunningStatus == newRunning) break;
                        DmMonitor.notifyAllQueueManagerListeners(t, dmqm, 4, null, true);
                    }
                }
            }
        }
    }

    private static void removeQueueManager(Trace t, String name) {
        ArrayList<DmQueueManager> qms = CoreServices.getQueueManagers(t);
        int i = 0;
        while (i < qms.size()) {
            DmQueueManager dmqm = qms.get(i);
            if (dmqm != null && dmqm.getTitle().equals(name) && dmqm.isLocal(t)) {
                if (Trace.isTracing) {
                    t.data(65, "DmMonitor.removeQueueManager", 300, "Removing " + dmqm.getTitle());
                }
                CoreServices.removeQueueManager(t, dmqm.getConnectionHandle());
                break;
            }
            ++i;
        }
    }

    private static void checkConnectionStatus(Trace t) {
        try {
            if (CoreServices.isClosing(t)) {
                closing = true;
            } else {
                ArrayList<DmQueueManager> qms = CoreServices.getQueueManagers(t);
                int i = 0;
                while (i < qms.size()) {
                    DmQueueManager qm = qms.get(i);
                    if (qm != null) {
                        qm.refresh(t);
                    }
                    ++i;
                }
            }
        }
        finally {
            DmMonitor.setUserRefresh(false);
        }
    }

    private static void notifyNewListener(Trace t, final DmQueueManagerListener listener) {
        if (!closing) {
            new Thread(){

                @Override
                public void run() {
                    Trace t2 = Trace.getInstance();
                    this.setName("IBM MQ notifying new listener");
                    ArrayList<DmQueueManager> qms = CoreServices.getQueueManagers(t2);
                    int i = 0;
                    while (i < qms.size()) {
                        DmQueueManager qm = qms.get(i);
                        if (qm != null) {
                            DmMonitor.notifyListener(t2, qm, 1, null, listener, false, false);
                            if (qm.isConnected()) {
                                DmMonitor.notifyListener(t2, qm, 103, null, listener, false, false);
                            }
                        }
                        ++i;
                    }
                    DmMonitor.sendSummaryEvent(t2, listener, "Machine", qms.size());
                }
            }.start();
        } else if (Trace.isTracing) {
            t.data(65, "DmMonitor.notifyNewListener", 300, "Notifying new listener ignored - data model closing");
        }
    }

    private static void sendSummaryEvent(Trace t, DmObjectListener listener, String owner, int count) {
        if (!closing) {
            DmObjectSummaryEvent summaryEvent = new DmObjectSummaryEvent(monitor, null, count);
            listener.dmObjectSummary(summaryEvent);
            listener.dmRefreshComplete(new DmObjectEvent(new Object(), 2, true, 104));
            t.eventListenerNotified("DmMonitor.sendSummaryEvent", 1, t.formatEventListenerData(t, (Object)monitor, (Object)listener, DmObjectEvent.getNotifyName(t, 0), String.valueOf(owner) + "(" + 1 + "/" + count + ")", "true"));
        } else if (Trace.isTracing) {
            t.data(65, "DmMonitor.sendSummaryEvent", 300, "Notifying summary event listener ignored - data model closing");
        }
    }

    public void refresh(Trace t) {
        if (Trace.isTracing) {
            t.data(65, "DmMonitor.refresh", 300, "Refreshing DmMonitor cache");
        }
        monitor.interrupt();
    }

    @Override
    public String toString() {
        return MY_NAME;
    }

    private static boolean knownQueueManager(Trace t, String name) {
        boolean known = false;
        ArrayList<DmQueueManager> qms = CoreServices.getQueueManagers(t);
        int i = 0;
        while (i < qms.size()) {
            DmQueueManager dmqm = qms.get(i);
            if (dmqm != null && dmqm.getTreeName(t).equals(name)) {
                known = true;
                break;
            }
            ++i;
        }
        if (Trace.isTracing) {
            if (known) {
                t.data(65, "DmMonitor.knownQueueManager", 300, "Queue manager " + name + " is known to the data model");
            } else {
                t.data(65, "DmMonitor.knownQueueManager", 300, "Queue manager " + name + " is NOT known to the data model");
            }
        }
        return known;
    }

    public static synchronized void setUserRefresh(boolean refresh) {
        userRefresh = refresh;
    }

    public static synchronized boolean isUserRefresh() {
        return userRefresh;
    }
}

