/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.event;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.filter.DmObjectResponse;
import com.ibm.mq.explorer.core.internal.filter.IDmObjectResponse;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmObjectFactory;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.core.internal.objects.PCFAction;
import com.ibm.mq.explorer.core.internal.report.ReportManager;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import com.ibm.mq.pcf.event.PCFQuery;
import java.util.ArrayList;

public class DmCommonObjectView {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/event/DmCommonObjectView.java";
    private DmObjectFilter objectFilter = null;
    private DmQueueManager queueManager = null;
    private ArrayList<IDmObject> listOfObjects = null;
    private PCFQuery statusQueury = null;
    private ArrayList<IDmObject> listOfStatusObjects = null;
    private DmCoreException dmCoreException = null;
    private int dmObjectType = -1;
    private int dmStatusObjectType = -1;
    protected static int NOT_FOUND = -1;
    private IDmObjectResponse responseFilter = null;

    public DmCommonObjectView(Trace t, DmQueueManager qMgr, DmObjectFilter filter) {
        this.objectFilter = filter;
        this.queueManager = qMgr;
        this.dmObjectType = filter.getType();
        this.listOfObjects = new ArrayList(10);
        this.listOfStatusObjects = new ArrayList(10);
        filter.generatePCFQuery(t, String.valueOf(this.queueManager.getUUID()) + "@" + filter.toString(t));
        DmObject plain = (DmObject)DmObjectFactory.getPlainObject(t, this.getDmObjectType(t));
        this.responseFilter = plain != null ? plain.getObjectResponse(t) : new DmObjectResponse(t);
    }

    protected int getObjectTypeFromPCFMessage(Trace t, PCFMessage pcfMessage, int id) {
        int type;
        block2: {
            type = NOT_FOUND;
            try {
                type = pcfMessage.getIntParameterValue(id);
            }
            catch (PCFException pCFException) {
                if (!Trace.isTracing) break block2;
                t.data(65, "DmCommonObjectView.getObjectTypeFromPCFMessage", 1000, "Object type not found in PFCMessage");
            }
        }
        return type;
    }

    protected String getObjectNameFromPCFMessage(Trace t, PCFMessage pcfMessage, int id) {
        String name = "";
        Object o = pcfMessage.getParameterValue(id);
        if (o == null) {
            if (Trace.isTracing) {
                t.data(65, "DmCommonObjectView.getObjectNameFromPCFMessage", 1000, "Object name not found in PFCMessage");
            }
            return "";
        }
        if (o instanceof String) {
            name = (String)o;
        } else if (o instanceof byte[]) {
            name = new String((byte[])o);
        } else if (Trace.isTracing) {
            t.data(65, "DmCommonObjectView.getObjectNameFromPCFMessage", 900, "Unknown object type in PFCMessage");
        }
        return name.trim();
    }

    protected DmObjectFilter getObjectFilter(Trace t) {
        return this.objectFilter;
    }

    protected ArrayList<IDmObject> getListOfObjects(Trace t) {
        return this.listOfObjects;
    }

    protected ArrayList<IDmObject> getListOfStatusObjects(Trace t) {
        return this.listOfStatusObjects;
    }

    protected PCFQuery getStatusQuery(Trace t) {
        return this.statusQueury;
    }

    protected void setStatusQuery(Trace t, PCFQuery q) {
        this.statusQueury = q;
    }

    public DmQueueManager getQueueManager(Trace t) {
        return this.queueManager;
    }

    protected DmCoreException getException(Trace t) {
        return this.dmCoreException;
    }

    public int getDmObjectType(Trace t) {
        return this.dmObjectType;
    }

    protected int getDmStatusObjectType(Trace t) {
        return this.dmStatusObjectType;
    }

    protected void setDmStatusObjectType(Trace t, int i) {
        this.dmStatusObjectType = i;
    }

    protected void setException(Trace t, DmCoreException ex) {
        this.dmCoreException = ex;
    }

    protected boolean ignoreClientConnChannel(Trace t, PCFMessage pcfMessage) {
        boolean retValue = false;
        int chType = this.getObjectTypeFromPCFMessage(t, pcfMessage, 1511);
        if (chType == 6 && this.objectFilter.getSubType() != 6 && this.objectFilter.getType() != 1005) {
            if (Trace.isTracing) {
                t.data(65, "DmCommonObjectView.ignoreClientConnChannel", 300, "Client conn channel");
            }
            retValue = true;
        }
        return retValue;
    }

    protected boolean ignorePCFMessage(Trace t, PCFMessage pcfMessage, int eventObjectType, int objectType) {
        boolean ignore = true;
        if (Trace.isTracing) {
            t.data(65, "DmCommonObjectView.ignorePCFMessage", 300, "Object type in PCF message " + eventObjectType + ", callers object type " + objectType);
        }
        int filterSubType = this.objectFilter.getSubType();
        if (Trace.isTracing) {
            t.data(65, "DmCommonObjectView.ignorePCFMessage", 300, "Sub-type from filter " + filterSubType);
        }
        int pcfTypeId = PCFAction.getPCFTypeId(t, objectType);
        if (Trace.isTracing) {
            t.data(65, "DmCommonObjectView.ignorePCFMessage", 300, "PCF type id " + pcfTypeId);
        }
        if (pcfTypeId != NOT_FOUND) {
            int subType = this.getObjectTypeFromPCFMessage(t, pcfMessage, pcfTypeId);
            if (Trace.isTracing) {
                t.data(65, "DmCommonObjectView.ignorePCFMessage", 300, "Sub-type from PCF message " + subType);
            }
            if (subType == filterSubType || filterSubType == 11) {
                ignore = false;
            }
        }
        if (Trace.isTracing) {
            t.data(65, "DmCommonObjectView.ignorePCFMessage", 300, "Ignore PCF message : " + ignore);
        }
        return ignore;
    }

    protected void updateInitToSet(Trace t, DmObject object) {
        if (Trace.isTracing) {
            t.data(65, "DmCommonObjectView.updateInitToSet", 300, "Filter type " + this.objectFilter.getType() + "/" + this.objectFilter.getSubType() + ", object type " + object.getObjectType(t) + "/" + object.getObjectSubType(t));
        }
        switch (this.objectFilter.getType()) {
            case 114: 
            case 120: 
            case 123: {
                if (this.objectFilter.getSubType() == 11) {
                    object.replaceAttributeValue(t, 1175, 0, 11, false);
                    if (!Trace.isTracing) break;
                    t.data(65, "DmCommonObjectView.updateInitToSet", 300, "Updated MQIACF_SYSP_TYPE to MQSYSP_TYPE_SET for " + object.getTitle());
                    break;
                }
                if (!Trace.isTracing) break;
                t.data(65, "DmCommonObjectView.updateInitToSet", 300, "Update MQIACF_SYSP_TYPE ignored for " + object.getTitle());
                break;
            }
            default: {
                if (!Trace.isTracing) break;
                t.data(65, "DmCommonObjectView.updateInitToSet", 300, "Update MQIACF_SYSP_TYPE ignored for " + object.getTitle() + ", wrong type");
            }
        }
    }

    protected boolean ignoreChannelInitiator(Trace t, PCFMessage pcfMessage) {
        boolean retValue;
        block5: {
            retValue = true;
            int port = 0;
            try {
                port = pcfMessage.getIntParameterValue(1599);
                if (this.objectFilter.getType() == 1015) {
                    if (Trace.isTracing) {
                        t.data(65, "DmCommonObjectView.ignoreChannelInitiator", 300, "User wants channel listener status and port address is " + port);
                    }
                    retValue = false;
                }
            }
            catch (PCFException pCFException) {
                if (this.objectFilter.getType() != 1000) break block5;
                if (Trace.isTracing) {
                    t.data(65, "DmCommonObjectView.ignoreChannelInitiator", 300, "User wants chinit status and this is chinit status");
                }
                retValue = false;
            }
        }
        return retValue;
    }

    protected IDmObjectResponse getResponseFilter(Trace t) {
        return this.responseFilter;
    }

    protected void report(Trace t, PCFQuery query) {
        ReportManager.getDefault().add(t, this.getQueueManager(t).getTitle(), query);
    }
}

