/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.base;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.utils.ConvertReasonCode;

public class DmCoreException
extends Exception {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/base/DmCoreException.java";
    private int reasonCode = 0;
    private int compCode = 0;
    private int severity = 0;
    private String messageID = "AMQ????";

    public DmCoreException(String message, String msgID, int rc, int cc, int sev) {
        super(message);
        this.messageID = msgID;
        this.reasonCode = rc;
        this.compCode = cc;
        this.severity = sev;
    }

    public DmCoreException(Trace t, String message, String msgID, int rc, int cc, int sev) {
        this(message, msgID, rc, cc, sev);
        if (Trace.isTracing) {
            t.data(65, "DmCoreException.DmCoreException", 900, "Message = " + message + ", msgID = " + msgID + ", reason = " + rc + ", comp = " + cc + ", severity = " + sev);
        }
    }

    public DmCoreException(String message, Throwable cause, String msgID, int rc, int cc, int sev) {
        super(message, cause);
        this.messageID = msgID;
        this.reasonCode = rc;
        this.compCode = cc;
        this.severity = sev;
    }

    public DmCoreException(Trace t, String message, Throwable cause, String msgID, int rc, int cc, int sev) {
        this(message, cause, msgID, rc, cc, sev);
        if (Trace.isTracing) {
            t.data(65, "DmCoreException.DmCoreException", 900, "Message = " + message + ", msgID = " + msgID + ", reason = " + rc + ", comp = " + cc + ", severity = " + sev + ", previous exception = " + cause.getMessage());
        }
    }

    public static DmCoreException create(Trace t, DmObject owner, int cmd, int rc, int cc) {
        if (Trace.isTracing) {
            t.data(65, "DmCoreException.create", 900, "Owner = " + owner.getTitle() + ", command = " + cmd + ", reason = " + rc + ", comp = " + cc);
        }
        String msg = ConvertReasonCode.getSystemMessage(t, owner, cmd, rc, cc);
        String msgId = CommonServices.getSystemMessageId((Trace)t, (int)rc);
        DmCoreException ex = new DmCoreException(t, msg, msgId, rc, cc, 20);
        return ex;
    }

    public int getCompCode() {
        return this.compCode;
    }

    public int getReasonCode() {
        return this.reasonCode;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getMessageID() {
        return this.messageID;
    }
}

