/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.base;

import com.ibm.mq.MQException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.explorer.core.internal.base.CorePlugin;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.base.IDmObservable;
import com.ibm.mq.explorer.core.internal.event.DmErrorListener;
import com.ibm.mq.explorer.core.internal.event.DmMonitor;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.event.DmQueueManagerListener;
import com.ibm.mq.explorer.core.internal.objects.DisplayGroup;
import com.ibm.mq.explorer.core.internal.objects.DmArchive;
import com.ibm.mq.explorer.core.internal.objects.DmArchiveTape;
import com.ibm.mq.explorer.core.internal.objects.DmAuthinfo;
import com.ibm.mq.explorer.core.internal.objects.DmAuthorityRecord;
import com.ibm.mq.explorer.core.internal.objects.DmChannel;
import com.ibm.mq.explorer.core.internal.objects.DmChannelAuthenticationRecord;
import com.ibm.mq.explorer.core.internal.objects.DmChannelStatusCurrent;
import com.ibm.mq.explorer.core.internal.objects.DmChannelStatusSaved;
import com.ibm.mq.explorer.core.internal.objects.DmClientChannel;
import com.ibm.mq.explorer.core.internal.objects.DmClusterQueue;
import com.ibm.mq.explorer.core.internal.objects.DmClusterQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmClusterTopic;
import com.ibm.mq.explorer.core.internal.objects.DmCommInfo;
import com.ibm.mq.explorer.core.internal.objects.DmCouplingFacility;
import com.ibm.mq.explorer.core.internal.objects.DmCouplingFacilitySMDS;
import com.ibm.mq.explorer.core.internal.objects.DmCouplingFacilitySMDSCONN;
import com.ibm.mq.explorer.core.internal.objects.DmCouplingFacilityStatusBackup;
import com.ibm.mq.explorer.core.internal.objects.DmCouplingFacilityStatusConnect;
import com.ibm.mq.explorer.core.internal.objects.DmCouplingFacilityStatusSMDS;
import com.ibm.mq.explorer.core.internal.objects.DmCouplingFacilityStatusSummary;
import com.ibm.mq.explorer.core.internal.objects.DmDistQueueManagement;
import com.ibm.mq.explorer.core.internal.objects.DmDistQueueManagementListener;
import com.ibm.mq.explorer.core.internal.objects.DmEntityAuthority;
import com.ibm.mq.explorer.core.internal.objects.DmListener;
import com.ibm.mq.explorer.core.internal.objects.DmListenerStatus;
import com.ibm.mq.explorer.core.internal.objects.DmLog;
import com.ibm.mq.explorer.core.internal.objects.DmLogCopy;
import com.ibm.mq.explorer.core.internal.objects.DmLogStatus;
import com.ibm.mq.explorer.core.internal.objects.DmMachine;
import com.ibm.mq.explorer.core.internal.objects.DmNHAGroupStatus;
import com.ibm.mq.explorer.core.internal.objects.DmNHAStatus;
import com.ibm.mq.explorer.core.internal.objects.DmNamelist;
import com.ibm.mq.explorer.core.internal.objects.DmProcess;
import com.ibm.mq.explorer.core.internal.objects.DmPubSubStatus;
import com.ibm.mq.explorer.core.internal.objects.DmQSGMember;
import com.ibm.mq.explorer.core.internal.objects.DmQueue;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerConnection;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerConnectionHandle;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandleInstance;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerStatus;
import com.ibm.mq.explorer.core.internal.objects.DmQueueStatusHandle;
import com.ibm.mq.explorer.core.internal.objects.DmQueueStatusQueue;
import com.ibm.mq.explorer.core.internal.objects.DmRemoteQueueManagerName;
import com.ibm.mq.explorer.core.internal.objects.DmSecurity;
import com.ibm.mq.explorer.core.internal.objects.DmSecuritySwitch;
import com.ibm.mq.explorer.core.internal.objects.DmService;
import com.ibm.mq.explorer.core.internal.objects.DmServiceStatus;
import com.ibm.mq.explorer.core.internal.objects.DmStorageClass;
import com.ibm.mq.explorer.core.internal.objects.DmSubscription;
import com.ibm.mq.explorer.core.internal.objects.DmSubscriptionStatus;
import com.ibm.mq.explorer.core.internal.objects.DmSystem;
import com.ibm.mq.explorer.core.internal.objects.DmTelemetryChannel;
import com.ibm.mq.explorer.core.internal.objects.DmTelemetryChannelStatus;
import com.ibm.mq.explorer.core.internal.objects.DmTopic;
import com.ibm.mq.explorer.core.internal.objects.DmTopicStatus;
import com.ibm.mq.explorer.core.internal.objects.DmTopicStatusPub;
import com.ibm.mq.explorer.core.internal.objects.DmTopicStatusSub;
import com.ibm.mq.explorer.core.internal.objects.DmUsage;
import com.ibm.mq.explorer.core.internal.objects.DmUsageBufferPool;
import com.ibm.mq.explorer.core.internal.objects.DmUsageDataset;
import com.ibm.mq.explorer.core.internal.objects.DmUsagePageset;
import com.ibm.mq.explorer.core.internal.objects.DmUsageSMDS;
import com.ibm.mq.explorer.core.internal.parser.UpdateGroupList;
import com.ibm.mq.explorer.core.internal.trace.Names;
import com.ibm.mq.explorer.core.internal.utils.CoreServices;
import com.ibm.mq.explorer.core.internal.utils.OtherQueueManager;
import com.ibm.mq.explorer.core.internal.utils.PersistQueueManagerHandles;
import com.ibm.mq.explorer.core.internal.utils.QueueManagerHandle;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.osgi.framework.Bundle;

public class DataModel
implements IDmObservable {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/base/DataModel.java";
    private HashMap<String, Object> currentListeners = null;
    private Object hashLock = new Object();
    private Bundle pluginBundle = null;

    public DataModel() {
        CommonServices.registerTraceNames((int)65, Names.getMethodNames());
        this.currentListeners = new HashMap();
        this.pluginBundle = CorePlugin.getDefault().getBundle();
    }

    public void init(Trace t, String dir) throws DmCoreException {
        this.commonInit(t, dir);
        if (this.pluginBundle != null) {
            String pluginName = this.pluginBundle.getSymbolicName();
            Object ver = this.pluginBundle.getHeaders().get("Bundle-Version");
            String version = null;
            if (ver != null) {
                version = ver.toString();
            }
            String location = this.pluginBundle.getLocation();
            Object dep = this.pluginBundle.getHeaders().get("Require-Bundle");
            String dependencies = null;
            if (dep != null) {
                dependencies = dep.toString();
            }
            Object cp = this.pluginBundle.getHeaders().get("Bundle-ClassPath");
            String classPath = null;
            if (cp != null) {
                classPath = cp.toString();
            }
            t.dataBox(65, "DataModel.init", pluginName, version, location);
            t.data(65, "DataModel.init", 300, "classpath: " + classPath);
            t.data(65, "DataModel.init", 300, "dependencies: " + dependencies);
        }
    }

    private void commonInit(Trace t, String dir) throws DmCoreException {
        File dirName;
        MQException.log = null;
        if (Trace.isTracing) {
            t.data(65, "DataModel.commonInit", 300, "Working directory : " + dir);
        }
        if (!(dirName = new File(dir)).isDirectory()) {
            if (Trace.isTracing) {
                t.data(65, "DataModel.commonInit", 1000, "Invalid working directory");
            }
            throw new DmCoreException(t, CommonServices.getSystemMessage((Trace)t, (String)"AMQ4576", (String[])new String[]{dirName.toString()}), "AMQ4576", 50018, 0, 40);
        }
        CoreServices.setWorkingDir(dirName);
        if (Trace.isTracing) {
            t.data(65, "DataModel.commonInit", 300, "Working directory set to " + dirName);
        }
        CoreServices.init(t);
        DisplayGroup.staticInit(t);
        new UpdateGroupList(t, this.pluginBundle, "DmUpdateGroups");
        DmArchive.staticInit(t, this.pluginBundle);
        DmArchiveTape.staticInit(t, this.pluginBundle);
        DmAuthinfo.staticInit(t, this.pluginBundle);
        DmChannel.staticInit(t, this.pluginBundle);
        DmChannelAuthenticationRecord.staticInit(t, this.pluginBundle);
        DmChannelStatusCurrent.staticInit(t, this.pluginBundle);
        DmChannelStatusSaved.staticInit(t, this.pluginBundle);
        DmClientChannel.staticInit(t, this.pluginBundle);
        DmClusterQueue.staticInit(t, this.pluginBundle);
        DmClusterTopic.staticInit(t, this.pluginBundle);
        DmClusterQueueManager.staticInit(t, this.pluginBundle);
        DmCommInfo.staticInit(t, this.pluginBundle);
        DmCouplingFacility.staticInit(t, this.pluginBundle);
        DmCouplingFacilityStatusBackup.staticInit(t, this.pluginBundle);
        DmCouplingFacilityStatusConnect.staticInit(t, this.pluginBundle);
        DmCouplingFacilityStatusSummary.staticInit(t, this.pluginBundle);
        DmCouplingFacilityStatusSMDS.staticInit(t, this.pluginBundle);
        DmDistQueueManagement.staticInit(t, this.pluginBundle);
        DmDistQueueManagementListener.staticInit(t, this.pluginBundle);
        DmEntityAuthority.staticInit(t, this.pluginBundle);
        DmListener.staticInit(t, this.pluginBundle);
        DmListenerStatus.staticInit(t, this.pluginBundle);
        DmLog.staticInit(t, this.pluginBundle);
        DmLogCopy.staticInit(t, this.pluginBundle);
        DmLogStatus.staticInit(t, this.pluginBundle);
        DmMachine.staticInit(t, this.pluginBundle);
        DmNamelist.staticInit(t, this.pluginBundle);
        DmNHAStatus.staticInit(t, this.pluginBundle);
        DmNHAGroupStatus.staticInit(t, this.pluginBundle);
        DmAuthorityRecord.staticInit(t, this.pluginBundle);
        DmProcess.staticInit(t, this.pluginBundle);
        DmPubSubStatus.staticInit(t, this.pluginBundle);
        DmQueue.staticInit(t, this.pluginBundle);
        DmQueueManager.staticInit(t, this.pluginBundle);
        DmQueueManagerConnection.staticInit(t, this.pluginBundle);
        DmQueueManagerConnectionHandle.staticInit(t, this.pluginBundle);
        DmQueueManagerHandle.staticInit(t, this.pluginBundle);
        DmQueueManagerStatus.staticInit(t, this.pluginBundle);
        DmQSGMember.staticInit(t, this.pluginBundle);
        DmQueueStatusHandle.staticInit(t, this.pluginBundle);
        DmQueueStatusQueue.staticInit(t, this.pluginBundle);
        DmRemoteQueueManagerName.staticInit(t, this.pluginBundle);
        DmSecurity.staticInit(t, this.pluginBundle);
        DmSecuritySwitch.staticInit(t, this.pluginBundle);
        DmService.staticInit(t, this.pluginBundle);
        DmServiceStatus.staticInit(t, this.pluginBundle);
        DmStorageClass.staticInit(t, this.pluginBundle);
        DmSubscription.staticInit(t, this.pluginBundle);
        DmSubscriptionStatus.staticInit(t, this.pluginBundle);
        DmSystem.staticInit(t, this.pluginBundle);
        DmTopic.staticInit(t, this.pluginBundle);
        DmTopicStatus.staticInit(t, this.pluginBundle);
        DmTopicStatusPub.staticInit(t, this.pluginBundle);
        DmTopicStatusSub.staticInit(t, this.pluginBundle);
        DmUsage.staticInit(t, this.pluginBundle);
        DmUsageBufferPool.staticInit(t, this.pluginBundle);
        DmUsageDataset.staticInit(t, this.pluginBundle);
        DmUsagePageset.staticInit(t, this.pluginBundle);
        DmUsageSMDS.staticInit(t, this.pluginBundle);
        DmQueueManagerHandleInstance.staticInit(t, this.pluginBundle);
        DmTelemetryChannel.staticInit(t, this.pluginBundle);
        DmTelemetryChannelStatus.staticInit(t, this.pluginBundle);
        DmCouplingFacilitySMDS.staticInit(t, this.pluginBundle);
        DmCouplingFacilitySMDSCONN.staticInit(t, this.pluginBundle);
        CoreServices.setDmMonitor(t, new DmMonitor(t));
        PersistQueueManagerHandles.getInstance(t);
    }

    public ArrayList<DmQueueManager> getQueueManagers(Trace t) {
        return CoreServices.getQueueManagers(t);
    }

    public List<OtherQueueManager> getQueueManagersFromOtherInstallations(Trace t) {
        return CoreServices.getQueueManagersFromOtherInstallations(t);
    }

    public ArrayList<DmQueueManagerHandle> getQueueManagerHandles(Trace t) {
        return CoreServices.getQueueManagerHandles(t);
    }

    public DmMachine getMachine(Trace t) {
        return CoreServices.getMachine(t);
    }

    public String getSystemMessage(Trace t, String id) {
        return CommonServices.getSystemMessage((Trace)t, (String)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addQueueManagerAndObserver(Trace t, DmQueueManager existingQM, String targetQ, String targetQM, int refreshInt, boolean autoConnect, boolean connectNow, DmQueueManagerListener listener) {
        boolean result = false;
        Object id = DmMonitor.addQueueManagerListener(t, listener, false);
        if (id != null) {
            Object object = this.hashLock;
            synchronized (object) {
                String uniqueName = this.getUniqueObjectName(listener);
                this.currentListeners.put(uniqueName, id);
            }
        } else {
            t.FFST(65, "DataModel.addQueueManagerAndObserver", 0, 50020, "Listen call failed to put an object ID for listener " + listener);
            result = false;
        }
        if (id != null) {
            CoreServices.addQueueManager(t, existingQM, targetQ, targetQM, id, refreshInt, autoConnect, connectNow);
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addQueueManagerAndObserver(Trace t, String qmName, String connName, String chl, int refreshInt, boolean autoConnect, boolean connectNow, DmQueueManagerListener listener) {
        boolean result = false;
        Object id = DmMonitor.addQueueManagerListener(t, listener, false);
        if (id != null) {
            Object object = this.hashLock;
            synchronized (object) {
                String uniqueName = this.getUniqueObjectName(listener);
                this.currentListeners.put(uniqueName, id);
            }
        } else {
            t.FFST(65, "DataModel.addQueueManagerAndObserver", 0, 50020, "Listen call failed to put an object ID for listener " + listener);
            result = false;
        }
        if (id != null) {
            CoreServices.addQueueManager(t, qmName, connName, chl, id, refreshInt, autoConnect, connectNow);
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addQueueManagerAndObserver(Trace t, String qmName, URL chanDefTable, int refreshInt, boolean autoConnect, boolean connectNow, DmQueueManagerListener listener) {
        boolean result = false;
        Object id = DmMonitor.addQueueManagerListener(t, listener, false);
        if (id != null) {
            Object object = this.hashLock;
            synchronized (object) {
                String uniqueName = this.getUniqueObjectName(listener);
                this.currentListeners.put(uniqueName, id);
            }
        } else {
            t.FFST(65, "DataModel.addQueueManagerAndObserver", 0, 50020, "Listen call failed to put an object ID for listener " + listener);
            result = false;
        }
        if (id != null) {
            CoreServices.addQueueManager(t, qmName, chanDefTable, id, refreshInt, autoConnect, connectNow);
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addQueueManagerAndObserver(Trace t, String qmName, URL chanDefTable, Hashtable<String, Object> secOptions, int refreshInt, boolean autoConnect, boolean connectNow, DmQueueManagerListener listener) {
        boolean result = false;
        Object id = DmMonitor.addQueueManagerListener(t, listener, false);
        if (id != null) {
            Object object = this.hashLock;
            synchronized (object) {
                String uniqueName = this.getUniqueObjectName(listener);
                this.currentListeners.put(uniqueName, id);
            }
        } else {
            t.FFST(65, "DataModel.addQueueManagerAndObserver", 0, 50020, "Listen call failed to put an object ID for listener " + listener);
            result = false;
        }
        if (id != null) {
            CoreServices.addQueueManager(t, qmName, chanDefTable, secOptions, id, refreshInt, autoConnect, connectNow);
            result = true;
        }
        return result;
    }

    public void asyncConnectQueueManager(Trace t, DmQueueManager dmQm, DmQueueManagerListener listener) {
        Object key = this.currentListeners.get(listener);
        dmQm.connectAsynchronously(t, key);
    }

    public boolean removeQueueManager(Trace t, DmQueueManagerHandle dmqmh) {
        return CoreServices.removeQueueManager(t, dmqmh);
    }

    public boolean addSystemErrorListener(Trace t, DmErrorListener listener) {
        boolean added = CoreServices.addSystemErrorListener(t, listener);
        return added;
    }

    public boolean removeSystemErrorListener(Trace t, DmErrorListener listener) {
        boolean removed = CoreServices.removeSystemErrorListener(t, listener);
        return removed;
    }

    public void close(Trace t, boolean reset) {
        PersistQueueManagerHandles.getInstance(t).close(t);
        CoreServices.systemReset = reset;
        CoreServices.close(t);
        CommonServices.processTerminate((Trace)t);
    }

    public void refreshDmMonitor(Trace t) {
        CoreServices.refreshDmMonitor(t);
    }

    public void setDmMonitorRefreshInterval(Trace t, int i) {
        CoreServices.setDmMonitorRefreshInterval(t, i);
    }

    public void setQueueManagerRefreshInterval(Trace t, int i) {
        QueueManagerHandle.setDefaultQueueManagerRefreshInterval(i);
    }

    public void setRemoteQueueManagerRefreshInterval(Trace t, int i) {
        QueueManagerHandle.setDefaultRemoteQueueManagerRefreshInterval(i);
    }

    public int getQueueManagerRefreshInterval(Trace t) {
        return QueueManagerHandle.getDefaultQueueManagerRefreshInterval();
    }

    public int getRemoteQueueManagerRefreshInterval(Trace t) {
        return QueueManagerHandle.getDefaultRemoteQueueManagerRefreshInterval();
    }

    public int getMinQueueManagerRefreshInterval(Trace t) {
        return 1;
    }

    public int getMinRemoteQueueManagerRefreshInterval(Trace t) {
        return 5;
    }

    public int getMaxQueueManagerRefreshInterval(Trace t) {
        return 86400;
    }

    public int getMaxRemoteQueueManagerRefreshInterval(Trace t) {
        return 86400;
    }

    public int getMonitorRefreshInterval(Trace t) {
        return DmMonitor.getRefreshInterval(t);
    }

    public int getMinMonitorRefreshInterval(Trace t) {
        return 30;
    }

    public int getMaxMonitorRefreshInterval(Trace t) {
        return 86400;
    }

    public int getQueueManagerExpiryInterval(Trace t) {
        return QueueManagerHandle.getDefaultQueueManagerExpiryInterval();
    }

    public int getQueueManagerWaitInterval(Trace t) {
        return QueueManagerHandle.getDefaultQueueManagerWaitInterval();
    }

    public int getRemoteQueueManagerExpiryInterval(Trace t) {
        return QueueManagerHandle.getDefaultRemoteQueueManagerExpiryInterval();
    }

    public int getRemoteQueueManagerWaitInterval(Trace t) {
        return QueueManagerHandle.getDefaultRemoteQueueManagerWaitInterval();
    }

    public void setQueueManagerExpiryInterval(Trace t, int i) {
        QueueManagerHandle.setDefaultQueueManagerExpiryInterval(i);
    }

    public void setRemoteQueueManagerExpiryInterval(Trace t, int i) {
        QueueManagerHandle.setDefaultRemoteQueueManagerExpiryInterval(i);
    }

    public void setQueueManagerWaitInterval(Trace t, int i) {
        QueueManagerHandle.setDefaultQueueManagerWaitInterval(i);
    }

    public void setRemoteQueueManagerWaitInterval(Trace t, int i) {
        QueueManagerHandle.setDefaultRemoteQueueManagerWaitInterval(i);
    }

    public boolean isObjectSupported(Trace t, int objectType, int subType, int commandLevel, int platform) {
        return CoreServices.isObjectSupported(t, objectType, subType, commandLevel, platform);
    }

    public boolean isObjectSupported(Trace t, int objectType, int commandLevel, int platform) {
        return CoreServices.isObjectSupported(t, objectType, -2, commandLevel, platform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addObserver(Trace t, DmObjectListener listener, DmObjectFilter filter) {
        boolean result = true;
        Object id = DmMonitor.addQueueManagerListener(t, (DmQueueManagerListener)listener, true);
        if (id != null) {
            Object object = this.hashLock;
            synchronized (object) {
                String uniqueName = this.getUniqueObjectName(listener);
                this.currentListeners.put(uniqueName, id);
            }
        } else {
            t.FFST(65, "DataModel.addObserver", 0, 50020, "Listen call failed to put an object ID for listener " + this.getUniqueObjectName(listener));
            result = false;
        }
        if (Trace.isTracing) {
            String traceText = "added listener " + this.getUniqueObjectName(listener) + " to " + this.getObservableName() + "id = " + id == null ? "null" : "" + id;
            t.data(65, "DataModel.addObserver", 300, traceText);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteObserver(Trace t, DmObjectListener listener) {
        boolean ret = false;
        Object id = null;
        Object object = this.hashLock;
        synchronized (object) {
            String uniqueName = this.getUniqueObjectName(listener);
            id = this.currentListeners.remove(uniqueName);
        }
        if (Trace.isTracing) {
            String traceText = "removing listener " + this.getUniqueObjectName(listener) + " from " + this.getObservableName() + " with object id " + id == null ? "null" : "" + id;
            t.data(65, "DataModel.deleteObserver", 300, traceText);
        }
        if (id != null) {
            DmMonitor.removeQueueManagerListener(t, (DmQueueManagerListener)listener, id);
            ret = true;
        } else {
            t.FFST(65, "DataModel.deleteObserver", 0, 50020, "Failed to retrieve object ID, cannot remove queue manager listener " + listener);
        }
        return ret;
    }

    private String getUniqueObjectName(Object object) {
        String uniqueName = String.valueOf(object.getClass().getName()) + "@" + System.identityHashCode(object);
        return uniqueName;
    }

    @Override
    public String getObservableName() {
        return "The Datamodel (com.ibm.mq.explorer.core)";
    }

    @Override
    public void refreshObservable(Trace t) {
        this.refreshDmMonitor(t);
        ArrayList<DmQueueManager> list = this.getQueueManagers(t);
        for (DmQueueManager dmQm : list) {
            dmQm.refresh(t);
        }
    }

    @Override
    public void refreshObservable(Trace t, DmObjectListener listener) {
        block2: {
            try {
                DmQueueManager dmQm = (DmQueueManager)listener;
                dmQm.refresh(t);
            }
            catch (ClassCastException cce) {
                if (!Trace.isTracing) break block2;
                t.data(65, "DataModel.refreshObservable", 900, "Given listener is not a queue manager\n" + cce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addQueueManagerAndObserver(Trace t, String qmName, String connName, String chl, Hashtable<?, ?> secOptions, int refreshInt, boolean autoConnect, boolean connectNow, DmQueueManagerListener listener) {
        boolean result = false;
        Object id = DmMonitor.addQueueManagerListener(t, listener, false);
        if (id != null) {
            Object object = this.hashLock;
            synchronized (object) {
                String uniqueName = this.getUniqueObjectName(listener);
                this.currentListeners.put(uniqueName, id);
            }
            CoreServices.addQueueManager(t, qmName, connName, chl, secOptions, id, refreshInt, autoConnect, connectNow);
            result = true;
        } else {
            t.FFST(65, "DataModel.addQueueManagerAndObserver", 0, 50020, "Listen call failed to put an object ID for listener " + listener);
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addQueueManagerAndObserver(Trace t, String qmName, String[] connName, String chl, Hashtable<?, ?> secOptions, int refreshInt, boolean autoConnect, boolean connectNow, DmQueueManagerListener listener) {
        boolean result = false;
        Object id = DmMonitor.addQueueManagerListener(t, listener, false);
        if (id != null) {
            Object object = this.hashLock;
            synchronized (object) {
                String uniqueName = this.getUniqueObjectName(listener);
                this.currentListeners.put(uniqueName, id);
            }
            CoreServices.addQueueManager(t, qmName, connName, chl, secOptions, id, refreshInt, autoConnect, connectNow);
            result = true;
        } else {
            t.FFST(65, "DataModel.addQueueManagerAndObserver", 0, 50020, "Listen call failed to put an object ID for listener " + listener);
            result = false;
        }
        return result;
    }

    public void enableFips(Trace t, int fips) {
        CoreServices.enableFips(t, fips);
    }
}

