/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.attrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import java.util.HashMap;
import java.util.Set;

public class UpdateGroup {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/attrs/UpdateGroup.java";
    private String name;
    private HashMap attributeStringToId;
    private HashMap attributesIdToString;
    private boolean repeating = false;
    private static final int NO_PRIMARY_ATTRIBUTE = -1;
    private Integer primaryAttribute = -1;

    public UpdateGroup(Trace t, String n, int primAttr, String[] attrNames, int[] attrValues) {
        this.name = n;
        if (primAttr != -1) {
            this.repeating = true;
            this.primaryAttribute = primAttr;
        }
        if (attrNames != null && attrValues != null) {
            if (attrNames.length == attrValues.length) {
                int i = 0;
                while (i < attrNames.length) {
                    this.addAttribute(t, attrNames[i], attrValues[i]);
                    ++i;
                }
            }
        } else if (attrNames == null) {
            // empty if block
        }
    }

    public UpdateGroup(Trace t, String n, int primAttr) {
        this(t, n, primAttr, null, null);
    }

    public void addAttribute(Trace t, String a, int id) {
        Integer pseudoPCFId = id;
        if (this.attributeStringToId == null) {
            this.attributeStringToId = new HashMap();
        }
        this.attributeStringToId.put(a, pseudoPCFId);
        if (this.attributesIdToString == null) {
            this.attributesIdToString = new HashMap();
        }
        this.attributesIdToString.put(pseudoPCFId, a);
    }

    public String getName() {
        return this.name;
    }

    public boolean isRepeating() {
        return this.repeating;
    }

    public void setPrimaryAttribute(int a) {
        this.primaryAttribute = a;
        this.repeating = a != -1;
    }

    public int getPrimaryAttribute() {
        return this.primaryAttribute;
    }

    public String getAttributeName(int id) {
        return (String)this.attributesIdToString.get(id);
    }

    public int getPseudoPCFId(String requiredName) {
        int retval = -1;
        Integer pseudoPCFId = (Integer)this.attributeStringToId.get(requiredName);
        if (pseudoPCFId != null) {
            retval = pseudoPCFId;
        } else {
            for (String curString : this.attributeStringToId.keySet()) {
                if (!curString.equalsIgnoreCase(requiredName)) continue;
                pseudoPCFId = (Integer)this.attributeStringToId.get(curString);
                if (pseudoPCFId == null) break;
                retval = pseudoPCFId;
                break;
            }
        }
        return retval;
    }

    public int[] getAttributeIDs(Trace t) {
        if (this.attributesIdToString.size() == 0) {
            return null;
        }
        int[] retValue = new int[this.attributesIdToString.size()];
        int index = 0;
        Set tableKeys = this.attributesIdToString.keySet();
        for (Integer key : tableKeys) {
            retValue[index] = key;
            ++index;
        }
        return retValue;
    }
}

