/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.attrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.objects.DisplayGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class AttrTypeStringArray
extends AttrType {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/attrs/AttrTypeStringArray.java";
    private final Pattern regularExpression;
    private final int minLen;
    private final int maxLen;
    private final int maxNumberOfItems;

    public AttrTypeStringArray(Trace t, String resource_stem, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc, int rwctrl, Object rwswval, String regExp, int maxLen, int minLen, int maxNumberOfItems) {
        super(t, resource_stem, grpseq, grp, distcolseq, zoscolseq, pcftype, rep, rw, rwoc, rwctrl, rwswval);
        this.setAttributeType(t, 15);
        this.regularExpression = regExp != null && !regExp.equals("") ? Pattern.compile(regExp) : null;
        this.minLen = minLen;
        this.maxLen = maxLen;
        this.maxNumberOfItems = maxNumberOfItems;
    }

    public AttrTypeStringArray(Trace t, String resource_stem, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc, String regExp, int maxLen, int minLen, int maxNumberOfItems) {
        this(t, resource_stem, grpseq, grp, distcolseq, zoscolseq, pcftype, rep, rw, rwoc, -1, NO_RWSWITCHVALUE, regExp, maxLen, minLen, maxNumberOfItems);
    }

    @Override
    protected String toString(Trace t, Attr attr) {
        return this.toString(t, attr, false);
    }

    @Override
    protected String toString(Trace t, Attr attr, boolean ebcdic) {
        if (ebcdic) {
            return this.toString(t, attr, "500", -1);
        }
        return this.toString(t, attr, "UTF8", -1);
    }

    @Override
    protected String toString(Trace t, Attr attr, String charSet, int length) {
        StringBuffer retValue = new StringBuffer();
        ArrayList al = (ArrayList)attr.getValue(t);
        int i = 0;
        while (i < al.size()) {
            retValue = retValue.append(al.get(i).toString().trim());
            if (i < al.size() - 1) {
                retValue = retValue.append(",");
            }
            ++i;
        }
        return retValue.toString();
    }

    @Override
    protected String toFormattedString(Trace t, Attr attr) {
        return this.toFormattedString(t, attr, false);
    }

    @Override
    protected String toFormattedString(Trace t, Attr attr, boolean ebcdic) {
        if (ebcdic) {
            return this.toFormattedString(t, attr, "500", -1);
        }
        return this.toFormattedString(t, attr, "UTF8", -1);
    }

    @Override
    protected String toFormattedString(Trace t, Attr attr, String charSet, int length) {
        StringBuffer retValue = new StringBuffer();
        ArrayList al = (ArrayList)attr.getValue(t);
        int i = 0;
        while (i < al.size()) {
            retValue = retValue.append(al.get(i).toString().trim());
            if (i < al.size() - 1) {
                retValue = retValue.append("\n");
            }
            ++i;
        }
        return retValue.toString();
    }

    @Override
    public String toDefaultString(Trace t) {
        return this.toDefaultString(t, false);
    }

    @Override
    public String toDefaultString(Trace t, boolean ebcdic) {
        if (ebcdic) {
            return this.toDefaultString(t, "500", -1);
        }
        return this.toDefaultString(t, "UTF8", -1);
    }

    @Override
    public String toDefaultString(Trace t, String charSet, int length) {
        if (this.defaultValue == null) {
            return "<not_set>";
        }
        StringBuffer retValue = new StringBuffer();
        ArrayList al = (ArrayList)this.getDefaultValue(t);
        int i = 0;
        while (i < al.size()) {
            retValue = retValue.append(al.get(i).toString().trim());
            if (i < al.size() - 1) {
                retValue = retValue.append(",");
            }
            ++i;
        }
        return retValue.toString();
    }

    @Override
    public String toFormattedDefaultString(Trace t) {
        return this.toFormattedDefaultString(t, false);
    }

    @Override
    public String toFormattedDefaultString(Trace t, boolean ebcdic) {
        if (ebcdic) {
            return this.toFormattedDefaultString(t, "500", -1);
        }
        return this.toFormattedDefaultString(t, "UTF8", -1);
    }

    @Override
    public String toFormattedDefaultString(Trace t, String charSet, int length) {
        if (this.defaultValue == null) {
            return "<not_set>";
        }
        StringBuffer retValue = new StringBuffer();
        ArrayList al = (ArrayList)this.getDefaultValue(t);
        int i = 0;
        while (i < al.size()) {
            retValue = retValue.append(al.get(i).toString().trim());
            if (i < al.size() - 1) {
                retValue = retValue.append("\n");
            }
            ++i;
        }
        return retValue.toString();
    }

    @Override
    protected boolean equals(Trace t, Attr attr1, Attr attr2) {
        ArrayList al1 = (ArrayList)attr1.getValue(t);
        ArrayList al2 = (ArrayList)attr2.getValue(t);
        if (al1.size() != al2.size()) {
            if (Trace.isTracing) {
                t.data(65, "AttrTypeStringArray.equals", 300, "The values of attribute id " + attr1.getAttributeID() + "." + attr1.getRepeatingIndex() + " and " + attr2.getAttributeID() + "." + attr2.getRepeatingIndex() + " are not equal");
            }
            return false;
        }
        int i = 0;
        while (i < al1.size()) {
            String b;
            String a = (String)al1.get(i);
            if (a.compareTo(b = (String)al2.get(i)) != 0) {
                if (Trace.isTracing) {
                    t.data(65, "AttrTypeStringArray.equals", 300, "The values of attribute id " + attr1.getAttributeID() + "." + attr1.getRepeatingIndex() + " and " + attr2.getAttributeID() + "." + attr2.getRepeatingIndex() + " are not equal");
                }
                return false;
            }
            ++i;
        }
        if (Trace.isTracing) {
            t.data(65, "AttrTypeStringArray.equals", 300, "The values of attribute id " + attr1.getAttributeID() + "." + attr1.getRepeatingIndex() + " and " + attr2.getAttributeID() + "." + attr2.getRepeatingIndex() + " are equal");
        }
        return true;
    }

    @Override
    protected boolean validate(Trace t, Attr attr, Object o) {
        List<String> al1;
        boolean rc = true;
        if (o instanceof List) {
            al1 = (List<String>)o;
        } else if (o instanceof String[]) {
            al1 = Arrays.asList((String[])o);
        } else {
            return true;
        }
        if (this.maxNumberOfItems != -1 && al1.size() > this.maxNumberOfItems) {
            if (Trace.isTracing) {
                t.data(65, "AttrTypeStringArray.validate", 900, "There are too many items in the list for attribute id " + attr.getAttributeID() + "." + attr.getRepeatingIndex());
            }
            rc = false;
        }
        int i = 0;
        while (i < al1.size()) {
            String a = al1.get(i);
            if (this.maxLen != -1 && a.length() > this.maxLen) {
                if (Trace.isTracing) {
                    t.data(65, "AttrTypeStringArray.validate", 900, "The value of attribute id " + attr.getAttributeID() + "." + attr.getRepeatingIndex() + " will exceed the maximum length");
                }
                rc = false;
            }
            if (this.minLen != -1 && a.length() < this.minLen) {
                if (Trace.isTracing) {
                    t.data(65, "AttrTypeStringArray.validate", 900, "The value of attribute id " + attr.getAttributeID() + "." + attr.getRepeatingIndex() + " will exceed the minimum length");
                }
                rc = false;
            }
            ++i;
        }
        return rc;
    }

    @Override
    public boolean isMultiLine() {
        return true;
    }

    @Override
    public void debug(Trace t) {
        super.debug(t);
    }

    public Pattern getRegExp() {
        return this.regularExpression;
    }

    public int getMaxLen() {
        return this.maxLen;
    }

    public int getMinLen() {
        return this.minLen;
    }

    public int getMaxNumberOfItems() {
        return this.maxNumberOfItems;
    }
}

