/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.attrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeInt;
import com.ibm.mq.explorer.core.internal.objects.DisplayGroup;

public class AttrTypeRange
extends AttrTypeInt {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/attrs/AttrTypeRange.java";
    private int minimumValue = 0;
    private int maximumValue = 0;

    public AttrTypeRange(Trace t, String resource_stem, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc, int rwctrl, Object rwswval, int min, int max) {
        super(t, resource_stem, grpseq, grp, distcolseq, zoscolseq, pcftype, rep, rw, rwoc, rwctrl, rwswval);
        this.setAttributeType(t, 4);
        this.minimumValue = min;
        this.maximumValue = max;
    }

    public AttrTypeRange(Trace t, String resource_stem, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc, int min, int max) {
        this(t, resource_stem, grpseq, grp, distcolseq, zoscolseq, pcftype, rep, rw, rwoc, -1, NO_RWSWITCHVALUE, min, max);
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    @Override
    protected boolean validate(Trace t, Attr attr, Object o) {
        int newValue = Integer.parseInt(String.valueOf(o));
        if (newValue < this.minimumValue || newValue > this.maximumValue) {
            t.data(65, "AttrTypeRange.validate", 300, "Attribute id " + attr.getAttributeID() + "." + attr.getRepeatingIndex() + " failed validation");
            return false;
        }
        t.data(65, "AttrTypeRange.validate", 300, "Attribute id " + attr.getAttributeID() + "." + attr.getRepeatingIndex() + " passed validation");
        return true;
    }

    @Override
    public void debug(Trace t) {
        super.debug(t);
        System.out.println("          min: " + this.minimumValue);
        System.out.println("          max: " + this.maximumValue);
    }
}

