/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.core.internal.attrs;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeByteArray;
import com.ibm.mq.explorer.core.internal.objects.DisplayGroup;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class AttrTypeQueueManagerUrid
extends AttrTypeByteArray {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.core/src/com/ibm/mq/explorer/core/internal/attrs/AttrTypeQueueManagerUrid.java";
    private static final int SHIFT_BITS = 24;
    public static final String HEX_8_FORMAT = "%08X";
    public static final String HEX_2_FORMAT = "%02X";
    public static final String UOWMQ = "MQM";
    public static final String UOWWAS = "WASD";
    public static final String XAFORMATID = "XA_FORMATID[";
    public static final String XAGTRID = "XA_GTRID[";
    public static final String XABQUAL = "XA_BQUAL[";
    public static final String CLOSEBRACKET = "] ";
    public static final String FINALCLOSEBRACKET = "]";

    public AttrTypeQueueManagerUrid(Trace t, String resource_stem, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc, int rwctrl, Object rwswval) {
        super(t, resource_stem, grpseq, grp, distcolseq, zoscolseq, pcftype, rep, rw, rwoc, rwctrl, rwswval);
        this.setAttributeType(t, 19);
    }

    public AttrTypeQueueManagerUrid(Trace t, String resource_stem, int grpseq, DisplayGroup grp, int distcolseq, int zoscolseq, int pcftype, boolean rep, boolean rw, boolean rwoc) {
        this(t, resource_stem, grpseq, grp, distcolseq, zoscolseq, pcftype, rep, rw, rwoc, -1, NO_RWSWITCHVALUE);
    }

    @Override
    protected String toFormattedString(Trace t, Attr attr) {
        return this.toFormattedString(t, attr, false);
    }

    @Override
    protected String toFormattedString(Trace t, Attr attr, boolean ebcdic) {
        return this.toString(t, attr);
    }

    @Override
    protected String toString(Trace t, Attr attr) {
        return this.toString(t, attr, false);
    }

    @Override
    protected String toString(Trace t, Attr attr, boolean ebcdic) {
        String result = "";
        int attrId = attr.getAttributeID();
        if (attrId == 7009) {
            result = this.processQMURID(t, attr, ebcdic);
        } else if (attrId == 7005) {
            result = this.processEXTURID(t, attr, ebcdic);
        } else {
            t.FFST(65, "AttrTypeQueueManagerUrid.toString", 0, 50005, "unknown attribute with id " + attrId);
        }
        return result;
    }

    private String processEXTURID(Trace t, Attr attr, boolean ebcdic) {
        String ret = "";
        String xaGtrid = "";
        String xaBQual = "";
        String xaFormatId = "";
        int MQFormatID = 5067085;
        int MQFormatIDSwapped = 1297173760;
        int WASFormatID = 1463898948;
        int WASFormatIDSwapped = 1146306903;
        ByteBuffer bb = (ByteBuffer)attr.getValue(t);
        bb.rewind();
        try {
            long format = this.extractLong(bb);
            long gtridLength = bb.get();
            bb.get();
            bb.get();
            bb.get();
            long bqualLength = bb.get();
            bb.get();
            bb.get();
            bb.get();
            xaFormatId = format == (long)MQFormatID || format == (long)MQFormatIDSwapped ? UOWMQ : (format == (long)WASFormatID || format == (long)WASFormatIDSwapped ? UOWWAS : String.format(HEX_8_FORMAT, format));
            int k = 0;
            while ((long)k < gtridLength) {
                xaGtrid = String.valueOf(xaGtrid) + String.format(HEX_2_FORMAT, bb.get());
                ++k;
            }
            k = 0;
            while ((long)k < bqualLength) {
                xaBQual = String.valueOf(xaBQual) + String.format(HEX_2_FORMAT, bb.get());
                ++k;
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {}
        ret = XAFORMATID + xaFormatId + CLOSEBRACKET;
        ret = String.valueOf(ret) + XAGTRID + xaGtrid + CLOSEBRACKET;
        ret = String.valueOf(ret) + XABQUAL + xaBQual + FINALCLOSEBRACKET;
        bb.rewind();
        return ret;
    }

    private long extractLong(ByteBuffer bb) {
        String val = "";
        int k = 0;
        while (k < 4) {
            int b = bb.get();
            if (b < 0) {
                b += 256;
            }
            val = String.valueOf(val) + String.format(HEX_2_FORMAT, b);
            ++k;
        }
        return Long.parseLong(val, 16);
    }

    private String processQMURID(Trace t, Attr attr, boolean ebcdic) {
        ByteBuffer bb = (ByteBuffer)attr.getValue(t);
        bb.rewind();
        IDmObject dmObject = attr.getDmObject();
        DmQueueManager dmQueueManager = dmObject.getQueueManager();
        int platform = dmQueueManager.getPlatform();
        StringBuffer formattedString = new StringBuffer();
        if (platform == 1) {
            int bytes = 8;
            if (dmQueueManager.getCommandLevel() < 800) {
                bytes = 6;
            }
            int i = 0;
            while (i < bytes) {
                int value = bb.get();
                if (value < 0) {
                    value <<= 24;
                    value >>>= 24;
                }
                formattedString.append(AttrTypeQueueManagerUrid.rightJustify(Integer.toHexString(value), 2));
                formattedString.append(" ");
                ++i;
            }
        } else {
            formattedString.append(bb.getInt(0));
            formattedString.append(".");
            formattedString.append(bb.getInt(1));
        }
        bb.rewind();
        return formattedString.toString();
    }

    private static String rightJustify(String str, int width) {
        String output = str;
        int i = width - str.length();
        while (i > 0) {
            output = "0" + output;
            --i;
        }
        return output;
    }
}

